/** Figure.java
 *
 *  Basisklasse zweidimensionaler geometrischer Objekte
 */


public abstract class Figure {

  // Datenelement
  private Point p;

  // Konstruktoren
  protected Figure() {
 	p = new Point();
  }

  protected Figure(int x, int y) {
	p = new Point(x,y);
  }

  // Methoden zum Abfragen von Attributen

  public Point getPoint() {
	return p;
  }

  // Methoden zum Modifizieren 
  public void moveTo(int xNew, int yNew) {
	p.moveTo(xNew,yNew);
  }

  public void moveRel(int dx, int dy) {
	p.moveRel(dx,dy);
  }

  // abstrakte Methoden
  public abstract void resize(int n);   // Groesse veraendern
  public abstract double area();	// Flaecheninhalt
  public abstract double perimeter(); 	// Umfang

}

// Figure
