package FDL.term;

// . 46
// , 44
// : 58
// ; 59
// ( 40
// ) 41
// { 123
// } 125

public class TermSyntax {

    public static final byte period = (byte)'.';

    public static final byte comma = (byte)',';
    public static final byte colon = (byte)':';
    public static final byte semicolon = (byte)';';
    public static final byte lparen = (byte)'(';
    public static final byte rparen = (byte)')';
    public static final byte lcurly = (byte)'{';
    public static final byte rcurly = (byte)'}';

    // ie backslash
    public static final byte escape = (byte)92;

    // special chars need to be escaped when embedded in strings.
    public static final byte specialchars [] = {
	period, comma, colon, semicolon, lparen, rparen, lcurly, rcurly};
   
    public static final byte eot = (byte)4;

    // none standard chars need to be converted to unicode
    public static final String standardchars =
	"\n\t\r !\"#$%&\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";

    public static final String unichars = "0123456789abcdefABCDEF";

    protected boolean special (char b) {

	for ( int i=0; i < specialchars.length; i++) {
	    if (b == specialchars[i]) { return true;}
	}
	    
	return false;
    }

    protected boolean standard (char b) {

	int r = standardchars.indexOf(b);

	return (!(r == -1));
    }

    protected boolean unichar (byte b) {
	
	int r = unichars.indexOf((char)b);

	return (!(r == -1));
    }

}
