
package FDL.workingmap;

import java.util.*;
import FDL.term.*;

public class FDLApi0 extends FDLOrb implements WMApi0 {
    
    public FDLApi0 (String fdlhost, int port, String environment) throws Exception {
	super(fdlhost, port, environment);
    }

    public ObjectId createObjectId() throws Exception { 
	Term t = evalCommand(new Term(SParameter.opidParm("create_object_id")));
	return ((OParameter)(t.parametern(2))).getValue();
    }

    public void put(ObjectId obid, Term t) throws Exception { 
	Parameter[] p = {SParameter.opidParm("put"), new OParameter(obid)};
	Term[] ts = { t };
	
	evalCommandn(new Term(p,ts));
    }

    public Term get(ObjectId obid) throws Exception { 
	Parameter[] p = {SParameter.opidParm("get"), new OParameter(obid)};
	Term[] ts = { };
	
	return evalCommand(new Term(p,ts));
    }

    public ObjectId createObject(String kind) throws Exception {
	Parameter[] p = {SParameter.opidParm("create_object"), SParameter.tokParm(kind)};
	Term[] ts = { };
	
	Term t = evalCommand(new Term(p,ts));
	return ((OParameter)(t.parametern(2))).getValue();
    }


    // Properties

    public void putProperty(ObjectId obid, String key, Term t) throws Exception { 
	Parameter[] p = {SParameter.opidParm("put_property"), new OParameter(obid), SParameter.tokParm(key)};
	Term[] ts = { t };
	
	evalCommandn(new Term(p,ts));
    }

    public void putProperty(ObjectId obid, ObjectId okey, Term t) throws Exception { 
	Parameter[] p = {SParameter.opidParm("put_property"), new OParameter(obid), new OParameter(okey)};
	Term[] ts = { t };
	
	evalCommandn(new Term(p,ts));
    }

    public void putName(ObjectId obid, String name) throws Exception {
	Parameter[] p = {SParameter.opidParm("!token"), new SParameter("t", name)};
	Term[] ts = { };
	putProperty(obid, "NAME", new Term(p,ts));
    }

    public Term getProperty(ObjectId obid, String key) throws Exception { 
	Parameter[] p = {SParameter.opidParm("get_property"),
			 new OParameter(obid), 
			 new SParameter("t",key)};
	Term[] ts = { };
	
	return evalCommand(new Term(p,ts));
    }

    public Term getProperty(ObjectId obid, ObjectId okey) throws Exception { 
	Parameter[] p = {SParameter.opidParm("get_property"),
			 new OParameter(obid), 
			 new OParameter(okey)};
	Term[] ts = { };
	
	return evalCommand(new Term(p,ts));
    }

    // make/modify object
    public ObjectId makeObject (String kind, ObjectProperty[] props, Term source) throws Exception {
	Parameter[] p = {SParameter.opidParm("make_object"), SParameter.tokParm(kind)};
	
	Term[] pts = new Term [props.length];
	for (int i=0; i<props.length; i++) {
	    pts[i] = props[i].toTerm();
	}
	
	Term[] ts = {Term.listToTerm(pts), source };

	Term t = evalCommand(new Term(p,ts));
	return ((OParameter)(t.parametern(2))).getValue();
    }
    public void modifyObject (ObjectId obid, String kind, ObjectProperty[] props, Term source) throws Exception {
	Parameter[] p = { SParameter.opidParm("modify_object"),
			  new OParameter (obid),
			  SParameter.tokParm(kind)};
	
	Term[] pts = new Term [props.length];
	for (int i=0; i<props.length; i++) {
	    pts[i] = props[i].toTerm();
	}
	
	Term[] ts = {Term.listToTerm(pts), source };

	evalCommandn(new Term(p,ts));
    }

    // Marshalled.

    public void putObjectContents(ObjectId obid, Term t) throws Exception { 
	Parameter[] p = {SParameter.opidParm("putObject"), new OParameter(obid)};
	Term[] ts = { t };
	
	evalCommandn(new Term(p,ts));
    }

    public Term getObjectContents(ObjectId obid) throws Exception { 
	Parameter[] p = {SParameter.opidParm("getObject"), new OParameter(obid)};
	Term[] ts = { };
	
	return evalCommand(new Term(p,ts));
    }

    // Directories

    public ObjectId mkDir (String name) throws Exception {
	
	Parameter p[] =	{ SParameter.opidParm("make_directory"),
                          SParameter.tokParm(name)};
	Term t[] = { };

	Term r = evalCommand(new Term(p,t));
	return ((OParameter)(r.parametern(1))).getValue();
    }


    public void dirInsert (boolean boa, ObjectId place, ObjectId dir, ObjectId obid) throws Exception {
	
	Parameter p[] =	{ SParameter.opidParm("insert"),
                          SParameter.boolParm(boa),
			  new OParameter(place),
			  new OParameter(dir),
			  new OParameter(obid)};

	evalCommandn(new Term(p,new Term[0]));
    }

    public void dirInsert (boolean boa, ObjectId dir, ObjectId obid) throws Exception { 
	Parameter p[] =	{ SParameter.opidParm("insert"),
                          SParameter.boolParm(boa),
			  new OParameter(dir),
			  new OParameter(obid)};

	evalCommandn(new Term(p,new Term[0]));
    }


    public ObjectId mkDir (boolean boa, ObjectId dir, String name) throws Exception {
	
	Parameter p[] =	{ SParameter.opidParm("make_directory"),
                          SParameter.boolParm(boa),
			  new OParameter(dir),
			  SParameter.tokParm(name)};
	Term t[] = { };

	Term r = evalCommand(new Term(p,t));

	return ((OParameter)(r.parametern(1))).getValue();
    }

    public ObjectId mkDir (boolean boa, ObjectId place, ObjectId dir, String name) throws Exception {
	
	Parameter p[] =	{ SParameter.opidParm("make_directory"),
                          SParameter.boolParm(boa),
			  new OParameter(place),
			  new OParameter(dir),
			  SParameter.tokParm(name)};
	Term t[] = { };

	Term r = evalCommand(new Term(p,t));

	return ((OParameter)(r.parametern(1))).getValue();
    }


    public void dirRemove (ObjectId dir, ObjectId obid) throws Exception {
	Parameter p[] =	{ SParameter.opidParm("remove"),
			  new OParameter(dir),
			  new OParameter(obid)};

	evalCommandn(new Term(p,new Term[0]));
    }

    public ObjectId dirDescendent(String[] path) throws Exception { 
	Parameter p = SParameter.opidParm("root_descendent");
	
	ArrayList q = new ArrayList(path.length);
	
	for (int i=0; i< path.length; i++) {
	    q.add(new SParameter("t", path[i]));
	}

	Term r = evalCommand(new Term(p,new Term(q,new ArrayList())));
	return ((OParameter)(r.parametern(1))).getValue();
    }

    public ObjectId dirDescendent(ObjectId dir, String[] path) throws Exception { 
	Parameter p = SParameter.opidParm("descendent");
	
	ArrayList q = new ArrayList(path.length + 1);
	
	q.add(new OParameter(dir));
	for (int i=0; i< path.length; i++) {
	    q.add(new SParameter("t", path[i]));
	}

	Term r = evalCommand(new Term(p,new Term(q,new ArrayList())));
	return ((OParameter)(r.parametern(1))).getValue();
    }


    //public ObjectInfo [] listDir (ObjectId dir) {
    //return new ObjectInfo[0];
}
