
package FDL.workingmap;

import java.util.*;
import FDL.term.*;

public class FDLOrb extends FDLConnect {
    

    private String env;
    private final static String kind = "APPLICATION"; 

    int seq = 1;

    boolean verbose = true;

    private long lasteval = (new Date()).getTime();

    public FDLOrb (String fdlhost, int port, String environment) throws Exception {
	super(fdlhost, port);
	env = environment;
    }

    protected Term disconnectTerm(int seq) throws Exception {
	Parameter[] p = {SParameter.opidParm("!req"), SParameter.natParm(seq), SParameter.tokParm("CONFIG")};
	Parameter[] q = {SParameter.opidParm("!disconnect"), SParameter.boolParm(false)}; 
	Term[] n = {};
	Term [] s = { new Term (SParameter.opidParm("!configure"), 
				new Term(SParameter.opidParm("!inform"),
					 new Term (q, n))) };
						   
	return new Term (p,s); 
    }
    

    public void open () throws Exception {
	super.open();
    }

    public void close () {
	try { 
	    send(disconnectTerm(seq++));
	    recv();
	}
	catch (Exception e) { }

	super.close();
    }
    protected Term reqTerm (int seq, Term t) throws Exception {
	ArrayList parms = new ArrayList();
	parms.add(SParameter.opidParm("!req"));
	parms.add(SParameter.natParm(seq));
	parms.add(SParameter.tokParm(kind));
	parms.add(SParameter.tokParm(env));
	
	ArrayList sterms = new ArrayList();
	sterms.add(t);

	return new Term (parms, sterms);
    }


    protected Term commandTerm (Term t) throws Exception {
	ArrayList parms = new ArrayList();
	parms.add(SParameter.opidParm("!command"));
	parms.add(SParameter.boolParm(true));

	ArrayList sterms = new ArrayList();
	sterms.add(t);

	return new Term (parms, sterms);
    }

    protected String opidOfTerm (Term t) throws TermException {
	Parameter p = t.parametern(1);
	
	if ((p.getType()).equals("OPID")) {
	    return ((SParameter)p).getValue();
	}
	else { throw new TermException("Term has no opid", t); }
    }

    protected boolean isOpid (Term t, String opid) throws TermException {
	Parameter p = t.parametern(1);
	
	if ((p.getType()).equals("OPID")) {
	    return ((SParameter)p).getValue().equals(opid);
	}
	else { return false; }
    }

    protected Term resultOfRsp(Term t) throws TermException { 
	Term result = t.subtermn(1);
	
	String opid = opidOfTerm(result);
	
	if (opid.equals("!value")) {
	    return result.subtermn(1);
	} else if (opid.equals("!fail")) {
	    throw new TermException("Request failed", result); 
	} else { 
	    throw new TermException("Result not a value", result); 
	}
    }

    protected void okRsp(Term t) throws TermException { 
	Term result = t.subtermn(1);
	
	String opid = opidOfTerm(result);
	
	if (opid.equals("!fail")) {
	    throw new TermException("Request failed", result); 
	}
    } 
    
    public Term evalCommand(Term t) throws Exception {
	
	System.out.println("Eval Command\n");

	long pre = (new Date()).getTime();

	send(reqTerm(seq++, commandTerm(t)));
	Term r = resultOfRsp(recv());
	long post = (new Date()).getTime();

	long elapsed1 = pre - lasteval;
	long elapsed2 = post - pre;
	String opid = opidOfTerm(t);

	if (verbose) {
	    System.out.println("Eval " + opid + " Last " + elapsed1 + " Elapsed " + elapsed2);
	}
	
	lasteval = post;
	return r;
    }

    public void sendReq(Term t) throws Exception {
	send(reqTerm(seq++, commandTerm(t)));
    }
    public Term recvRsp() throws Exception {
	return recv();
    }

    public void evalCommandn(Term t) throws Exception {
	long pre = (new Date()).getTime();
	send(reqTerm(seq++, commandTerm(t)));
	okRsp(recv());
	long post = (new Date()).getTime();

	long elapsed1 = pre - lasteval;
	long elapsed2 = post - pre;
	String opid = opidOfTerm(t);

	if (verbose) {
	    System.out.println("Eval " + opid + " Last " + elapsed1 + " Elapsed " + elapsed2);
	}
	lasteval = post;
    }

    public Term echo(Term t) throws Exception { 
	System.out.println("echo\n");
	Term c = new Term (SParameter.opidParm("echo"), t);
	return evalCommand(c);  }
}
