
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)


;;;;	
;;;;	At some point after edit modification, need to refresh
;;;;	term to reflect change.
;;;;	
;;;;	  - desire labels and tags(?) to be robust.
;;;;	  - should be similar to asynch mod.
;;;;	  
;;;;	
;;;;	
;;;;	after asynch mod to dyn-term need edit to reflect mod.
;;;;	
;;;;	
;;;;	let vobject update happen from below.
;;;;	ie do dyneval-set and let it modify vojbject
;;;;	
;;;;	
;;;;	
;;;;	in direct dynamic terms like the peregrinator 
;;;;	are not generally directly updated. However direct edit
;;;;	of directories is. Direct updates will lose/move edit labels.
;;;;	Desire labels to be moved, or require (encourage) dir views to be indirect.
;;;;	
;;;;	
;;;;	
;;;;	

;;;;	
;;;;	Two scenarios :
;;;;	  - lib asynch modifies dynamic term data.
;;;;	      * need to recompute when arg data touched. 
;;;;	      * call hook informs edit after recomputation.
;;;;	
;;;;	
;;;;	  - edd synch modifies dynamic term args.
;;;;	      * need to recompute only when args modified.
;;;;	      * edit intentionally calls for recomputation.
;;;;	      * need to call dyneval-synch-refresh
;;;;	
;;;;	
;;;;	

(defun view-of-oid (oid)
  (find-first #'(lambda (v)
		  (let ((o (oid-of-view v)))
		    (when (and o (equal-oids-p oid o))
		      v)))
	      *views*))


;; when called?
;; after every structure mod with touchp nil.
;; on demand with touchp t.
(defun maybe-dyneval-set (v touchp)
  (let ((oid (oid-of-view v)))

    (when (edit-refresh-oid-p oid)

      (let ((term (term-of-view v)))

	;;(setf -term term -v v) (break "mds")

	;;(setf (oid-object-edit obj) term)
	;; might we be overwriting asnych updated term?
	;; use flags to detect and then force complete refresh.
	(dyneval-set oid term)

	;; (save-dynamic-term term) ; to be used when saving to lib.
    
	;; could try to sneak it onto touch history and let end hook take care of this.

	;; maybe view touched should be lazier.
	(when touchp
	  (when v (view-touched v)) ))

      t)))




;; this is different than touch by broadcast.
;; Here we need only recompute, we do not need to regenerate args???
;; actuall both come through here.

;; called from dyneval hook or by (m-x)dyn-refresh
;; when called from hook do not need to recompute as that is already done.
;; when called from dyn-refresh then need to do a synch form of recomputation.
(defun edit-touch-dynamic (v)
  ;;(format t "edit-touch-dynamic ~a~%" (car (titles-of-view v)))
  (view-flag-set-touched v t)
  v)



;;;;	fixup :
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	

(define-primitive |!lib_record| ((oid . oid) (token . link)) (name status other))
(define-primitive |!lib_record_status|
    ((string . kind)
     (bool . active)
     (bool . compiled)
     (bool . sticky)))

(defun ilib-record-status (ostate &optional oid)
  
  (if (or (null ostate) (iobject-state-not-term-p ostate))
      (ilib-record-status-term "    " nil nil nil)

      (let ((kind (kind-of-iobject-state-term ostate)))
	(when (and oid (eql kind 'term) (dag-directory-p oid))
	  (setf kind 'dir))
	(ilib-record-status-term (pad-string (string kind) 4 t)
				 (active-of-iobject-state-term ostate)
				 (translated-of-iobject-state-term ostate)
				 (not (allow-of-iobject-state-term ostate))))))

(defun lib-record-nmemonic (link name)
  (string (if (eql link '||)
	      (or name link)
	    link)))

;; need only do this if in scroll-list or if not in dyneval
(defun dag-child-to-lib-record (term)
  ;;(format t ".")
  (let ((dc (term-of-wrapped-term term)))
    (transfer-wrapper
     term
     (let* ((oid (oid-of-idag-child-term dc))
	    (ostate (if (idag-child-state-term-p dc)
			(state-of-idag-child-state-term dc)
			(lookup-ostate oid))))

       (ilib-record-term oid
			 (name-of-idag-child-term dc)
			 (itext-term (pad-string
				      (string (lib-record-nmemonic (name-of-idag-child-term dc)
								   (name-property-of-ostate oid)))
				      20 10))
			 (ilib-record-status ostate oid)
			 (or ostate (ivoid-term)))))))

(defun edit-term-fixup (term)
  ;;(format t "edit-term-fixup~%")
  ;;(break "etf")
   (term-replace term
		 #'(lambda (x) (or (idag-child-state-term-p x)
				   (iscroll-list-term-p x)
				   (idag-child-term-p x)))
		 #'(lambda (term)
		     (if (or (idag-child-state-term-p term)
			     (idag-child-term-p term))
			 (dag-child-to-lib-record term)
			 term))))

(defun instantiate-dynamic-object (oid)

  ;;(setf -oid oid) (break "ido")
  (let ((dterm (with-ignore (lookup-term oid))))
    (when dterm

      (let ((term (edit-term-fixup dterm))
	    (geo (edit-read-geo oid))
	    (implicit (edit-read-implicit oid)))

	(new-vobject oid term implicit geo)))))
		      

;; called by  view-touch to 
(defun edit-dynamic-refresh (v)

  ;;(format t "edit-dynamic-refresh~%")
  (let ((oid (oid-of-view v)))

    ;; could be called by separate transaction end hook.
    ;; should not be called if refresh called by end hook.
    (dyneval-synch-refresh 'editrefresh oid)

    (let ((vobj (instantiate-dynamic-object oid)))

      (when vobj

	(set-view-object v vobj)
	(view-dtree-init v
			 (term-of-vobject vobj)
			 (implicit-of-vobject vobj))
	))))


;; if viewing dir listing and dir changed then loose point.
;; this should try to put point in a similar position.

;;;;	modify some dir.
;;;;	dir oid is touched.
;;;;	transaction end hook refreshes nav.
;;;;	nav is affected.
;;;;	end hook calls dyneval hook.
;;;;	dyneval hook sets touched.
;;;;	edit-refreshses
;;;;	refresh calls fixup.
;;;;	
;;;;	
;;;;	
;;;;	need laziness to avoid duplication of effort.
;;;;	
;;;;	



(defun elib-move-point (old new) (declare (ignore old)) new)



(defun edit-dyneval-touched (oid term def)
  ;;(declare (ignore term def))

  ;;(format t "Dyneval touched ~a~%" (name-property-of-ostate oid))

  ;;(setf -oid oid -term term -def def) (break "edt")
  (let ((v (view-of-oid oid)))
    (when v (edit-touch-dynamic v))))
  

;;(add-dyneval-hook 'update-edit #'edit-dyneval-touched)




;;;;	
;;;;	Orphans? 
;;;;	  want to be able to find, but will not be able to jump.
;;;;	  - have dynamic root dir of orphans which is 
;;;;	    built on demand ??
;;;;	
;;;;	not orphans but not listed in a directory, ie anchored by some object in a dir.
;;;;	
;;;;	orphans and not directory referenced can not be found via dir jumping so
;;;;	need another search and make dynamic dir method.
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	Finding named objects in directory tree.
;;;;	  List : show list of all objects with matching name.
;;;;	   - select then jump?
;;;;	  Jump : jump navigator to next matching name in traversal of dir tree.
;;;;	   - need to know current position.
;;;;	      * relative to all roots.
;;;;	      * relative to cur dir as root.
;;;;	      * in current directly explicitly.


(defunml (|refiner_subtree_listings| (path))
    ((tok list) -> ((tok |#| object_id) list))
  (let ((refdesc (new-event-description *system* *version* '(refine))))
    (mapcan #'(lambda (e)
		(let ((oid (cadr e)))
		  (let ((kind (kind-of-oid oid))
			(desc (description-of-ostate oid)))
		  
		    (when (case kind
			    (abs (match-descriptions-p desc refdesc))
			    (stm t)
			    (code (match-descriptions-p desc refdesc)))
		      (list (cons (car e) oid))))))

	    (subtree-listings path))))


;;;;	
;;;;	desire ability to indirectly tie windows to 
;;;;	arbitrary data, here we make dummy up object data.
;;;;	
;;;;	this is just dynamic 
;;;;	
;;;;	Examples 
;;;;	  - eval history
;;;;	  - open list
;;;;	  - io-history
;;;;	  - Navigator.
;;;;	
;;;;	could use to store ancillary data for other objects such as search patterns in navigator.
;;;;	
;;;;	
;;;;	


(defvar *edit-oid-assoc* nil)

(defstruct edit-oid-element
  data
  dispose
  id
  )

(defun data-of-edit-oid-element (e) (edit-oid-element-data e))
(defun dispose-of-edit-oid-element (e) (edit-oid-element-dispose e))
(defun id-of-edit-oid-element (e) (edit-oid-element-id e))


(defun edit-oid-assoc-add (oid element)
  (setf *edit-oid-assoc* (acons oid element *edit-oid-assoc*)))

(defun edit-oid-assoc-lookup (oid)
  (cdr (assoc (stamp-of-oid oid) *edit-oid-assoc* :key #'stamp-of-oid :test #'equal)))

(defun edit-oid-assoc-lookup-data (oid)
  (let ((e  (edit-oid-assoc-lookup oid)))
    (when e
      (data-of-edit-oid-element e))))


(defun edit-oid-assoc-delete (oid)
  (let ((e (edit-oid-assoc-lookup oid)))
    (when e

      (setf *edit-oid-assoc* (delete (stamp-of-oid oid) *edit-oid-assoc*
				     :key #'(lambda (ee) (stamp-of-oid (car ee)))
				     :test #'equal))
      (let ((f (dispose-of-edit-oid-element e)))
	(when f (funcall f e)))

      (data-of-edit-oid-element e))))

(defun edit-oid-assoc-reset ()
  (dolist (o-e *edit-oid-assoc*)
    (let ((e (cdr o-e)))
      (let ((f (dispose-of-edit-oid-element e)))
	(when f (funcall f e))))))


(defun edit-oid-assoc-limit (id n)
  (dolist (oid (nthcdr n (mapcan #'(lambda (o-e)
				     (let ((e (cdr o-e)))
				       (let ((eid (id-of-edit-oid-element e)))
					 (when (eql eid id)
					   (list (car o-e))))))
				 *edit-oid-assoc*)))
    (edit-oid-assoc-delete oid)))


  
;;;
;;;    history walk.
;;;

;; could tie to a log file so as to recover on reconnect.
;; twould be overkill but neat to remember edit state thus as well.

(defvar *eval-history* (new-history
			(cons (list* 64 7 nil)
			      '((32 15) (16 15) (16)))))

(defunml (|eval_history_push| (term))
    (term -> unit)

  (history-update *eval-history* term)
  nil)

(defunml (|open_evaluator_history_walk| (oid))
    (object_id -> term)

  (let ((w (history-walk-begin *eval-history* t)))

    (edit-oid-assoc-add oid
			(make-edit-oid-element
			 :data w
			 :dispose #'(lambda (e)
				      (history-walk-end (data-of-edit-oid-element e))
				      )
			 :id 'evaluator))

    (let ((term (history-walk-peek w)))
      (if (term-p term)
	  term
	  (ivoid-term)))))


(defunml (|close_evaluator_history_walk| (oid))
    (object_id -> unit)

  (edit-oid-assoc-delete oid)
  nil)


(defunml (|evaluator_history_walk| (dir oid))
    (bool -> (object_id -> term))

  (let ((w (edit-oid-assoc-lookup-data oid)))

    (if dir
	(history-walk-forward w)
	(history-walk-backward w))

    (let ((term (history-walk-peek w)))
      (unless (term-p term)
	(raise-error (error-message '(evaluator history term not))))
      term)))

(defunml (|evaluator_history_walk_peek| (oid))
    (object_id -> term)

  ;;(break "ehwp")

  (let ((w (edit-oid-assoc-lookup-data oid)))

    (let ((term (history-walk-peek w)))
      (unless (term-p term)
	(raise-error (error-message '(evaluator history term not))))
      term)))




;;;;	
;;;;	eventually have history be in db so as to be persistent.
;;;;	some sort of static list rather than a history would be another
;;;;	complimentary construct.
;;;;	


(defun state-history-push (h term)
  (let ((fst (first-of-history h))
	(snd (second-of-history h)))
    (if (or (null fst)
	    (and (not (compare-terms-p term fst))
		 (or (null snd)
		     (not (compare-terms-p term snd)))))
	(progn (history-update h term) t)
	nil)))

(defun state-open-history-walk (id h oid)

  (format t "HO")

  (let ((w (history-walk-begin h t)))

    (edit-oid-assoc-add oid
			(make-edit-oid-element
			 :data w
			 :dispose #'(lambda (e)
				      (history-walk-end (data-of-edit-oid-element e)))
			 :id id))

    (let ((term (history-walk-peek w)))
      (if (term-p term)
	  term
	  (ivoid-term)))))


(defun state-close-history-walk (oid)
  (format t "HC")

  (edit-oid-assoc-delete oid))


(defun state-history-p (oid)
  (and (edit-oid-assoc-lookup-data oid) t))


(defun state-history-walk (dir oid)

  (let ((w (edit-oid-assoc-lookup-data oid)))

    (if dir
	(history-walk-forward w)
	(history-walk-backward w))

    (let ((term (history-walk-peek w)))
      (unless (term-p term)
	(raise-error (error-message '(state history term not))))
      term)))


(defun state-history-walk-peek (oid)

  (let ((w (edit-oid-assoc-lookup-data oid)))

    (let ((term (history-walk-peek w)))
      (unless (term-p term)
	(raise-error (error-message '(state history term not))))
      term)))

  


(defvar *pattern-history* (new-history
			   (cons (list* 64 7 nil)
				 '((32 15) (16 15) (16)))))

(defunml (|pattern_history_push| (oid term))
    (object_id -> (term -> unit))
  (format t "H")
  (when (state-history-push *pattern-history* term)
    ;;(state-close-history-walk oid)
    )
  nil)

(defunml (|open_pattern_history_walk| (oid))
    (object_id -> term)
  (edit-oid-assoc-limit 'pattern 10)
  (state-open-history-walk `pattern *pattern-history* oid))

(defunml (|close_pattern_history_walk| (oid))
    (object_id -> unit)
  (state-close-history-walk oid)
  nil)

(defunml (|pattern_history_walk| (dir oid))
    (bool -> (object_id -> term))

  (unless (state-history-p oid)
    (edit-oid-assoc-limit 'pattern 10)
    (state-open-history-walk `pattern *pattern-history* oid))
  (state-history-walk dir oid))

(defunml (|pattern_history_walk_peek| (oid))
    (object_id -> term)

  (unless (state-history-p oid)
    (edit-oid-assoc-limit 'pattern 10)
    (state-open-history-walk `pattern *pattern-history* oid))

  (state-history-walk-peek oid))

  

;;(add-dyneval-hook 'update-edit #'edit-dyneval-touched)
(defunml (|dyneval_demand_refresh| (term))
    (term -> term)

  (let ((e (expression-of-idyneval-term term)))
    (mlet* (((newv newe) (dynamic-eval e (value-of-idyneval-term term))))

	   ;;(setf -newv newv -newe newe) (break)
	   (idyneval-term (oid-of-idyneval-term term)
			  t
			  (conditions-of-idyneval-term term)
			  (or newe e)
			  (ivoid-term)
			  newv))))


