
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

(defun allocate-dforms (stamp tag)
  (new-dform-table stamp tag))

(defun allocate-precedences (stamp tag)
  (precedence-table stamp tag))



(defun init-edit-resource (kind value)
  ;;(setf -kind kind -value value) (break "ier")
  (case kind
    (LABELS (inform-labels value))
    (FONTS (inform-fonts value))
    (CHARACTERLABELMAP (inform-character-label-map value))
    (CHARACTERGLYPHMAP (inform-character-glyph-map value))
    (otherwise nil)
    ))

(defun init-edd ()
  (pushnew :fdl-edd *features*))


(defunml (|write_view_to_file_as_ptree| (view filename))
    (view -> (string -> unit))
  (with-prl-open-file (stream filename out)
    (write-ptree-to-stream (layout (dtree-of-view view) 80) stream)))
					


;;;;	view (oa)
;;;;
;;;;	edit-get-geo 
;;;;	edit-put-geo 
;;;;	edit-get-term
;;;;	edit-put-term
;;;;	edit-check
;;;;	
;;;;	
;;;;	
;;;;	


(defun edit-read-source (oid)
  (orb-get-term oid))	    

(defun edit-read-geo (oid)
  (let ((geo (property-of-ostate 'geometry oid)))
    (when geo
      (map-isexpr-to-list geo (icons-op) #'int-of-iint-term))))

(defun edit-read-implicit (oid)
  (let ((imp (property-of-ostate 'implicit oid)))
    (when imp
      (map-isexpr-to-list imp (icons-op) #'id-of-ivariable-term))))



;; kludge should be better way need these defs in com-lib but clash
;; which lib versions in lib-defs. why not let lib-def recompile?
(defun name-of-oid (oid) (name-property-of-ostate oid))
(defun kind-of-oid (oid) (kind-of-ostate oid))


