%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

%
;;;;	view_object : object_address -> view
;;;;	
;;;;	
;;;;	
;;;;	


%

let view_object = view_open;;

let show_object oid v =
 view_disassociate_object false v;
 view_associate_object oid v;
 view_refresh v
;;
    

let view_oid = view_object;;
let view_oids oids = map view_object oids;;

let view_name manyp name =
 let oids = oids_with_name name in
  if (null oids) then (raise_error [] ``view_name none`` [itoken_term name]; fail)
  else (if (length oids) > 1 then tty_print (concatenate_strings [ "view_name multiple values "
								 ; int_to_string (length oids) ])
        ; (if (length oids) > 1 then (if manyp then view_show (map_to_ilist ioid_term ioid_cons_op oids)
			                       else view_oid (hd oids))
	   else view_oid (hd oids)))
;;
 
let view = view_name false;;

% todo should find matching view(s?) and kill %
let kill_view_oid () = 
 failwith `kill_view_oid`;
 ()
;;



let oed_view_stm_prf v =
 view_prf_of_stm (view_object_q v)
;;


let edd_replace_top_term term v = 
    edit_tag_address point_tag nil true v;

    edit_cut point_tag v;
    edit_paste_term point_tag term v 
;;

let pui_replace_top_term term = edd_replace_top_term (proof_editor_wrap term)
;;
let found_tag = tok_to_tag `FOUND`;;
% ce tester ignores ! in opids %
let proof_search_up_ce = edit_ce_string_to_expression "$proof_node";;

let proof_search_ce = edit_ce_string_to_expression "$proof_node";;

let temp_tag = tok_to_tag `TEMP`;;
let edd_replace_top_mark term v = 
    edit_tag_address mark_tag nil true v;

    edit_cut mark_tag v;
    edit_paste_term mark_tag term v;

    edit_remove_label mark_tag v
;;

let pui_replace_top_mark term = edd_replace_top_mark (proof_editor_wrap term);;

let eddtop_save v = 
 let top = oed_filter (view_term_q v) in
 eddtop_save_obj (proof_editor_unwrap top v) v
;;


let address_of_iproof_node_term term = subterm_of_term term 2
;;
let address_of_proof_node_term term =
 address_term_to_list (address_of_iproof_node_term term) 
;;

% move window on proof to first unproven subgoal, no-op if complete %
let oed_proof_jump v =
  eddtop_save v;  
  pui_replace_top_mark (edd_add_point_label (first_unrefined_prf_of_view v)) v
;;

let equal_goals t goal (tac:term) (subgoals:(term list)) = alpha_equal_terms t goal;;
letref oed_proof_filter_p t = equal_goals t;;

let view_proof_filter t v =
 let addresses = prf_filter (oed_proof_filter_p t) v in
   addresses
;;

let oed_view_stm_prfs v =
 let views = view_prfs_of_stm (view_object_q v) in 
 oed_proof_jump (hd views)
;;

let oed_view_prf_prfs v =
   let soid = stm_of_view v in
   let views = view_prfs_of_stm soid in 
   oed_proof_jump (hd views)
;;

let oed_view_new_stm_prf v =
 let v' = view_new_prf_of_stm (view_object_q v) in 
 oed_proof_jump v'
;;

let goal_of_iproof_node_term term = subterm_of_term term 3
;;
let subgoals_of_iproof_node_term term = subterm_of_term term 5
;;
%
these defined in oed-ref.lsp
     object_of_view
     top_proof_of_proof_object
     top_proof_of_view
        
%

let term_break v = itoken_term v = ivoid_term ;;

let view_search ce tag1 tag2 view =
  view_search_up ce tag1 tag2 view ?
  view_search_down ce tag1 tag2 view
;;

let find_node_at_point_aux dir v =

% find first proof-editor term above point %

  eddtop_save v;
  if dir then view_search proof_search_up_ce point_tag found_tag v
  else view_search_up proof_search_up_ce point_tag found_tag v;

  let term = edit_term_at_label found_tag false v in
    edit_remove_label found_tag v;
    let a = address_of_proof_node_term (oed_filter term)
    in
    let top = top_edit_proof_of_view v in
    find_node_at_address top a
;;

let find_node_at_point = find_node_at_point_aux true
;;

% move up from the node you are at until you reach an incomplete node %
let oed_proof_jump_up v =
  eddtop_save v;  
  let address = address_of_proof_node_term (find_node_at_point v) and
      top = top_edit_proof_of_view v in
  pui_replace_top_mark (edd_add_point_label (proof_jump_up_aux address top)) v
;;

let oed_proof_jump_next v =
  let address = address_of_proof_node_term (find_node_at_point v) in
  pui_replace_top_mark (edd_add_point_label (next_unrefined_prf address v)) v
;;
% move up from the node you are at until you reach an incomplete node with no subgoals %
let oed_proof_jump_down = oed_proof_jump_next;;

let oed_proof_jump_to_address v addr =
  eddtop_save v;
  let top = top_edit_proof_of_view v in
  let node = find_node_at_address top addr in
    pui_replace_top_term node v
;;    

let null_goal_term =
  make_term (`!inf_goal`, [])
   [([],  iplaceholder_term); ([], (make_term (`!annotation_cons`, []) []))]
;;

let goal_of_iinf_goal = subtermn 1;;

let oed_stm_save_goal goal oid =
    lib_eval (oid_ap (term_ap
		      (begin_ap "\\goal oid. lib_modify_stm_goal oid goal")
		      goal) oid)
;;

let oed_proof_save_goal_aux stm_p v =

    let node = find_node_at_point v in
    if not (null (address_of_proof_node_term node)) then
    (raise_error [] ``save goal not`` [node]; fail)
    else
    let goal = goal_of_iproof_node_term node and oid = oid_of_view v in
    oed_stm_save_goal (goal_of_iinf_goal goal) oid;
    lib_eval (oid_ap (term_ap
		      (begin_ap "\\goal oid. lib_modify_prf_goal oid goal")
		      goal)
	     oid);
    
    pui_replace_top_mark (set_top_proof_goal goal v) v;
    edit_tag_address point_tag (prf_tac_addr()) true v;
;;

let oed_proof_save_goal = oed_proof_save_goal_aux true;;
let oed_save_prf_goal = oed_proof_save_goal_aux false;;

let oed_proof_refine_aux f v =
 
  let term = find_node_at_point v in 
  let top = proof_editor_unwrap (oed_filter (view_term_q v)) v and
      goal = top_goal_of_view v in
  if (alpha_equal_terms goal null_goal_term) or (alpha_equal_terms goal imp_null_goal_term) then
  oed_proof_save_goal v;
  let view_address = address_of_proof_node_term top in
  let newtop = replace_proof_node_top v (edd_add_point_label (f v term)) in
  pui_replace_top_mark (find_node_at_address newtop view_address) v
;;

% executes one refine, then reuses matching refined children from prf in the library %
let oed_proof_refine = oed_proof_refine_aux edit_proof_refine;;

% executes one refine, does not reuse any existing refined children %
let oed_proof_step_refine = oed_proof_refine_aux edit_proof_step_refine;;    

% replays the proof, does not fail if extra or missing subgoal, reuses proof in lib
if it exists but displays other status %
let oed_proof_tree_refine = oed_proof_refine_aux edit_proof_tree_refine;;

% refines using the tttt term on the term stack, same behavior as above%
let oed_proof_tttt_refine = oed_proof_refine_aux edit_proof_tttt_refine;;

% executes one refine, reusing children from prf in the editor %
let oed_proof_edit_refine = oed_proof_refine_aux edit_proof_edit_refine;;

% replays the proof reusing the children in the editor when it breaks but shows other
status %
let oed_proof_edit_tree_refine = oed_proof_refine_aux edit_proof_edit_tree_refine;;

% refines by kreitzing the subtree into one tactic%
let oed_proof_kreitz_refine = oed_proof_refine_aux edit_proof_kreitz_refine;;

% refines the tree by dekreitzing current tactic %
let oed_proof_dekreitz_refine = oed_proof_refine_aux edit_proof_dekreitz_refine;;

let oed_asynch_proof_refine_aux2 refinef v =

    let node = find_node_at_point v and  
        top = proof_editor_unwrap (oed_filter (view_term_q v)) v and
        goal = top_goal_of_view v in
       
    if alpha_equal_terms goal null_goal_term then oed_proof_save_goal v;    
    let top_address = address_of_proof_node_term top and
        (op, (s . ([],addr) . ([],goal) . ([], ref) . r)) =
        destruct_term (unnumber_proof_node node v) in

    let (op, (([],tactic) . r)) = destruct_term ref in
    refinef (oid_of_view v) addr goal tactic;
    edit_remove_label point_tag v;
    pui_replace_top_mark (replace_proof_node top (show_refine_pending node)) v
;;

let oed_mark_address v =
   term_stack_push (address_of_iproof_node_term (find_node_at_point v))
;;


% move window on proof down to first child %
let oed_proof_down v =
  let address = address_of_proof_node_term (find_node_at_point v) and
      top = oed_filter ( top_edit_proof_of_view v) in
  (pui_replace_top_mark
   (edd_add_point_label 
     (first_subgoal_of_proof (find_node_at_address top address))) v)
  ? ()
;;

% move window on proof up to next ancestor of top %
let oed_proof_up_view v =

  let node = find_node_at_point v and
      top = proof_editor_unwrap (oed_filter (view_term_q v)) v and
      etop = top_edit_proof_of_view v in
  let a = address_of_proof_node_term top in
  if length a = length (address_of_proof_node_term etop) then () else
  let n = replace_proof_node etop (edd_add_point_label node) in
  let newtop = find_node_at_address n (butlast a) in
  pui_replace_top_mark (edd_add_point_label newtop) v
;;

% move cursor up to next ancestor of top %
let oed_proof_up v =
  let address = address_of_proof_node_term (find_node_at_point v) in
  if address = [] then ()
  else 
  let top = find_node_at_address (top_edit_proof_of_view v) (butlast address) in
  pui_replace_top_mark (edd_add_point_label top) v 
;;

let oed_proof_right v = 
  let address = address_of_proof_node_term (find_node_at_point v) in 
  pui_replace_top_mark (edd_add_point_label (find_node_at_address (top_edit_proof_of_view v)
			    (append (butlast address) [((last address) + 1)])))
                         v ? ()
;;

let oed_proof_left v = 
  let address = address_of_proof_node_term (find_node_at_point v) in
  let i = (last address) ? 1 in
  if i = 1 then ()
  else
  pui_replace_top_mark (edd_add_point_label (find_node_at_address (top_edit_proof_of_view v)
			   (append (butlast address) [(i - 1)])))			  
	                 v ? ()
;;

let oed_proof_right_most v = 
  let address = address_of_proof_node_term (find_node_at_point v) and
      top = top_edit_proof_of_view v in
  let last = length (map_isexpr_to_list (`!proof_node_cons`,[]) id
					(subgoals_of_iproof_node_term
					 (find_node_at_address top (butlast address)))) in
  pui_replace_top_mark (edd_add_point_label (find_node_at_address top (append (butlast address) [last])))
                         v ? ()
;;

let oed_proof_left_most v = 
  let address = address_of_proof_node_term (find_node_at_point v) in
  let i = (last address) ? 1 in
  if i = 1 then ()
  else
  pui_replace_top_mark (edd_add_point_label (find_node_at_address (top_edit_proof_of_view v)
			   (append (butlast address) [1])))
	                 v ? ()
;;

let oed_proof_next v =
   pui_replace_top_mark (edd_add_point_label (next_proof v)) v ? ()   
;;

let oed_proof_prev v =
   pui_replace_top_mark (edd_add_point_label (prev_proof v)) v ? ()
;;

let oed_proof_move v =
  eddtop_save v;
  pui_replace_top_mark (edd_add_point_label (edit_proof_move v)) v
;;

   
% make node at point top in window %
let oed_proof_zoom v = pui_replace_top_term (find_node_at_point v) v
;;

% move window on proof up to next ancestor of top %
let oed_proof_top v = pui_replace_top_term (top_proof_of_view v) v;;

%assumes must be at top%
let oed_proof_lib_save v =
  let top = top_edit_proof_of_view v in
  lib_eval (oid_ap (term_ap
		      (begin_ap "\\term oid. lib_modify_prf_src oid term")
		      (unnumber_proof_node top v))
		   (oid_of_view v));
  set_top_proof top v;
  pui_replace_top_term top v
;;
    
let oed_proof_create_scratch v =
  let top = top_edit_proof_of_view v and
      soid = stm_of_view v in
  let n = name_property soid in
  let node = find_node_at_address top (address_of_proof_node_term (find_node_at_point v)) in
  let name = string_to_tok (J (tok_to_string n) (J " " (datetime_sortable (utime())))) in
  let v' = edd_make_new_proof node (oid_of_view v) soid name in
  view_cmd (edit_tag_address point_tag nil true) v'
;;

let oed_proof_interior v =
 
  let a = address_of_proof_node_term (find_node_at_point v) and
      oid = oid_of_view v in
  let node = find_node_at_address (top_edit_proof_of_view v) a in
  let name = string_to_tok (J (tok_to_string (name_property oid)) (J " " (datetime_sortable (utime())))) in
  edd_interior_proof node oid (view_open (dummy_object_id ())) name
;;


let oed_proof_primitive v = 
  let term = find_node_at_point v in
  let a = address_of_proof_node_term term and
      n = name_property (stm_of_view v) in 
  let node = find_node_at_address (top_edit_proof_of_view v) a and
      name = string_to_tok (J (tok_to_string n) (J " " (datetime_sortable (utime())))) in
  edd_primitive_proof (oid_of_view v) node (view_open (dummy_object_id ())) name
;;


let oed_copy_proof v = lib_copy_proof (oid_of_view v);;

let oed_remove_prf v = remove_prf (oid_of_view v);;

let oed_remove_backup_prfs v = remove_backup_prfs (oid_of_view v);;

let oed_set_first_prf v =
  set_first_prf (oid_of_view v);
  modify_view_title v
;;

let oed_update_prf v = pui_replace_top_term (edd_update_prf v) v
;;

letref view_show_proof_wrap_cache = inl () : unit + term;;

let view_show_proof_wrap_term () =
  outr
   (if (isr view_show_proof_wrap_cache)
       then view_show_proof_wrap_cache
       else view_show_proof_wrap_cache := 
	     (inr (term_lookup (descendent_s [`system-aux`; `src`; `proof show buttons`]))))
;;

let view_show_proof_wrap t = 
 (replace_term 2 (view_show_proof_wrap_term()) t)
 ? t
;;

let view_show_proofs term =
 let v = new_view false in
   view_associate_object (dummy_object_id ()) v;
   view_set_term (view_show_proof_wrap term) true v;
   view_open_window v;
   view_init_point v;
 v
;;

let oed_proof_stats v = view_show_proofs (proof_stats (stm_of_view v))  
;;


let set_mltoploop_cmd v term =

   (let curterm = view_term_q v in
     let cmd = subterm_of_term (term_of_wrapped_term curterm) 1 in
       if not (identical_terms_p null_cmd cmd) then oed_cmd_stack_push cmd);

   edit_tag_address point_tag [] true v;
   view_point_cut v;
   view_point_paste_term (iml_cmd_term term) v;
   edit_tag_address point_tag [1;1] true v;

 ()
;;



let oed_build_putedesc_aux v ioid =
  (set_mltoploop_cmd v
		     (ml_build_oid_ap (itext_term "putedesc")
				      (first_oid_of_term ioid)))
;;


let double_break_cons_op = (`!double_break_cons`, []);;

let double_break_ilist l =
  (map_to_ilist (\x.x) double_break_cons_op l)
;;

let show_precedence_tree v =
   view_show (make_term (`show`, [make_token_parameter `PrecdenceTree`])
	       [([], precedence_tree ())])
;;

letrec oed_term_stack_segment i l =
 if i = 0 then l
 else
  oed_term_stack_segment (i-1) ((oed_term_stack_peek i) . l)
;;

let show_term_list tok info list =
 view_show (make_term (`show`, [make_token_parameter `TermStack`])
	       [([],info); ([], double_break_ilist list)])
;;

let show_term_stack v =
   show_term_list `TermStack` ivoid_term  
    (oed_term_stack_segment 10 nil)
;;


let show_term_stack_top v =
   view_show (make_term (`show`, [make_token_parameter `TermStackTop`])
   	       [([], (oed_term_stack_peek 1))])
;;
   

let show_io_history v =
  let (hdr, l) = (io_history_snap ()) in 
     show_term_list `IO History` hdr l
;;


% may make sense to take term arg which is ml to evaluate to produce term result
  then can include ml in show to allow mod and implicit re-eval (refresh)
%

let show_object_data_term kind oid term =  
  (make_term (`show_data`, [make_object_id_parameter oid; make_token_parameter kind])
	        [([], term)])
;;

let show_ml_xref v =
 let oid =  (oed_term_stack_get_oid()) in
   view_show (show_object_data_term `XREF` oid
				    (xref_of_code_object oid))
;;

let show_dependencies v = 

 let oid =  (oed_term_stack_get_oid()) in
   view_show (show_object_data_term `Dependencies` oid
				    (dependencies_of_object oid))
;;

let show_dependents v = 

 let oid =  (oed_term_stack_get_oid()) in
   view_show (show_object_data_term `Dependents` oid
				    (dependents_of_object oid))
;;

let show_properties v =
 let oid =  (oed_term_stack_get_oid()) in
   view_show (show_object_data_term `Properties` oid
		(map_to_ilist (uncurry iproperty_term)
		   double_break_cons_op
   	  	   (get_properties oid)))
;;

let double_print_true v = double_print true;;
let double_print_false v = double_print false;;



let print_oid oid = print_ascii true_ce 80 (get_term oid) "~/test.prt";;



%
;;;;	
;;;;	db-view 
;;;;	
;;;;	show_db_term : term{data-persist} -> view
;;;;	  - data-persist term may be blotted.
;;;;	
;;;;	show_db_oid : oid -> view
;;;;	  - shows db term of related objc or lobjc
;;;;	
;;;;	
;;;;	show_logs  : tok list -> term list
;;;;	
;;;;	show_log_segment	: int -> int -> term -> view
;;;;	
;;;;	
%


let db_read_ap = (begin_ap "dbread ");;
let db_term term = (lib_eval_to_term (term_ap db_read_ap term));;

let db_read_oid_ap = (begin_ap "(dbread o link_of_objc o oc)");;
let db_oid oid = (lib_eval_to_term (oid_ap db_read_oid_ap oid));;

let show_db_oid_cmd v =
 let oid = (oed_term_stack_get_oid()) in
  view_show (db_oid oid);;

let show_db_term_cmd term = view_show (db_term term);;

let show_log_segment s l env = 
  show_term_list `LogSegment` (icons_term (inatural_term s) (icons_term (inatural_term l) (fst env)))
    (log_segment s l (snd env))
;;
  

% change pui view modes %

let oed_proof_view_mode mode v =

  let term = find_node_at_point v in
  let address = address_of_proof_node_term (oed_filter term) in

  let newtop = get_proof_variant mode v in

  pui_replace_top_term (find_node_at_address newtop address ? newtop) v
;;

%default%
let oed_proof_view_d = oed_proof_view_mode `d`;;

%verbose%
let oed_proof_view_v = oed_proof_view_mode `v`;;

%tactics%
let oed_proof_view_t = oed_proof_view_mode `t`;;

%address%
let oed_proof_view_a = oed_proof_view_mode `a`;;

%
let oed_proof_push v = 

let oed_proof_up v =

  view_search_up proof_search_up_ce point_tag found_tag v;

  let term = edit_term_at_label found_tag false v in
  edit_remove_label found_tag v;
  let top = oed_filter (view_term_q v) and
      etop = top_edit_proof_of_view v in
  let a = address_of_iproof_node_term top in
  if length a = length (address_of_iproof_node_term etop) then () else
  let newtop = find_node_at_address (replace_proof_node etop (oed_filter term)) (butlast a) in
  edd_replace_top_mark (edd_add_point_label newtop) v
;;
%

%need to move this to libenv - okay, moved to proof print object in system-aux%
% print_object defined later in utilities-2 so file order needs to be changed
 or this needs to be moved.
%%
let oed_proof_print v =
  let oid = oid_of_view v in
  print_object oid
;;
%

letref oed_stopped_view_oids = nil : object_id list;;    

let oed_suspend () = 
    oed_x_reset ();

  let vs = views () in
   if not (null vs) then
    (oed_stopped_view_oids :=
            map_omitting_failures
	                  (\v. let oid = inr (oid_of_view v) ? inl () in
                                 view_disassociate_object true v
				 ; view_discard v
				 ; if isr oid then outr oid else fail
			  )
			  (views())
    ; ())
;;

let oed_resume_aux () =
   fdl_editor ()
 ; win_init ()
 ; map view_oid oed_stopped_view_oids
 ; ()
;;
			   
			   
let oed_resume () =
  orb_queue_asynch_local_by_address  true 
     (orb_match_local_environment [`edd`])
     (unit_ap (begin_ap "oed_resume_aux"))
 ; ()
;;

