
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;;;;	Test with edd and lib same process
;;;;	
;;;;	(prep-test)
;;;;	(win-test)
;;;;	(test3)
;;(with-lib ('test) (ml-text "(objc_source (lib_object_contents (object_address (`FontTest` . nil))))"))


;;;;	something like:
;;;;	
;;;;	setup_connect 6289 (2896 - 2) "locke";;
;;;;	dc();;
;;;;	
;;;;	Then:
;;;;	
;;;;	In library : library_open_as ``rcctest`` `<some-name>`
;;;;
;;;;	Then in oed. 
;;;;	
;;;;	start_edd `<some-name>`
;;;;	edd.
;;;;	oed_init ();;      
;;;;	g.
;;;;	sysinit();;
;;;;
;;;;
;;;;	oed_init() takes a while.
;;;;
;;;;	sysinit() brings up toploop and navigator. If they are placeholders
;;;;	then you forgot the g. oed_reset() and then sysinit after the g. should fix.
;;;;	
;;;;	to switch from shell toploop to window input, at shell toploop enter:
;;;;
;;;;	win.
;;;;	 
;;;;	(cm-q) will return to shell toploop.
;;;;	
;;;;	Other new useful commands 
;;;;	(cm-a)tmd	toggle macro debug
;;;;	(cm-a)tpb	toggle process break
;;;;	
;;;;	
;;;;	Navigator:
;;;;	(c-(up)) (cm-(up)) : control iterates up 5 times, cm does ten.	
;;;;	same for down.
;;;;	
;;;;	(c-v) == (cm-(down))
;;;;	(m-v) == (cm-(up))
;;;;	(c-f) == (right)
;;;;	(c-b) == (left)
;;;;	(c-n) == (down)
;;;;	(c-p) == (up)
;;;;	
;;;;
;;;;	
;;;;	(c-_) aka (cs--)  : undo
;;;;	(c-+) aka (cs-=)  : redo
;;;;	
;;;;	 Editor still a little buggy, text mods and list mods in particular. Some debugging
;;;;	breaks will be encountered, when in doubt try :cont.
;;;;	
;;;;	see oed.macro or navigator.macro for other keys.
;;;;	I added some temp keybindings for proof motion in navigator.macro.
;;;;	
;;;;	
;;;;	oedmacro : string -> bool allow defining macros in top loop.
;;;;	
;;;;	You can run the v5 and v4 editors simultaneously but modifications
;;;;	in one will not gracefully affect the other.
;;;;	The Navigator in particular has lost some auto updates so, if something
;;;;	is missing try going up a level then back down.
;;;;   
;;;;	
;;;;	
;;;;	markb_test
;;;;
;;;;	In library :
;;;;	  library_open ``rmarkb_test``;;
;;;;
;;;;	In edd
;;;;	  start_edd `rmarkb_test`;
;;;;	  edd.
;;;;	  g.
;;;;	  sysinit();
;;;;	  win.



;;;;	let oid = (descendent (root `system`) ``view filters Navigator``);;
;;;;	let oid = (descendent (root `theories`) ``standard boot boot_begin``);;
;;;;
;;;;	let moid = (descendent (root `test`) ``testml``);;
;;;;	let toid = (descendent (root `test`) ``test_TODO``);;
;;;;	
;;;;	Important to call oed_init prior to view_open to ensure edit-state instead of view-state.
;;;;	
;;;;	g.
;;;;	let v = view_open oid;;
;;;;	g.
;;;;	
;;;;	l.
;;;;	(setf v (ml-text "v"));;
;;;;	(oed-focus-on (window-of-view (current-view)));;
;;;;	m.
;;;;	
;;;;	view_associate_object_reset v;;
;;;;	view_refresh v;;
;;;;
;;;;	view_close_window v;;
;;;;	
;;;;	view_disassociate_object false v;;
;;;;	view_discard v;;
;;;;	


;;;;	
;;;;	(runprl '|edd|)
;;;;	
;;;;	(reset)
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	


(defun init-edit-resources ()
  (read-resources (complete-system-path (list "bin") "fdl" "resources")
		  #'init-edit-resource)
  )

(defun re-init-glyph-map ()
  (reallocate-glyph-map)
  (read-resources (complete-system-path (list "bin") "fdl" "resources")
		  #'(lambda (kind value)
		      (case kind
			(CHARACTERGLYPHMAP (inform-character-glyph-map value))
			(otherwise nil)))
    ))

(defun rigm () (re-init-glyph-map))

(defun emlcomp (&optional (printp t) (oed-p nil))
  (com-ml-comp)
  (inml (ml-text
	 (list
	  (format-string "load_system true false ~a [\"library\"]"
			 (if printp "true" "false"))

	  "[ ([\"orb\"],"
          "   [\"orbm-bsc\"; \"orbm-edd\"])"

  	  "; ([\"top\"],"
          "   [\"comm-dag\"; \"comm-nlb\"; \"comm-graph\"; \"comm-lib\"; \"comm-nrf\"; \"utilities\"])"

	  "; ([\"edit\"],"
	  "   [\"eddm-edt\"; \"eddm-def\"; \"oedm-edt\"; \"eddm-mp\";"
          "    \"eddm-cmd\"; \"eddm-dyn\"; \"oedm-out\";"
	  "    \"pproof-aux\"; \"pproof\"; \"theory\"; \"nutils\"; \"nutils-2\"; \"utilities-2\"])"
	  "]"))) 
  )

(defun emlcomp-helm (&optional (printp t) (oed-p nil))
  (com-ml-comp)
  (inml (ml-text
	 (list
	  (if printp
	      "load_system true false true (nuprl_path_prefix())"
	      "load_system true false false (nuprl_path_prefix())" )
	  "[([\"sys\"; \"src\"],"
	  "  [\"orbm-bsc\"; \"comm-dag\"; \"comm-ost\"; \"comm-nlb\"; \"comm-graph\"; \"comm-lib\"; \"comm-od\"; \"comm-nrf\";"
	  "   \"orbm-edd\"; \"eddm-edt\"; \"eddm-def\"; \"oedm-edt\"; \"eddm-mp\"; \"eddm-cmd\"; \"eddm-dyn\"; \"oedm-out\"% \"eddm-bsc\"%])"
	  ";([\"lib\"; \"ml\"; \"standard\"], [\"utilities\"; \"pproof-aux\"; \"pproof\"; \"theory\"; \"nutils\"; \"nutils-2\"; \"utilities-2\"])"
	  
	  "]"))) 

  (when nil
        ;; oed-p
    (inml (ml-text
	 (list
	  "load_system true false true (nuprl_path_prefix())"
	  "[([\"lib\"; \"ml\"; \"standard\"], [\"general\"])"
	  ";([\"sys\"; \"src\"],"
	  "  [\"eddm-edt\"; \"oedm-edt\" "
	  "   ])]")))
	  ))

(defun emlcomp-mp (&optional (printp t) (oed-p nil))
  (com-ml-comp)
  (inml (ml-text
	 (list
	  (if printp
	      "load_system true false true (nuprl_path_prefix())"
	      "load_system true false false (nuprl_path_prefix())" )
	  "[([\"sys\"; \"src\"],"
	  "  [\"orbm-bsc\"; \"comm-dag\"; \"comm-ost\"; \"comm-nlb\"; \"comm-lib\"; \"comm-od\";"
	  "   \"orbm-edd\"; \"eddm-edt\"; \"eddm-def\"; \"oedm-edt\"; \"comm-nrf\"; \"eddm-mp\"; \"eddm-cmd\"; \"eddm-dyn\"; \"oedm-out\"% \"eddm-bsc\"%"
	  "   ])" 
	  ";([\"lib\"; \"ml\"; \"standard\"], [ \"primitives\"; \"term\"; \"utilities\"; \"pproof-aux\"; \"pproof\"; \"theory\"; \"nutils\"; \"nutils-2\"; \"utilities-2\"; \"jprover\"])"
	  "]")))
  (when nil
        ;; oed-p
    (inml (ml-text
	 (list
	  "load_system true false true (nuprl_path_prefix())"
	  "[([\"lib\"; \"ml\"; \"standard\"], [\"general\"])"
	  ";([\"sys\"; \"src\"],"
	  "  [\"eddm-edt\"; \"oedm-edt\" "
	  "   ])]")))
	  ))


(defunml (|gowin| (unit) :declare ((declare (ignore unit))))
    (unit -> unit)
  (go-win)
  nil)


;;;;	
;;;;	init for disksave
;;;;	init for restart
;;;;	init for load
;;;;	
;;;;	
;;;;	


(defun init-edd-base (&optional (expand-p nil))

  (init-com-base)

  (setf *component-kind* '|edd|)
  (pushnew :fdl-edd *features*)
  (init-edit-resources)

  ;; expand done in restart
  ;;(when expand-p (edd-expand))
  )


(defun init-edd-restart (&optional hotp)

  (init-com-restart t hotp)
  
  (if hotp
      (db-init *master-pathname*)
      (db-init (db-root-path t (find-db-path))))

  (setf *host* nil *display-index* nil)

  (let ((eddhost (get-config-data 'eddhost)))
    (when eddhost
      (setf *host* (car eddhost))
      (when (cdr eddhost)
	(setf *display-index* (cadr eddhost)))))

  ;; maybe com-client-restart?
  (unless hotp
    (ml-text "(setup_config_connect(); ()) ? tty_print \"setup_config_connect failed\""))

  ;;(push-message-suppression (message-filter-by-prefix `(WARNING DEPENDENCIES NOT NOTE)))
  (push-message-emit-suppression (message-filter-by-prefix `(WARNING DEPENDENCIES NOT NOTE)))

  ;;(setf *make-view-f* #'make-edit-state)
  (setf *make-view-f* #'make-view-state)

  (edd-expand (car (get-config-data 'memory-profile)))
  )

(defun do-init-edd (&optional (expand-p nil) (oed-p nil))

  (init-edd-base expand-p)

  (set-reload-global-alist)

  (init-com-top)
  (emlcomp nil oed-p)

  (init-edd-restart)
  
  (print-client-banner "Editor")
  )


(defun do-edd-restart ()
  (init-edd-restart)
  (print-client-banner "Editor")
  (eval `(in-package ,*system-package-name*))

  #+cmu
  (read-eval-print-loop)
)



(defun do-edd-hot-start ()

  (init-edd-restart t)

  ;; sets socket and libhost.
  ;;(print-client-banner "Editor")

  (eval `(in-package ,*system-package-name*))

  (format t ";;; HotStart (orb-init) ~%")
  (orb-init)

  (format t ";;; HotStart dc() ~%")
  (let ((orbe (match-environment-in-list '(orb) *component*)))
    (with-environment-actual orbe
      (with-appropriate-transaction (nil nil)
	(ml-text "if not (connected_p ()) then (dc();())")))
  
    (format t ";;; HotStart lib_env ~%")
    (let ((libenv (with-environment-actual orbe (ml-text "lib_env"))))
      (unless (match-bus-environment-p (list libenv))
	(format t ";;; HotStart restart ~%")
	(with-environment ((address-of-environment (match-environment-in-list (list '|edd|) *component*)))
	  (with-appropriate-transaction (nil nil)
	    (ml-text (format-string "restart_edd `~a`" libenv))))))

    (format t ";;; HotStart top/win. ~%")
    (top)
    
    ;;(go-win)
    ;;(format t ";;; HotStart top. ~%")
    ;;(top)

    #(top #'go-win)

    ;;#+cmu
    ;;(read-eval-print-loop)
    ))

(defun do-disk-init-edd ()
  (init-edd-base)
  (emlcomp nil)

  (format t "~%;;;~%;;;	")
  (format t "~%;;;	FDL Editor.~%;;;	")
  (format t "~%;;;~%;;;	(in-package \"FDL0\")(dodisk-edd)")
  (format t "~%;;;	(in-package \"FDL0\")(dodisk-edd t) ; overwrites current~%")
  (format t "~%;;;~%;;;	")
  )


(defun dodisk-edd (&optional overwrite)
  
  (dodisk #'do-edd-restart overwrite)
  ;;#+cmu (dodisk "/home/lolorigo/edd-restart.lsp" overwrite)
  )

(defunml (|dodisk_edd| (hotp name))
  (bool -> (tok -> unit))

  (if hotp
      (dodisk-kind name #'do-edd-hot-start)
      (dodisk-kind name #'do-edd-restart)))

(defmacro withedd (&body body)
  `(insys
    (with-environment ((address-of-environment (match-environment-in-list '(|edd|) *component*)))
      (with-local-transaction 
	  ,@body))))




;;;;	
;;;;	
;;;;	view_point_down_tree_cmd true v;;
;;;;	view_point_up_cmd v;;
;;;;	
;;;;	view_point_sibling_cmd false v;;
;;;;	view_point_sibling_cmd true v;;
;;;;	
;;;;	view_point_down_cmd true v;;
;;;;	
;;;;	view_move_point_text_cmd true v;;
;;;;	view_move_point_text_cmd false v;;
;;;;	
;;;;	view_delete_point_text_cmd true v;;
;;;;	view_delete_point_text_cmd false v;;
;;;;	
;;;;	view_insert_point_text_cmd true "fu" v;;
;;;;	view_insert_point_text_cmd true "6" v;;
;;;;	
;;;;	view_point_cut_cmd v;;
;;;;	view_point_paste_term_cmd ivoid_term v;;
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	

;;;;
;;;;	layout-modified if refresh-tree chooses no new dforms
;;;;	still need to present.
;;;;	
;;;;	
;;;;	
;;;;	


(defun go-edd ()
  (go-client)
  ;;(go-win)
  )

