
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

(defunml (|term_to_print_string| (x w))
    (term -> (int -> string))
  (let ((*ml-output-width* w))
    (term-to-ml-output x)))

(defunml (|rule_to_print_string| (x w))
	  (rule -> (int -> string))
   (let ((*ml-output-width* w))
     (term-to-ml-output (term-of-rule x))))

(defvar %ml-out-file nil)

(defun implode-ichar (ichar)
  (aref *character-token-array* ichar))

(defunml (|newline| (unit))
	  (unit -> token)
   (implode-ichar inewline))

(defunml (|open_snapshot_file| (overwrite)) 
	  (bool -> void)

  (unless *snapshot-file*
    (breakout evaluation '|No snapshot file.  Use set_snapshot_file.|))
  (when %ml-out-file
    (close %ml-out-file)
    (format t "Warning: open_snapshot_file: there existed an open snapshot file stream.~%\
It has been closed."))
  (setq %ml-out-file (outfile *snapshot-file* overwrite))
  )

(defunml (|close_snapshot_file| (ignore))
  (void -> void)
  ;;(declare (ignore ignore))
  
  (close %ml-out-file)
  (setf %ml-out-file nil)
  nil)

(defunml (|print_to_snapshot_file| (string))
    (string -> void)
  (princ string %ml-out-file))

(defunml (|print_return_to_snapshot_file| (ignore))
  (void -> void)
  ;;(declare (ignore ignore))

  (terpri %ml-out-file))


(defunml (|set_snapshot_file| (x))
	  (string -> void)
  (setf *snapshot-file* x))

(defunml (|reset_snapshot_file| (ignore))
	  (void -> void)
  ;;(declare (ignore ignore))

  (setf *snapshot-file* nil))


(defun check-sequent-closure (assumptions conclusion)
   ;;(break "cs")
   (with-variable-minor-invocation

      (dolist (assum assumptions)
	;; check for unbound variable injection in type.
	(dolist (var-id (free-vars (type-of-assumption assum)))
	  (when (not (variable-minor-use-p var-id))
	    (raise-error (error-message '(refiner instantiate sequent not-closed)
					var-id assumptions conclusion))))

	(when (set-variable-minor-use (id-of-assumption assum))
	  (raise-error (error-message '(refiner instantiate sequent duplicate-ids)
				      (id-of-assumption assum) assumptions conclusion))))

    ;; check for free vars in conclusion.
    (dolist (var-id (sticky-free-vars conclusion))
      (when (not (variable-minor-use-p var-id))
	(raise-error (error-message '(refiner instantiate sequent not-closed)
				    var-id assumptions conclusion))))))

(defstruct (sequent (:copier default-sequent-copy))
  assumptions
  conclusion)

(defstruct (proof-node (:include sequent)
		       (:print-function proof-print))
  rule
  children)

 
(defun incf-allocated-proof-count ()
  (when (boundp '*allocated-proof-count*)
    (incf *allocated-proof-count*)))

(defun instantiate-proof-node (assumptions conclusion)
  (incf-allocated-proof-count)
  (make-proof-node :assumptions assumptions :conclusion conclusion))

(defun instantiate-proof-node-r (assumptions conclusion)
  (check-sequent-closure assumptions conclusion)
  (instantiate-proof-node assumptions conclusion))



(defunml (|make_proof_node| (assumptions concl))
    ((assumption list) -> (term -> proof))
  (instantiate-proof-node-r assumptions concl))

(defunml (|hypotheses| (proof) :error-wrap-p nil)
    (term -> (term list))
  (assumptions-of-proof-term proof))

(defunml (|destruct_assumption| (term) :error-wrap-p nil)
    (term -> (variable |#| (term |#| bool)))
  (cons (id-of-assumption-term assum)
	(cons (type-of-assumption-term assum)
	      (hidden-assumption-term-p assum))))

(defunml (|conclusion| (proof) :error-wrap-p nil)
    (term -> term)
  (conclusion-of-proof-term proof))

(defunml (|refinement| (proof) :error-wrap-p nil)
    (term -> term)
  (cond
    ((refined-proof-node-p proof)
     (rule-of-proof-term proof))
    (t (breakout evaluation "refinement"))))

(defunml (|children| (proof) :error-wrap-p nil)
    (term -> (proof list))
  (cond
    ((refined-proof-node-p proof)
     (children-of-proof-term proof))
    (t (breakout evaluation "children"))))

(defunml (|status_of_rule| (rule))
  (rule -> tok)
   'nostatus)



#|
(defun print-objects (object last-object filename width append-p)
  (unless (null library$)
    (let ((start (if (eq first-object '|first|)
		     0
                   (position first-object library$)))
	  (end (if (eq last-object '|last|)
		   (1- (length library$))
                 (position last-object library$))))
      (unless (and start end) (error "Objects not in library."))
      (handle-file-error
       (with-open-file (*output-stream* filename
					:direction :output
					:if-exists (if append-p :append :new-version)
					:if-does-not-exist :create)
                       (let* ((*indentation* 0)
                              (*ml-print-library-width* width))
                         (for (name in (subseq library$ start (1+ end)))
                              (do
                                  (let ((obj (library-object name)))
                                    (format *output-stream* "~A ~A ~A~%"
                                            (status-string (object-status obj))
                                            (string (object-kind obj))
                                            (string name))
                                    (with-indentation
                                     2 #'print-Ttree (object-to-ttree obj (ml-print-library-width)))
                                    (when (and (eql (object-kind obj) 'THM)
                                               (is-name-of-ext-theorem name))
                                      (new-line)
                                      (with-indentation 2 #'print-extraction name))
                                    (new-line 2))))))))))

(defun print-object-tree (first-object last-object filename width append-p)
  (unless (null library$)
    (let ((start (if (eq first-object '|first|)
		     0
                   (position first-object library$)))
	  (end (if (eq last-object '|last|)
		   (1- (length library$))
                 (position last-object library$))))
      (unless (and start end) (error "Objects not in library."))
      (handle-file-error
       (with-open-file (*output-stream* filename
					:direction :output
					:if-exists (if append-p :append :new-version)
					:if-does-not-exist :create)
                       (let* ((*indentation* 0)
                              (*ml-print-library-width* width))
                         (for (name in (subseq library$ start (1+ end)))
                              (do
                                  (let ((obj (library-object name)))
                                    (format *output-stream* "~A ~A ~A~%"
                                            (status-string (object-status obj))
                                            (string (object-kind obj))
                                            (string name))
                                    (with-indentation
                                     2 #'print-Ttree (object-to-ttree obj (ml-print-library-width)))
                                    (when (and (eql (object-kind obj) 'THM)
                                               (is-name-of-ext-theorem name))
                                      (new-line)
                                      (with-indentation 2 #'print-extraction name))
                                    (new-line 2))))))))))

(defun print-library (first-object last-object filename width append-p)
  (unless (null library$)
    (let ((start (if (eq first-object '|first|)
		     0
                   (position first-object library$)))
	  (end (if (eq last-object '|last|)
		   (1- (length library$))
                 (position last-object library$))))
      (unless (and start end) (error "Objects not in library."))
      (handle-file-error
       (with-open-file (*output-stream* filename
					:direction :output
					:if-exists (if append-p :append :new-version)
					:if-does-not-exist :create)
                       (let* ((*indentation* 0)
                              (*ml-print-library-width* width))
                         (for (name in (subseq library$ start (1+ end)))
                              (do
                                  (let ((obj (library-object name)))
                                    (format *output-stream* "~A ~A ~A~%"
                                            (status-string (object-status obj))
                                            (string (object-kind obj))
                                            (string name))
                                    (with-indentation
                                     2 #'print-Ttree (object-to-ttree obj (ml-print-library-width)))
                                    (when (and (eql (object-kind obj) 'THM)
                                               (is-name-of-ext-theorem name))
                                      (new-line)
                                      (with-indentation 2 #'print-extraction name))
                                    (new-line 2))))))))))

(defunml |print_library| (first last filename width append-p)
  (tok -> (tok -> (string -> (int -> (bool -> void)))))
  (unless (and (or (member first '(|first| |last|))
		   (member first library$))
	       (or (member last '(|first| |last|))
		   (member last library$)))
    (breakout evaluation '|print_library: start or end not in library.|))
  (let ((*ml-print-library-width* width))
    (print-library first last filename width append-p)))
|#

(defunml (|print_library| (first last filename width append-p))
  (tok -> (tok -> (string -> (int -> (bool -> void)))))
  nil)


;; coordinates with *non-standard-graphic-code->latex-macro* to 
;;  map prl internal chars 127,142-173 to a latex macro.
(defun nonstandard-graphic-ichar->latexizable-char (ich)
  (code-char ich))

(defun ichar->char-for-latexize (ich)
  (nonstandard-graphic-ichar->latexizable-char ich))

(defun implode-for-print (x)
  (let* ((l (if (output-for-latexize-p)
		(mapcan #'(lambda (y)
			    (if (integerp y)
				(list (ichar->char-for-latexize y))
				(coerce (string y) 'list)))
			x)
		(mapcan #'(lambda (y)
			    (if (integerp y)
				(ichar->char-list y)
				(coerce (string y) 'list)))
			x)))
	 (len (length l))
	 (s (make-string len)))

      (dotimeslist (i c l)
	(setf (aref s i) c))

      s))

(defun outfile (file &optional (overwrite nil))
  (handle-file-error
   (open file 
	 :direction :output
	 :if-exists (if overwrite :supersede :append)
	 :if-does-not-exist :create)))


(defmacro with-collect-errors ((&optional (prefix "") (suffix "")) &body body)
  `(let ((*prl-errors* nil)
	 (*prl-errors-p* nil))
    (prog1
	(handle-process-err #'(lambda (err)
				(process-err
				 (error-list-to-string
				  (cons err (nreverse *prl-errors*))
				  ,prefix ,suffix)))

	  (progn ,@body))
      (when *prl-errors*
	(display-msg
	 (error-list-to-string (nreverse *prl-errors*)
			       ,prefix ,suffix))))))

(defunml (|term_to_print_string_with_suppression| (ce x w dform-addrs))
  (cond_expr -> (term -> (int -> ((term list) -> string))))

  (let ((*ml-output-width* w)
	(*suppressed-dforms*
	 (with-collect-errors ()
	   (mapcan #'(lambda (x)
		       (handle-process-err #'(lambda (err)
					       (display-msg err)
					       nil)
		         (let* ((addr (term-to-dform-address x))
				(dform (address-to-dform addr)))
			   (when dform
			     (list dform)))))
		   dform-addrs))))
    
    (with-dform-ce (ce)
      (term-to-ml-output x))))
;;lal convert to std

(defunml (|destruct_rule_term_tree| (rule-tree))
    (rule_term_tree -> (term |#| (rule_term_tree list)))

    (if (null (car rule-tree))
	(list (inil-term))
	rule-tree))


(defun lemma-lookup (name)
  
  (or (let ((defs (name-table-lookup (environment-resource 'statements) name (current-transaction-stamp))))
	(when defs
	  (if (cdr defs)
	      (progn (setf xx (cdr defs)) (break)
		     (raise-error (oid-error-message (mapcar #'oid-of-definition defs)
						     '(ref lemma lookup multiple)
						     name)))
	      (oid-of-definition (car defs)))))
      (progn (setf n name );; (break "n")
	     (raise-error (error-message '(ref lemma lookup none) name)))))

(defunml  (|lemma_lookup| (name))
    (tok -> object_id)
  (lemma-lookup name))



(defun assumptions-of-proof-term (term)
  (break) (list (ivoid-term)))
