
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;**************************************************************************
;*                                                                        *
;*      Projet     Formel                       LCF    Project            *
;*                                                                        *
;**************************************************************************
;*                                                                        *
;*            Inria                         University of Cambridge       *
;*      Domaine de Voluceau                   Computer Laboratory         *
;*      78150  Rocquencourt                    Cambridge CB2 3QG          *
;*            France                                England               *
;*                                                                        *
;**************************************************************************

; F-dml.lisp      Original code: dml (lisp 1.6) part of Edinburgh LCF
;                 by M. Gordon, R. Milner and C. Wadsworth   (1978)
;                 Transported by G. Huet in Maclisp on Multics, Fall 1981
;
; V2.2 :exit instead of err
; V3.1: exit renamed in breakout
; V4.3: Added fast arithmetic (smallnums)  GC



#-dontinline
(eval-when (compile)
  (proclaim '(inline
	      ml-displace
	      ml-div ml-difference ml-less ml-greater
	      ml-hd ml-tl |@| |.|
	      ml-do
	      ml-isl ml-outl ml-outr ml-inl ml-inr
	      )))


(defun ml-displace (f newf)
  (rplaca f (car newf))
  (rplacd f (cdr newf))
)

(eval-when (compile load)
  (proclaim '(special
	      tracelist initenv mlreserved infixables
	      )))

;; there was more here but only caller passes int.
(defun tokof (x)
  (intern (princ-to-string x)))


(defun intof (x) 
  (cond
    ((eql x '||) (breakout evaluation 'intof))
    ((forall 'digitp (setq x (explode x)))
     (readlist x)
     )
    (t (breakout evaluation 'intof))))

(defun ml-implode (l)
  (handle-process-err #'(lambda (tok) (breakout evaluation tok))
		      (implode-toks l)))

;;; PART 2: functions to set up lisp definitions in ml


; define an ML function in terms of a Lisp function of n arguments
(defun declare-ml-fun (ml-fn n lisp-fn mty)
  (let ((closure-name (gen-runtime-name ml-fn))
	(f (symbol-function lisp-fn)))
    (let ((cl (make-closure f n)))
      (let ((def (maybe-new-mldef ml-fn t)))
	(set-mldef-description def (make-prim-function :id ml-fn
						       :name closure-name
						       :fname lisp-fn
						       :arity n))
	(set-mldef-type def (makety mty))
	(set-mldef-closure def cl)
	(set-mldef-source def 'builtin)
	(set-mldef-value def f)
	(set-mldef-external-name def closure-name))

      ;; TODO: locate callers which use this value and update to use mldef.
      (proclaim `(special ,closure-name))
      (setf (symbol-value closure-name) cl)))
    ml-fn)

; define an ML constant in terms of a Lisp constant
(defun declare-ml-const (id exp mty)
  (let ((value-name (gen-runtime-name id))
	(v (eval exp)))
    (new-mldef
     (make-ml-definition :id id
			 :description (make-value :id id :name value-name)
			 :type mty
			 :external-name value-name
			 ;;:value v
			 :source 'builtin
			 ))
    ;; not sure what to do with symbol-value
    ;; probably treated like lisp variable thus should be set.
    (setf (symbol-value value-name) v)
  id))


;  PART 3: defining ml primitives

;  Uses manifests:
;                   initenv  [tml]

;  SETS manifests:  infixables, mlreserved

;  Sets global:  tracelist

;  Special:  %e



(dml |*| 2 * (int -> (int -> int)))
(defmlsubst (|/|  #|||# ml-div) (x y) (int -> (int -> int))
  (cond ((zerop y) (breakout evaluation 'div)) (t (truncate x y))))
(dml |+| 2 + (int -> (int -> int)))
(defmlsubst (|-| ml-difference) (a b)
	  (int -> (int -> int))
  (- a b))
(defmlsubst (|<| ml-less) (a b) (int -> (int -> bool))
  (< a b))
(defmlsubst (|>| ml-greater) (a b) (int -> (int -> bool))
  (> a b))
(dml |%-| 1 - (int -> int))

(defun equal-ints-p (a b)
  (declare (integer a b))

  (= a b))

;;; RLE TODO PERF ml-= :  needs serious optimization.
(defunml (= (x y) :error-wrap-p nil) (%A -> (%A -> bool))
  (cond
   ((eql x y))				; efficient positive check
   ((and (symbolp x) (symbol-package x)) (eql x y))
   ((stringp x) (string= x y))
   ((integerp x) (equal-ints-p x y))
   ((null x) (null y))
   ((or (ml-level-expression-p x)
	(ml-level-expression-p y))
    (break "le-="))
   ((atom x) (defined-abstract-type-equal-p x y))
   ((atom y) nil)

   (t (and (ml-= (car x) (car y))
	   (ml-= (cdr x) (cdr y))))))


;; And and or have to be treated specially.
;;(setf (get '|%&| 'mltype) (makety '((bool |#| bool) -> bool)))
;;(setf (get '|%or| 'mltype) (makety '((bool |#| bool) -> bool)))
;;(defmlsubst |%&| (a b) (bool -> (bool -> bool))
;;  (and a b))
;;(defmlsubst |%or| (a b) (bool -> (bool -> bool))
;;  (or a b))
(defmlsubst |@| (a b) ((%A list) -> ((%A list) -> (%A list)))
  (append a b))
(defmlsubst |.| (a b) (%A -> ((%A list) -> (%A list)))
  (cons a b))

(dml |not| 1 not (bool -> bool))
(dml |null| 1 null ((%A list) -> bool))
(dml |fst| 1 car ((%A |#| %B) -> %A))
(dml |snd| 1 cdr ((%A |#| %B) -> %B))

(defmlsubst (|do| ml-do) (x) (%A -> |.|)
  x						;unused
  nil)						;ml-do

(defunml (|hd| (x) :error-wrap-p nil) ((%A list) -> %A) 
  (if x (car x) (breakout evaluation 'hd)))

(defunml (|tl| (x) :error-wrap-p nil) ((%A list) -> (%A list))
    (if x (cdr x) (breakout evaluation 'tl)))

(defmlsubst (|isl| ml-isl) (x) ((%A |+| %B) -> bool)
  (car x))

(defunml (|outl| (x) :error-wrap-p nil) ((%A |+| %B) -> %A)
  (cond ((car x)(cdr x)) ((breakout evaluation 'outl))))

(defunml (|outr| (x) :error-wrap-p nil) ((%A |+| %B) -> %B)
  (cond ((car x)(breakout evaluation 'outr)) ((cdr x))))

(defmlsubst (|inl| ml-inl) (x) (%A -> (%A |+| %B))
  (cons t x))

(defmlsubst (|inr| ml-inr) (x) (%B -> (%A |+| %B))
  (cons nil x))

(dml |explode| 1 explode (token -> (token list)))
(dml |implode| 1 ml-implode ((token list) -> token))

(dml |tok_of_int| 1 tokof (int -> token))
(dml |int_of_tok| 1 intof (token -> int))


(setq tracelist nil)

(defun checktraceable (F)
  (cond
    ((atom  F)
     (llprins "closure not traceable: ")
     (llprinc  F) (llterpri)
     (breakout  evaluation 'TRACE))
    (t F)))

(defunml (|TRACE| (phi) :error-wrap-p nil)
	  (((%A -> %B) -> ((%A -> %B) |#| %C)) -> ((%A -> %B) -> %C))
 (cons
  #'(lambda (%e)
      (let ((F (checktraceable (car %e)))
	    (Fcopy (cons nil nil))
	    (phi (cadr %e)))
	(ml-displace Fcopy F)
	(let ((x (ap phi Fcopy)))
	  (ml-displace F (car x))
	  (push (cons F Fcopy) tracelist)
	  (cdr x))))
  (cons phi initenv)
 ))  ;ml-TRACE


(defunml (|UNTRACE| (F) :error-wrap-p nil) ((%A -> %B) -> bool)
  (let ((x (assoc F tracelist)))
       (if (null x) nil
          (progn (setq tracelist (outq x tracelist))
         (ml-displace F (cdr x))
         t))))  ;ml-UNTRACE

(prog ()
 (setq infixables  '(gcd |#| |*| |+| |-| |<| |=| |>| |?| |@| |^|))
 (setq mlreserved (append '(|=| |?|) rsvdwds))
)

(defun trymlinfix (fun tok sort)
  (cond ((or (member tok mlreserved)
	     (not (or (idenp tok) (member tok infixables))))
         (ptoken |can't infix |)
         (ml-print_tok tok)(pnewline)
         (breakout evaluation fun)))
  (mlinfix2 tok sort))				;trymlinfix


(defunml (|ml_paired_infix| (tok) :error-wrap-p nil)  (token -> |.|)
  (trymlinfix 'ml_paired_infix tok 'paired))

(defunml (|ml_curried_infix| (tok) :error-wrap-p nil) (token -> |.|)
  (trymlinfix 'ml_curried_infix  tok 'curried))

    
