%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

%;;;
;;;;	Connect lib to lib to unify contents.
;;;;	
;;;;	stateless connection.
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	orbaddr = [`NUPRL5.0`; `rich@nuprl1-3266178058`; `ORB`] : tok list
;;;;	libaddr = [`NUPRL5.0`; `lib`; `asynchref`; `5`] : tok list
;;;%

let liblib_connect envtag host port =
 orb_connect port host 0;

 % connect orbs%
 orb_send_address port;
 let orbaddr = orb_request_address port in
 let libaddr = orb_request_environment_address orbaddr [`lib`; envtag] in
  orbaddr,libaddr  
;;

let liblib_disconnect port orbaddr libaddr = 
  orb_unrequest_environment_address orbaddr libaddr;
  orb_unrequest_address port;
  orb_unsend_address port
;;

%;;;	
;;;;	
;;;;	Sort, Compare, Diff, Annotate, Merge
;;;;	  - Report diffs, annotate preferences, merge 
;;;;	      * Dirs : order, content, sometimes want to delete.
;;;;	  - breadth_first_walk_to_tree + prfs to find tree of objects to
;;;;	    compare.
;;;;	      * ignore : mill, detritus, backups
;;;;	    Compute global breadth_first then take subtree. 
;;;;	
;;;;	kind, active, term, properties.
;;;;	 - PRF, tttt, re.
;;;;	 - STM, first prf obid.
;;;;
;;;%

letref liblib_addrs = ([],[]) : (tok list # tok list);;

%liblib_addrs := liblib_connect `asynchref` "nuprl1" 3289;;%
  

