%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

%
;;;;	
;;;;	inf_objc : old new.
;;;;	
;;;;	 similar	:
;;;;	   - goal and subgoals alpha equal.
;;;;	  or old unrefined.
;;;;	
;;;;	 identical	: 
;;;;	   - goal and subgoals are indentical
;;;;       - proof annotations are indential
;;;;	   - extracts are identical (or old N/A).
;;;;	  or old was unrefined.
;;;;	
;;;;	May want something akin to equal-sequents for comparing goals.
;;;;	But that is not abstract
;;;;	
;;;;	
;;;;	Replayability :
;;;;	 - similar : should be replayable if old subgoals pasted into
;;;;	     new node. node-wise replayable?
;;;;	 - identical : should be replayable if new tree constructed using only
;;;;	   tactic src from old tree. tree-wise replayable?
%

%lal not sure why we do the deactivate and make this a f%
let prf_src_modify_inf_tree poid pobjc itree = 
    deactivate poid;
    save poid (prf_objc_src_modify_inf_tree pobjc itree)
;;

letref notify_proof_update = inl () : unit + (object_id -> int list -> unit);;

let prf_src_replace_inf_tree poid addr itree =
 let pobjc = oc poid in
   prf_src_modify_inf_tree poid
    pobjc
    (inf_tree_replace_tree (prf_objc_src_inf_tree pobjc) itree addr)
 ; if isr notify_proof_update then ((outr notify_proof_update) poid addr)
;;

% doesn't care if annos match %
let similar_goals_p a b = alpha_equal_terms (fst a) (fst b);;

let identical_goals_p a b = 
 lex_equal_terms (fst a) (fst b)
 & equal_lists_p lex_equal_terms (snd a) (snd b)
;;

let similar_inf_objcs old new =
 let ostep = inf_objc_src_step old 
 and nstep = inf_objc_src_step new in

  (`UNREFINED` = inf_step_type ostep)
  or ( (similar_goals_p (inf_step_goal ostep) (inf_step_goal nstep))
     & (equal_lists_p similar_goals_p (inf_step_subgoals ostep) (inf_step_subgoals nstep)))
;;
 
let identical_inf_objcs old new =
 let ostep = inf_objc_src_step old 
 and nstep = inf_objc_src_step new in

  (`UNREFINED` = inf_step_type ostep)
  or ( (identical_goals_p (inf_step_goal ostep) (inf_step_goal nstep))
     & (equal_lists_p identical_goals_p (inf_step_subgoals ostep) (inf_step_subgoals nstep))
     & (  (not (can inf_step_extract ostep))
       or (lex_equal_terms (inf_step_extract ostep) (inf_step_extract nstep)))
     )
;;

let inf_node_extract poid address =
 let itree = inf_tree_find (prf_objc_src_inf_tree (oc poid)) address in
  extract_from_inf_step (inf_objc_src_step (inf_tree_object_contents itree))
;;

let inf_objc_refined_p objc = 
  (inf_step_refined_p (inf_objc_src_step objc)) ? false
;;

letref ref501_envoid = dummy_object_id ();;
letref ref501_envoid_set_p = false;;

letref get_dyn_reference_environment_f = ((\oid. fail) : (object_id -> object_id));;

let get_ref_environment_obid oid =
  oid_of_ioid_term (get_property oid `reference_environment`)
? get_dyn_reference_environment_f oid
? % don't fail so that we can be compatible with version 501.
    instead, return the default 501 envoid
    (raise_error [oid] ``reference_environment__not`` []; fail)
  %
  if ref501_envoid_set_p then ref501_envoid
  else (ref501_envoid_set_p := true;
	ref501_envoid := lib_find_oid_by_name `ref501 environment`)
        
;;
letref get_ref_environment_term_f = (\oid:object_id. ivoid_term);;

let get_ref_environment_term oid =
 get_ref_environment_term_f oid
;;

let get_dyn_ref_environment_at dir oid = 
  put_property oid `theory` (ioid_term dir);
  get_dyn_reference_environment_f oid
;;

let put_ref_environment_obid obid oid = put_property oid `reference_environment` (ioid_term obid);;

let put_inf_tactic exactp term ioid oids =
 let objc = oc ioid in
 let p = inf_objc_refined_p objc in
 let nobjc = if p 
                then inf_object_contents_refine (objc_modify_source objc term)
		       (get_ref_environment_obid ioid)
		       oids
                else objc_modify_source objc term in

  if p & (not (if exactp then identical_inf_objcs else similar_inf_objcs) objc nobjc)
     then raise_error (ioid . oids) ``INF Tactic Put Similar Not`` [term]
     else save ioid nobjc
;;

letref iobjcs = nil : object_contents list;;

let put_inf_refine_result exactp ioid nobjc =
 let objc = oc ioid in iobjcs := [objc; nobjc];
   if ((if exactp then identical_inf_objcs else similar_inf_objcs) objc nobjc)	
      then save ioid nobjc
      else raise_error [ioid] ``INF Tactic Put Similar Not`` nil
;;


%
;;;
;;;
;;;
%

let oid_to_name oid = token_of_itoken_term (objc_property (oc oid) `NAME`) ? `name???`;;
let name_to_oid name = lib_find_oid_by_name (token_of_itoken_term name);;
let names_to_oids names = lib_find_oids_by_names (map token_of_itoken_term names);;

let name_to_stm name =
    let l = filter (\oid. (lib_active_p oid & (objc_kind (oc oid)) = `STM`))
	       (lib_find_oids_by_name name) in
    if not (null l) then hd l
    else let l = filter (\oid. (objc_kind (oc oid)) = `STM`)
	                 (lib_find_oids_by_name name) in
             if null l then (raise_error nil ``name to stm not`` [itoken_term name]; hd l)
             else hd l
;;


let lib_statements oids =
  letrec f l =
  if null l then [] 
  else let h1.t1 = l in
  (if (objc_kind (oc h1)) = `STM` then h1. f t1 
  else f t1)
  in f oids
;;

%
	create prf object
	make unrefined step from stm.
	store prf oid in stm

%

let inf_objc goal =
 inf_objc_src_modify_step (objc_contents `INF`) (inf_step goal)
;;

let stm_objc_src_clear_proofs objc =
  if [] = stm_objc_src_proofs objc then objc
  else stm_objc_src_modify_proofs objc nil
;;

let stm_src_clear_proofs oid =
 save oid (stm_objc_src_clear_proofs (oc oid))
;;

let stm_clear_first_prf soid =
  let proofs = stm_objc_src_proofs (oc soid) in
  let nproofs = tl proofs in
  if nproofs = nil then ()
  else save soid (stm_objc_src_modify_proofs (oc soid) nproofs)
;;

let stm_clear_butfirst_proofs soid =
  let proofs = stm_objc_src_proofs (oc soid) in
  if proofs = nil then ()
  else
  let nproofs = tl proofs in
  if nproofs = nil then ()
  else save soid (stm_objc_src_modify_proofs (oc soid) [(hd proofs)])
;;


%%% Build proof object from nl term (assumed to be sequent). %

let mp_build_proof_from_sequent doid name seq  = 
  let poid = create_object_id () in
    save poid
         (objc_set_properties
	  (prf_objc_src_modify_inf_tree
	   (objc_contents `PRF`)
	   (inf_tree (add_object (inf_objc (seq, []))) nil))
	  [`DESCRIPTION`, metaprl_refiner_description_term; `NAME`, itoken_term name])
    ; dag_insert doid name poid
    ; poid
;;

%%%  FTTB this is ok but return hd of current list not best solution %
%%%  also requiring translation to build proof isn't right	%
let mk_prf_objc inf_tree = 
  prf_objc_src_modify_inf_tree
	  (objc_contents `PRF`)
	  inf_tree
;;

let find_backup_limits () =
 letref upper = 128 in
 letref lower = 64 in
   ((let term = objc_substance (oc (descendent_s ``theories .backups limits``)) in
     search_isexpr icons_op 
       (\t. (let (id, (p . r)), bts = destruct_term t in
	      if id = `upper_limit` then (upper := destruct_natural_parameter p; ())
	      else if id = `lower_limit` then (lower := destruct_natural_parameter p; ())
	      else ())
	     ? ()
	     ; false)
       (\t.())    
       term) 
   ? [])
   ; if (upper > lower) 
        then (upper, lower)
	else (lower, upper)
;;
   
let proof_backups () =
  let goid = (descendent_s ``theories .backups``) in
     (child goid `queue`) 
     ? (let qoid = (dag_make_directory goid `queue`) in
        put_name qoid "queue";
	qoid)
;;
   
let append_to_backups tokoids = 
  let goid = proof_backups() in
  let goc = dag_directory_objc goid in
  let gdir = (objc_source goc) in
  let (upper, lower) = find_backup_limits () in

  let children = dag_dir_children gdir in
   let lold = length children 
   and lnew = length tokoids in
   let lkeep = if (lold + lnew ) < upper then lold
	       else (max 0 (lower - lnew)) 
     in save goid
         (objc_modify_source goc
           (dag_dir_children_replace gdir 
	      (append tokoids (if lkeep = lold then children else (firstn lkeep children)))))
;;


letref get_ref_env_property_f = (\oid:object_id . fail; `fu`, ivoid_term);;

% adds poid to .backups dir%
let make_backup_prf term opoid soid name =
  let poid = create_object_id () in
  append_to_backups [name, poid];

  let reprop = %((`reference_environment`, (ioid_term (get_ref_environment_obid opoid))) . nil)%
               % (let reterm = get_ref_environment_term opoid in (((ref_env_property_tag reterm), reterm) . nil))%
	       [ get_ref_env_property_f opoid ]
	       ? nil in
  let nmprop = (`NAME`, itoken_term name) . reprop in
  let sprop = (`stm_oid`, ioid_term soid) . nmprop in
  
  let prf = objc_set_properties
		(mk_prf_objc
		  (iproof_node_term_to_inf_tree term))
		  %(inf_tree (add_object (inf_objc (goal, nil))) nil)%
		  
		((`DESCRIPTION`, nuprl5_refiner_description_term) . sprop)
        in   
    save poid prf;
    poid
;;		

    

let findinr l arg failtok =
 letrec aux l =

   if l = nil then ((failwith failtok); ());

   let r = (((hd l) arg) ? inl ()) in
    if isr r then outr r
    else aux (tl l) 

  in aux l
;;
		    
let stm_to_prf_default_hook ((oid:object_id), objc) = 
 (let dprop = ((`DESCRIPTION`, description_of_objc objc) . nil) ? nil in
  let nprop = ((`NAME`, name_of_objc objc) . dprop) ? dprop in
  let sprop =  ((`stm_oid`, ioid_term oid) . nprop) ? nprop in

  let prf = objc_set_properties
		(mk_prf_objc
		  (inf_tree (add_object (inf_objc (stm_objc_goal objc, [])))
			    nil))
		 sprop in

    let poid = create_object_id () in
 	save poid prf;
        (inr poid))

  ? (inl ())
;;

letref stm_to_prf_hooks = [stm_to_prf_default_hook];;

let add_stm_oid_prop poid =
   % should not go by name, could be duplicates, temp sol'n- better way is to map through
   lib and assign the property to all poids of stms.%
   
   (let soid = name_to_stm (oid_to_name poid) in
     put_property poid `stm_oid` (ioid_term soid);
    soid)
    ?
   (raise_error nil ``stm_oid property not`` [(ioid_term poid)];
   fail)
;;

let stm_of_prf poid =
   (oid_of_ioid_term (get_property poid `stm_oid`)) ? (add_stm_oid_prop poid)
;;
	
let stm_to_prf_aux soid =
 let objc = translate_objc (oc soid) in
 let poid = findinr stm_to_prf_hooks (soid, objc) `stm_to_prf_aux` in
 let pobjc = oc poid in

 let xfer_prop prop pobjc = 
  if can (objc_property pobjc) prop then pobjc
  else ((objc_add_property pobjc prop (objc_property objc prop)) ? pobjc)
 in

 let npobjc =
   (xfer_prop `reference_environment`
    (xfer_prop `DESCRIPTION`
     (xfer_prop `NAME`
       (if (can (objc_property pobjc) `stm_oid`) then pobjc
       else (objc_add_property pobjc `stm_oid` (ioid_term soid))))))
  in

   % ((get_property poid `SYMBOLICADDRESS`; ()) ?
	((let prop = get_property soid `SYMBOLICADDRESS` in put_property poid `SYMBOLICADDRESS` prop) ? ()))
   %

  maybe_save poid npobjc pobjc;

  save soid (stm_objc_src_modify_proofs objc (poid . (stm_objc_src_proofs objc)));
  poid
;;

let stm_to_prfs oid =
 let objc = lib_object_contents oid in
 if not ((objc_kind objc) = `STM`) then failwith `stm_to_prfs kind not stm`
 else
 let proofs = stm_objc_src_proofs objc in
 if not (proofs = [])
    then proofs
 else [stm_to_prf_aux oid]
;; 

let activate_stm_prfs soid = map activate (stm_to_prfs soid);;
	 
let stm_to_prf oid = hd (stm_to_prfs oid);; 

let stm_to_new_prf oid = stm_to_prf_aux oid;; 

let stm_to_indexed_prf oid index =
 let proofs = stm_to_prfs oid in
 (nth index proofs) ? hd proofs
;;

let stm_to_next_prf oid = stm_to_indexed_prf oid 2;; 

%lal when copying stms, rename prfs%
let remove_prf_from_stm poid =
  let soid = (oid_of_ioid_term (objc_property (oc poid) `stm_oid`)) ?
    (add_stm_oid_prop poid) in
  let objc = oc soid  in
  let proofs = stm_objc_src_proofs objc
  in save soid (stm_objc_src_modify_proofs objc (filter (\oid. (not equal_oids_p oid poid)) proofs)) %lal will just be 1 that's equal so can do better than filter, but list is small%
;;

let remove_backup_prfs poid =
  let soid = (oid_of_ioid_term (objc_property (oc poid) `stm_oid`)) ?
    (let soid = name_to_stm (oid_to_name poid) in
         (put_property poid `stm_oid` (ioid_term soid); soid)) in
  stm_clear_butfirst_proofs soid
;;

let unrefined_node_p node =
  let ((id, parms), bts) = destruct_term node in
  id = `!inf_unrefined`
;;

% sequent tactic annotations children %
let destruct_itree itree =
 let ((id, parms),
      [([],goal);
       ([],node); 
       ([],children);
       ([],annotations)]) = destruct_term itree in
 
  let ((id, parms),
       [([],sequent); ([], pannos)]) = destruct_term goal in
   if unrefined_node_p node %ch should be null too%
      then (sequent, ((ivoid_term), (annotations,  map_isexpr_to_term_list iinf_tree_cons_op children)))
      else let ((id, parms), [([], dependencies); ([], extract); ([], tactic)]) = destruct_term node in
            (sequent, (tactic, (annotations,  map_isexpr_to_term_list iinf_tree_cons_op children)))
;;

%
	refines top inf_step of proof inf-tree and replaces inf-tree.
	uses top tactic from migrate_proof tree save in stm. 

%       

% itree oids : objc{inf}  or should it be inf_tree. %  
let inf_objc_refine desc iobjc tactic envoid oids =
 inf_object_contents_refine
   (objc_add_property (objc_modify_source iobjc tactic)
	   `DESCRIPTION`
	   desc)
   envoid			    
   oids	    
;;
let inf_objc_refinet desc iobjc tactic envterm =
 inf_object_contents_refinet
   (objc_add_property (objc_modify_source iobjc tactic)
	   `DESCRIPTION`
	   desc)
   envterm
;;


let inf_tree_from_object_id oid = 
 let objc = lib_object_contents oid in
 inf_tree oid
	  (map (\subgoal . inf_tree (add_object (inf_objc subgoal)) [])
	       ((inf_step_subgoals (inf_objc_src_step objc))?[]))
;;

let inf_from_inf_subgoal ioid i =
 add_object (inf_objc (nth i (inf_step_subgoals (inf_objc_src_step (oc ioid)))))
;;

let inf_refine ioid tactic oids =
 add_object (inf_objc_refine nuprl5_refiner_description_term
			     (lib_object_contents ioid)
			     tactic
			     (get_ref_environment_obid ioid)
			     oids) 
;;


let find_inf_tree tree oid =
 letrec aux tree =
   if oid = inf_tree_object_id tree
      then tree
      else first_value aux (inf_tree_children tree)
  in aux tree
;;

let inf_tree_child_ids tree = 
 map inf_tree_object_id (inf_tree_children tree)
;;

let find_subgoals tree oid = inf_tree_child_ids (find_inf_tree tree oid);;

let inf_tree_to_prf desc tree =
 add_object
   (objc_add_property (prf_objc_src_modify_inf_tree (objc_contents `PRF`) tree)
	   `DESCRIPTION`
	   desc)
;; 

%  abstract Tactic Term Tree :
   f : unit -> ttt{children} # (term{tactic} # (term{ttt} # tok{mnemonic}))
%			   
%absrectype ttt = (unit -> ttt list) # (term # (term # tok))
 with make_ttt stuff = abs_ttt stuff
  and ttt_children  ttt = (fst (rep_ttt ttt)) ()
  and ttt_tactic    ttt = fst (snd (rep_ttt ttt))
  and ttt_remainder ttt = fst (snd (snd (rep_ttt ttt)))
  and ttt_tag	    ttt = snd (snd (snd (rep_ttt ttt)))
;;
%
% destruct : term -> term # term list %
%
let build_ttt destruct tag t =
 letrec aux term =
   let tactic, children = destruct term in
    make_ttt ((\(). map aux children), (tactic, (term, tag))) 
 in aux t
;;
%

let migrate_proof_to_ttt =  
  build_ttt
     (\t. let (s, (tac, (a, c))) = destruct_itree t in (tac,c))
     `migrate_proof`
;;

let ttree_to_ttt =  
  build_ttt
     (\t. let (op, [([],tac); ([], c)]) = destruct_term t in
		    (tac, (map_isexpr_to_term_list (`!ttree_cons`,[]) c)))
     `ttree`
;;

absrectype tgt = (unit -> tgt list) # (term # (term list # (term # (tok # object_id))))
 with make_tgt stuff = abs_tgt stuff
  and tgt_children  tgt = (fst (rep_tgt tgt)) ()
  and tgt_tactic    tgt = fst (snd (rep_tgt tgt))
  and tgt_subgoals  tgt = fst (snd (snd (rep_tgt tgt)))
  and tgt_remainder tgt = fst (snd (snd (snd (rep_tgt tgt))))
  and tgt_tag	    tgt = fst (snd (snd (snd (snd (rep_tgt tgt)))))
  and tgt_oid	    tgt = snd (snd (snd (snd (snd (rep_tgt tgt)))))
;;

% destruct : term -> term # term list %
let build_tgt destruct tag t =
 letrec aux term =
   let tactic, goal, children, oid = destruct term in
    make_tgt ((\(). map aux children), (tactic, (goal, (term, (tag, oid)))))
 in aux t
;;

let tgtree_to_tgt =  
  build_tgt
     (\t. let (op, [([],tac); ([], ioid); ([], subgoals); ([], c)]) = destruct_term t in
		    (tac, ((map_isexpr_to_term_list (`!proof_node_cons`,[]) subgoals), 
			   ((map_isexpr_to_term_list (`!tgtree_cons`,[]) c), (oid_of_ioid_term ioid)))))
     `tgtree`
;;

let inf_refined_p oid =
  (inf_step_refined_p (inf_objc_src_step (oc oid))) ? false
;;

let add_objc_ref_environment_obid oid oc = objc_add_property oc `reference_environment` (ioid_term oid);;
let add_objc_ref_environment term oc = objc_add_property oc `reference_environment` term;;


%let apply_ttt desc ttt iobjc envoid oids  =
%%let maybe_annotate_goal desc goal =
  if alpha_equal_terms nuprl5_refiner_description_term desc then goal
  else let (g, annos) = goal in
  (g, ((symaddr_to_annotation (objc_property (oc (hd oids)) `SYMBOLICADDRESS`)) . annos))
;;
%%
  letrec aux ttt iobjc = 
    (let robjc = if ttt_unrefined_p ttt then iobjc else 
	 inf_objc_refine desc iobjc (ttt_tactic ttt) envoid oids in
      let step = inf_objc_src_step robjc
      and children = ttt_children ttt
      in if not (inf_step_refined_p step)
	   then (if children = []
		    then inf_tree (add_object (add_objc_ref_environment_obid envoid robjc)) []
		    else inf_tree (add_object
				   (add_objc_ref_environment_obid envoid
  				      (objc_add_property robjc
							 (ttt_tag ttt)
							 (ttt_remainder ttt))))
				   [])
	   else (let subgoals = inf_step_subgoals step in
		 if not (length children = length subgoals)
		   then (inf_tree (add_object
				   (add_objc_ref_environment_obid envoid
  				     (objc_add_property robjc
							(ttt_tag ttt)
							(ttt_remainder ttt))))
				  (map (\ goal. (inf_tree (add_object (inf_objc goal%%(maybe_annotate_goal desc goal)%%)) []))
				subgoals))

		   else (inf_tree (add_object (add_objc_ref_environment_obid envoid robjc))
			  (map2 (\ goal ttt. aux ttt (inf_objc goal%%(maybe_annotate_goal desc goal)%%))
				subgoals children))))
 in aux ttt iobjc
;;
%

let apply_ttt desc ttt objc envterm oids =
 letrec reff objc ttac contf =
  if ivoid_term_p ttac then inf_tree (add_object objc) nil
  else
  let robjc = inf_objc_refinet desc objc ttac envterm in
    let step = inf_objc_src_step robjc in
      if not (inf_step_refined_p step) 
       then let r = contf nil in
            let nrobjc =  if isl r
			     then let ttag, trem = outl r in
				    (objc_add_property robjc ttag trem)
			     else robjc in
              inf_tree (add_object (add_objc_ref_environment envterm nrobjc)) nil
       else let goals = map inf_objc (inf_step_subgoals step) in
            let r = contf goals in
	     if isr r
                then inf_tree (add_object (add_objc_ref_environment envterm robjc))
			      (outr r)
                else let ttag, trem = outl r in
		       inf_tree (add_object (add_objc_ref_environment envterm
						(objc_add_property robjc ttag trem)))
			        (map (\g. inf_tree (add_object g) nil) goals)
  in
   apply_ttt_aux_cont reff ttt objc
;;

% when replaying a proof from a tactic tree, behavior may be slightly different,
like extra or re-ordered subgoal, and we want to catch this and reoreder the tacs
accordingly.
%
let void_ttt = build_ttt (\t. (ivoid_term, nil)) `void_ttt` ivoid_term;;
let void_inf_tree = make_inf_tree (dummy_object_id()) nil;;

let maybe_reorder_trees_terms rchildren tchildren lchildren = 
  letref tlist = nil and llist = nil in
  letrec aux refl tacl libl = 
  if refl = nil then 
     if tacl = nil then () 
     else (tty_print "`reorder_tacl_not_nil`"; ()) %wip: find ivoid_terms and substitute members of tacl.%
  
  else let goal = hd refl in
    let position = (find_position_p goal libl alpha_equal_terms) ? 0 in
    if position = 0 then
       (tlist := void_ttt . tlist;  %always if not in lib do we assume its an extra?,
                                     what if its just slightly different?
                                     maybe need to look at the bigger picture, and if extra tl%
        aux (tl refl) tacl llist)
    else
      (tlist := (nth position tacl) . tlist; 
       llist := (nth position libl) . llist;
       aux (tl refl) (remove_nth position tacl) (remove_nth position llist))
  in  %above assumes tlist matches llist%
  
  aux rchildren tchildren lchildren; 
  (rev tlist, rev llist) %rlist should not change% %maybe need to reverse all%
;;

letref rlist_debug = nil:object_contents list ;;
letref tlist_debug = nil:ttt list ;;
letref llist_debug = nil:inf_tree list ;;

% rchildren is objcs,  lchildren are inf_trees %
let maybe_reorder_trees rchildren tchildren lchildren = 
  tty_print "reorder 1";
  rlist_debug := rchildren;
  llist_debug := lchildren;
  tlist_debug := tchildren;
  tty_print "reorder 2";
  letref tlist = nil and llist = nil in
  letrec aux refl tacl libl = 
  if refl = nil then 
     if tacl = nil then () 
     else () %wip: find ivoid_terms and substitute members of tacl.%
  
  else let goal = hd refl in
    let position = (find_position_p goal libl 
                   (\oc it. (alpha_equal_terms 
                               (fst (inf_step_goal (inf_objc_src_step oc)))
                               (fst (inf_step_goal (inf_objc_src_step (inf_tree_object_contents it))))))) ? 0 in
    if position = 0 then
       (tlist := void_ttt . tlist;  %always if not in lib do we assume its an extra?,
                                     what if its just slightly different?
                                     maybe need to look at the bigger picture, and if extra tl%
        llist := void_inf_tree . llist;
	aux (tl refl) tacl llist)
    else
      (tlist := (nth position tacl) . tlist; 
       llist := (nth position libl) . llist;
       aux (tl refl) (remove_nth position tacl) (remove_nth position llist))
  in  %above assumes tlist matches llist%
  
  aux rchildren tchildren lchildren; 
  (rev tlist, rev llist) %rlist should not change% %maybe need to reverse all%
;;

let apply_ttt_lib_aux apply_f ttt nobjc ltree =
  letrec aux ttt node ltree = 
     if ttt_unrefined_p ttt then 
        apply_f node ivoid_term (\l1 l2 l3. tty_print "`apply_ttt_lib_aux`"; failwith `apply_ttt_lib_aux`) ltree
     else (apply_f node 
                (ttt_tactic ttt)
                (\rchildren lchildren tchildren. tty_print "atac ";
                    let (tlist, llist) = maybe_reorder_trees rchildren tchildren lchildren in
                        inr (map3 (\rchild tchild lchild. aux tchild rchild lchild)
                                  rchildren tlist llist))
                ltree)
		                         		    
 in aux ttt nobjc ltree 
;;

let void_tgt = 
  build_tgt (\t. (ivoid_term, nil, nil, (dummy_object_id()))) `void_ttt` ivoid_term;;

let tgt_unrefined_p ttt =
  alpha_equal_terms (tgt_tactic ttt) ivoid_term
;;
  
let maybe_reorder_trees_tg rchildren tchildren tsubgoals = 
  letref tlist = nil in

  letrec aux refl tgtl goall = 
  if refl = nil then 
     if tgtl = nil then () 
     else () %wip: find ivoid_terms and substitute members of tacl.%
  
  else let goal = hd refl in
    let position = (find_position_p goal goall 
                   (\oc it. (alpha_equal_terms 
                               (fst (inf_step_goal (inf_objc_src_step oc)))
                               it))) ? 0 in
    if position = 0 then
       (tlist := void_tgt . tlist;  %always if not in lib do we assume its an extra?,
                                     what if its just slightly different?
                                     maybe need to look at the bigger picture, and if extra tl%
 
	aux (tl refl) tgtl goall)
    else
      (tlist := (nth position tgtl) . tlist; 
       aux (tl refl) (remove_nth position tgtl) (remove_nth position goall))
  in
  
  aux rchildren tchildren tsubgoals; 
  rev tlist 
;;
letref tree_reorder_p = false;;

let apply_tgt_aux apply_f tgt nobjc =
  letrec aux tgt node =
	
     if tgt_unrefined_p tgt then 
        inf_tree (add_object (node)) nil
     else (apply_f node 
             (tgt_tactic tgt)
	     (tgt_oid tgt)
	     (tgt_subgoals tgt)
             (\rchildren tsubgoals. 
	      
	      let tlist =
		if tree_reorder_p then
		  maybe_reorder_trees_tg rchildren (tgt_children tgt) tsubgoals
		else tgt_children tgt in
	      
              letrec recf tsubs rsubs l =
	      if (nil = tsubs) then
		(if (nil = rsubs) then 
		  rev l
		else 
		  recf nil 
		    (tl rsubs)
		    ((inf_tree (add_object (hd rsubs)) nil).l))
	      else (if (nil = rsubs) then
		recf (tl tsubs) nil l
	      else recf (tl tsubs) (tl rsubs) ((aux (hd tsubs) (hd rsubs)).l)) in
            inr (recf tlist rchildren nil)))
			      		                         		    
 in aux tgt nobjc 
;;


let apply_tgt desc tgt nobjc envterm oids =
 let apply_f objc ttac ioid tsubs contf =
  
  %before building inf tree, check if goal and tac and subs are same and reuse inf oid%

  let iobjc = oc ioid in 
  let istep = inf_objc_src_step iobjc in 
  let igoal = inf_step_goal istep and itac = (inf_step_tactic istep) ? (ioid_term ioid) %the oid term is just there to be distinct so tac won't match% in
 
  if (identical_goals_p igoal (inf_step_goal (inf_objc_src_step objc))) & 
    (alpha_equal_terms itac ttac) then

  (let goals = map inf_objc (inf_step_subgoals istep) in
          (let val = contf goals tsubs in
	     if isr val
                then inf_tree ioid (outr val)
                else let ttag, trem = outl val in
		       inf_tree (add_object (add_objc_ref_environment envterm
						(objc_add_property iobjc ttag trem)))
			        (map (\goal. inf_tree (add_object goal) nil) goals))) 
	
  else
  if ivoid_term_p ttac then inf_tree (add_object objc) nil
  else
  if alpha_equal_terms (itext_term "") ttac then inf_tree (add_object objc) nil
  else
  let robjc = inf_objc_refinet desc objc ttac envterm in
    let step = inf_objc_src_step robjc in
      if not (inf_step_refined_p step) then % refinement failed, stop here %
         (let val = contf nil tsubs in
            let nrobjc = if isl val then 
			 let ttag, trem = outl val in objc_add_property robjc ttag trem
			 else robjc in
		inf_tree (add_object (add_objc_ref_environment envterm nrobjc)) nil)
      else
      let goals = map inf_objc (inf_step_subgoals step) in
          (let val = contf goals tsubs in
	     if isr val
                then inf_tree (add_object (add_objc_ref_environment envterm robjc))
			      (outr val)
                else let ttag, trem = outl val in
		       inf_tree (add_object (add_objc_ref_environment envterm
						(objc_add_property robjc ttag trem)))
			        (map (\goal. inf_tree (add_object goal) nil) goals))
  in
  apply_tgt_aux apply_f tgt nobjc
;;
   
% contf takes new subgoal list, lib's stored subgoal list and ttt_children %
% reff refines nobjc with ttac and if it works, it calls contf on its goals, the current goals stored in the lib, and the ttt children. %


% nobjc is node objc, lobjc is corresponding objc in the lib %
% returns inf tree %
%
let apply_ttt_lib desc ttt nobjc envoid oids ltree =
 
 let apply_f objc ttac contf ltree =
  
  if ivoid_term_p ttac then inf_tree (add_object objc) nil
  else
  let robjc = inf_objc_refine desc objc ttac envoid oids in
    let step = inf_objc_src_step robjc in
      if not (inf_step_refined_p step) then %% refinement failed, return ltree but with ? status %%
        let val = contf nil nil (ttt_children ttt) in
            (let nrobjc = if isl val
			    then let ttag, trem = outl val in
				    (objc_add_property robjc ttag trem)
			    else robjc in
              inf_tree (add_object (add_objc_ref_environment_obid envoid nrobjc)) nil)

      else
      let goals = map inf_objc (inf_step_subgoals step) and
          lgoals = inf_tree_children ltree in
            (let val = contf goals lgoals (ttt_children ttt) in
	     if isr val
                then inf_tree (add_object (add_objc_ref_environment_obid envoid robjc))
			      (outr val)
                else let ttag, trem = outl val in
		       inf_tree (add_object (add_objc_ref_environment_obid envoid
						(objc_add_property robjc ttag trem)))
			        (map (\goal. inf_tree (add_object goal) nil) goals))
  in
   apply_ttt_lib_aux apply_f ttt nobjc ltree
;;
%
let check_ttt desc ttt iobjc envterm oids  =
  letrec aux ttt iobjc = 
    (let robjc = if ttt_unrefined_p ttt then iobjc else 
	 inf_objc_refinet desc iobjc (ttt_tactic ttt) envterm in
      let step = inf_objc_src_step robjc
      and children = ttt_children ttt
      in if not (inf_step_refined_p step)
	   then inf_tree (add_object (add_objc_ref_environment envterm robjc)) []
		   
	   else (let subgoals = inf_step_subgoals step in
		 if not (length children = length subgoals)
		   then inf_tree (add_object (add_objc_ref_environment envterm robjc))
				  (map (\goal. (inf_tree (add_object (inf_objc goal)) []))
				subgoals)
		   else inf_tree (add_object (add_objc_ref_environment envterm robjc))
			  (map2 (\goal ttt. aux ttt (inf_objc goal))
				subgoals children)))
 in aux ttt iobjc
;;
 

let irefine_failure_term_p t =
 let ((id, parms),bs) = destruct_term t in id = `!refine_failure`
;;

let apply_ref_tactic_finish_aux otto robjc =
  let step = inf_objc_src_step robjc in 
  let annotations = inf_step_info_annotations step in

  let (x, found) = ( (find_first (\t. irefine_failure_term_p t) annotations, true)
                   ? (ivoid_term, false)) in
  if found then (raise_error nil ``apply_ref_tactic, failure`` [x]; fail)
   else 
  (if not (inf_step_refined_p step) then failwith `apply_ref_tactic, unrefined`
  else
   let subgoals = inf_step_subgoals step in
    inf_tree (otto robjc)
	 (map (\goal. (inf_tree (add_object (inf_objc goal)) nil)) subgoals))
;; 

let apply_ref_tactic_finish robjc =
  apply_ref_tactic_finish_aux (\objc. add_object objc) robjc
 ;;

let apply_ref_tactic desc tactic iobjc envoid oids  =
   apply_ref_tactic_finish (inf_objc_refine desc iobjc tactic envoid oids)
;;

let apply_ref_tactict desc tactic iobjc envterm  =
   apply_ref_tactic_finish (inf_objc_refinet desc iobjc tactic envterm)
;;

letrec inf_tree_complete_p itree =
  inf_objc_refined_p (inf_tree_object_contents itree)
  & all inf_tree_complete_p (inf_tree_children itree)
;;


let inf_tree_max_subgoal_length itree =
 letrec aux itree =
  if (inf_objc_refined_p (inf_tree_object_contents itree))
     then let c = inf_tree_children itree ? nil in
           max (length c) (reduce max 0 (map aux (inf_tree_children itree)))
     else 0
  in aux itree
;;

let prf_max_subgoal_length oid =
  inf_tree_max_subgoal_length (prf_objc_src_inf_tree_eph (lib_object_contents oid))
;; 

  
let prf_complete_p oid =
  inf_tree_complete_p (prf_objc_src_inf_tree_eph (lib_object_contents oid))
;; 

let proven_p soid =
  exists prf_complete_p (stm_objc_src_proofs (oc soid))
;; 

%returns oid%
let migrate_proof soid =
 let poid = stm_to_prf soid  in
 let pobjc = oc poid in
 let itree = apply_ttt 
	       (objc_property pobjc `DESCRIPTION`)	
	       (migrate_proof_to_ttt (objc_property (oc soid) `migrate_proof`))
	       (inf_tree_object_contents (prf_objc_src_inf_tree_eph pobjc))
	       (get_ref_environment_term soid) 
	       [soid; poid]
	  in      
  save
    poid
    (objc_add_property 
      (prf_objc_src_modify_inf_tree pobjc itree)
      `migrated_proof` (ibool_term (inf_tree_complete_p itree)))
  ; poid
;;	

let stm_migrates_p soid =
 let poid = stm_to_prf soid  in
 let pobjc = oc poid in
 let itree = check_ttt 
	       (objc_property pobjc `DESCRIPTION`)	
	       (migrate_proof_to_ttt (objc_property (oc soid) `migrate_proof`))
	       (inf_tree_object_contents (prf_objc_src_inf_tree_eph pobjc))
	       (get_ref_environment_term soid) 	       
	       [soid; poid] in
		
  inf_tree_complete_p itree
;;	

let inf_checks_p ioid desc oids =
 
 let iobjc = oc ioid in
 let step = inf_objc_src_step iobjc in
 
 if not (inf_step_refined_p step) then true
 else
 let children = inf_step_subgoals step in
 let robjc = inf_objc_refine desc iobjc (inf_step_tactic step) (get_ref_environment_obid ioid) oids in
 let rstep = inf_objc_src_step robjc in
 let annotations = inf_step_info_annotations rstep in

 let (x, found) = ((find_first (\t. irefine_failure_term_p t) annotations, true)
		   ? (ivoid_term, false)) in
  if found then false % will also want to return failure term, x [x] %
   else 
 if not (inf_step_refined_p rstep) then false
 else
 (let subgoals = inf_step_subgoals rstep in
 if not (length children = length subgoals) then false
 else (forall (\x. x) (map2 (\ (x, l) (y, l). alpha_equal_terms x y) subgoals children))) 
;;
 
let inf_checks_p_info ioid desc oids =
 
 let iobjc = oc ioid in
 let step = inf_objc_src_step iobjc in
 
 if not (inf_step_refined_p step) then  (true, ivoid_term)
 else
 let children = inf_step_subgoals step in
 let robjc = inf_objc_refine desc iobjc (inf_step_tactic step) (get_ref_environment_obid ioid) oids in
 let rstep = inf_objc_src_step robjc in
 let annotations = inf_step_info_annotations rstep in

 let (x, found) = ((find_first (\t. irefine_failure_term_p t) annotations, true)
		   ? (ivoid_term, false)) in
  if found then (false, x)
   else 
 if not (inf_step_refined_p rstep) then (false, istring_term "step unrefined")
 else
 let subgoals = inf_step_subgoals rstep in
 if not (length children = length subgoals) then (false,  istring_term "length children not")
 else if (forall (\x. x) (map2 (\ (x, l) (y, l). alpha_equal_terms x y) subgoals children)) 
 then (true, ivoid_term)
 else  (false,  istring_term "subgoal not match")
 
;;
 
let prf_checks_p soid poid =

 let pobjc = oc poid in
 let desc = objc_property pobjc `DESCRIPTION` and oids = [soid; poid] in
							   
 letrec icheck tree =
  (inf_checks_p (inf_tree_object_id tree) desc oids) &
  forall icheck (inf_tree_children tree)
  in

  let itree = prf_objc_src_inf_tree pobjc in
  icheck itree
 
;;	

let stm_checks_all_p soid =
 let poids = stm_objc_src_proofs (oc soid) in
 forall (prf_checks_p soid) poids
;;	

let ittree_op = (`!ttree`, nil);;
let ittree_term a b = make_term ittree_op [([],a); ([],b)];;
let ittree_cons_op = (`!ttree_cons`, nil);;
let ittree_cons_term = make_icons_term ittree_op;;
let ittree_nil_term = make_term ittree_op [];;
let irefine_failure_op = (`!refine_failure`, nil);;
let irefine_failure_term term = make_term irefine_failure_op [([],term)];;

let poid_to_ttree_term poid =
 
    letrec aux itree =
    let step = inf_objc_src_step (inf_tree_object_contents itree)
    in let tactic = (inf_step_tactic step ? (mk_text_term "Id ") %ivoid_term%) in
  
	ittree_term tactic
		    (map_to_ilist aux ittree_cons_op (inf_tree_children itree))
						in aux (prf_objc_src_inf_tree_eph (oc poid))
;;

       					
%use after modifying goal. runs ttree of prf with original stm on modified stm.%
%uh oh #1, lal, if checks is still leaving copy there, fix this%
%uh oh #2, lal, if both incomplete not a real check - fix this%
let stm_checks_p soid =
 let poid = stm_to_prf soid in
 let ttree = poid_to_ttree_term poid in
 let poid2 = stm_to_new_prf soid in
 let pobjc = oc poid2 in
 let itree = prf_objc_src_inf_tree_eph pobjc in
 let desc = objc_property pobjc `DESCRIPTION` and oids = [soid; poid2] in
							  
 let itree2 = apply_ttt
		  desc
		  (ttree_to_ttt ttree)	       
		  (inf_tree_object_contents itree)
		  (get_ref_environment_term soid) 
		  oids in
	    
 let new_pobjc =
    prf_objc_src_modify_inf_tree pobjc itree2
    
  in save poid2 new_pobjc;

  %check for tag_remainder from apply_ttt incase of difference not apparent by status (to fix #2)%
  if inf_tree_complete_p (prf_objc_src_inf_tree_eph (oc poid)) then
  inf_tree_complete_p itree2
  else (%remove first poid from stm proofs (to fix #1)% true)
			     
;;	
%
let stm_checks_p_safe soid =
 let objc = lib_object_contents soid in
 let proofs = stm_objc_src_proofs objc in
 let poid = stm_to_prf soid in
 copy_proof poid;
 let ttree = poid_to_ttree_term poid in
 let poid2 = stm_to_new_prf soid in
 let pobjc = oc poid2 in
 let itree = prf_objc_src_inf_tree_eph pobjc in
 let desc = objc_property pobjc `DESCRIPTION` and oids = [soid; poid2] in
							  
 let itree2 = apply_ttt
		  desc
		  (ttree_to_ttt ttree)	       
		  (inf_tree_object_contents itree)
		  oids in
	    
 let new_pobjc =
    prf_objc_src_modify_inf_tree pobjc itree2
    
  in save poid2 new_pobjc;

  if inf_tree_complete_p (prf_objc_src_inf_tree_eph (oc poid)) then inf_tree_complete_p itree2
  else true
			     
;;	
%
%returns name of first that fails%
let maybe_check_proofs soids =
 letrec check l =
  if l = nil then itoken_term `Check proofs complete.`
  else let oid = hd l in
  if not (stm_checks_p oid) then
  %(name_property oid ? `noname`)%
  (objc_property (oc oid) `NAME` ? itoken_term `name??`)
  else check (tl l)
  in check soids

;;
%returns name, oid of all stms whose hd proof is incomplete%
let check_proofs soids =
 letref r = nil in
 letrec check l =
  (if l = nil then ()
  else
  let oid = hd l in
  if not (stm_checks_p oid) then
  (r := ((oid_to_name oid), oid) . r ; ()); 
  check (tl l))
  in check soids;
  r
;;
  
%returns name, oid of all stms whose proofs don't replay the same%
let run_proofs soids =
 letref r = nil in
 letrec check l =
  (if l = nil then ()
  else
  let oid = hd l in
  if not (stm_checks_p oid) then
  (r := ((oid_to_name oid), oid) . r ; ()); 
  check (tl l))
  in check soids;
  r
;;

%
let oids_to_ignore poid =  
  poid . ([(stm_of_prf poid)] ? nil)
;;
%

let oids_to_ignore poid =
  poid .
  ( [((oid_of_ioid_term (objc_property (oc poid) `stm_oid`))
     ? let soid = name_to_stm (oid_to_name poid) in
         (put_property poid `stm_oid` (ioid_term soid); soid))]
    ? nil
  )
;;

let iproof_status_term token =
 make_term (`!proof_status`, [(make_token_parameter token)]) []
;;
let iproof_info_term status oid name=
 make_term (`!proof_info`, [(make_token_parameter name)]) [([],status); ([],oid)]
;;
let iproof_info_cons_op = (`!proof_info_cons`, nil);;

let status_of_itree itree =
  let state = 
    if inf_tree_complete_p itree then `complete`
    else
    if (not (null (inf_tree_children itree))) then
    (let step = inf_objc_src_step (inf_tree_object_contents itree) in
     if inf_step_refined_p step then `incomplete` else `unknown`)
    else `incomplete` in
    
    iproof_status_term state
;;

% 
old version forces tactic tree to match proof tree in size, instead we
want to make the most of it by allowing extra subgoals, say, to appear 
while running the tactics
%

let run_proof poid =
 let ttree = poid_to_ttree_term poid in
 let pobjc = oc poid in
 let itree = prf_objc_src_inf_tree_eph pobjc in
 let desc = objc_property pobjc `DESCRIPTION` and oids = oids_to_ignore poid in
							  
 let itree2 = apply_ttt
		  desc
		  (ttree_to_ttt ttree)	       
		  (inf_tree_object_contents itree)
		  (get_ref_environment_term poid)
		  oids in
	    
 let new_pobjc =
    prf_objc_src_modify_inf_tree pobjc itree2
    
  in save poid new_pobjc;
     status_of_itree itree2
;;
  
%returns name,oid of all stms that don't have a complete proof%
let test_proofs_all soids =
 letref r = nil in
 letrec check l =
  (if l = nil then ()
  else
  let oid = hd l in
  if not (exists (prf_checks_p oid) (stm_objc_src_proofs (oc oid))) then
  (r := ((oid_to_name oid), oid) . r ; ()); 
  check (tl l))
  in check soids;
  r
;;
  
let check_thy doid =
 let soids = lib_statements (map snd (directory_children doid)) in
 maybe_check_proofs soids
;;

let check_thy_make_links doid =
 let odir = (dag_make_named_directory doid `proofs` "proofs") ? (child doid `proofs`) in
 let soids = lib_statements (map snd (directory_children doid)) in
 let rest = check_proofs soids in
 directory_append_children odir rest
;;

%returns bool, for completeness%
let migrate_proof2 soid =
 let poid = stm_to_prf soid in
 let pobjc = oc poid in
 let itree = apply_ttt 
	       (objc_property pobjc `DESCRIPTION`)	
	       (migrate_proof_to_ttt (objc_property (oc soid) `migrate_proof`))
	       (inf_tree_object_contents (prf_objc_src_inf_tree_eph pobjc))
	       (get_ref_environment_term soid) 
	       [soid; poid]
	  in
	  let complete_p = inf_tree_complete_p itree in 
	  
  save
    poid
    (objc_add_property 
      (prf_objc_src_modify_inf_tree pobjc itree)
      `migrated_proof` (ibool_term complete_p))
  ; complete_p 
;;	

let lib_range oid1 oid2 =
  let name1 = objc_property (oc oid1) `NAME` and
      name2 = objc_property (oc oid2) `NAME` in
  letrec aux l b sl =
  if l = [] then sl
   else let hoid = (hd l) in
   let nameh = (objc_property (oc hoid) `NAME`) ? (itoken_term `name???`) in
   if b then
     (if (token_of_itoken_term name2) = (token_of_itoken_term nameh) then sl
     else aux (tl l) b (hoid . sl))
  else if (token_of_itoken_term name1) = (token_of_itoken_term nameh)
  then aux (tl l) true (hoid . sl)
  else aux (tl l) b sl

  in aux (lib_list ()) false []
;;



%
 old code for debugging migration of prfs
%
%
%%returns bool, for completeness%%
let migrate_proof2 soid =
 let poid = stm_to_prf soid in
 let pobjc = oc poid in
 let itree = apply_ttt 
	       (objc_property pobjc `DESCRIPTION`)	
	       (migrate_proof_to_ttt (objc_property (oc soid) `migrate_proof`))
	       (inf_tree_object_contents (prf_objc_src_inf_tree_eph pobjc))
	       (get_ref_environment_term soid) 
	       [soid; poid]
	  in
	  let complete_p = inf_tree_complete_p itree in 
	  
  save
    poid
    (objc_add_property 
      (prf_objc_src_modify_inf_tree pobjc itree)
      `migrated_proof` (ibool_term complete_p))
  ; complete_p 
;;	

%%returns unit or fails%%
let migrate_proof3 soid =
 if migrate_proof2 soid then ()
 else failwith ((token_of_itoken_term (get_property soid `NAME`)) ? `name???`);;

let lib_migrate soid =
  if not (lib_migrated_p soid) then migrate_proof3 soid  
;;

let lib_migrate2 soid =
  if not (lib_migrated_p soid) then migrate_proof2 soid else true 
;;

let force_lib_migrate soid = migrate_proof2 soid;;

let lib_range oid1 oid2 =
  let name1 = objc_property (oc oid1) `NAME` and
      name2 = objc_property (oc oid2) `NAME` in
  letrec aux l b sl =
  if l = [] then sl
   else let hoid = (hd l) in
   let nameh = (objc_property (oc hoid) `NAME`) ? (itoken_term `name???`) in
   if b then
     (if (token_of_itoken_term name2) = (token_of_itoken_term nameh) then sl
     else aux (tl l) b (hoid . sl))
  else if (token_of_itoken_term name1) = (token_of_itoken_term nameh)
  then aux (tl l) true (hoid . sl)
  else aux (tl l) b sl

  in aux (lib_list ()) false []
;;

letref aux_oids = []:object_id list;;

let maybe_activate soid =
 let poid = stm_to_prf_r soid in
 let term = objc_property (oc poid) `migrated_proof` ? (ibool_term false)
  in if (bool_of_ibool_term term) then
   ((activate soid) ? ())
 else (aux_oids := soid.aux_oids; stm_src_clear_proofs soid);
 ()
;;

let migrate_and_activate_proofs oids =
  aux_oids := [];
  letrec aux l =  if l = [] then ()
  else let soid = hd l in 
  if (lib_active_p soid ? false) then aux (tl l) 
  else
    ((stm_src_clear_proofs soid; migrate_proof soid; maybe_activate soid) ? 
       (aux_oids := soid.aux_oids; ()); aux (tl l))
  in aux oids
  ;  rev aux_oids
;;

let migrate_and_activate_proofs_and_code oid_list =
  aux_oids := [];
  letrec aux l =  if l = [] then ()
  else let oid = (hd l) in 
  if (objc_kind (lib_object_contents oid)) = `STM` then
  (if (lib_active_p oid ? false) then aux (tl l) 
  else
    ((migrate_proof oid; maybe_activate oid) ? 
       (aux_oids :=  oid.aux_oids; stm_src_clear_proofs oid); aux (tl l)))
  else (((activate oid) ? (aux_oids :=  oid.aux_oids; ())); aux (tl l))
 in aux oid_list
  ;  aux_oids
;;
	   
let lib_statements_or_code oids =
  letrec f l =
  if null l then [] 
  else let h1.t1 = l in
  (if member (objc_kind (oc h1)) [`STM`; `CODE`] then h1. f t1 
  else f t1)
  in f oids
;;

let lib_statements_term oids =
     ioids_term (lib_statements oids)
;;

let prf_migrated_p soid =
 let poid = stm_to_prf_r soid in
 objc_property (oc poid) `migrated_proof` ? (itoken_term `error`)
;;

let stm_to_prf_r oid = (stm_to_prf oid) ? oid ;;

let lib_migrated oids =
  map prf_migrated_p (map stm_to_prf_r (lib_statements oids))
;;

%%returns first soid that fails migration%%
let migrate_activate oids =
  letref soid = hd oids in 
  letrec aux l =
  if l = [] then ()
  else
  let oid = hd l in 
  if (lib_active_p soid ? false) then aux (tl l) 
  else
    (stm_src_clear_proofs oid;
     if (migrate_proof2 oid ? (soid := oid; false)) then (activate soid; aux (tl l))) 
  in aux oids
  ;  soid
;;

let lib_migrated_p soid =  
 let objc = lib_object_contents soid in
 if not ((objc_kind objc) = `STM`) then failwith `lib migrated p kind not stm`
 else
 let proofs = stm_objc_src_proofs objc in
 if proofs = [] then false
 else
 let poid = hd proofs in
 bool_of_ibool_term (objc_property (oc poid) `migrated_proof`) ? false  
;;

letref force_migrate_p = false;;

%%returns tok # oid list%%
let migrate_proofs soids =
  letref rest = []  in
  letrec acc l = if l = [] then rest
  else let x = (hd l) in
  if (if force_migrate_p then (stm_migrates_p x ? false) %%(force_lib_migrate x ? false)%%
	 else (lib_migrate2 x ? false))
  then acc (tl l)
  else (rest := append [((oid_to_name x) , x)] rest; acc (tl l))
  in acc soids
;;


let force_migrate_thy oids =
  (map (\x. if (objc_kind (lib_object_contents x)) = `STM` then migrate_proof3 x
	    else ()) oids; true) ? false
;;

let expand_thy_make_links doid =
 let odir = (dag_make_named_directory doid `proofs` "proofs") ? (child doid `proofs`) in
 let soids = lib_statements (map snd (directory_children doid)) in
 let rem = migrate_proofs soids in
 directory_append_children odir rem
;;

%


let ipui_addr_nil_term = make_term (`!pui_addr_cons`, []) [];;
      
let oid_of_iproof_info_term term =
  let ((id, [name]),
      [([], status);
       ([], oid)]) = destruct_term term in
   oid_of_ioid_term oid;;

let name_of_iproof_info_term term =
  let ((id, [name]), bterms) = destruct_term term in
   destruct_token_parameter name;;
							   
							   
letref default_view_mode = `d`;;

%takes address as a term and returns the inf_tree of the node at that address in tree%
let inf_tree_at_address tree address = 
  letrec aux l tree  = 
    if l = [] then tree 
    else aux (tl l) (nth (hd l) (inf_tree_children tree)) in

  aux address tree
;; 

let get_pvs_inf_tree poid =
 pvs_term_to_inf_tree (get_term poid)
;;
 
% returns the proof node and checks for repeat hyps in the parent node for disply in edd %
% is normally called when updating a proof after asynch refines%
let get_inf_term_at_address address poid =
  let address_list = address_term_to_list address in

  if null address_list then
  (let itree = inf_tree_at_address ( prf_objc_src_inf_tree (oc poid)
				   ? get_pvs_inf_tree poid)
                                   address_list in
   inf_tree_to_iproof_node_term_g itree (status_of_itree itree) address default_view_mode 0)

  else
  (let parent = inf_tree_at_address (prf_objc_src_inf_tree (oc poid)) (butlast address_list) in
   let itree = nth (last address_list) (inf_tree_children parent) in
   inf_tree_to_iproof_node_term_p itree (status_of_itree itree) address default_view_mode
   (fst (inf_step_goal (inf_objc_src_step (inf_tree_object_contents parent)))) 0)
;;

let get_inf_term = get_inf_term_at_address ipui_addr_nil_term 
;;

let get_inf_term_stm oid =
  let poid = stm_to_prf oid 
  in icons_term (ioid_term poid) (get_inf_term poid)
;;

let top_address_p address =  alpha_equal_terms address ipui_addr_nil_term;;

let destruct_pui_term term =
  let ((id, [view; depth]), [([], addr); ([], goal); ([], tactic); ([], rhyps)]) = destruct_term term in
  let (op, [([], g); ([], annos)]) = destruct_term goal in

  (g, 
  (map_isexpr_to_list iannotation_cons_op (\p. p) annos),
  tactic,
  addr,
  (destruct_token_parameter view),
  (destruct_natural_parameter depth),
  (map_isexpr_to_list icons_op number_of_inatural_term rhyps))
;;

let destruct_iproof_node_term term =
  let ((id, parms), [([], stat); ([], addr); ([], goal); ([], tac); ([], subgoals); ([], annos)]) = destruct_term term in
  let (op, [([], goal'); ([], annos)]) = destruct_term goal in
	    
  (stat, addr, goal', tac, subgoals)
;;

let destruct_iproof_node_term_prim term =
  let ((id, parms), [([], stat); ([], addr); ([], goal); ([], tac); ([], subgoals); ([], annos)]) =
    destruct_term term in
  let (op, [([], goal'); ([], annos)]) = destruct_term goal in 	    
    let  (op, [([], tac'); ([], ref)]) = destruct_term tac in
  (stat, addr, goal, tac', subgoals)
;;

let refine_tttt_tree term poid envterm oids =		 
  let (goal, annos, rtree, address, view, depth, rhyps) = destruct_pui_term term and
      pobjc = oc poid in
  let desc = objc_property pobjc `DESCRIPTION` in
  let itree = apply_ttt
		  desc
		  (ttree_to_ttt rtree)	       
		  (inf_objc (goal,
			     (if alpha_equal_terms nuprl5_refiner_description_term desc then annos 
			      else ((symaddr_to_annotation (objc_property (oc (hd oids)) 
									 `SYMBOLICADDRESS`)) .
				    ((address_to_annotation address) . annos)))))
	          envterm
		  (oids_to_ignore poid) 
	    in
  let itree' =
    if top_address_p address then itree 
    else inf_tree_replace_tree_ns (prf_objc_src_inf_tree pobjc) itree (address_term_to_list address) in

  prf_src_modify_inf_tree poid pobjc itree';
  inf_tree_to_iproof_node_term_g itree (status_of_itree itree) address view depth
;;

%lal TODO seems oids list is not really used, instead oids_to_ignore%
let refine_tree term poid envterm oids =
		 
  let (goal, annos, tgtree, address, view, depth, rhyps) = destruct_pui_term term and
      pobjc = oc poid in
  let desc = objc_property pobjc `DESCRIPTION` and
      address_list = address_term_to_list address in

  let itree = apply_tgt
		  desc
		  (tgtree_to_tgt tgtree)
		  (inf_objc (goal,
			     (if alpha_equal_terms nuprl5_refiner_description_term desc then
			       annos 
			      else ((symaddr_to_annotation (objc_property (oc (hd oids)) %pobjc%
									 `SYMBOLICADDRESS`)) .
				    ((address_to_annotation address) . annos)))))
	          envterm
		  nil
	    in

  let itree' =
    if top_address_p address then itree 
    else inf_tree_replace_tree_ns (prf_objc_src_inf_tree pobjc) itree address_list in

  prf_src_modify_inf_tree poid pobjc itree';
			     
  inf_tree_to_iproof_node_term (inf_tree_find itree' address_list)
                                 (status_of_itree itree') address view depth
;;


let destruct_plib_term term =
  let (op, [([],goal); ([],addr); ([],tactic)]) = destruct_term term in
  let (op, [([],g); ([],annos)]) = destruct_term goal in

  (g, annos, tactic, addr)
;;

%
  save as you go
%	     

%1/2001 used to try to use stm oid from a list of oids formerly passed :
	           (if alpha_equal_terms nuprl5_refiner_description_term desc then annos 
		   else ((symaddr_to_annotation (objc_property (oc (hd oids)) 
							       `SYMBOLICADDRESS`)) .

%

let proof_step_refine_aux reff term poid =

  let (goal, annos, tactic, address, view, depth, rhyps) = destruct_pui_term term
  and pobjc = oc poid in

  let desc = objc_property pobjc `DESCRIPTION` in

  let itree = reff desc	tactic (inf_objc (goal, annos)) in

  let nitree = if top_address_p address then itree
	       else inf_tree_replace_tree_ns (prf_objc_src_inf_tree pobjc) itree (address_term_to_list address) in

  prf_src_modify_inf_tree poid pobjc nitree; 			     

  inf_tree_to_iproof_node_term_g itree (status_of_itree itree) address view depth
;;

let proof_step_refine term poid oids = 
 proof_step_refine_aux
  (\desc tactic objc. 
     apply_ref_tactic desc tactic objc
       (get_ref_environment_obid poid)
       oids)
 term poid
;;
let proof_step_refinet term poid = 
 proof_step_refine_aux
  (\desc tactic objc. 
     apply_ref_tactict desc tactic objc
       (get_ref_environment_term poid)
       )
   term poid
;;

% modifies at prf oid level%
%let proof_step_refine term poid oids =

  let (goal, annos, tactic, address, view, depth, rhyps) = destruct_pui_term term and 
      pobjc = oc poid in
  let desc = objc_property pobjc `DESCRIPTION` in
	
  let itree = apply_ref_tactic
		  desc
		  tactic
		  (inf_objc (goal,
			     (if alpha_equal_terms nuprl5_refiner_description_term desc then annos 
			      else ((symaddr_to_annotation (objc_property (oc (hd oids)) 
									 `SYMBOLICADDRESS`)) .
				    ((address_to_annotation address) . annos)))))
	          (get_ref_environment_obid poid)
		  nil %% get_ref_environment supercedes: (oids_to_ignore poid)%% %%(poid . oids)%%
	in
			     
  let nitree = if top_address_p address then itree
	       else inf_tree_replace_tree_ns (prf_objc_src_inf_tree pobjc) itree (address_term_to_list address) in

  prf_src_modify_inf_tree poid pobjc nitree; 			     

  inf_tree_to_iproof_node_term_g itree (status_of_itree itree) address view depth
;;
%

%let proof_refine term poid oids =

  let (goal, annos, tactic, address, view, depth, rhyps) = destruct_pui_term term and pobjc = oc poid in
  
  let pobjc = oc poid in
  let desc = objc_property pobjc `DESCRIPTION` in
  
  let itree = apply_ref_tactic
  		  desc
		  tactic
		  (inf_objc (goal,
			     (if alpha_equal_terms nuprl5_refiner_description_term desc then annos 
			      else ((symaddr_to_annotation (objc_property pobjc `SYMBOLICADDRESS`)) .
				    ((address_to_annotation address) . annos)))))
		%%LAL oids should have stm but doesn't, see view-assign-oid, etc., temp fix%%
		(get_ref_environment_obid poid)
	        nil %% get_ref_environment supercedes: (oids_to_ignore poid)%% %%(poid . oids)%% in
	    
  let al = address_term_to_list address in
  let ntree = inf_tree_replace_tree (prf_objc_src_inf_tree pobjc) itree al in
    prf_src_modify_inf_tree%%_d%% poid pobjc ntree;
  let itree' = inf_tree_find ntree al in
    let result = inf_tree_to_iproof_node_term itree' (status_of_itree itree') address view depth in
    set_primitive_tree false;
    result
;;
%
let proof_refine_aux reff term poid =

  let (goal, annos, tactic, address, view, depth, rhyps) = destruct_pui_term term
  and pobjc = oc poid in
  
  let pobjc = oc poid in
  let desc = objc_property pobjc `DESCRIPTION` in
  
  let itree = reff desc
		   tactic
		   (inf_objc (goal,
			      (if alpha_equal_terms nuprl5_refiner_description_term desc then annos 
			       else ((symaddr_to_annotation (objc_property pobjc `SYMBOLICADDRESS`)) .
				     ((address_to_annotation address) . annos)))))
		in			    
	    
  let al = address_term_to_list address in
  let ntree = inf_tree_replace_tree (prf_objc_src_inf_tree pobjc) itree al in
    prf_src_modify_inf_tree poid pobjc ntree;
  let itree' = inf_tree_find ntree al in
    let result = inf_tree_to_iproof_node_term itree' (status_of_itree itree') address view depth in
    set_primitive_tree false;
    result
;;

let proof_refine term poid oids = 
 proof_refine_aux 
  (\desc tactic objc. apply_ref_tactic desc tactic objc (get_ref_environment_obid poid) oids)
  term poid
;;

let proof_refinet term poid = 
 proof_refine_aux 
  (\desc tactic objc. apply_ref_tactict desc tactic objc (get_ref_environment_term poid))
  term poid
;;

let ref_prf_begin term poid =

  let (goal, annos, tactic, address, view, depth, rhyps) = destruct_pui_term term and
      pobjc = oc poid in
  
  let desc = objc_property pobjc `DESCRIPTION` in
  

    ( (term, poid)
    , inf_objc_refine_begin
       (objc_add_property (objc_modify_source (inf_objc (goal, annos)) tactic)
                          `DESCRIPTION`
                          desc)
    , (get_ref_environment_obid poid)
    )
;;


let ref_prf_finish cont step cookie =
 
  let (term, poid) = cont in
  let pobjc = oc poid and
     (goal, annos, tactic, address, view, depth, rhyps) = destruct_pui_term term in
	    
  (let itree =  apply_ref_tactic_finish (inf_objc_refine_complete cookie step) in		    

  let al = address_term_to_list address in
  let ntree = inf_tree_replace_tree (prf_objc_src_inf_tree pobjc) itree al in
    prf_src_modify_inf_tree%_d% poid pobjc ntree;
  let itree' = inf_tree_find ntree al in
  let status =
    if inf_tree_complete_p itree' then iproof_status_term `complete`  
    else iproof_status_term `incomplete`
    in
      inf_tree_to_iproof_node_term itree' status address view depth)
  ? (irefine_failure_term term)
;;

	
let goal_of_iproof_node_term term =

  let ((id, parms),
       [([],status);
	([],addr);
        ([], goal);      
        ([], ref);
        ([], subs);
        ([], annos)])= destruct_term term in
  subterm_of_term goal 1
;;

% term is a !proof_node, saves out a proof that was previously refined, ie in ped history %
let lib_modify_prf_src poid term =
  prf_src_modify_inf_tree poid (oc poid) (iproof_node_term_to_inf_tree term)
;;

let mp_thm_set a b = ();;	    

%scratch poids won't have stms%
let lib_modify_stm_goal poid goal =
  let soid = stm_of_prf poid in	
  let objc = objc_modify_source (oc soid) goal in     
    save soid (translate_objc objc)
;;
    
% saves goal to inf_tree of proof  %	     
let lib_modify_prf_goal poid goal =

  let pobjc = oc poid in
  let desc = objc_property pobjc `DESCRIPTION` in
  (if alpha_equal_terms nuprl5_refiner_description_term desc then () 
   else
   let address = term_to_tokens (objc_property pobjc `SYMBOLICADDRESS`) in
       mp_thm_set address goal
  );
  let itree = prf_objc_src_inf_tree pobjc in
  let ioid = create_object_id () in
  let iobjc = inf_objc ((subterm_of_term goal 1), nil) %oc ioid% in
  save ioid iobjc %(inf_objc_src_modify_step_goal iobjc (inf_objc_src_step iobjc) (subterm_of_term goal 1), nil))%;
	    %instead of nil above do map on the annotation cons term%
  prf_src_modify_inf_tree poid (oc poid) (inf_tree_force ioid (inf_tree_children itree))
;;


let is_start_tttt tttt =
  let tactic = ihead tttt ? (mk_text_term "Id ")%ivoid_term% in
  let src = source_reduce tactic [`ML`; `REF`] in
  if is_string_prefix "%S%" (first_text_string tactic) then true
  else false
;;

let get_start_tttt tttt =
  if is_start_tttt tttt then tttt
  else 
  letrec find l1 l2 =
  if (null l1) & (null l2) then fail
  else if null l1 then find l2 []
  else let it = hd l1 in
  if is_start_tttt it
  then it else find (tl l1) (append (children_of_tttt it) l2)
  in find (children_of_tttt tttt) []
;;


let psterm_of_prf poid =
  let tttt = tactic_tree_of_prf_objc (oc poid) in

  letrec aux tttt =
   let tactic = ihead tttt in
   let src = source_reduce tactic [`ml`; `ref`] in

   if is_string_prefix "%E%" (first_text_string tactic) %temp fix%
   then mk_simple_term `pscript_node`
	[%tactic%mk_text_term "Id "]
	else
	mk_simple_term `pscript_node`
	(src . (map aux (children_of_tttt tttt))) in
	
 aux (get_start_tttt tttt)     	
;;

let get_psterm soid = psterm_of_prf (stm_to_prf soid);;

%
let is_start_itree itree =
  let step = inf_objc_src_step (inf_tree_object_contents itree) in
  let tactic = inf_step_tactic step ? (mk_text_term "Id ") in
  let src = source_reduce tactic [`ML`; `REF`] in
  if is_string_prefix xxx (first_text_string tactic) then true
  else false
;;
 
let get_start_itree itree =
  if is_start_itree itree then itree
  else 
  letrec find l1 l2 =
  if (null l1) & (null l2) then fail
  else if null l1 then find l2 []
  else let it = hd l1 in
  if is_start_itree it
  then it else find (tl l1) (append (inf_tree_children it) l2)
  in find (inf_tree_children itree) []
;;
  
let psterm_of_prf_old poid =
  let pobjc = oc poid in
  letrec aux itree =
  let step = inf_objc_src_step (inf_tree_object_contents itree)
  in let tactic = (inf_step_tactic step ? (mk_text_term "Id ")) in
  let src = source_reduce tactic [`ml`; `ref`] in
  if is_string_prefix ... (first_text_string tactic)
  then mk_simple_term `pscript_node`
	[mk_text_term "Id "]
	else
	mk_simple_term `pscript_node`
	(src . (map aux (inf_tree_children itree)))
	
  in aux (get_start_itree (prf_objc_src_inf_tree pobjc)) 
;;
%


%
pushes a copy of nth proof of soid onto poid list
%

let copy_stm_proof soid n =
  let oobjc = lib_object_contents soid in
  let proofs = stm_objc_src_proofs oobjc in
  let objc = translate_objc oobjc in
  let prf = ((oc (nth n proofs)) ? failwith `proof_copy`) in
  let poid = create_object_id () in
    save poid (objc_set_properties prf
	  
	  [(`DESCRIPTION`, nuprl5_refiner_description_term);
	   (`stm_oid`, ioid_term soid); (`NAME`, (objc_property (oc soid) `NAME`))]);
    save soid (stm_objc_src_modify_proofs objc (append proofs [poid]))
;;

let copy_prf_objc_inf_tree objc = 
 prf_objc_src_modify_inf_tree objc (copy_inf_tree (prf_objc_src_inf_tree objc))
;;

let copy_proof poid =
  let soid = oid_of_ioid_term (get_property poid `stm_oid`) in
  let oobjc = lib_object_contents soid in
  let proofs = stm_objc_src_proofs oobjc in
  let objc = translate_objc oobjc in
  let pobjc = copy_prf_objc_inf_tree (oc poid ? failwith `copy_proof`) in
  let poid = create_object_id () in
    save poid (objc_set_properties pobjc	  
	  [`DESCRIPTION`, nuprl5_refiner_description_term;
	   `stm_oid`, (ioid_term soid); `NAME`, (objc_property (oc soid) `NAME`)]);
    save soid (stm_objc_src_modify_proofs objc (append proofs [poid]));
  poid
;;
   

let set_proof_first poid  =
  let soid = stm_of_prf poid in let objc = lib_object_contents soid in
  let proofs = filter (\oid. (not (equal_oids_p poid oid))) (stm_objc_src_proofs objc) in
  save soid (translate_objc (stm_objc_src_modify_proofs objc (poid . proofs)))
;;

let stm_add_prf soid poid  =
  let objc = lib_object_contents soid in
  let proofs = filter (\oid. (not (equal_oids_p poid oid))) (stm_objc_src_proofs objc) in
    save soid (stm_objc_src_modify_proofs objc (poid . proofs))
;;
  
let lib_replace_tad soid tactic address =
 let itreeterm = objc_property (oc soid) `migrate_proof`
 in put_property soid `migrate_proof`
      (iinf_tree_replace_term itreeterm tactic (address_term_to_list address))
;;

let lib_get_tad soid address =
 let itreeterm = objc_property (oc soid) `migrate_proof`
 in
 let itree = inf_tree_find (iinf_tree_term_to_inf_tree itreeterm) (address_term_to_list address)
 in inf_tree_to_iproof_node_term itree (iproof_status_term `incomplete`) address `d` (length (address_term_to_list address))
;; 
													      %
;;;;	
;;;;	constructive inf_tree updates :
;;;;	
;;;;	
;;;;	
;;;;	
%

let inf_tree_replace_oids itree oidnoids = 
 letref anyp = false in
 letrec aux itree = 

  let ioid = inf_tree_object_id itree in
  let noid = snd (find (\oidnoid. equal_oids_p ioid (fst oidnoid)) oidnoids) ? ioid in

  if not (equal_oids_p noid ioid) then (anyp := true; ());

  inf_tree noid
       (map aux (inf_tree_children itree))

 in let nitree = aux itree in 
     if anyp
        then nitree
        else itree
;;

let inf_tree_replace_oid itree oid noid = inf_tree_replace_oids itree [(oid,noid)];;
	

let get_thy_oids thy =
  map snd (directory_children (descendent (root `theories`) [`markb`; thy]))
;;									  

let activate_prf poid = 
 letrec activate_itree addr itree =
     ((activate (inf_tree_object_id itree)
      ? (raise_error [poid] ``activate_prf inf activate error`` 
                     [make_term (`!natural`,map make_natural_parameter (rev addr)) nil])))

    ;  addr_map activate_itree 0 addr (inf_tree_children itree)
    ; ()  
 and addr_map f i address l =
      if (null l) then nil
      else let ii = i + 1 in
             ((f (ii . address) (hd l)) . addr_map f ii address (tl l))

  in
  
   activate_itree nil (prf_objc_src_inf_tree (oc poid))

  ;  activate poid
;;
      
let build_info_term oids =
  map_to_ilist (\oid. iproof_info_term
		      (let itree = prf_objc_src_inf_tree_eph (oc oid)
			   in (status_of_itree itree))
		      (ioid_term oid)
		      (name_property oid))
  iproof_info_cons_op oids
;;
					 
let proof_stats soid =
  let objc = oc soid in
  let proofs = stm_objc_src_proofs objc in
  build_info_term proofs
;;

% lal: wip , want to perhaps create a proof that can be refined? %
let make_interior_prf term poid name =
  let (stat, addr, goal, tac, subgoals) = destruct_iproof_node_term term in

  let noid = create_object_id () in
  let reprop = ((`reference_environment`, (ioid_term (get_ref_environment_obid poid))) . nil) ? nil in
  let nmprop = (`NAME`, itoken_term name) in

  save noid
    (objc_set_properties
      (prf_objc_src_modify_inf_tree
	   (objc_contents `PRF`)
	   (inf_tree (add_object (inf_objc (goal, []))) nil))
	((`DESCRIPTION`, nuprl5_refiner_description_term) . (nmprop . reprop))
    );
  
  let prf = interior_inf_tree_to_iproof_node_term (iproof_node_term_to_inf_tree term)
		stat (ipui_addr_nil_term) default_view_mode 0

  in
  icons_term (ioid_term noid) prf
;;		


% lal: wip , want to perhaps create a proof that can be refined? %
let make_primitive_prf poid term oids =
  let (stat, addr, goal, tac, subgoals) = destruct_iproof_node_term_prim term in
  
  primitive_inf_tree_to_iproof_node_term (prim_refine (get_ref_environment_obid poid) goal tac oids) stat
		(ipui_addr_nil_term) default_view_mode 0
;;		
let make_primitive_prft poid term =
  let (stat, addr, goal, tac, subgoals) = destruct_iproof_node_term_prim term in
  
  primitive_inf_tree_to_iproof_node_term (prim_refinet (get_ref_environment_term poid) goal tac) stat
		(ipui_addr_nil_term) default_view_mode 0
;;		

let prf_extract_tree oid = inf_tree_extract_tree (prf_objc_src_inf_tree_eph (oc oid));;
let stm_extract_tree oid = prf_extract_tree (hd (stm_objc_src_proofs (oc oid)));;

