
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;;;;	
;;;;	desire was that this code could be loaded into v4 or v5.
;;;;	I think that is misguided, better is to have migration code in v5
;;;;	and v4 only supply data to migration. 
;;;;	
;;;;	OK so no need to worry about v4 compatibility in this file.
;;;;	Leave v4 mig files intact and consider this v5.
;;;;	lib-nv4 still useful for direct read and stub definition for some copied (from v4) functions.
;;;;	
;;;;	Migrate can happen two ways. 
;;;;	  - mig orginated in v4.
;;;;	  - mig direct read of v4 theory file.
;;;;	First case should do as little as possible in v4 so that
;;;;	functionality is not duplicated. In the past this functionality
;;;;	was mostly in v4.
;;;;	
;;;;	


;;;;	
;;;;	Fixups : specific purpose functions to fix identified migration problems.
;;;;		 Fixups may be to fix badly migrated data which we do not plan to remigrate.
;;;;		 or to fixup freshly migrated data.
;;;;	  - can be used dynamically 
;;;;	  - should be integrated into migration suite.
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	Sweeps : general purpose op migration.
;;;;	  
;;;;	
;;;;	
;;;;	
;;;;	


;;;;	
;;;;	TODO : 
;;;;	
;;;;	better op migration
;;;;	!MARK's on rhs of dforms being quoted?.
;;;
;;; need to fix up abs defs with opquoting:
;;;
;;; if conditions of abs being migrate include abs or unconditional
;;;  - opquote lhs with 'abs.
;;;
;;; walk rhs if any term has an abstraction with abs or unconditional
;;;  then opquote with abs.


(defvar *model* nil)
(defvar *lhs-p* nil)
(defvar *migrate-obj* nil)


;;;;	
;;;;	fixups
;;;;	
;;;;    migfix-precedence-label
;;;;	
;;;;	

;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	



;; apply to precedence expression term.
;; TODO dform addresses.
(defun migfix-precedence-object (term)

  ;; old migration converted addresses to !object_address_term { tok list }

  (labels ((visit (term)
	     (cond
	       ((eql `|!object_address| (id-of-term term))
		(iprecedence-object-term
		 (lib-find-oid-by-name (value-of-parameter-r
					(car (parameters-of-term term)))))
		)

	       (t
		(maybe-instantiate-term term
					(operator-of-term term)
					(mapcar #'(lambda (bt)
						    (maybe-instantiate-bound-term bt
										  (bindings-of-bound-term bt)
										  (visit (term-of-bound-term bt))))
						(bound-terms-of-term term))))))
	   )

    (visit term)))

;; (|!precedence_label| ("bd_preop" . |token|))
(defun migrate-5to4-precedence-label (term)
  (if (iprecedence-label-term-p term)
      (instantiate-term (instantiate-operator '|!dform_address|
					      (list (token-parameter nil)
						    (string-parameter (string (token-of-iprecedence-label-term term)))))
			nil)
      term))

(defun nv4-idform-address-term-p (term)
  (or (isymbolic-dform-address-term-p term)
      nil)
  )				  

(defun migrate-precedence-label (term)
  (if (nv4-idform-address-term-p term)
      (cond
	((and (isymbolic-dform-address-term-p term)
	      (eql '|| (object-of-idform-address-term term))
	      )
	 ;;(format t "prec: ~a~%" (name-of-idform-address-term term))
	 (iprecedence-label-term (if (stringp (name-of-idform-address-term term))
				     (intern (name-of-idform-address-term term))
				     (name-of-idform-address-term term)))
	 )
	((and nil
	      ;; I think this should be ok if left alone.
	      (irelative-dform-address-term-p term)
	      (let ((v (name-index-of-idform-address-term term)))
		(and (stringp v) (string= v ""))))
	 (format t "In object ~a, converting !dform_address{:s}() to !void()~%" *migrate-obj*)
	 (ivoid-term))
	(t term))
      term))


(defun migrate-idform-conditions (term)
  (if (idform-conditions-term-p term)
      (let ((ilist (list-of-idform-conditions-term term)))
	(list-to-ilist-by-op (ilist-to-list ilist
					    (if (equal-operators-p (icons-op) (operator-of-term ilist))
						(icons-op)
						(icond-cons-op)))
			     (instantiate-operator '|!condition_cons| nil)))
      term))

(defun migrate-5to4-idform-conditions (term)
  (if (idform-conditions-term-p term)
      (let ((ilist (list-of-idform-conditions-term term)))
	(setf -term term) (break "m524ic")
	(list-to-ilist-by-op (ilist-to-list ilist (instantiate-operator '|!condition_cons| nil))
			     (instantiate-operator '|!cond_cons| nil)))
      term))


(defun migrate-oid-op-sweep (term)

  ;; convert oids parameter to token parameters.
  (instantiate-term
   (let ((op (operator-of-term term)))
     (if (parameters-of-operator op)
	 (instantiate-operator
	  (id-of-operator op)
	  (mapcar #'(lambda (p)
		      (if (and (real-parameter-p p) (oid-parameter-p p))
			  (let ((oid (value-of-parameter-r p)))
			    (if (not (library-oid-bound-p oid))
				(token-parameter `unbound_object_identifier)
				(token-parameter
				 (sanitize-name
				  (name-of-oid (value-of-parameter-r p))))))
			  p))
		  (parameters-of-operator op)))
	 op))
   (mapcar #'(lambda (bt)
	       (instantiate-bound-term (migrate-oid-op-sweep
					(term-of-bound-term bt))
				       (bindings-of-bound-term bt)))
	   (bound-terms-of-term term))))


(defun migrate-idform-op-sweep (term &optional dform-rhs-p)
  (labels ((build-or-cond-expr (conds)
	     (if (null (cdr conds))
		 (car conds)
		 (format-string "|(~a ~a)" (car conds) (build-or-cond-expr (cdr conds))))))

    ;;(setf -term term) (break "what")
    (cond

      ((and *lhs-p*
	    (itext-term-p term))
       term)

      ;; opquote source
      ((idform-term-p term)
       (let* ((rhs (migrate-idform-op-sweep (rhs-of-idform-term term) t))
	      (abs (abstraction-of-term rhs)))
	 (setf -abs abs) 
	 (idform-term (migrate-idform-op-sweep (attributes-of-idform-term term))
		      (let ((*model* rhs)
			    (*lhs-p* t))
			(migrate-idform-op-sweep (lhs-of-idform-term term)))
		      (if (or (member 'unconditional (expansion-conditionals-of-abstraction abs))
			      (member 'disp (expansion-conditionals-of-abstraction abs)))
			  (opquote-term rhs 'DISP)
			  rhs))))

      ;; !dform_conditions(<dform_condition_sexpr>) -> <dform_condition_sexpr>
      ((idform-conditions-term-p term)
       (if dform-rhs-p
	   (idform-conditions-term (migrate-idform-op-sweep (list-of-idform-conditions-term term)))
	   (migrate-idform-conditions term)))

      ;; !dform_break_control{s}() -> !dform_break_control{t}()
      ;; !dform_break_control{:s}() -> !dform_break_control{NIL:t}()
      ((idform-break-control-term-p term)
       (construct-term (instantiate-operator (id-of-term term)
					      (list (let ((type (type-of-idform-break-control-term term)))
						 
						     (construct-parameter-from-string
						      (if (stringp type)
							  (if (string= "" type)
							  "NIL"
							   (string-upcase type))
							 (string type))
						      'token))
						    ))))

      ((idform-parents-term-p term)
       (if dform-rhs-p
	   (idform-parents-term (migrate-idform-op-sweep (list-of-idform-parents-term term)))
	   (let ((l (mapcan #'(lambda (x) x)
			    (map-ilist (list-of-idform-parents-term term)
				       #'(lambda (idform-addr)
					   (let* ((dform (address-to-dform-p (term-to-dform-address idform-addr))))
					     (when dform
					       (let* ((obj-name (object-name-of-dform dform))
						      (index (when obj-name
							       (position dform
									 (permuted-dforms-of-disp-object obj-name)))))
						 (when (and obj-name index)
						   (list (format-string "#~a-~a" obj-name index)))))))
				       (idform-parent-cons-op)))))
	     (idform-cond-expr-term
	      (if l
		  (itext-term (build-or-cond-expr l))
		  (itext-term "TRUE"))))))
     

      ;; !dform_lhs_cons(0;0) -> !dform_format_cons(0;0)
      ;; !dform_lhs_cons() -> !dform_format_cons()
      ((ilist-nil-p term (idform-lhs-cons-op))
       (inil-term-of-op (idform-format-cons-op)))
      ((idform-lhs-cons-term-p term)
       (idform-format-cons-term 
	(migrate-idform-op-sweep (icar term))
	(migrate-idform-op-sweep (icdr term))))



      ;;!dform_child_parentheses{t}(void(); 1) -> !dform_child_parentheses{t}(!void(); 1)
      ((and (eql '|!dform_child_parens| (id-of-term term))
	    (void-term-p (icar term)))
       ;;(instantiate-operator '|!dform_child_parentheses| (parameters-of-term term))
       (construct-term (operator-of-term term)
		       (list (construct-bound-term (ivoid-term)))))

      ;; !dform_child{s,s}(!dform_child_library{<name>:s}) -> !dform_library_child{<name>:s}(0)
      ;; !dform_child{s,s}() -> !dform_variable_child{s,s}(0)
      ;; NEW: !dform_constant_child{}(0;0)
      ((idform-child-term-p term)
       (migrate-idform-child term))
				 

      ;; !dform_address{:t, s} -> !precedence_label{t}
      ((nv4-idform-address-term-p term)
       (if dform-rhs-p
	   term
	   (migrate-precedence-label term)))

      ;; !dform_not_point_condition() -> !dform_cond_expr(!text{|(!~point-suppress !~point):s})
      ((idform-not-point-condition-term-p term)
       (idform-cond-expr-term (itext-term "|(!~point-suppress !~point)")))

      ;; !dform_hidden_ok() -> !dform_hidden_cond_expr(!text{TRUE})
      ((idform-hidden-ok-term-p term)
       (idform-hidden-cond-expr-term (itext-term "TRUE")))

      ;; TEMPLATE{v} -> !template{s}
      ((template-term-p term)
       (itemplate-term (let ((id (id-of-template-term term)))
			 (if (variable-id-p id)
			     (string id)
			     id))))


      ;; !dform_edit_macro{s} -> !dform_macro_name{s}
      ((idform-edit-macro-term-p term)
       (construct-term (instantiate-operator '|!dform_macro_name| (parameters-of-term term))))
    
      (t (when (exists-p #'parameter-substitution-list-parameter-p (parameters-of-term term))
	   (process-err 'psl))
	 (construct-term (operator-of-term term)
			 (mapcar #'(lambda (bt)
				     (construct-bound-term (migrate-idform-op-sweep (term-of-bound-term bt))
							   (bindings-of-bound-term bt)))
				 (bound-terms-of-term term)))))))



      #|
      ;; !dform_lhs_cons(0;0) -> !dform_format_cons(0;0)
      ;; !dform_lhs_cons() -> !dform_format_cons()
      ((ilist-nil-p term (idform-lhs-cons-op))
       (inil-term-of-op (idform-format-cons-op)))
      ((idform-lhs-cons-term-p term)
       (idform-format-cons-term 
	(migrate-idform-op-sweep (icar term))
	(migrate-idform-op-sweep (icdr term))))


      ;;!dform_child_parentheses{t}(void(); 1) -> !dform_child_parentheses{t}(!void(); 1)
      ((and (eql '|!dform_child_parens| (id-of-term term))
	    (void-term-p (icar term)))
       ;;(instantiate-operator '|!dform_child_parentheses| (parameters-of-term term))
       (construct-term (operator-of-term term)
		       (list (construct-bound-term (ivoid-term)))))

      ;; !dform_child{s,s}(!dform_child_library{<name>:s}) -> !dform_library_child{<name>:s}(0)
      ;; !dform_child{s,s}() -> !dform_variable_child{s,s}(0)
      ;; NEW: !dform_constant_child{}(0;0)
      ((idform-child-term-p term)
       (migrate-idform-child term))
				 

      ;; !dform_address{:t, s} -. !precedence_label{t}
      ((idform-address-term-p term)
       (if dform-rhs-p
	   term
	   (migrate-precedence-label term)))
      ;; !dform_not_point_condition() -> !dform_cond_expr(!text{|(!~point-suppress !~point):s})
      ((idform-not-point-condition-term-p term)
       (idform-cond-expr-term (itext-term "|(!~point-suppress !~point)")))

      ;; !dform_hidden_ok() -> !dform_hidden_cond_expr(!text{TRUE})
      ((idform-hidden-ok-term-p term)
       (idform-hidden-cond-expr-term (itext-term "TRUE")))

      |#

(defun stu-string (s)
  ;;(setf -s s) (break "ss")
  (let ((is (istring s)))
    (let ((isa nil))
      (do ()
	  ((null is))
	(if (and (eql (car is) iescape)
		 (> (length is) 4)
		 (hex-code-p (nth 1 is))
		 (hex-code-p (nth 2 is))
		 (hex-code-p (nth 3 is))
		 (hex-code-p (nth 4 is)))

	    (progn (push (ascii-unicode-to-int (nth 1 is) (nth 2 is) (nth 3 is) (nth 4 is)) isa)
		   (setf is (nthcdr 5 is)))
	    (progn (push (car is) isa)
		   (setf is (cdr is)))))
      (implode-to-string (nreverse isa))
      )))
      

(defvar *convert-oids-to-strings-p* t)
(defun convert-oids-to-strings (term)
  (format t "x")
  (if (not *convert-oids-to-strings-p*)
      term
      (maybe-instantiate-term
       term
       (maybe-instantiate-operator (operator-of-term term)
				   (id-of-term term)
				   (mapcar #'(lambda (p)
					       (if (and (oid-parameter-p p)
							(display-meta-parameter-p p))
						   (progn
						     (format t "y")
						     (string-parameter (value-of-parameter-m p)))
						   p))
					   (parameters-of-term term)))
       (bound-terms-of-term term))))


(defun migrate-5to4-idform-op-sweep (term)
  ;;(format t "~a~%" (id-of-term term))
  (labels ((build-or-cond-expr (conds)
	     (if (null (cdr conds))
		 (car conds)
		 (format-string "|(~a ~a)" (car conds) (build-or-cond-expr (cdr conds))))))
    (cond

      ((itext-term-p term)
       (let ((s (string-of-itext-term term)))
	 (if (stringp s)
	     (if (let ((foundp nil)) (dotimes (i (length s)) (when (eql #\\ (char s i)) (setf foundp t))) foundp)
		 (itext-term (stu-string s))
		 term)
	     term)))

      ;; opquote source
      ((idform-term-p term)
       (if (term-walk-p term #'idform-text-term-p)
	   (idform-nil-term)
	   (idform-term (list-to-ilist-by-op
			 (map-ilist (migrate-5to4-idform-op-sweep (attributes-of-idform-term term))
				    #'(lambda (attr)
					(if (or (icondition-cons-term-p attr) (icondition-term-p attr))
					    (instantiate-term (instantiate-operator '|!dform_conditions| nil)
							      (list (instantiate-bound-term attr)))
					    attr))
				    (idform-attr-cons-op))
			 (idform-attr-cons-op))
			(migrate-5to4-idform-op-sweep (lhs-of-idform-term term))
			(convert-oids-to-strings
			 (migrate-5to4-idform-op-sweep (un-opquote-term (rhs-of-idform-term term) 'DISP)))
			)))

      ((idform-child-parentheses-term-p term)
       (let ((addr (icar term)))
	 (instantiate-term (operator-of-term term)
			   (cons (instantiate-bound-term 
				  (if (ivoid-term-p addr)
				      (void-term)
				      addr))
				 (mapcar #'(lambda (bt)
					     (instantiate-bound-term
					      (migrate-5to4-idform-op-sweep (term-of-bound-term bt))
					      (bindings-of-bound-term bt)))
					 (cdr (bound-terms-of-term term)))))))

      ;; !dform_conditions(<dform_condition_sexpr>) -> <dform_condition_sexpr>
      ((idform-conditions-term-p term)
       (migrate-5to4-idform-conditions term))
      
      ((iprecedence-label-term-p term)
       (migrate-5to4-precedence-label term))

      ;; !dform_break_control{s}() -> !dform_break_control{t}()
      ;; !dform_break_control{:s}() -> !dform_break_control{NIL:t}()
      ((idform-break-control-term-p term)
       (construct-term (instantiate-operator (id-of-term term)
					     (list (let ((type (type-of-idform-break-control-term term)))
						     (construct-parameter-from-string
						      (if (null type)
							  ""
							  (string type))
						      'string)))
					     )))

      ((idform-parents-term-p term)
       (break "dpt")
       (let ((l (mapcan #'(lambda (x) x)
			(map-ilist (list-of-idform-parents-term term)
				   #'(lambda (idform-addr)
				       (let* ((dform (address-to-dform-p (term-to-dform-address idform-addr))))
					 (when dform
					   (let* ((obj-name (object-name-of-dform dform))
						  (index (when obj-name
							   (position dform
								     (permuted-dforms-of-disp-object obj-name)))))
					     (when (and obj-name index)
					       (list (format-string "#~a-~a" obj-name index)))))))
				   (idform-parent-cons-op)))))
	 (idform-cond-expr-term
	  (if l
	      (itext-term (build-or-cond-expr l))
	      (itext-term "TRUE")))))
     

      ;; TEMPLATE{v} -> !template{s}
      ((itemplate-term-p term)
       (template-term (let ((id (id-of-template-term term)))
			;;(format t "template [~a] ~%" id)
			(get-variable-id id))))

      ((idform-variable-child-term-p term)
       (instantiate-term (instantiate-operator `|!dform_child| (parameters-of-term term))
			 (list (instantiate-bound-term (migrate-5to4-idform-op-sweep (icar term))))))
      
      ((idform-format-cons-term-p term)
       (idform-lhs-cons-term
	(migrate-5to4-idform-op-sweep (icar term))
	(migrate-5to4-idform-op-sweep (icdr term))))

      ((idform-format-nil-term-p term)
       (idform-lhs-nil-term))

      ;; !dform_edit_macro{s} -> !dform_macro_name{s}
      ((idform-macro-name-term-p term)
       (construct-term (instantiate-operator '|!dform_edit_macro| (parameters-of-term term))))
    
      (t (construct-term (operator-of-term term)
			 (mapcar #'(lambda (bt)
				     (construct-bound-term (migrate-5to4-idform-op-sweep (term-of-bound-term bt))
							   (bindings-of-bound-term bt)))
				 (bound-terms-of-term term)))))))


(defun migrate-leaf-variable-p (id model)
  ;;(format t "migrate-leaf [~a]~%" id)
  (let ((tid (get-template-variable-id id)))
    (or
     (some #'(lambda (p)
	       (eql tid (value-of-parameter p)))
	   (parameters-of-term model))
     (some #'(lambda (bt)
	       (or (some #'(lambda (b) (eql b tid))
			 (bindings-of-bound-term bt))
		   (let ((term (term-of-bound-term bt)))
		     (and (not (template-term-p term))
			  (some #'(lambda (p) (eql tid (value-of-parameter p)))
				(parameters-of-term term))))))
	   (bound-terms-of-term model)))))

(defun migrate-idform-child (term)
  (let ((attrs nil)
	(lib nil))
    (mapc #'(lambda (attr)
	      (if (idform-child-library-term-p attr)
		  (setf lib (variable-of-idform-child-library-term attr))
		  (if (or (idform-child-noelide-p-term-p attr)
			  (idform-child-mode-term-p attr)
			  ;; strip parens attributes from parameter children.
			  (and *model*
			       (or (idform-child-parentheses-term-p attr)
				   (eql '|!dform_child_parens| (id-of-term attr)))
			       (migrate-leaf-variable-p (id-of-idform-child-term term) *model*)))

		      (unless (eql '|!dform_child_parentheses| (id-of-term attr))
			(format t "In object ~a, child attr op ~a filtered~%" *migrate-obj* (id-of-term attr)))
		      (push (migrate-idform-op-sweep
			     (if (and (idform-child-parentheses-term-p attr)
				      (void-term-p (address-of-idform-child-parentheses-term attr)))
				 (idform-child-parentheses-term
				  (relation-of-idform-child-parentheses-term attr)
				  (ivoid-term)
				  (binding-of-formats-of-idform-child-parentheses-term attr)
				  (migrate-idform-op-sweep (formats-of-idform-child-parentheses-term attr)))
				 attr))
			    attrs))))
	  (ilist-to-list (attributes-of-idform-child-term term)
			 (idform-child-cons-op)))

    ;;(setf b attrs) (break "b")
    (if lib
	(idform-library-child-term lib
				   (list-to-ilist-by-op (nreverse attrs)
							(idform-child-attr-cons-op)))
	(idform-variable-child-term (id-of-idform-child-term term)
				    (descriptor-of-idform-child-term term)
				    (list-to-ilist-by-op (nreverse attrs)
							 (idform-child-attr-cons-op))))))

(defun mig-term-to-condition-list (term)
  ;;(setf a term) (break "tcl")
  (mapcar #'(lambda (term)
		     (if (or (icondition-term-p term)
			     (itext-term-p term))
			 (intern-system (string-upcase
					(string-of-itext-term term)))
			 (progn
			   ;;(setf a term) (break "tcl")
			   (raise-error (error-message '(condition not) term)))))

	  (ilist-to-list term
			 (icond-cons-op))))


(defun change-string-parameter-to-token (term)
  (let ((donep nil))
    (construct-term
     (instantiate-operator (id-of-term term)
			   (mapcar #'(lambda (p)
				       (if (and (not donep)
						(string-parameter-p p))
					   (progn (setf donep t)
						  (token-parameter
						   (let ((v (value-of-parameter p)))
						     (if (stringp v)
							 (intern v)
							 v))))
					   p))
				   (parameters-of-term term)))
     (bound-terms-of-term term))))


(defvar *v4-op-map*
  (list
   (cons `(|!dform_break_control| (|string|)) #'change-string-parameter-to-token)
   ))


(defun v4-migrate-op-map (term)
  (let  ((m (assoc (term-sig-of-term term) *v4-op-map* :test #'equal)))
    (if m
	(funcall (cdr m) term)
	term)))


(defun migrate-iabstraction (term)
  (labels
      (
       ;; migrate dform stuff on rhs of abs.
       (visit (iterm)
	 (let ((term (v4-migrate-op-map iterm)))
	   (cond
	     ((idform-edit-macro-term-p term)
	      (construct-term (instantiate-operator '|!dform_macro_name| (parameters-of-term term))))
	 
	     ;; still need !dform_break_control{:t} -> !dform_break_control{NIL:t}

	     ((template-term-p term)
	      (itemplate-term (let ((id (id-of-template-term term)))
				(if (variable-id-p id)
				    (string id)
				    id))))
	     
	     ((ilist-nil-p term (idform-lhs-cons-op))
	      (inil-term-of-op (idform-format-cons-op)))
	     
	     ((idform-lhs-cons-term-p term)
	      (idform-format-cons-term 
	       (visit (icar term))
	       (visit (icdr term))))
	     
	     ((idform-child-term-p term)
	      (migrate-idform-child term))

	     (t (migrate-idform-conditions
		 (migrate-precedence-label
		  (let ((abs (abstraction-of-term term)))
		    (setf -abs abs)
		    (let ((new-term (construct-term
				     (operator-of-term term)
				     (mapcar #'(lambda (bound-term)
						 (construct-bound-term
						  (visit (term-of-bound-term bound-term))
						  (bindings-of-bound-term bound-term)))
					     (bound-terms-of-term term)))))
		      (if (and abs
			       (or (member 'unconditional (expansion-conditionals-of-abstraction abs))
				   (member 'Abs (Expansion-conditionals-of-abstraction abs))))
			  (opquote-term new-term 'ABS)
			  new-term))))))))))

    (let ((conditions (with-handle-error (('fu) nil)
			 (mig-term-to-condition-list (conditionals-of-iabstraction-term term)))))
      (iabstraction-term (conditionals-of-iabstraction-term term)
			 (if (or (member 'unconditional conditions)
				 (member 'abs conditions))
			     (opquote-term (lhs-of-iabstraction-term term)
					   'abs)
			     (lhs-of-iabstraction-term term))
			 (visit (rhs-of-iabstraction-term term)))))))



(defun remove-dform-digit-name (idform name)
  (if (idform-term-p idform)
      (let ((iattrs (ilist-to-list (attributes-of-idform-term idform)
				   (idform-attr-cons-op))))
	(let ((iname (find-first #'(lambda (term) (when (idform-name-term-p term) term)) iattrs)))
	  (if iname
	      (let ((n (name-of-idform-name-term iname)))

		(if (every #'(lambda (d) (member d *digit-chars*)) n)
		    (progn
		      (format t "In object ~a, dform name term lost as all digits :~a.~a~%" *migrate-obj* name n)
		      (idform-term (list-to-ilist-by-op (delete iname iattrs)
							(idform-attr-cons-op))
				   (lhs-of-idform-term idform)
				   (rhs-of-idform-term idform)))
		    idform))
	      idform)))
      idform))

(defun migrate-dform-isexpr (term dform-list name)
  (let ((idforms (map-ilist term
			    #'(lambda (idform)
				;;(setf -dform idform) (break "mios")
				(migrate-idform-op-sweep idform))
			    (idform-cons-op)
			    )))
    ;;(setf a obj b term)
    (if (and idforms (forall-p #'idform-term-p idforms))
	(let* ((idforms1 (mapcar #'(lambda (idform)  
				    (remove-dform-digit-name idform name))
				idforms))
	  
	       (idforms2 (if dform-list
			     (mapcar #'add-dform-parent-condition
				     idforms1
				     dform-list)
			     idforms1)))
      
	  (list-to-ilist-by-op idforms2 (idform-cons-op)))
	term)))


(defun migrate-prec-isexpr (term)

  (migfix-precedence-object term))


(defunml (|migfix_term| (kind term))
    (tok -> (term -> term))

  (case kind
    (prec	(migrate-prec-isexpr term))
    (otherwise	(raise-error (error-message '(migrate fixup term kind not) kind)))))
