%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

let new_edit_environment tag =
  let ea = [sys_version(); orb_name(); `edd`; tag] in
    new_environment ea
		    ``EDIT ObjectIdDAG ObjectState``
		    nil %let broadcast subscribe add :  (apply_alist client_broadcasts `edd`)%
		    nil
		    ``EDD EDIT``;
    ea
;;


let set_who gowinp ro la =
 iam := inr (string_to_tok (string_upcase (hd (config_string `IAM`)))) ? inl ();
 if (isr iam)
    then orb_eval_args_by_address ro
          (tokens_ap (bool_ap (token_ap (begin_ap "set_environment_bool_property ")
				       (outr iam))
			     true)
		la);
	 orb_eval_args_by_address la
	   (term_ap 
  	     (token_ap (begin_ap "set_environment_property") `edd_connection`)
	     (itoken_term (outr iam)));
	 ()
 ; if gowinp then gowin()    
;;
    

let whoami () = if isr iam then (outr iam) else null_token;;

let finish_start_edd_go = finish_start_aux (set_who true) `edd`;;
let finish_start_edd = finish_start_aux (set_who false) `edd`;;
 
let start_edd_go_aux = start_aux (begin_ap "finish_start_edd_go ");;
let start_edd_aux = start_aux (begin_ap "finish_start_edd ");;

let start_edd name =
 start_edd_aux (inl ())
               name
               (new_edit_environment name)
;;

let restart_edd () =
  start_edd_go_aux (inr restart_event_synchronization_stamp)
                   restart_name
                   (orb_match_local_environment [restart_kind; restart_name])
;;
let restart = restart_edd;;
					
let stop_edd =  stop_aux_nosync ;;

let finish_edd_disksave hotp name = finish_client_disksave (dodisk_edd hotp) name ;;

let oed_shutdown () = 
    oed_x_reset ()
  ; map (\v. view_disassociate_object true v; view_discard v) (views())
  ; ()
;;

% edd. g. %
let edd_disksave hotp name =
 oed_shutdown ();
 stop_aux (inr (bool_ap (begin_ap "finish_edd_disksave ") hotp)) true name
;;
 
let open_lib = start_edd;;
let close_lib = stop_edd false;;

let go_open () = open_aux start_edd;;
let stop_close () = close_aux (stop_edd true) ;;
 
