
% tactics from file orig ed.ml file %


letrec ItTBetaC e t = 
  TryC
    (RenamingTBetaC ORELSEC IfC (\e t. is_apply_term t) 
                      (NthSubC 1 ItTBetaC ANDTHENC TryC RenamingTBetaC))
    e t
;;
  
letrec HeadC C e t =
  if is_apply_term t then NthSubC 1 (HeadC C) e t
  else C e t
;;

let tlambda_arity_of_ab t =
  if not is_ab_term t
  then  failwith `tlambda_arity_of_ab`
  else let lhs,rhs = abstraction_definition_of_term t in
       let binders, () = it_dest_tlambda rhs in
       length binders
;;

let tlambda_rhs_p t =
  is_ab_term t & is_tlambda_term (snd (abstraction_definition_of_term t))
;;

let teta_expand_ab t =
  if not (tlambda_rhs_p t) then t
  else let lhs,rhs = abstraction_definition_of_term t in
       let binders, b = it_dest_tlambda rhs in
       it_mk_tlambda binders (it_mk_apply (lhs . map (mvt o fst) binders))
;;

% For each maximal application t = c a1 ... an, if the tlambda arity m 
  of the rhs of c is greater than n, rewrite t to
  \z(n+1):A(n+1)...\zm:Am. t c a1 ... an z(n+1) ... zm. %
let teta_expand_ab_ap t =
  let hd.args = it_dest_apply t in
  if tlambda_rhs_p hd then
    let m = tlambda_arity_of_ab hd in
    let n = length args in
    if m>n then (apply_conv ItTBetaC
                            (it_mk_apply (teta_expand_ab hd . args))
                 ? failwith `teta_expand_ab_ap bug: conv failed`)
    else t
  else t
;;

% Returns a term and the list of names of abstractions maximized %
let maximize_ab_ap_tarity filter t =
( letref opids = [] in
  let push id = opids := id . opids in
  letrec f t = 
    let top_p = filter t in
    let t' = if is_apply_term t 
             then (let hd.args = it_dest_apply t in
                   it_mk_apply (map_on_immediate_subterms f hd . map f args) ? failwith `1`)
             else map_on_immediate_subterms f t  in
    if top_p then let res = teta_expand_ab_ap t' ? failwith `2` in
                  if (is_tlambda_term res ? failwith `3`) then (push (head_opid t'); res)
                  else res
    else t'  in
  f t, opids
) ?\id  failwith id ^ ` / maximize_ab_ap_tarity`
;;

%[ Apply only at top level.  Does teta_expand_ap everywhere possible,
  as long as filter is satisfied.
]%
let MaximizeAbApTarityC filter e t =
  let t',opids = maximize_ab_ap_tarity filter t in
  let conv = UnfoldsC opids ANDTHENC ItTBetaC in
  MacroC `MaximizeAbApTarityC` conv t conv t' e t
;;



%[
There are five kinds of hol defs.

1. Direct: the def satisfies the axioms and is interesting
   a) The def is "old", i.e. the rhs has a single abstraction
      which is already defined.
   b) It is "new", in which case we will first want to add
      a new abstraction to reduce it to the "old" case.

2. Indirect: the def we need to make to satisfy the axioms
   is not of interest, but there an interesting object
   which is "equivalent".
   a) "old", as above
   b) "new"

3. Dead.  We have no interest in this object other than to
   satisfy HOL axioms.  

Class names: [direct_old|direct_new|indirect_old|indirect_new|dead]_hdef

]%

let hdef_to_simp_o hobid =
  %let hname_t = string_to_tok hname in
  hname_t , %
  (\e t.true) , 
  HeadC UnfoldTopAbC ANDTHENC ItTBetaC
;;

let hdef_simpset_simp_add uobid hobid =
  simp_add_o_aux false uobid [hobid, (hdef_to_simp_o hobid)]
;;

let is_rec_def fmla =
  let (),a,b = dest_equal (third (dest_simple_formula fmla)) in
  let i = opid_of_term a in
  (find_subterm (\(),t. i = opid_of_term t) b ; true)
  ? false
;;



let is_rec_hdef hname rhs =
  (find_subterm (\b. ab_lhs hname = snd b) rhs ; true)
  ? false
;;


let EtaExpHRecC e t =
( let id = opid_of_term t in
  if not ( %mem id (get_info `dead_hdef`) % true
          & is_term `ycomb` (subterm (ab_rhs (tok_to_string id)) 1))
  then fail
  else let ctxt, body = it_dest_tlambda (apply_conv (RecUnfoldTopC id) t) in
       let res =  it_mk_tlambda ctxt (it_mk_apply (t . map (mvt o fst) ctxt))  in
       (MacroC (`EtaExpHRecC`^`_`^id)
	       (RecUnfoldTopC id)
               t
               (TopC (RecUnfoldTopC id) ANDTHENC RepeatForC (length ctxt) (TopC TBetaC))
	       res
       ) e t
)
;;

letref new_name_hint = "" ;;

let apply_conv_string conv_str t =
  letref main_subgoal = mk_sequent [] mk_nil_term in
  let Tac = StringToTac ("RW (" J conv_str J ") 0") in
  (Tac THENM (\p. main_subgoal:=p; Id p)) (mk_sequent [] t) ;
  concl main_subgoal
;;

let RewriteOfThm namet conv =
  Assert (main_goal_of_theorem namet)
  THENL [Try (Lemma namet); Rewrite conv (-1)]
;;

let is_wf_name x =
  is_suffix (explode `_wf`) (explode x)
;;

let try f x = (f x ; ()) ? () ;;

let hn t = 
  let b = quick_rw in
  quick_rw := true ;
  with_cleanup (apply_conv (SimpsetC ``hol_to_nuprl bequal``))
               t 
               (\(). quick_rw := b)
;;

% Don't apply simp! %
let hol_to_nuprl t =
  let b = quick_rw in
  quick_rw := true ;
  with_cleanup (apply_conv (SimpsetOnlyC ``hol_to_nuprl``))
               t 
               (\(). quick_rw := b)
;;  

let thm_goal name =
  main_goal_of_theorem (string_to_tok name)
;;


let exists_subterm p t =
  (find_subterm p t ; true) ? false
;;

%[



Inputs.  names (hol,nuprl): type, constructors, hrep, habs, ty_def, iso_def, constrdefs.

Create: 

..C  - label type, softified.
..Q  - subtype pred.
groundedness theorem
..   - rectype def, with wf theorem in S.
constructor defs + wfs.

Prove: ty_def, iso_def, constr defs.

]%

letref continue_rec_type : unit->unit = \().() ;;

%[
let ExistsByMatch p =
    if not is_exists_term (concl p) then fail else
    let (),e,e' = dest_equal (addressed_subterm (concl p) [1;2]) in
    let [(),t] = fo_match (free_vars e') e' e in
    (D 0 THENL [DTerm t 0;Id] THEN Complete Auto) p in
]%
  

let RecTypeConWf con_op ty_op tyC_op tyQ_op =
  let T p = 
    let (),e,e' = dest_equal (addressed_subterm (concl p) [1;2]) in
    let [(),t] = fo_match (free_vars e') e' e in
    (D 0 THENL [DTerm t 0;Id] THEN Complete Auto) p in
  Unab [con_op;ty_op] THEN Simp THEN Auto
  THEN IfOnConcl is_member_term 
        (Unab [tyC_op])
        (D 0 THEN Unfold tyQ_op 0 THEN Simp
         THEN SomeDisjunct (T ORELSE Complete Auto) THEN Auto)
;;

letref htrp_update = inl () : unit +  object_id ;;

let RecTypeTyDef ty tyC tyQ grounded =
  %Rewrite (WSimpsC (filter (\x. not fst x = `htrp`) (get_simpset `hol_to_nuprl`))
                      SimpC)  
          0%
  Rewrite (WithSimpsetsC ``hol_to_nuprl``
            (WOSimpC (outr htrp_update) SimpC))
	  0
  THENM Fold tyC 0
  THENM UnivCD
  THENM (Unab [ty] THEN L `rec_type_ty_def` THEN Auto)
  THENM Simp THEN Auto
  THENM Try (L grounded THEN Auto)
  THENM Unab [tyQ] THEN Simp THEN Auto
;;

let RecTypeIso ty tyC tyQ grounded =
  %Rewrite (WSimpsC (filter (\x. not fst x = `htrp`) (get_simpset `hol_to_nuprl`))
                      SimpC)  
          0%
  Rewrite (WithSimpsetsC ``hol_to_nuprl``
            (WOSimpC (outr htrp_update) SimpC))
	  0
  THENM Fold tyC 0
  THENM Repeat (IfOnConcl (\c. is_all_term c & is_term `stype` (subterm c 1))
                 (D 0) Fail)
  THENM (Unab [ty] THEN L `rec_type_iso` THEN Auto)
  THENM Simp THEN Auto
  THENM Try (L grounded THEN Auto)
  THENM (Unab [tyQ] THEN Simp) THEN Auto
;;

let RecTypeConDef con_op ty tyQ grounded =
  let T p = 
    let (),e,e' = dest_equal (addressed_subterm (concl p) [1;2]) in
    let [(),t] = fo_match (free_vars e') e' e in
    (D 0 THENL [DTerm t 0;Id] THEN Complete Auto) p in
  HN THEN Auto
  THEN Unab [con_op;ty] THEN Simp THEN SwapEquands 0
  THEN L `ltree_retract_char` THEN Auto
  THEN Try (L grounded THEN Auto)
  THEN D 0 THEN Unfold tyQ 0 THEN Simp
  THEN SomeDisjunct (T ORELSE Complete Auto) THEN Auto
;;


let UnitHDs =
  let T p = let i = find (\i. h i p = mst `unit` []) (upto 1 (num_hyps p)) in
            (D i THEN Thin i THEN All (Fold `it`)) p in
  Repeat T
;;


% Prove   .. i: e=e' in T  |- G  where e and e' are different
  compositions of inl and inr.  T must be unions.
%
let DisproveInlrEq i p =
  let x = fresh_var `x` p in
  let y = fresh_var `y` p in
  let ydecide b u v = mk_decide_term b ([y],u) ([y], v) in
  let tt = mst `btrue` [] in
  let (),e,e' = dest_equal (h i p) in
  letrec f b u u' =
    if is_inl_term u & is_inl_term u' then
       ydecide b (f (mvt y) (subterm u 1) (subterm u' 1)) tt 
    if is_inr_term u & is_inr_term u' then
       ydecide b tt (f (mvt y) (subterm u 1) (subterm u' 1)) 
    else mst `isl` [b]   in
  (EquandMap (mk_lambda_term x (f (mvt x) e e')) (mst `bool` []) i
   THENM Last (\i. SimpSome [i])
  ) p
;;

let LTreeSubHD i p = 
    let i = normalize_clause_number i p in 
    if i=0 then failwith `LTreeSubHD: only applies to hyps` 
    else let t = (h i p) in  
      if not is_term `ltree_sub` t 
         then failwith `LTreeSubHd: hyp not ltree_sub` 
      else let [A;Q] = subterms t in 
           (Repeat (UnfoldSoftAb i) 
            THENM D i 
            THENM D i 
            THENM (\p. let [x;y] = map (mvt o C var_of_hyp p) [i;i+1] in 
                       let Qxy = mk_squash_term (mk_ap [Q;x;y]) in 
                       let mem_prop = mk_member_term (mk_list_term t) y in 
                       (AssertAtHyp (i+3) Qxy 
                        THEN IfLabL [`assertion`,Unhide THENM SimpSome [i+2] THENM 
                                        D (i+2) THENM D 0 THENM Trivial; 
                                    `main`,AssertAtHyp (i+4) mem_prop] 
                        THEN IfLabL [`assertion`,Unhide THENM SimpSome [i+2] THENM 
                                        RWD (LemmaC `forevery_map_distrib_U1_U2` 
                                             ANDTHENC ReduceC) (i+2) THENM 
                                        BLemma `forevery_ltree_sub_list` 
                                        THENM D (i+2) THENM Trivial; 
                                    `main`,Thin (i+2)]) p) 
            ) p ;; 
   
let SquashHyp i p =
 (Assert (mk_squash_term (h i p)) 
  THENL [D 0 THEN Trivial; Thin i]
 ) p
;;
            
letrec RListD n p = if n=0 then Id p else 
                    Last (\i. D i THENL [Id; Thin i THEN RListD (n-1)]) p 
;;

let FullRecTypeHD ty tyC tyQ constrs i p =

( let i = normalize_clause_number i p in
  let find_length label_pat =
      let clauses = dest_iterated_or 
                      (snd (dest_iterated_lambda (ab_rhs (tok_to_string tyQ)))) in
      let pat_occurs t =  exists_subterm (fo_matches label_pat o snd) t in
      let clause = find pat_occurs clauses in
      let (),(), nexp = dest_equal (subterm clause 2) in
      dest_natural_number (evaluate_term nexp)  in
  let true_nat_eq t  = let (),e,e' = dest_equal t in 
                       null (free_vars e) & null (free_vars e') &
                       evaluate_term e = evaluate_term e'  in

  Unfold ty i THEN D i THENM D i THENM SquashHyp (i+2)
  THENM Unfold tyC i
  THENM (Last (\i. SimpSome [i]) THEN RD is_union_term i)
  THENM (\p. let n = find_length (addressed_subterm (h (num_hyps p) p) [1;1;1;2])  in
             let l = var_of_hyp (i+1) p in
             let nterm = mk_natural_number_term n in
             let zero = mk_natural_number_term 0 in
             (Decide (mk_equal_term (mst `nat` []) (mst `length` [mvt l]) nterm)
              THENML [
                     (
                      MoveToConcl (-1) THEN MoveToConcl (-1) THEN D (i+1) 
                      THENL [Id;RListD n]
                      THEN (SimpSome [0] THEN RepeatMFor 2 (D 0))
                      THENM (IfOnHyp true_nat_eq (\i. Thin i THEN Try (All (Fold ty)))
                             (\j.
                              (\p. Assert (mst `le` [zero; 
                                                     mst `length` [mvt (var_of_hyp (-3) p)]]) 
                                         p)
                              THENL [Id; Try Arith])
                             (-1)
                            )
                     ) ORELSE AddHiddenLabel (`Proper length, n= `^ tok_of_int n)
                     ;
                     (UseWitness (mst `it` []) THEN Last D 
                      THEN Last D  THEN Last D THEN Last Thin 
                      THEN Last (Unfold tyQ)
                      THEN Last Reduce THEN Last (RD is_or_term) THEN Last D
                      THEN Try (Last D THEN Trivial)
                      THEN (DisproveInlrEq (-2) ORELSE AddHiddenLabel `DisproveInlrEq`)
                     ) ORELSE AddHiddenLabel  (`Bad length, n= ` ^ tok_of_int n)
                     ]
             ) p )
  THENM Try Trivial
  THENM Try (D i THEN Fold `it` 0 THEN Thin i THEN All (Folds constrs))
) p
;;

let RecTypeHD ty constrs i = FullRecTypeHD ty (ty^`C`) (ty^`Q`) constrs i ;;


let rec_simp patterns =
  if null patterns then failwith `add_rec_simp: need at least one pattern` else
  let apat = hd patterns in
  let opid = id_of_term apat in
  let ob = obid_of_abstraction_term apat in
  (ob,
   (\e t. exists (\p. fo_matches p t) patterns),
   RecUnfoldTopC opid
  )

;;

let add_rec_simp uobid patterns = simp_add_o uobid [rec_simp patterns] ;;

%
letrec generate_old_name name =
  letrec f i = let x = name J "__old" J (i<1 => "" | int_to_string i) in
               if is_lib_member (string_to_tok x) then f (i+1) else x  in
  f 0
;;
%  

let abstract_one_eq_pred t =
  let pred = find_subterm (is_term `eq_pred_marker` o snd) t in
  let dom_type = addressed_subterm pred [1;1] in
  let eq_var = tok_to_var `eq` in
  letrec f t =
    if is_all_term t & is_term `stype` (subterm t 1) 
    then apply_to_nth_immediate_subterm f 2 t
    else mk_all_term eq_var (mst `eq_pred` [dom_type])
                     (replace_subterm pred (mvt eq_var) t) in
  f t
;;
  

