
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2000                                *
;;;                                                                       *
;;;                                                                       *
;;;                Nuprl Proof Development System                         *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the Nuprl group, Department of Computer Science,       *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify Nuprl provided this notice  *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;************************************************************************


#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

(defun do-ml-hol-compile (&optional printp forcep)

  (inml (ml-text
	 (list
	  (format-string "load_system true false ~a []"
			 (if printp "true" "false"))

	  "[ ([\"library\"; \"top\"],"
          "   [\"subst\"])"
    
	  "; ([\"refiners\"; \"nuprl5\"; \"hol\"],"
	  "   [\"refm-hol\"; \"simp-re\"; \"onesimp\"])"

  	  "]; "

	  (format-string "load_system true false ~a []"
			 (if printp "true" "false"))

	  "[ ([\"refiners\"; \"nuprl5\"; \"hol\"],"
	  "   [\"onesimp\"])"
	  "; ([\"refiners\"; \"nuprl5\"; \"hol\"],"
	  "   [\"hol-tactics\"; \"edtactics\"; \"in-pred-tactics\" ])"
	  "];"

	  (format-string "load_system true false ~a []"
			 (if printp "true" "false"))

	  "[ ([\"refiners\"; \"nuprl5\"; \"tactics\"; \"standard\"],"
	  "   [\"inc-tactics-3\"])"

	  "; ([\"refiners\"; \"nuprl5\"; \"hol\"],"
	  "   [\"hol-tactics\"; \"edtactics\"; \"in-pred-tactics\" ])"
	  "]"

	  )))

  )

(defun do-ml-old-hol-compile (&optional printp forcep)

  (inml (ml-text
	 (list
	  (format-string "load_system true false ~a []"
			 (if printp "true" "false"))

	  "[ ([\"library\"; \"top\"],"
          "   [\"subst\"])"
    
	  "; ([\"refiners\"; \"nuprl5\"; \"hol\"],"
	  "   [\"refm-hol\"; \"old-onesimp\"])"

  	  "]; "

	  (format-string "load_system true false ~a []"
			 (if printp "true" "false"))

	  "[ ([\"refiners\"; \"nuprl5\"; \"hol\"],"
	  "   [\"old-onesimp\"])"
	  "; ([\"refiners\"; \"nuprl5\"; \"hol\"],"
	  "   [\"hol-tactics\"; \"old-edtactics\"; \"in-pred-tactics\" ])"
	  "];"

	  (format-string "load_system true false ~a []"
			 (if printp "true" "false"))

	  "[ ([\"refiners\"; \"nuprl5\"; \"tactics\"; \"standard\"],"
	  "   [\"inc-tactics-3\"])"

	  "; ([\"refiners\"; \"nuprl5\"; \"hol\"],"
	  "   [\"hol-tactics\"; \"old-edtactics\"; \"in-pred-tactics\" ])"
	  "]"

	  ))))

(defunml (|load_old_hol_system| (unit))
    (unit -> unit)
  
  (do-ml-old-hol-compile))


(defunml (|load_hol_system| (unit))
    (unit -> unit)
  
  (do-ml-hol-compile))