
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2000                                *
;;;                                                                       *
;;;                                                                       *
;;;                Nuprl Proof Development System                         *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the Nuprl group, Department of Computer Science,       *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify Nuprl provided this notice  *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;************************************************************************


#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;;;	RLE ??? Interdependency supported :
;;;	RLE ???  ie has stubs in interdependent modules. 

;;;; -docs- (mod ref)
;;;;
;;;;	refiner-environment (<deftable{abs}>
;;;;			     <deftable{statements}>
;;;;			     <deftable{proofs}>
;;;;			     <deftable{rules}>
;;;;			     <deftable{rule-ids}>)
;;;;
;;;;	ref-eval (<term> <id{tag}>)			: <term{ml-result}>
;;;;	 * tag identifies an environment
;;;;
;;;;
;;;; -doct- (mod ref ml)
;;;;
;;;;	ref_refine	: term{goal} -> term{tactic}
;;;;			    -> object_id list -> term{!inf_tree}
;;;;
;;;; -doce-
;;;;  -page-
;;;;
;;;;
;;;
;;;RLE TODO eval and interdependency for refine compute eval.
;;;;
;;;;  -page-
;;;;	Interdependency supported : 
;;;;	ref_compute	: term{tagged} -> term
;;;;
;;;;	eval	 	: variable -> term -> tok{environment}
;;;;				-> bool -> tok list{exceptions} -> term
;;;;	eval_update_env	: tok{env} -> tok{id} -> term -> unit
;;;;	eval_save_env	: tok -> object_address -> unit
;;;;	 * removes duplicates.
;;;;	eval_load_env	: tok -> object_address -> unit
;;;;	eval_clear_env	: tok -> unit
;;;;
;;;;

(defun allocate-rules (stamp tag)
  (ref-rule-table stamp tag))


(defun iinf-sequent-to-sequent (iinf-sequent)
  (let ((acc nil))
    (labels
	((visit (isequent)
	   (if (iinf-sequent-term-p isequent)
	       (progn (push (instantiate-assumption-r (binding-of-sequent-of-iinf-sequent-term isequent)
						      (type-of-iinf-sequent-term isequent)
						      (hidden-of-iinf-sequent-term isequent))
			    acc)
		      (visit (sequent-of-iinf-sequent-term isequent)))
	       (instantiate-sequent-r (nreverse acc) isequent))))

      (visit iinf-sequent))))

(defun iinf-goal-to-sequent-aux (iseq iannos)
  (let ((sequent (iinf-sequent-to-sequent iseq)))

    (dolist (iannotation iannos)
      (if (iannotation-term-p iannotation)
	  (setf sequent
		(mark-proof-node-n sequent
				   (label-of-iannotation-term iannotation)
				   (term-to-ml-annotation (term-of-iannotation-term iannotation)))) ;;LAL
	  (message-emit (warn-message '(!annotation not) iannotation))))
    
    sequent))

(defunml (|goal_to_proof| (iseq annos))
    (term -> ((term list) -> proof))
  (iinf-goal-to-sequent-aux iseq annos))

#|
(defunml (|proof_term_to_proof| (pterm))
    (term -> proof)
  (let ((goal (goal-of-iproof-node-term pterm))
        (refinement (refinement-of-iproof-node-term pterm))
        (children (children-of-iproof-node-term pterm)))
    (if children
	(proof-to-proof proof children)
	(iinf-goal-to-sequent-aux iseq annos)))))
|#
  

(defun iinf-goal-to-sequent (iinf-goal)
  (let ((sequent (iinf-sequent-to-sequent (sequent-of-iinf-goal-term iinf-goal))))

    (map-isexpr-to-sexpr (annotations-of-iinf-goal-term iinf-goal)
			 (iannotation-cons-op)
			 #'(lambda (iannotation)
			     (if (iannotation-term-p iannotation)
				 (setf sequent
				       (mark-proof-node-n sequent
							  (label-of-iannotation-term iannotation)
							  (term-to-ml-annotation (term-of-iannotation-term iannotation))))
				 (message-emit (warn-message '(!annotation not) iannotation)))))
    
    sequent))

(defunml  (|iinf_goal_to_sequent| (iinf_goal))
    (term -> proof)
  (iinf-goal-to-sequent iinf_goal))

(defun proof-to-isequent-term (seq)
  (labels ((iseq (assums)
	     (if (null assums)
		 (conclusion-of-sequent seq)
		 (iinf-sequent-term (hidden-assumption-p (car assums))
				    (type-of-assumption (car assums))
				    (id-of-assumption (car assums))
				    (iseq (cdr assums))))))
    (iseq (assumptions-of-sequent seq))))
	  

;;
;;abstype arg =
;;  int + term<tactic> + term + tok + var + ((var # term) list)<sub>
;;


(defun ml-arbitrary-union-to-term (u)
  (labels ((aux (u)
	     (cond
	       ((null u) (inil-term))
	       
	       ((consp u)
		(icons-term (aux (car u)) (aux (cdr u))))

	       ((integerp u)
		(inatural-term u))

	       ((variable-id-p u)
		(ivariable-term u))

	       ((symbolp u)
		(itoken-term u))

	       ((term-p u) (iterms-term u))

	       (t (break "mautt")))))
    (aux u)))

(defun arg-to-term (arg)
  (ml-arbitrary-union-to-term arg))
				       

(defun term-to-arbitrary-ml-union (term)
  (labels
      ((aux (u)
	 (cond
	   ((inil-term-p u) nil)
	       
	   ((icons-term-p u)
	    (cons (aux (icar u)) (aux (icdr u))))

	   ((itoken-term-p u)
	    (token-of-itoken-term u))

	   ((inatural-term-p u)
	    (numeral-of-inatural-term u))

	   ((ivariable-term-p u)
	    (id-of-ivariable-term u))

	   ((iterms-term-p u) (subterm-of-iterms-term u))

	   (t (break "ttamu")))))
    (aux term)))

(defun term-to-arg (term) (term-to-arbitrary-ml-union term))

  
(define-primitive |!anno_arg| ((token . name)) (value))
(define-primitive |!anno_arg_cons| () (car cdr))
(define-primitive |!arg_term| () (term))
(define-primitive |!nil_arg| () ())
(define-primitive |!tactic_arg| () (term))
(define-primitive |!substitution| ((variable . variable)) (term))

(defun null-annotation () (list (list (intern-system "main") nil) nil))


#|
(defun arg-to-term (arg)
  
  (if (null arg)
      (inil-arg-term)
      (let ((length (do ((i 1 (1+ i))
			 (a arg (cdr a)))
			((not (consp (cdr a))) i)))
	    (value (last arg)))
	(cond 
	  ((= length 1) (inatural-term (cdr value)))
	  ((= length 2) (itactic-arg-term (cddr arg)))
	  ((= length 3) (iarg-term-term (cdr value)))
	  ((= length 4) (itoken-term (cdr value)))
	  ((= length 5) (variable-term (cdr value)))
	  ((= length 6) ;;(break "s")
	   (isubstitution-term (caar value) (cdar value))) 
	  ((= length 7) ;;(break "2")
	   (isubstitution-term (car value) (cdr value)))
	  (t (break "arg?") (inil-term))))))
    
(defun term-to-arg (term)
  (cond
   ((inil-term-p term) nil)
   ((inil-arg-term-p term) nil)
   ((inatural-term-p term) (cons T (numeral-of-inatural-term term)))
   ((itactic-arg-term-p term) (append (list nil) (cons T (term-of-itactic-arg-term term))))
   ((iarg-term-term-p term) (append (list nil nil) (cons T (term-of-iarg-term-term term))))
   ((itoken-term-p term) (append (list nil nil nil) (cons T (token-of-itoken-term term))))
   ((variable-term-p term) (append (list nil nil nil nil) (cons T (id-of-variable-term term))))
   ((isubstitution-term-p term) 
    (append (list nil nil nil nil nil) (list (cons (variable-of-isubstitution-term term)
						   (term-of-isubstitution-term term))))) 
   (t (break "term?") nil)))
|#

    
          
(defun ml-annotation-args-to-term (args)
  ;;(when args (break "aas"))
  (map-sexpr-to-isexpr (mapcar #'(lambda (arg)
				   (let ((token (car arg))
					 (value (arg-to-term (cdr arg))))
				     (ianno-arg-term token value)))
			       args)
		       (ianno-arg-nil-term)))

(defun ml-annotation-label-to-term (label)
  (ianno-label-term (car label)
		    (ml-arbitrary-union-to-term (cdr label))

		    ;;(if (cadr label)
		    ;;	(progn;;(setf xx (cadr label))
		    ;;	  ;;(break)
		    ;;	  (inatural-term (cddr label))
		    ;;	  )
		    ;;	(inil-arg-term))
				    
		    ))

(defun ml-annotation-to-term (anno)
  (let* ((label (ml-annotation-label-to-term (car anno)))
	 (args (ml-annotation-args-to-term (cadr anno))))
    (iml-annotation-term label args)))

(defun term-to-ml-annotation (term)
  (let* ((label (label-of-iml-annotation-term term))
	 (args (map-isexpr-to-list (args-of-iml-annotation-term term) (ianno-arg-cons-op)))
	 (lvalue (value-of-ianno-label-term label)))
    ;;(setf -lvalue lvalue -label label -args args)
    (list
     (cons (name-of-ianno-label-term label)
	   (if (inatural-term-p lvalue)
	       (cons T (numeral-of-inatural-term lvalue))
	       (if (inil-arg-term-p lvalue)
		   (cons nil nil)
		   (if (inil-term-p lvalue)
		       (cons nil nil)
		       (term-to-arbitrary-ml-union lvalue)))))
     (mapcar #'(lambda (a) (cons (name-of-ianno-arg-term a)
				 (term-to-arg (value-of-ianno-arg-term a))))
	     args))))



(defun top-rule-to-itactic (rule)
  ;;(setf -rule rule) (break "ttti")
  (text-of-tactic-rule rule))

(defun top-proof-to-iinf-top (top-rule)
  (let ((proof (proof-of-top-rule top-rule)))
    (iinf-top-term nil
		   (environment-dependencies-sexpr-to-term (proof-node-mark-value proof 'dependencies))
		   (top-proof-to-iinf-tree proof)
		   (top-rule-to-itactic top-rule))))


(defun primitive-proof-to-iinf-primitive (proof &optional extract)
  (let* ((rule (rule-of-proof-node proof))
	 (extract (if (primitive-tree-rule-p rule)
		      (extract-of-primitive-tree-rule rule)
		      extract)))

    ;;(setf -rule rule -proof proof) (break "pptip")
    (iinf-primitive-term (environment-dependencies-to-term
			  (or (proof-node-mark-value proof 'dependencies)
			      ;; when tactic calls refiner recursively with no
			      ;; primitive steps then there will be no dependencies.
			      ;; atm, this is being returned as no dependencies recorded!
			      ;;(break "dep")
			      ))
			 (if extract
			     (progn
			       (format t "~%ext ~a " (term-op-count extract))
			       (iinf-extract-term extract))
			     (null-iinf-extract-term)))))


(defun actual-primitive-proof-to-iinf-primitive (proof)
  (iinf-primitive-actual-term
   (primitive-rule-to-term (rule-of-proof-node proof))))


;;;;	
;;;;	
;;;;	
;;;;	
;;;;	evidently something like IdTac will have a proof top whose
;;;;	rule is nil. This is not unrefined as there is a node with
;;;;	a single child (identical to the parent). Annotations may
;;;;	be added.
;;;;	
;;;;	Something similar may occur for a tactic which 
;;;;	calls the refiner recursively without first doing any
;;;;	primitive steps?
;;;;	
;;;;	
;;;;	assuming that we would n't be here if not refined
;;;;	so treat null rule as identity.
;;;;	

(defvar *persistent-proof-marks* '(dependencies xref ml-annotation))

(defun proof-marks-to-annotations (marks &optional filter)
  (mapcan #'(lambda (m)
	      (when (member (car m) (or filter *persistent-proof-marks*))
		(list
		 (iannotation-term (car m)
				   (case (car m)
				     (ml-annotation	(ml-annotation-to-term (cdr m)))
				     (dependencies	(environment-dependencies-to-term (cdr m)))
				     (xref		(cdr m))
				     (otherwise (ivoid-term)))))))
	  marks))


(defun proof-marks-to-annotations-term (proof &optional filter)
  (map-sexpr-to-isexpr
   (proof-marks-to-annotations (let ((marks (marks-of-proof-node proof)))
				 (when marks (marks-alist marks)))
			       filter)
   (iannotation-nil-term)))

(defun proof-to-goal (proof)
  (iinf-goal-term (proof-to-isequent-term proof)
		  ;; LAL subgoals in 5 were inheriting annos not in 4
		  (if *marks-p*
		      (proof-marks-to-annotations-term proof '(ml-annotation))
		      (iannotation-nil-term))))

(defunml (|proof_to_goal| (proof))
    (proof -> term)
  (proof-to-goal proof))

(defun null-rule-to-iinf-primitive (proof)
  ;;(setf -proof proof) (break "nrtip")
  (iinf-primitive-term
   ;; uncertain why this would be the correct one.
   (environment-dependencies-to-term (proof-node-mark-value proof 'dependencies))
   ;;(environment-dependencies-sexpr-to-term (proof-node-mark-value proof 'dependencies))

   ;; if id want extract to be extract of only child???
   (iinf-extract-term (iincomplete-term 1)) ;; was 0
   ))


(defun proof-to-rule (p)
  (let ((rule (rule-of-proof-node p)))
    (cond
      
      ((not (refined-proof-node-p p))
       (iinf-unrefined-term))

      ((proof-rule-p rule)
       (primitive-proof-to-iinf-primitive (partial-extract p t t)))

      ((top-rule-p rule)
       (top-proof-to-iinf-top rule))

      ((primitive-tree-rule-p rule)
       (primitive-proof-to-iinf-primitive p))

      ((null rule)
       (null-rule-to-iinf-primitive p))

      ;;((primitive-rule-p rule)
      ;;(actual-primitive-proof-to-iinf-primitive p))

      (t (raise-error (error-message '(interior proof to iinf tree)))))))


;; ptog : proof-to-goal
;; ptot : proof-to-iinf-tree
(defun proof-to-iinf-tree-aux (proof ptog ptot &optional rule children-p children annotations)

  ;;(setf -ptproof proof -ptog ptog -ptot ptot -rule rule -children children -annotations annotations) (break "ptita")
  (iinf-tree-term
   
   (if ptog
       (funcall ptog proof)
       (instantiate-term (iinf-goal-op)))

   (let ((r (or rule
		(proof-to-rule proof))
	   ))
     (setf -r r -c (if children-p
		       children
		       (children-of-proof-node proof)))
     ;;(break "ptiita")
     -r)

			    
   
   (map-sexpr-to-isexpr (if children-p
			    children
			    (children-of-proof-node proof))
			(iinf-tree-nil-term)
			ptot)

   (let ((proof-marks ;;(proof-node-mark-value proof 'ml-annotation)
	  (marks-of-proof-node proof)
	   ))
     ;;(setf -proof-marks proof-marks) (break "ptita")
     ;;(when anno-marks (format t "proof-marks ~a~%" (length proof-marks)))
     (map-sexpr-to-isexpr (if (and t ;;*marks-p*
				   proof-marks)
			      (if annotations
				  (cons annotations
					(proof-marks-to-annotations-term (marks-alist proof-marks)
									 '(xref dependencies)))
				  (proof-marks-to-annotations (marks-alist proof-marks)
							      '(xref dependencies)))
			      annotations)
			  (iannotation-nil-term)))))



(defun refinement-to-iinf-tree (proof children &optional annotations)
  ;;(setf -pn proof -children children) (break "rtit")
  ;; (make-proof (make-top proof) children)

  (proof-to-iinf-tree-aux
   proof
   nil
   #'exterior-proof-to-iinf-tree

   ;; !inf_top with no tactic. 
   (instantiate-term (iinf-top-op t)
		     (list (instantiate-bound-term
			    (environment-dependencies-to-term
			     (proof-node-mark-value proof 'dependencies)))
			   (instantiate-bound-term
			    (top-proof-to-iinf-tree proof))))
   t
   children
   annotations))

(defun primitive-proof-to-iinf-tree (proof)
  ;;(setf -pn proof) (break "pptit")

  (proof-to-iinf-tree-aux
   proof
   #'proof-to-goal
   #'primitive-proof-to-iinf-tree

   (if (primitive-rule-p (rule-of-proof-node proof))
       (actual-primitive-proof-to-iinf-primitive proof)
       (proof-to-rule proof))))


(defunml (|push_ref_avoid| (oids))
    ((object_id list) -> unit)

  (if (boundp `*ref-current-objects*)
      (setf *ref-current-objects* (append *ref-current-objects* oids))
      (progn
	;;(break "pra")
	(raise-error (oid-error-message oids `(push ref avoid))))))

;; used only on children of outermost tree of refinement.
;; differs from internal only in that rule must be top
;; ie can not be prim or prim tree.
(defun exterior-proof-to-iinf-tree (p)
  (proof-to-iinf-tree-aux
   p
   #'proof-to-goal
   #'exterior-proof-to-iinf-tree))


(defvar *marks-p* t)

(defun fooa (&optional e)
  (when (ml-text "quick_fiat_conv")
    (ml-text "quick_fiat_conv := false; tac_debug := true")
    (format t "~%quick_fiat_conv was reset to false~%tac_debug was reset to true~%"))
    
  (raise-abort e))

(defunml (|abort| (msg))
    (string -> unit)

  (format t "~%Abort : ~a~%" msg)
  (fooa (error-message '(ml abort) msg)))

(defun ref-refine-aux-aux (igoal tactic envoid)
  (let ((sequent (iinf-goal-to-sequent igoal)))

    (ml-text "quick_fiat_conv := false; tac_debug := true")
    (handle-stack-overflow
     '(refiner)
     (let ((rule nil)
	   (children nil))
	     
       (with-reference-environment envoid
	 (mlet* (((rrule rchildren)
		  (refine sequent (nml-tactic-rule tactic))))
		(setf rule rrule children rchildren)))

	    ;; RLE ??? Should we check that proof in rule matches goal
	    ;; RLE ??? can we always trust that children is the frontier? 
	    ;; RLE !!! we should simply pass back the proof top here.
	    ;; RLE !!! all else is known or can be computed.
			  
	    ;; xref for tactic compile is mark on proof-node.
	    ;; TODO if recursive tactics how is this accounted for???
	    ;;   recursive call will return interior tree thus account
	    ;;   during abbrev/activate of inf.
	    (cons rule children)))))

(defun ref-refine-aux-auxt (igoal tactic envterm)
  ;;(setf -igoal igoal -tactic tactic -envterm envterm)
  ;;(break "rraat")
  (let ((sequent (iinf-goal-to-sequent igoal)))
    ;;(setf -sequent sequent -envterm envterm) (break "rraat")
    (ml-text "quick_fiat_conv := false; tac_debug := true")
    (handle-stack-overflow
     '(refiner)

     (let ((rule nil)
	   (children nil))

       (with-reference-environment-term envterm
	 (mlet* (((rrule rchildren)
		  (refine sequent (nml-tactic-rule tactic))))
		(setf rule rrule children rchildren)))
	   
       ;; RLE ??? Should we check that proof in rule matches goal
       ;; RLE ??? can we always trust that children is the frontier? 
       ;; RLE !!! we should simply pass back the proof top here.
       ;; RLE !!! all else is known or can be computed.
			  
       ;; xref for tactic compile is mark on proof-node.
       ;; TODO if recursive tactics how is this accounted for???
       ;;   recursive call will return interior tree thus account
       ;;   during abbrev/activate of inf.
       (cons rule children)))))


(defun ref-refine-aux (igoal tactic envoid &optional avoid-oids validity-p (name t))
  ;;(fooe) ;;(break "rraaa")
  (let ((*ref-current-objects* avoid-oids)
	(*ref-validity-check* (when (and validity-p
					 ;; I think if envoid then avoid-oids not good enough.
					 (not (and envoid (not (dummy-object-id-p envoid)))))
				(or (let ((grphash (ref-group-hash)))
				      (let ((indices (mapcan #'(lambda (oid)
								 (let ((rdag (hashoid-get grphash oid)))
								   (when rdag
								     (let ((i (index-of-ref-dag rdag)))
								       (when i (list i))))))
							     avoid-oids)))
					(when indices
					  (if (cdr indices)
					      (reduce #'min indices)
					      (car indices)))))
				    t	; anything which has an index is ok.
				    )))
	(stats nil)
	)

    ;; envoid may be dummy.
    (let ((r (with-refine-stats #'(lambda (ref-stats) (setf stats ref-stats))
	       (ref-refine-aux-aux igoal tactic envoid))))


      (let ((rule (car r))
	    (children (cdr r)))
	
	(let ((proof (proof-of-tactic-rule rule)))
	  ;;(setf -rule rule -c children -proof proof -stats stats) (break "rra")
	  (let ((cstats (complete-refine-stats stats proof t)))
	    (refine-stats-accumulate name stats)
	    (refinement-to-iinf-tree proof children
				     (iannotation-term 'refine-stats
						       (refine-stats-to-term 	  
							cstats)))))))))


(defunml (|ref_refine| (igoal tactic envoid avoidoids))
    (term -> (term -> (object_id -> ((object_id list) -> term))))

  (ref-refine-aux igoal tactic envoid avoidoids nil))

(defunml (|ref_refinet_aux| (name igoal tactic envterm))
    (tok -> (term -> (term -> (term -> term))))

  ;;(setf -name name -igoal igoal -tactic tactic -envterm envterm) (break "rra1")
  (let ((stats nil))
    (let ((r (with-refine-stats #'(lambda (ref-stats) (setf stats ref-stats))
	       (ref-refine-aux-auxt igoal tactic envterm))))

      (let ((rule (car r))
	    (children (cdr r)))
	
	(let ((proof (proof-of-tactic-rule rule)))
	  ;;(setf -rule rule -c children -proof proof -stats stats -envterm envterm) (break "rra")
	  (let ((cstats (complete-refine-stats stats proof t)))
	    ;;(setf -cstats cstats) (break "stats")
	    (refine-stats-accumulate name stats)
	    (refinement-to-iinf-tree proof children
				     (iannotation-term 'refine-stats
						       (refine-stats-to-term 	  
							cstats)))))))))


(defunml (|ref_refine_wname| (name igoal tactic envoid avoidoids))
    (tok -> (term -> (term -> (object_id -> ((object_id list) -> term)))))

  (ref-refine-aux igoal tactic envoid avoidoids nil name))

(defunml (|ref_refine_valid| (igoal tactic envoid avoidoids))
    (term -> (term -> (object_id -> ((object_id list) -> term))))

  (if (dummy-object-id-p envoid)
      ;;(equal-oids-p envoid (ml-text "ref501_envoid")) 
      (ref-refine-aux igoal tactic envoid avoidoids nil)
      (if *ref-monitor-p*
      
	  #+lucid(with-monitoring (ref-refine-aux igoal tactic envoid avoidoids t))
	  #+allegro(with-profiling () (ref-refine-aux igoal tactic envoid avoidoids t))
	  #-(or lucid allegro) (ref-refine-aux igoal tactic envoid avoidoids t)

	  (ref-refine-aux igoal tactic envoid avoidoids t))))


(defunml (|ref_refine_profile_aux| (igoal tactic envoid))
    (term -> (term -> (object_id -> term)))

  (with-profile (:space refine-profile t nil)
    (ref-refine-aux igoal tactic envoid nil t)))


(defun refine-check-aux (goal tac envoid)
  (let ((r (let ((*primitive-extract-mode* 'lazy))
	     (ref-refine-aux-aux (goal-to-term goal) tac envoid))))
    (let ((rule (car r))
	  (children (cdr r)))
      
      ;;(setf -r r) (break "rca")
      (cons (proof-of-tactic-rule rule)
	    (mapcar #'(lambda (sb)
			;;(setf -sb sb)
			(cons
			 (proof-to-isequent-term sb)
			  (let ((marks (marks-of-proof-node sb)))
			    (when marks 
			      (proof-marks-to-annotations (marks-alist marks) '(ml-annotation))))))
		    children)))))

(defunml (|refine_check| (goal tac envoid))
    ((term |#| (term list)) -> (term -> (object_id -> (proof |#| ((term |#| (term list)) list)))))

  (refine-check-aux goal tac envoid))

(defunml (|refine_check_wname| (name goal tac envoid))
    (tok -> ((term |#| (term list)) -> (term -> (object_id -> (proof |#| ((term |#| (term list)) list))))))

  (let ((stats nil))
    (let ((r (with-refine-stats #'(lambda (ref-stats)
				    ;;(setf -rstats ref-stats) (break "he")
				    (setf stats ref-stats))
	       (refine-check-aux goal tac envoid))))
      (complete-refine-stats stats (car r) t)
      (refine-stats-accumulate name stats)
      r)))


(defunml (|assumptions_of_sequent| (term))
    (term -> (assumption list))
  (assumptions-of-sequent (iinf-sequent-to-sequent term)))
	
(defunml (|conclusion_of_sequent| (term))
    (term -> term)
  (conclusion-of-sequent (iinf-sequent-to-sequent term)))

;;;;	
;;;;	
;;;;	Proof to term.
;;;;	
;;;;

(defun top-proof-to-iinf-tree (proof)
  ;;(setf -proof proof) (break "tptit")
  (let ((rule (rule-of-proof-node proof)))
     
    (proof-to-iinf-tree-aux

     (if (and (refined-rule-p rule)
	      (primitive-rule-p rule))
	 (let ((*primitive-extract-mode* 'eager))
	   (refined-primitive-proof proof))
	 proof)

     nil

     #'interior-proof-to-iinf-tree
   
     ;; Id tac, otherwise gets treated like unrefined.
     (when (null rule)
       (null-rule-to-iinf-primitive proof))

     (null rule)

     (when (null rule)
       (list proof))

     )))


;;; interior be primitive tree while exterior can not.
(defun interior-proof-to-iinf-tree (proof)

  (let ((rule (rule-of-proof-node proof)))
    (proof-to-iinf-tree-aux

     (if (and (refined-rule-p rule)
	      (primitive-rule-p rule))
	 (let ((*primitive-extract-mode* 'eager))
	   (refined-primitive-proof proof))
	 proof)

     ;; lib-inf : 
     ;;	  - the the goals of the children of an exterior proof are identical to the
     ;;	    goals of the frontier of the interior proof of the node of the exterior
     ;;	    proof.
     ;; thus we do not need to supply them.

     (when (refined-rule-p rule)
       #'proof-to-goal)
   
     #'interior-proof-to-iinf-tree)))

(defun ref-refine-prim (igoal tactic envoid oids)
  (let ((*ref-current-objects* oids)
	(*primitive-extract-mode* `lazy)
	)

    (let ((r (ref-refine-aux-aux igoal tactic envoid)))
      (let ((rule (car r))
	    ;;(children (cdr r))
	    )
	
	(let ((proof (proof-of-tactic-rule rule)))
	  (primitive-proof-to-iinf-tree proof))
	))))

(defunml (|ref_refine_prim| (igoal tactic envoid oids))
    (term -> (term -> (object_id -> ((object_id list) -> term))))

  (ref-refine-prim igoal tactic envoid oids)
  )

(defun ref-refine-primt (igoal tactic envterm)
  (let ((*primitive-extract-mode* `lazy)
	)

    (let ((r (ref-refine-aux-auxt igoal tactic envterm)))
      (let ((rule (car r))
	    ;;(children (cdr r))
	    )
	
	(let ((proof (proof-of-tactic-rule rule)))
	  (primitive-proof-to-iinf-tree proof))
	))))
(defunml (|destruct_primitive_rule| (rule))
    (rule -> (tok |#| (term list)))

  (unless (primitive-rule-p rule)
    (setf -rule rule) (break "pr") (breakout evaluation "destructprimitiverule: rule is not primitive."))

  (cons (id-of-rule rule)
	(args-of-primitive-rule rule)))

(defunml (|ref_refine_primt_aux| (igoal tactic envterm))
    (term -> (term -> (term -> term)))

  (ref-refine-primt igoal tactic envterm))

(defunml (|ref_refine_primr_aux| (igoal tactic envterm))
    (term -> (term -> (term -> proof)))
  (let ((*primitive-extract-mode* `lazy)
	)
    (setf -goal igoal -tactic tactic -ev envterm) (break "rr")
    (proof-of-tactic-rule (car (ref-refine-aux-auxt igoal tactic envterm)))))

;; used only on children of outermost tree of refinement.
;; differs from internal only in that rule must be top
;; ie can not be prim or prim tree.
(defun exterior-proof-to-iinf-tree (p)
  (proof-to-iinf-tree-aux
   p
   #'proof-to-goal
   #'exterior-proof-to-iinf-tree))



;;;;	
;;;; -docs- (mod ref ml)
;;;;	
;;;;	init_refine_monitoring		: bool{lisp} -> bool{ml} -> unit
;;;;	  * bools indicate what types of function defs to monitor.
;;;;	  * use to initialize or reset monitoring.
;;;;	  * init_refine_monitoring false false should be evaled when monitoring
;;;;	    is complete.
;;;;
;;;;	monitor_ref_refine		: term -> term -> object_id list -> term
;;;;	  * similar to ref_refine
;;;;	
;;;;	report_refine_monitoring	: unit -> unit
;;;;	  * prints monitor report to stdout.
;;;;
;;;;	report_refine_monitoring does not reset the monitors. init_refine_monitoring
;;;;	must be eval to reset. Monitor_ref_refine may be called many times between init
;;;;	and results are cumulative.
;;;;	
;;;;	Eg if two reports without an intervening init, the second is cumulative and 
;;;;	still contains the firsts data.
;;;;	
;;;;	Beware : monitoring significantly impacts performance.	
;;;;	
;;;; -doce-
;;;;	


(defun monitor-init (lisp-p ml-p)
  (let ((acc nil)
	(unacc nil))
    (do-all-symbols (s nil)
      (when (fboundp s)
	(if (or (and lisp-p (eql (symbol-package s) *system-package*))
		(and ml-p (eql (symbol-package s) *ml-runtime-package*)))
	    (unless (monitoredp s)
	      (push s acc))
	    (when (and (or (eql (symbol-package s) *system-package*)
			   (eql (symbol-package s) *ml-runtime-package*))
		       (monitoredp s))
	      (push s unacc)))))
    (unmonitor-functions unacc)
    (monitor-functions acc)
    (cons (length acc) (length unacc))))

(defvar *ref-monitor-p* nil)

(defunml (|init_refine_monitoring| (lisp-p ml-p))
    (bool -> (bool -> unit))

  (monitor-init lisp-p ml-p)
  (reset-monitors)
  (stop-monitoring)

  (setf *ref-monitor-p* nil)

  nil
  )

#|
(defunml (|monitor_ref_refine| (igoal tactic oids))
    (term -> (term -> ((object_id list) -> term)))
  
  (with-monitoring
      (ref-refine-aux igoal tactic nil oids)))

|#

(defunml (|report_refine_monitor| (unit) :declare ((declare (ignore unit))))
    (unit -> unit)
  #+lucid(summarize-monitors :inclusive-time t :number-of-calls t :inclusive-consing t)
  #+allegro(progn (prof:show-flat-profile)
		  (prof:show-call-graph)
		  (prof:show-call-counts))
  nil)
    




;;#+dontdoit
(defun map-command-ref0 (cmd)
  (case (id-of-term cmd)
    (|!refine_cmd|
     (instantiate-term (iml-op nil t)
		       (cons (instantiate-bound-term
			      *refine-text*)
			     (bound-terms-of-term cmd))))

    (|!code_check_cmd|
     (break)
     ;; need some variable of !ML
     )

    (otherwise nil))  )


#|
(defun current-proof-cache-update (proof)
  (let ((cache (current-cache t)))
    (if (eql 'complete (status-of-proof-node proof))
	(when cache
	  (proof-cache-update cache proof))
	(display-msg "Update to proof-cache with incomplete proof attempted.")))
  nil)

(defun current-proof-cache-lookup (proof)
  (let ((cache (current-cache)))
    ;;(setf a cache) (break)
    (or (when cache (proof-cache-lookup cache proof))
	(process-err "NoCacheMatch"))))

(defun proof-cache-stats (name)
  (let ((cache (theorem-object-cache (find-library-object name 'thm))))
    ;;(setf a cache) (break)
    (or (when cache (cache-stats cache))
	(process-err "NoCache"))))



(defunml (|update_current_pcache| (proof))
  (proof -> void)

  (current-proof-cache-update proof))

(defunml (|lookup_current_pcache| (proof))
  (proof -> proof)

  (current-proof-cache-lookup proof))

(defunml (|clear_pcache| (name))
  (tok -> void)

  (clear-cache-of-theorem-object (find-library-object name 'thm)))

|#
