%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%
****************************************************************************
Conversion to Tactic functions
****************************************************************************
%

%
Top level functions to apply a conversion as either a direct computation
or a tactic.

At some time should fix to use SubstClause instead of ReplaceClause,
when returned relation is equality rather than iff or implies.

Could also add intelligence to handle equands of equal terms.
%

letref quick_rw = false ;;

let quick_just = form_tactic_just Fiat ;;
let just_accelerator j = if quick_rw then quick_just else j ;;


%
Take care to not weaken if we have compute sequence just rather than
tactic just
%

let WeakenC r' (c:convn) e t1 =
  let t2,r,j = c e t1 in
  if is_comp_seq_just j then t2,r,j 
  else
  let j_weakener = 
   get_weakening_just r r'
     ? failwith 
       (`WeakenC: cannot weaken ` ^ name_of_rel r ^ ` to ` ^ name_of_rel r' )
    in
      t2,r', j_weakener j 
;;
  

let TopLevelC i (c:convn) e t =
  let r' = if i = 0 then rev_implies_reln else implies_reln in
    WeakenC r' c e t
;;

% NB: When replacing hyps, the new hyp might involve variables bound later
in the hyp list. In this case, the old hyp is deleted and the new hyp
is included at the end of the hyp list.
%

let ReplaceClause t1 t2 Tac i p =
  let n = num_hyps p in
  if i = 0 then
  % apply conversion to conclusion, Tac proves t1 <= t2 %

  % H1...Hn |- t1 %

    (  Assert (mk_rel_term rev_implies_reln t1 t2)

  % H1...Hn, |- t1 <= t2 
    H1...Hn t1 <= t2 |- t1 %

       THENL
       [Tac THENM AddHiddenLabel `rewrite subgoal`
       ;
          ( D (n+1)

          % H1...Hn |- t2
            H1...Hn, t1 |- t1 %

            THENL [AddHiddenLabel `main`;NthHyp (n+1)]
          )  
       ]
    ) p
  else
  % apply conversion to hypothesis. Tac proves t1 => t2 %

  % H1...#i:t1...Hn |- C %

    (  Assert (mk_rel_term implies_reln t1 t2)

  % H1...#i:t1...Hn |- t1 => t2 
    H1...#i:t1...Hn, t1 => t2 |- C %

       THENL
       [Tac THENM AddHiddenLabel `rewrite subgoal`
       ;
          ( D (n+1)

   % H1...#i:t1...Hn |- t1
     H1...#i:t1...Hn, t2 |- C %

            THENL 
            [NthHyp i
            ;(MoveToHyp i (n+1) THEN Thin (i+1))
             ORELSE 
             (Message "New rewritten hyp at end"
              THEN Thin i THEN AddHiddenLabel `main`
             )
            ]
          )  
       ]
    ) p
;;


let Rewrite c i p =
  let i' = get_pos_hyp_num i p in
  let t1 = clause_type i' p in
  let t2,r,j = c (env_of_sequent p) t1 in  % j proves t1 r t2 %

  if name_of_rel r = `identity` then
    Id p
  else if is_comp_seq_just j then
    ExecuteComputeSeq (open_comp_seq_just j) i' p
  else if is_sqequal_rel r then
    let j' = just_accelerator j in
    let tac1 = if is_sqjust j' then
                 (ExecuteSqJust (open_sqjust j'))
              else
                  open_tactic_just j' in
    (SqSubst (mk_sqequal_term t1 t2) i' THENL [tac1;Id]) p
  else
    let r' = if i = 0 then rev_implies_reln else implies_reln in
    let j' = apply_just_weakening r' r j in
    ReplaceClause t1 t2 (open_tactic_just (just_accelerator j')) i' p
;;



let OldRewrite c i p =
  let i' = get_pos_hyp_num i p in
  let t1 = clause_type i' p in
  let t2,r,j = c (env_of_sequent p) t1 in  % j proves t1 r t2 %
               
  if name_of_rel r = `identity` then Id p 
  if is_comp_seq_just j then
    ExecuteComputeSeq (open_comp_seq_just j) i p
  else
  let n = num_hyps p in
  if i' = 0 then

  % apply conversion to conclusion %

    let j_weakener = get_weakening_just r rev_implies_reln 
              ? failwith 
         `Rewrite: the original concl must follow from the rewritten concl` in

  % j' proves t1 <= t2 %

    let j' = just_accelerator (j_weakener j) in  

  % H1...Hn |- C %

    (  Assert (mk_rel_term rev_implies_reln t1 t2)

  % H1...Hn, |- t1 <= t2 
    H1...Hn t1 <= t2 |- C %

       THENL
       [open_tactic_just j' THENM AddHiddenLabel `rewrite subgoal`
       ;
          ( D (n+1)

          % H1...Hn |- t2
            H1...Hn, t1 |- t1 %

            THENL [Id;NthHyp (n+1)]
          )  
       ]
    ) p

  else

    % apply conversion to hypothesis %

    let j_weakener = get_weakening_just r implies_reln 
              ? failwith 
              `Rewrite: the rewritten hyp must follow from the orginal hyp` in

  % j' proves t1 => t2 %

    let j' = just_accelerator (j_weakener j) in

  % H1...Hi:t1...Hn |- C %

    (  Assert (mk_rel_term implies_reln t1 t2)

  % H1...Hi:t1...Hn |- t1 => t2 
    H1...Hi:t1...Hn, t1 => t2 |- C %

       THENL
       [open_tactic_just j' THENM AddHiddenLabel `rewrite subgoal`
       ;
          ( D (n+1)

   % H1...Hi:t1...Hn |- t1
     H1...Hi:t1...Hn, t2 |- C %

            THENL [NthHyp i;MoveToHyp i (n+1) THEN Thin (i+1)]
          )  
       ]
    ) p
;;


let RewriteConcl c =  OnConcl (Rewrite c) ;;
let RewriteHyp i c =  OnHyp i (Rewrite c) ;;
let RewriteHyps is c =  OnHyps is (Rewrite c) ;;
let RewriteClauses cls c =  OnClauses cls (Rewrite c) ;;


let RW = Rewrite ;;

let RWHi c = Rewrite (HigherC c) ;;

let RWNth n c = Rewrite (NthC n c) ;;

let RWNths ns c = Rewrite (NthsC ns c) ;;

let RWAddr addr c = Rewrite (AddrC addr c) ;;

let RWN = RWNth ;;
let RWNs = RWNths ;;
let RWH = RWHi ;;

let RWD c = Rewrite (SweepDnC c) ;;
let RWU c = Rewrite (SweepUpC c) ;;



%
****************************************************************************
Version of rewrite for types of members and equalities.
****************************************************************************
Allows type rewriting without any subgoals to prove members in type.

%

let RewriteType c i p = 
  let i' = get_pos_hyp_num i p in
  let t1 = clause_type i' p in
  if not is_terms ``member equal`` t1 then
    failwith `RewriteType: only applies to types of member or equal terms`
  else
  let T1.equands = subterms t1
  in
  let T2,r,j = c (env_of_sequent p) T1 in  % j proves T1 r T2 %
               
  if name_of_rel r = `identity` then Id p 
  if is_comp_seq_just j then
    failwith `RewriteType: got direct comp just, use Rewrite instead`
  if not r = untyped_equal_reln then
    failwith `RewriteType: got non equality rewrite relation`
  else
  let t2 = 
     is_term `member` t1 => mk_simple_ab_term `member` (T2.equands)
                         |  mk_simple_prim_term `equal` (T2.equands)
  in
  let UTerm = U_lub (get_type p T1) (get_type p T2) 
  in 
  ( ReplaceWith t2 i'
    THENA 
    (Assert (mk_equal_term UTerm T1 T2)
     THEN IfLabL [`assertion`,open_tactic_just (just_accelerator j)
                 ;`main`,DebugTry Eq]
    )
  ) p
;;

let RWT c i p = RewriteType c i p ;;
let RWTH c i p = RewriteType (HigherC c) i p ;;
  

%[
*****************************************************************************
Applying conversion directly to term to get term
*****************************************************************************
]%

letref apply_conv_debug = ivoid_term;;
let apply_conv (c:convn) t =

 let p = quick_fiat_conv in
  quick_fiat_conv := true;

  (let r = fst (c null_env t) in
      quick_fiat_conv := p;
      r)

  ? (quick_fiat_conv := p; apply_conv_debug := t; failwith `apply_conv`)
;;
