
%[
RA = Run Autotactic on all subgoals
RAA  = Run Autotactic on auxiliary subgoals. (any subgoal with a label)
RAWF = Run Autotactic on well formedness subgoals (any subgoal with wf label)
]%

let ArithAuto = Repeat (Progress Auto ORELSE TryOnAllMClauses ArithSimp) ;;
let RA T p = RunTactic (T THEN Auto) p ;;
let RAA T p = RunTactic (T THENA Auto) p ;;
let RAWF T p = RunTactic (T THEN (IfLab `wf` Auto Id)) p ;;

%[
*********************************************************************
Setting Auto hooks
**********************************************************************
References related to previous entries in library which want to use
Autotactic 

Should probably change these to type unit->tactic, so that we always look 
up a fresh version of autotactic in the event that we overwrite autotactic.
]%

% See equality-tactics.ml %

NonReflEqCD_Autotactic := Auto ;;

% See inclusion-tactics.ml %

InclusionAuto := SIAuto ;;

%[
*********************************************************************
Experimental Multi-level Autotactic
**********************************************************************
Use Expand and Contract tactics from txform-tactics.ml to see embedded 
tactics.
]%

let MemEqCD p = 
  EqToMemberEq (\i.EqCDAux `regular`) 0 p;;

let StringToTac str p = 
  refine (make_tactic_rule (mk_text_term str)) p
;;

let HAuto = 
  Repeat
   ( StringToTac "Trivial" 
     ORELSE StringToTac "Progress (OnAllHyps RepeatAndHD)"
     ORELSE StringToTac "Progress WeakGenUnivCD" 
     ORELSE StringToTac "RepeatMemberReflEqCD `regular`"
     ORELSE StringToTac "Arith"
   )
;;

   