%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
****************************************************************************
****************************************************************************
PRIM-EQ-TACTICS
****************************************************************************
****************************************************************************
Tactics for simplifying equality conclusion terms. i.e. 
terms of form 

t = t' in T

by eliminating the outermost constructors of t t' and T.

The main equality decomposition tactics add hidden labels to the subgoals for
the equalities over the subterms of t and t'. T must be a primitive term.
]%
%
Tactics for working on primitive equalities in both hyp and concl.

%

%
SOApEqCDUsing
~~~~~~~~~~~~~~~~~~
(Second Order Application in Equality term Conclusion Decomp)

Recall the applyEquality rule...

|- f a = g b in B[a/x]

BY applyEquality x:A -> B

  |- f = g in x:A -> B
  |- a = b in A

We have to soup this up a bit to cope with cases where x is a so variable 
which occurs free in B and a is a so_lambda term.
In this case if the initial goal is

|- f (\xs.a[xs]) = g (\ys.b[ys]) in B0

where the \s are so_lambdas, we need a middle step reached by reverse direct 
computation of

|- f a = g b in B1{(\xs.a[xs])[B2]}

where {} indicate some subterm of B1. _[_] is a second order application term.
Then we invoke applyEquality...
 
BY applyEquality x:A -> B1{x[B2]}
...

We want to be able to use this function generally, so we do a couple of 
quick checks before launching into the extra work.  This might be one place
where having special types for the types of so variables would be helpful.
One could check if a variable is so in constant time then.
%

let SOApEqCDUsing A_arrow_B p =
  
  % See whether x is so and occurs in B %
  let t1,t2 = equands (concl p) in
  let (),a = dest_apply t1 in
  let name =
      if is_rfunction_term A_arrow_B then
          `rfunction_applyEquality`
      else
          `applyEquality`
  in
  if is_term `so_lambda` a then
  ( let f,x,A,B =
	if is_rfunction_term A_arrow_B then
	    dest_rfunction A_arrow_B
	else
	    null_var, dest_function A_arrow_B
    in
    let g, () = dest_apply t1 in
    let un_soreduced_B_of_a = fo_subst [x,a; f,g] B 
    in
      Assert (mk_equal_term un_soreduced_B_of_a t1 t2)
      THEN IfLabL
      [`main`,
       Try (SOReduce (-1)) THEN NthHyp (-1)
      ;`assertion`,
       Refine name [mk_term_arg A_arrow_B] 
      ]
  ) p
  else
    Refine name [mk_term_arg A_arrow_B] p
;;





% Used in EqCDByLemma to handle lambda subterm equalities. %

%
>> \x1 ... xn. s = \y1 ... yn .t in z1:A1 -> ...-> zn:An -> B

  BY RepeatLambdaEqCDThen [w1;...;wn] T

  w1:A1 ... wn:An >> s = t in B

  BY T

  w1:A1 ... wn-1:An-1 >> An = An in U{*}
     .    .     .
     .    .     .
     .    .     .
  >> A1 = A1 in U{*}

  With ws substituted in for xs, ys and zs.
%

% assume |vars| > 0 %
  
letrec RepeatLambdaEqCD vars p =
  let Tac p =
      let goal = concl p in
      let T, (), () = dest_member_or_equal goal in
      let name =
          if is_function_term T then
	      `lambdaEquality`
	  else if is_rfunction_term T then
	      `rfunction_lambdaEquality`
          else
	      failwith `RepeatLambdaEqCD: not a function type`
      in
      let new_var_args = mk_new_var_args [[hd vars]] p in
      let le_arg = infer_level_exp_arg p (subterm_of_term (eq_type goal) 1) in
	  Refine name (le_arg . new_var_args) p
  in
      if null vars then 
	  AddHiddenLabel `main` p
      else
	  ((Try (UnfoldSoftEquands 0)        % might have so_lambda abstraction %
	    THEN Tac)
	   THENL
	   [RepeatLambdaEqCD (tl vars); WFPrettyUp]) p
;;

let RepeatLambdaMemEqCDThen vars T p = 
  if null vars then T p
  if is_member_term (concl p) then
  ( UnfoldTop `member` 0
    THEN RepeatLambdaEqCD vars 
    THENM (FoldTop `member` 0 THEN T)
  ) p
  else
  ( RepeatLambdaEqCD vars 
    THENM T
  ) p
;;


%
~~~~~~~~~~~~
PrimEqCD
~~~~~~~~~~~~
Invoke appropriate conclusion equality rule 

Does fancy work e.g. for apply equalities belong here?
Maybe introduce it separately later...

intended for use with 
``ind list_ind decide spread rec_ind`` 
terms. 
%

let get_over_pair t T =
  let principal_arg = hd (subterms_of_term t)   in
  if is_var_term principal_arg then 
    dest_var principal_arg, T 
  else 
    replace_subterm_by_new_free_var principal_arg T  
;;


let PrimEqCD p =

  let T,t,t' = dest_equal (concl p)  in
  let opid = opid_of_term t in
  let local_get_using_type p t = 
    get_term_arg `t1` p ? get_using_type p t
  in
  if not opid = opid_of_term t' then
    failwith `PrimEqCD: outermost constructors do not match`
  else

 ((\p.

  if opid = `token` then 
    Refine `tokenEquality` [] p

  if opid = `any` then
    Refine `anyEquality` [] p

  if opid = `natural_number` then
    Refine `natural_numberEquality` [] p

  if opid = `minus` then 
    Refine `minusEquality` [] p

  if opid = `add` then 
    Refine `addEquality` [] p

  if opid = `subtract` then 
    Refine `subtractEquality` [] p

  if opid = `multiply` then 
    Refine `multiplyEquality` [] p

  if opid = `divide` then 
    Refine `divideEquality` [] p

  if opid = `remainder` then 
    Refine `remainderEquality` [] p

  if opid = `axiom` then
    if is_equal_term T then
	Refine `axiomEquality` [] p
    else if is_sqequal_term T then
	Refine `axiomSqEquality` [] p
    else
	Refine `less_thanMember` [] p
 
  if opid = `term_sq` then
    Refine `termSqEquality` [] p

  if opid = `nil` then 
    Refine `nilEquality` [infer_level_exp_arg p T] p

  if opid = `cons` then 
    Refine `consEquality` [] p

  if opid = `inl` then 
    Refine `inlEquality` [infer_level_exp_arg p (subterm_of_term T 2)] p

  if opid = `inr` then 
    Refine `inrEquality` [infer_level_exp_arg p (subterm_of_term T 1)] p

  if opid = `lambda` then
    (let new_var_args = mk_new_var_args [[(fst (dest_lambda t))]] p in
     let goal = concl p in
     let T, (), () = dest_member_or_equal goal in
     let name =
	 if is_rfunction_term T then
	     `rfunction_lambdaEquality`
	 else
	     `lambdaEquality`
     in
	 Refine name (infer_level_exp_arg p (subterm_of_term T 1) 
		      . new_var_args) p)

  if opid = `pair` then 
  ( let v,A,B = dest_product T  in
    if is_null_var v then 
      Refine `independent_pairEquality` [] p
    else if fails_p (get_int_arg `weak_types`) p then
    ( let v' = get_distinct_var v p 
      in let var_args = mk_new_var_args [[v]] p in
        Refine `dependent_pairEquality` 
          [infer_level_exp_arg 
             (extend_sequent p [v',A]) 
             (v = v' => B | subst [v,mvt v'] B)
          ;mk_var_arg v'
          ] p
    ) 
    else
    ( Refine `dependent_pairEquality2` 
          [infer_level_exp_arg p T] p
    ) 
  )
  if opid = `decide` then 
    ( let [(),a; [x],(); [y],()] = bterms_of_term t in
      let using_term = local_get_using_type p a in
      let z,over_term = get_over_pair t T in
      let new_var_args = mk_new_var_args [[x];[y];[]] p in

      Refine `decideEquality`
             ( mk_bterm_arg [z] over_term
               . mk_term_arg using_term
               . new_var_args
             )
             p
    )

  if opid = `spread` then
    ( let [(),a; [x;y],()] = bterms_of_term t in
      let using_term = local_get_using_type p a in
      let z,over_term = get_over_pair t T in
      let new_var_args = mk_new_var_args [[x];[y];[]] p in

      Refine `spreadEquality`
             ( mk_bterm_arg [z] over_term
               . mk_term_arg using_term
               . new_var_args
             )
             p
    )

% This case is different from the V3 case, Although hopefully not in an 
  essential way. Changes:
  1. We leave Cumulativity reasoning to the Inclusion tactic.
  2. We assume Inclusion will deal with case when arithmetic simplification 
     (+ head normalisation?) will make T and T' equal.
  3. We do so application expansions in the ApEqUsing tactic rather than
     leaving that task to Inclusion.
%

  if opid = `apply` then
   (  let f,a = dest_apply t  in

     (let F = local_get_using_type p f in
      let g,x,A,T'' =
	  if is_function_term F then
	      null_var, dest_function F
          else if is_rfunction_term F then
	      dest_rfunction F
          else failwith `PrimEqCD: not a function type`

      in
      let T' = if is_null_var x then T'' 
               else quasi_so_subst [x,a; g,f] T'' in
      if alpha_equal_terms T' T then 

        SOApEqCDUsing F p 

      else  
        
      ( Assert (mk_equal_term T' t t')
        THENL
        [SOApEqCDUsing F
        ;OnLastHyp Inclusion
        ]
      ) p
     ) 

% Q.Does this next option ever help in practice?? Has been
    noticed to cause EqCD to be done when it shouldn't.
  A.Yes it does sometimes . With curried polymorphic functions, type 
    inference on function fails, yet 

    However none of these are used yet in any v4 theories, so leave as is.
%

%     ?
     (SOApEqCDUsing (mk_function_term null_var (get_type p a) T) p)
%
   )
  if opid = `atom_eq` then 

    ( Refine `atom_eqEquality` [mk_var_arg (new_invisible_var p)] 
      THENL
      [Id
      ;Id
      ;Id
      ;OnLastHyp (\i. FoldAtAddr `false` [2] i THEN FoldTop `implies` i THEN
                      FoldTop `not` i)
      ] 
    ) p

  if opid = `int_eq` then 
    ( Refine `int_eqEquality` [mk_var_arg (new_invisible_var p)] 
      THENL
      [Id
      ;Id
      ;Id
      ;OnLastHyp (\i. FoldAtAddr `false` [2] i THEN FoldTop `implies` i THEN
                      FoldTop `not` i)
      ] 
    ) p

  if opid = `less` then 
    ( Refine `lessEquality` [mk_var_arg (new_invisible_var p)] 
      THENL
      [Id
      ;Id
      ;Id
      ;OnLastHyp (\i. FoldAtAddr `false` [2] i THEN FoldTop `implies` i THEN
                      FoldTop `not` i)
      ] 
    ) p
  
  if opid = `list_ind` then
    ( let [(),u;();[h;t';v],()] = bterms_of_term t in

      % only do non recursive case here %

      if not v = null_var then failwith `PrimEqCD` else
      let using_term = local_get_using_type p u in
      let z,over_term = get_over_pair t T in

      Refine  `list_indEquality` 
              ( mk_bterm_arg [z] over_term
                . mk_term_arg using_term
                . mk_new_var_args [[h];[t'];[v]] p 
              )
              p
    )
  if opid = `void` then Refine `voidEquality` [] p

% no object rules in current library  %
%
  if opid = `object` then Refine `objectEquality` [] p
%

  if opid = `atom` then Refine `atomEquality` [] p

  if opid = `int` then Refine `intEquality` [] p

  if opid = `less_than` then Refine `less_thanEquality` [] p

  if opid = `universe` then Refine `universeEquality` [] p

  if opid = `list` then Refine `listEquality` [] p

  if opid = `equal` then Refine `equalityEquality` [] p

  if opid = `function` then
    ( let x = fst (dest_function t) in
      let new_var_args = mk_new_var_args [[x]] p in
 
      Refine `functionEquality` new_var_args
    ) p

  if opid = `sqequal` then
      (let SQType p =
	   % This tactic is only used here; it does not fail gracefully %
	   let goal = concl p in
           let opname, [type] = dest_simple_term goal in
	   let typename, () = operator_of_term type in
	       (if opname = `sq_type` then
		    Refine `lemma` [mk_tok_arg (typename ^ `_sq`)]
		else
		    Fail) p
       in
	   Refine `sqequalIntensionalEquality` [] THEN Try SQType) p

  if opid = `rfunction` then
    ( let f, x, (), () = dest_rfunction t in
      let (u.v.rest) =
	  mk_new_var_args
	      [[get_var_arg `v2` p ? `u'];
	       [get_var_arg `v3` p ? `v'];
	       [f];
	       [x];
	       [get_var_arg `v1` p ? `z']]
	      p
      in
      let R = get_term_arg `t1` p ? failwith `PrimEqCD: need relation for rfunction: use With` in
	  Refine `rfunctionEquality` (u . v . mk_term_arg R . rest)
    ) p

  if opid = `isect` then
    ( let x = fst (dest_isect t) in
      let new_var_args = mk_new_var_args [[x]] p in
 
      Refine `isectEquality` new_var_args
    ) p

  if opid = `product` then
    ( let x = fst (dest_product t) in
      let new_var_args = mk_new_var_args [[x]] p in
 
      Refine `productEquality` new_var_args
      THENL
      [Id
      ;If (\p.is_null_var x) (OnLastHyp Thin) Id
      ]
    ) p

  if opid = `set` then
    ( let x = fst (dest_set t) in
      let x' = fst (dest_set t') in
 
      Refine `setEquality` (mk_new_var_args [[x;x']] p) 
      THENL
      [Id
      ;If (\p.is_null_var x & is_null_var x') (OnLastHyp Thin) Id
      ]
    ) p

  if opid = `union` then Refine `unionEquality` [] p

  if opid = `quotient` then
    ( let [();[x;y],()] = bterms_of_term t in

      Refine `quotientWeakEquality` 
             (mk_new_var_args [[x];[y];[x];[];[]] p)
    ) p

  if opid = `rec` then
  ( let z,T = dest_rec (first_equand (concl p))
    in
      Refine `recEquality`
         (mk_new_var_args [[get_optional_var_arg `v1` p;z]] p)
  ) p

  if opid = `msubtype` then Refine `msubtypeEquality` [] p

  else failwith `PrimEqCD`
  )
  THEN_OnEach 
   (\p.let n = length p in
       let m = length (bterms_of_term t) in
       if n < m then
         map (AddHiddenLabelAndNumber `subterm`) (upto 1 n)
       else
         map (AddHiddenLabelAndNumber `subterm`) (upto 1 m)
         @
         replicate 
           (IfLab `inclusion?` Id (AddHiddenLabel `eq aux`)) 
           (n - m)
   )
 ) p

;;


let RecPrimEqCD p =
  let local_get_using_type p t = 
    get_term_arg `t1` p ? get_using_type p t
  in
  let T,t,t' = dest_equal (concl p)  in
  let opid = opid_of_term t in
  
  if not opid = opid_of_term t' then
    failwith `PrimEqCD: outermost constructors do not match`
  else

 ((\p.

  if opid = `ind` then
  ( let z,over_t = get_over_pair t T in
    let [();[m;x],();();[n;y],()] = bterms_of_term t in

    Refine `indEquality` ( mk_bterm_arg [z] over_t
                         . mk_new_var_args [[n;m];[y;x];[]] p)
                          p
  )

  if opid = `list_ind` then
    ( let [(),u;();[h;t';v],()] = bterms_of_term t in
      let using_term = local_get_using_type p u in
      let z,over_term = get_over_pair t T in

      Refine  `list_indEquality` 
              ( mk_bterm_arg [z] over_term
                . mk_term_arg using_term
                . mk_new_var_args [[h];[t'];[v]] p 
              )
              p
    )

% rec type and rec_ind recursive form not yet in rule set %
%
  if opid = `rec` then
     Refine `RecEquality` [] p

  if opid = `rec_ind` then 
    ( let using = get_type p (fst (dest_rec_ind t))  in 
      let ids = map (undeclared_id p) [`P`; `x`; `h`; `z`] in
      RecIndIOverUsingNew over_id over_term using ids
    ) p

%
  else failwith `RecPrimEqCD`
  )
  THEN_OnFirstL 
   (map 
     (AddHiddenLabelAndNumber `subterm`)
     (upto 1 (length (bterms_of_term t)))
   )
 ) p

;;





let extend_using_types_for_repeated_ap t function_type =

  let ().args = dest_iterated_apply t in
  if null args then fail else

  % build using types inside out %

  letrec build_using_types remaining_args =
    if null remaining_args then [function_type]
    else let h_arg.tl_args = remaining_args in
         let l = build_using_types tl_args  in
         let x,A,B = dest_function (hd l) in
         if is_null_var x then
           B.l
         if not is_function_term A then
           fo_subst [x,h_arg] B . l
         else
           subst [x,h_arg] B . l
  in
    build_using_types (tl (rev args))
;;

%  
RepeatSOApEqCDUsing
~~~~~~~~~~~~~~~~
Here we assume conclusion is of form:

|- f a1 a2 ... an = g b1 b2 ... bn in B

and we know f and g have type x1:A1 -> x2:A2 -> ... -> xn:An -> B

BY RepeatSOApEqDUsing x1:A1 -> x2:A2 -> ... -> xn:An -> B

Uses the types

                        (xn:An -> B)[a1 ... an-1/x1 ... xn-1]
                         .
                         .
                         .
        (x2:A2 -> ... -> xn:An -> B)[a1/x1]
x1:A1 -> x2:A2 -> ... -> xn:An -> B

with repeated applications of the applyEquality rule to end up with
the following subgoals.

|- f = g in x1:A1 -> x2:A2 -> ... -> xn:An -> B

|- a1 = b1 in A1

    .
    .
    .

|- an = bn in An[a1...an-1/x1...xn-1]

Proper so substitution is used if necessary.
%


let RepeatSOApEqCDUsing using_type p = 
  
  letrec Aux using_types p =
    if null using_types then Id p
    else 
      ( SOApEqCDUsing (hd using_types)
        THENL [Aux (tl using_types); Id]
      ) p   
  in
    Aux 
      (extend_using_types_for_repeated_ap 
          (first_equand (concl p)) 
           using_type
      ) p
;;



let RepeatSOApEqCD p =
  RepeatSOApEqCDUsing
    ((get_using_type p o head_of_application o first_equand o concl) p) 
    p
;;

let LemmaWitnessEqCD p =
 (let c = concl p
  in let T,a,b = dest_equal c
  in 
  if alpha_equal_terms a b & is_extract_term a then
  ( let lemma_oid, les = dest_extract_with_extra_le a in
    let lemma_name = name_of_lemma lemma_oid 
    in let lemma_term = raw_main_goal_of_theorem lemma_name
    in let lemma_le_vars = level_vars lemma_term
    in let lemma_extract = 
         mk_extract_term lemma_oid (map mk_var_level_exp lemma_le_vars)
    in let ext_typing = mk_equal_term lemma_term lemma_extract lemma_extract

    in let lemma_extract_le_vars = 
         default_le_var_in_extract_terms . lemma_le_vars
    in let parm_sub = zip lemma_extract_le_vars (map mk_level_exp_parm les)
    in let term_sub = parm_sub_to_term_sub parm_sub
    in let inst_lemma_term = full_subst term_sub lemma_term
    in let inst_ext_typing = mk_equal_term inst_lemma_term a a
    in
      OnAllHyps Thin
      THEN 
      Assert inst_ext_typing
      THEN IfLabL
      [`assertion`,
         Refine `instantiate` 
              [mk_assumption_list_arg []
              ;mk_term_arg ext_typing
              ;mk_parm_sub_arg parm_sub
              ]
        THEN Refine `extract` [mk_tok_arg lemma_name]
      ;`main`,
          Inclusion (-1)
      ]
  ) p
  else
    failwith `LemmaWitnessEqCD: not term_of equands`
 )      
;;

%[
****************************************************************************
Functions for working on hypothesis equality terms.
****************************************************************************
These complement the above functions.
]%


% ctl = [] give both super type and property, and thin original.
  ctl = [1] give only super type
  ctl = [2] give only property
%

let BasicSetEqTypeHD ctl i p =
  let i' = get_pos_hyp_num i p in
  let T,a,b = dest_equal (h i' p) in
  let T_opid = opid_of_term T in
  if T_opid = `set` then
  ( let x,A,B = dest_set T in
    let x' = maybe_new_proof_var x p in
    let B' = fo_subst [x,mk_var_term x'] B in
    SeqOnM
    [
      (if ctl = [] or member 2 ctl then

        %  ...#i: a = b in {y:A|B[y]} ... >> C %

         ApFunToHypEquands x' axiom_term (mk_squash_term B') i'

    % `fun wf`...#i: a = b in {y:A|B[y]}...x:{y:A|B[y]} 
                                                 >> axiom = axiom in Sq(B[x])  
        `wf`: ...#i: a = b in {y:A|B[y]} ...  >> {y:A|B[y]}={y:A|B[y]} in U17 
      `main`: ...#i: a = b in {y:A|B[y]} ... axiom = axiom in  Sq(B[a]) >> C %

         THEN IfLabL
         [`fun wf`, BasicSetHD (-1) THEN SquashEqTypeCD THEN NthHyp (-1)
         ;`wf`, Id
         ;`main`, SquashEqTypeHD (-1) THEN MoveToHyp (i'+1) (-1)
         ]
       else
          AddHiddenLabel `main`
      )
    ;
      (if ctl = [] or member 1 ctl then
         ApFunToHypEquands x' (mk_var_term x') A i'
         THENM MoveToHyp (i'+1) (-1)
       else
          AddHiddenLabel `main`
      )
    ;
       if ctl = [] or ctl = [1;2] then
         Thin i'
       else
         Id
    ]
  ) p
  else
    failwith `BasicSetEqTypeHD`
;;

let BasicAbSetEqTypeHD ctl i =
  Repeat (UnfoldAtAddr [1] i) THEN BasicSetEqTypeHD ctl i
;;

let PairEqHD ctl i p =
  let i' = get_pos_hyp_num i p in
  let T,a,b = dest_equal (h i' p) in
  let T_opid = opid_of_term T in
  if T_opid = `product` then
  ( let x,A,B = dest_product T in
    let xv = if x = null_var then tok_to_var `pp` else x in
    let x' = maybe_new_proof_var xv p in
    let xp_tm = mk_var_term x' in
    let B' = fo_subst [x, mk_simple_term `pi1` [xp_tm]] B in
    SeqOnM
    [
      (if ctl = [] or member 2 ctl then
         ApFunToHypEquands x' (mk_simple_term `pi2` [xp_tm]) B' i'    
         THENM (Try (ReduceEquands (-1)) THEN MoveToHyp (i'+1) (-1))
       else
          AddHiddenLabel `main`
      )
    ;
      (if ctl = [] or member 1 ctl then
         ApFunToHypEquands x' (mk_simple_term `pi1`  [xp_tm]) A i'
         THENM (Try (ReduceEquands (-1)) THEN MoveToHyp (i'+1) (-1))
       else
          AddHiddenLabel `main`
      )
    ;
       if (ctl = [] or ctl = [1;2])
          & (not (get_tok_arg `thinning` p = `no`) ? true) 
       then
         Thin i'
       else
         Id
    ]
  ) p
  else
    failwith `PairEqHD`
;;

%
EqHDWithApArg
~~~~~~~~~~~~~
This mirrors effect of FunHD with argument supplied.


...,   i. f = g in x:A->B[x], ... |- C
  
  BY With t (EqHDWithApArg i) 

`main` ...,   i. f = g in x:A->B[x], ...,f t = g t in B[t] |- C
`wf`   ...,   i. f = g in x:A->B[x], ... |- t in A

Unless `no` thinning arg supplied, original hyp i is thinned.
%

let EqHDWithApArg i p = 
  let T,f,g = dest_equal (h i p)
  in let x,A,Bx = dest_function T
  in let t = get_term_arg `t1` p
  in let Bt = is_null_var x => Bx | subst [x,t] Bx
  in let thin = not (get_tok_arg `thinning` p = `no`) ? true
  in 
  ( Assert (mk_equal_term
              Bt
              (mk_apply_term f t)
              (mk_apply_term g t)
           )
    THEN IfLabL
    [`main`,thin => Thin i | Id
    ;`assertion`,
     % ... f = g in x:A->B[x] ... |- f t = g t in B[t] %
     With T PrimEqCD
     THENL [NthHyp i;AddHiddenLabel `wf`]
    ]
  ) p ? failwith `EqHDWithApArg`
;;


let PrimEqHD ctl i =
  First [PairEqHD ctl i;EqHDWithApArg i]
;;

let PrimEqTypeHD ctl i = 
  BasicSetEqTypeHD ctl i ;;

%
ApplyFunToHypEquands
~~~~~~~~~~~~~~~~~~~~
Generalization of ApFunToHypEquands in inclusion-tactics.

   ...#i: a = b in T ... >> C

    BY With (x:T'->S[x]) (ApplyFunToHypEquands f i) 

       `wf`: ...#i: a = b in T ... |- f in x:T -> S[x]
     `main`: ...#i: a = b in T ... f a = f b in S[a] |- C

If With arg omitted, type inference is done on f to get plausible type.
%

let ApplyFunToHypEquands f i p =

  let T,a,b = dest_equal (h i p) in
  let F = get_term_arg `t1` p ? get_using_type p f in
  let name,g,x,T',S =
      if is_function_term F then
	  `applyEquality`, null_var, dest_function F
      else if is_rfunction_term F then
	  `rfunction_applyEquality`, dest_rfunction F
      else
	  failwith `ApplyFunToHypEquands: not a function`
  in
  let S_of_a = fo_subst [x,a; g,f] S in

  %...#i: a = b in T ... >> C  %

 (Assert (mk_equal_term S_of_a (mk_apply_term f a) (mk_apply_term f b))
  THEN IfLabL
  [`assertion`,
   %...#i: a = b in T ... >> f a = f b in S[a]  %

   Refine name [mk_term_arg F]

   THENL
   [%...#i: a = b in T ... >> f = f in (x:T' -> S[x])  %
    AddHiddenLabel `wf`
   ;
    %...#i: a = b in T ... >> a = b in T' %
    NthHyp i ORELSE Inclusion i
   ]
  ;`main`,Id
  %...#i: a = b in T ... f a = f b in S[a] >> C  %
  ]
 ) p
;;

