%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
*********************************************************************
*********************************************************************
CLASSICAL-TACTICS.ML
*********************************************************************
**********************************************************************
Two things in here:

1. Tactics which assume an excluded middle theorem is inhabited
   by various oracles. This is a rough and ready approach.

2. Tactics which assume Squash(All P{i}. P or not P} being inhabited
   This approach is preferable; it never introduces oracles, and
   allows easy labelling of `classical proofs with xmiddle antecedent.
]%

%
excluded_middle: All Pi P or not P

 is lemma in library for these tactics to work.
%

% Could make this more efficient %  

let ClassUnhideHyp i p =
 (UnhideSqStableHyp1 i
  THEN IfLab `sq stable`
       (SeqOnM
        [BackThruLemma `sq_stable__from_stable`
        ;BackThruLemma `stable__from_decidable`
        ;Unfold `decidable` 0 THEN BackThruLemma `excluded_middle`
        ]
       )
       Id
 ) p
;;

let ClassAbSetHD i p = 
  let i' = get_pos_hyp_num i p
  in
  ( Repeat (UnfoldTopAb i')
    THEN BasicSetHD i'
    THEN (TrivializeConcl ORELSE ClassUnhideHyp (i'+1))
  ) p
;;

  

let ClassDecide P p =
 (Assert (mk_simple_term `decidable` [P]) 
  THEN
  IfLabL
  [`assertion`,Fiat
  ;`main`,OnHyp (-1) D 
   THENL [AddHiddenLabel `truecase`;AddHiddenLabel `falsecase`]
  ]
 ) p
;;

let DoubleNeg p =
 (Assert (mk_not_term (mk_not_term (concl p)))
  THEN IfLab `main` Id Fiat
 ) p
;;
% Belongs elsewhere, but put here for now %

let TypeCheck p = Auto p
;;

let ClassDNegHD i p = 
  let i' = get_pos_hyp_num i p
  in let Q = dest_not (dest_not (h i' p))
  in
  ( AssertAtHyp i' Q
    THEN IfLab `main` (Thin (i'+1)) (Fiat)
  ) p
;;



%[
*********************************************************************
A Decision Procedure for Classical Propositional Logic
**********************************************************************
This will not execute properly unless the class_prop theory is loaded.
]%


let ClassPropHD i 
  =
  First
    [IfThenOnHyp is_or_term D i
    ;FwdThruLemma `neg_or_elim` [i] THENM Thin i
    ;IfThenOnHyp is_and_term D i
    ;FwdThruLemma `neg_and_elim` [i] THENM Thin i
    ;FwdThruLemma `imp_elim` [i] THENM Thin i
    ;FwdThruLemma `neg_imp_elim` [i] THENM Thin i
    ;FwdThruLemma `dneg_elim` [i] THENM Thin i
    ]
;;

let ClassProveProp p = 
 (BackThruLemma `dneg_elim`
  THENM D 0
  THENM (RepeatM (OnSomeHyp ClassPropHD ORELSE Contradiction)) 
 ) p
;;

%[
*********************************************************************
A Useful Tactic for Propositional Logic
**********************************************************************
This will take care of trying to blow away OR's in concl as much as poss.

However, it isn't complete.

Strategy: Repeat On each step
 0) Hypothesis
 i) CD on `implies'`rev_implies' `not' HD on `and'
 ii) CD on `and',`iff' HD on `or'
 iii) Try Sel 1 CD or Sel 2 CD on concl or's. 
      On either must complete all main goals for step to succeed.
      If none succeed, then Add special label.

Main tactic fails if sees special labels.
However, aux version leaves these for user to contemplate.

Performance improvements:
1. OR branch search not using tactics?  
2. Faster case split. 

Scope improvement
1. Follow classical reasoning style. Introduce
  instances of decidable propositions as and when necessary.
2. Try (Dyber's?) set of rules for intuitionistic proof where
   termination guaranteed.
]%

letrec ProvePropAux T complete p = 
 ((First
    [Hypothesis
    ;OnSomeHyp (IfThenOnHyp is_and_term D) 
    ;IfThenOnConcl (is_terms ``implies rev_implies not``) (D 0)
    ;OnSomeHyp (IfThenOnHyp (is_term `or`) D) 
    ;IfThenOnConcl (is_terms ``and iff``) (D 0)
    ] THENM ProvePropAux T complete
  )
  ORELSE
  IfThenOnConcl is_or_term
   (First 
     [OrCD 1 THENM ProvePropAux T true
     ;OrCD 2 THENM ProvePropAux T true
     ]
   )
  ORELSE
  OnSomeHyp 
    (IfThenOnHyp (is_terms ``not implies rev_implies``) 
                 (\i.D i THEN ProvePropAux T true)
    )
  ORELSE    
  T THENM ProvePropAux T complete
  ORELSE
  If (\p.complete) 
     Fail (AddHiddenLabel `ProveProp1: unproved goal`)

 ) p
;;

let ProveProp1 p = Progress (ProvePropAux Fail false) p;;

let ProvePropWith T p = Progress (ProvePropAux T false) p;;

let ProveProp p = 
  (ProveProp1 THEN IfLabL 
   [`ProveProp1: unproved goal`,FailWith `ProveProp`]
  ) p
;;





