%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
*********************************************************************
*********************************************************************
COMMANDS.ML
**********************************************************************
**********************************************************************
the ML functions here invoke the various commands of Nuprl's P> mode.

Summary:

Arguments:
  <*obname> : name of object, enclosed in backquotes.
  <place>   : name of object, enclosed in backquotes
              (operation is carried out at position before this object)
              `last` can be used to refer to fictitious object after last
              object in library.
  <n>       : # of lines Always +.
  <i>       : # of pages + or -.
  <>        : Argument of type unit, entered as ().

Lib Window
----------
jump <obname>
up  <n>
down <n>
top <>
bottom <>
page <i>

Objects
-------
create_rule <obname> <place> 
create_thm  <obname> <place>
create_abs  <obname> <place>
create_ml   <obname> <place>
create_disp <obname> <place>
create_com  <obname> <place>
create_lat  <obname> <place>

rename <old-obname> <new-obname>
delete <obname>
check  <obname>
move   <obname> <place>
view   <obname>

check_objects <obname1> <obname2>
move_objects <obname1> <obname2> <obname3>

Theory based
------------
See theory.ml

Misc
----
exit <>


IDEAS FOR ADDITIONS:

copy_object oldname newname:
  
  adds copy called newname right after oldname


]%


%[
*****************************************************************************
Aux functions
*****************************************************************************
]%

%
 "+<name>" yields "after <name>"
 "-<name>" yields "before <name>"
 "<name>" yields "before <name>"
%

let mk_lib_place_string place = 
  let h.t = string_to_toks place
  in
  if h = `+` then
    "after " J toks_to_string t
  if h = `-` then
    "before " J toks_to_string t
  else
    "before " J place
;;



%[
*****************************************************************************
Object Manipulation
*****************************************************************************
]%

% Always inserts object before "place". (optionally "last" can be used instead
of an object name%

%
let create_object_nr name kind place = 
  mlbreak `create`; fail
    
;;

let create_object n k p = create_object_nr n k p ;;
let create n k p = create_object n k p;;

let create_object_after name kind place = 
  mlbreak `create`; fail
;;

let create_rule name = create_object name "rule" ;;
let create_thm name = create_object name  "thm" ;;
let create_ab  name = create_object name  "abs" ;;
let create_abs  name = create_object name  "abs" ;;
let create_ml  name = create_object name   "ml" ;;
let create_disp name = create_object name "disp" ;;
let create_com name = create_object name  "com" ;;
let create_lat name = create_object name  "lat" ;;


%
% checks sequentially a range of objects, stopping at objects, whose
status changes upon checking.%
%
let delete_nr obname = 
 mlbreak `create`; fail
;;

let delete ob = delete_nr ob  ;;

let check_object_nr obname = 
  ()
;;
let check_object ob = check_object_nr ob ;;
let check = check_object ;;
%
