%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
**********************************************************************
**********************************************************************
COMPUTE-AUX2.ML
**********************************************************************
**********************************************************************

]%

%[
**********************************************************************
term computation functions
**********************************************************************
]%

let do_computations = do_indicated_computations ;;

let normalize_wrt tagger = repeatf (do_computations o tagger) ;;

let reduce_term  = normalize_wrt tag_all_prim_redices ;;

let beta_reduce_term = normalize_wrt tag_all_beta_redices ;;

let unfold_ab t =
  do_computations (tag_any_ab_for_unfold t)
  ? failwith `unfold_ab`
;;

let unfolds_top names t = 
  do_computations (tag_abs_for_unfold names t)
  ? failwith `unfolds`
;;

let unfolds names t = 
  do_computations (tag_all_abs_for_unfold names t)
  ? failwith `unfolds`
;;

  