%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%
****************************************************************************
****************************************************************************
LIB.ML
****************************************************************************
****************************************************************************
Library access functions.
%

% Here we preappend quantifiers for the level variables to the theorem term. %

let raw_main_goal_of_theorem = goal_of_statement ;;

let goal t = goal_of_statement (string_to_tok t) ;;

let main_goal_of_theorem_aux t =
    mk_iterated_all
      (map (\v.tok_to_var v, level_exp_type) (level_vars t))
      t
;;

let main_goal_of_theorem name =
 main_goal_of_theorem_aux (goal_of_statement name)
;;

let main_goal_of_theorem_o oid =
 main_goal_of_theorem_aux (statement_lookup oid)
;;

letrec strip_le_quants fmla = 
  (let x,T,fmla' = dest_all fmla
   in if T = level_exp_type then
     strip_le_quants fmla'
   else
     fail
  ) ? fmla
;;


% object_lookup does not find all objects
let is_lib_member name = can (\n. object_lookup n) name ;; 
%

% let is_lib_member name = is_library_member name ;; %
% let names_of_lib_objects_with_prefix = library_with_prefix ;; %

% let library_with_prefixes prefixes =
  flatten
  (map
     library_with_prefix
     prefixes
  )
;; %

% let libfind str = filter (is_substring str o tok_to_string) (library ())
;; %


%
****************************************************************************
Functions for analysing lists of library objects.
****************************************************************************
%

% let filter_lib_by_kind kind lib = 
  filter (\x.kind_of_object x = kind) lib
;; %

% get segment from a to b inclusive %

% let lib_segment a b =
  let lib = library () in
  let from = find_position a lib ? failwith `lib_segment: bad start name` in
  let to = find_position b lib ? failwith `lib_segment: bad end name` in
    nthtl (from - 1) (firstn to lib) 
;; %


% Versions of above, working with strings. %

% let list_lib (():unit) = map tok_to_string (library ()) ;; %
% let list_lib_seg a b = 
  map tok_to_string (lib_segment (string_to_tok a) (string_to_tok b))
;; %

letref object_kind_alist = 
  ["thm",`THM`
  ;"ab",`ABS`
  ;"disp",`DISP`
  ;"ml",`ML`
  ;"lat",`LAT`
  ;"rule",`RULE`
  ;"com",`COM`
  ]
;;

% use this explicitly with filter function %

% let is_object kind ob = 
  apply_alist object_kind_alist kind = (kind_of_object (string_to_tok ob)) 
  ? false
;; %

% let lib_list_match str = 
  filter (is_substring str) (list_lib ())
;; %

let set_term_of_object obname t = 
  t
;;
% let term_of_object obname = object_body_to_term (string_to_tok obname) ;; %
% let set_term_of_object obname t = 
  term_to_object_body t (string_to_tok obname) ;; %
 
%
****************************************************************************
Controlling library object visibility
****************************************************************************
make_object_invisible
make_object_visible
invisible_object_p
%

% let hide_object obj = make_object_invisible (string_to_tok obj) ;; 
let unhide_object obj = make_object_visible (string_to_tok obj) ;; 
let is_hidden_object obj = invisible_object_p (string_to_tok obj) ;; %


% let hide_lib (():unit) = map (hide_object o tok_to_string ) (library ()) ; ();;
let unhide_lib (():unit) = map (unhide_object o tok_to_string ) (library ()) ; ();; %

%
let hide_wfcombs (():unit) = 
  do map make_object_invisible (library_with_prefix `comb_for`) ;;
let unhide_wfcombs (():unit) = 
  do map make_object_visible (library_with_prefix `comb_for`) ;;
%
