%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%
****************************************************************************
****************************************************************************
MATCH EXTENSION 
****************************************************************************
****************************************************************************
%

%
Pattern is formula:

All x1:A1 ... xn:An, Bs => C

pattern might have free variables.

We have binding for xi, call it ai. 
The environment of ai is e. (includes bindings for all free vars, and
assumptions.)


We also have a set of bindings sub for a subset of x1..xi-1. We try
with this function to infer some of the missing bindings in sub, and
collect level expression disagreement pairs.

Important to check that new bindings are all compatible with existing 
bindings.
%

letrec infer_bindings_from_typing
       type_match_fun
       (type_inf_fun : env -> term -> term)
       (le_vs : tok list) % level exp vars in pattern %
       xs    % x1...xi=1 %
       sub   % bindings for subset of xs %
       A     % Ai %
       e     % environment in which match takes place. %
       a     % binding for xi %
  =
  let a' = if is_term `so_lambda` a then (unfold_soft_ab a) else a in
  let missing_xs = diff xs (map fst sub) in
  if is_term `lambda` a' then
  ( let x,P,Q = (dest_function A ? failwith `infer_bindings_from_typing: 1`) in
    if not is_null_var x then failwith `infer_bindings_from_typing: 2` 
    if not null (level_vars P) then failwith `infer_bindings_from_typing: 3`
    if not subset (free_vars P) xs then 
      failwith `infer_bindings_from_typing: 4`
    if null (level_vars Q) 
       & null (intersection (free_vars Q) missing_xs)
    then
      failwith `infer_bindings_from_typing: 5`
    else
    let x,t = dest_lambda a' in
      infer_bindings_from_typing
        type_match_fun
        type_inf_fun
        le_vs
        xs
        sub
        Q
        (extend_env e (x, subst sub P , false))
        t
  )
  if null (level_vars A) 
     & null (intersection (free_vars A) missing_xs)
  then
    failwith `infer_bindings_from_typing: 6`
  else
  let AInst = type_inf_fun e a in

  % NB: 1. all the types in a context have -ve polarity.
        2. We choose to soft match pat and inst. %


  let parm_dset,sub' = type_match_fun (-1) le_vs xs A AInst in
  let new_sub,duplicate_sub = 
    divide_list
      (\y,t.member y missing_xs)
      (filter is_term_binding sub') % strip out bvar bindings %
  in

  % fail if match contains duplicates bound to different values%

% if all
       (\y,t.t = apply_alist sub y)  
       duplicate_sub
  then
%
    parm_dset,new_sub

% else 
    failwith `infer_bindings_from_typing: 7`
%
;;





%
Action of function:


   1. Separate input context into
      a: meta parm_vars  [p1;...;pk] (should all be level exp vars) 
      b: [x1,A1;...;xn,An] (the standard context)
   2. Work through [x1,A1;...;xn,An] context list right to left. 
      If at xi,Ai, and we already have binding for xi, and
        Either a: we are missing a binding for some x1...xi-1 which occurs 
                  in Ai, 
        Or     b: Ai contains a level expression.

      Then match Ai as a pattern against the inferred type of what xi is bound
      to. (use half_match... this does not match parameters. Rather it 
      just returns parameter disagreement triples.)
      We try fairly hard to get match. If Exact match fails we try
      unfolding top soft abs. If that fails we try unfolding all soft abs.
      (in last case we might end up with uglier match than we desire...)

      If match succeeds, we augment the current bindings by the new 
      bindings (if they are compatible), and add the new parameter disagreement
      triples to the parm dset.

   3. Return 
          a: parameter disagreement set.
      and b: extended bindings.
%

% A `full' context is one containing level expression variables. %

let dest_full_context x_A_prs =
  let level_exp_prs,x_A_prs' = divide_list (is_level_exp_type o snd) x_A_prs in
  let le_vars = map (var_to_tok o fst) level_exp_prs in
    le_vars,x_A_prs'
;;

let extend_match_using_context 
  type_match_fun type_inf_fun init_bindings x_A_prs env
  =
  let le_vars,x_A_prs' = dest_full_context x_A_prs in

  % set up context inside out of ...
    x : var
    A : term
    inl () OR inr a : unit | term
  %

  let x_A_sub_trips = 
    map
    (\x,A. x,A, (inr (apply_alist init_bindings x) ? inl ()))
    (rev x_A_prs)
  in

  letrec aux x_A_sub_trips' parm_dset sub =
    if null x_A_sub_trips' then parm_dset,sub
    else
    let (x,A,maybe_sub) . rest = x_A_sub_trips' in
    if isl maybe_sub then
      aux rest parm_dset sub
    else
    let new_parm_dset,new_sub =
    (infer_bindings_from_typing
       type_match_fun
       type_inf_fun
       le_vars % level exp vars in pattern %
       (map fst rest)    % x1...xi=1 %
       (mapfilter (\x,A,sub.x,outr sub) rest) % bindings for subset of xs %
       A     % Ai %
       env   % environment in which match takes place. %
       (outr maybe_sub)     % binding for xi %
    ?
     [],[]
    )
    in   
      aux 
        (map 
          (\x,A,sub.x,A,inr (apply_alist new_sub x) ? x,A,sub)
          rest 
        )
        (new_parm_dset @ parm_dset) 
        (new_sub @ sub)
  in
    aux x_A_sub_trips [] init_bindings
;;



% 
NEEDS UPDATING:

match_in_context_with
  [x1,A1;...;xn,An] : (var # term) list
  half_matcher : tok list -> var list -> term -> term -> 
                    (parm # parm # int) list # (var # term) list
  pat_tm  : term
  inst_tm : term
  completing_bindings : (var # term) list
  env : env
  =
  sub : (var # term) list

1. match pat_tm against inst_tm using semi_matcher to get initial le parm 
   dset and initial set of binding variables.

2. Augment bindings by explicit term bindings in completing bindings. These
   term bindings override bindings generated by initial match.

3. If level exp in context type, or term bindings are not complete,
   then augment bindings, and get aux parm dset by using 
   extend_match_using_context
   
4. If user has provided complete set of bindings for le vars (either 
   with var names or with null_var names.) Use these for le_bindings in 
   result.
   If not, do le match on parm dset to get bindings for level expressions.
           If this match fails, include result in match-info.

5. If term bindings are still not complete, then try completing them using
   "wild" term bindings. ie. ones with null_vars.

6. If 5 fails to complete term bindings then set match info appropriately.

NB: completing bindings and the result bindings can include:
  1. bindings of term vars to term.
  2. bindings of higher order term vars to higher order terms. (with 
     so_lamdba)
  3. bindings of level exp vars to level expressions.
     These bindings are encoded using:
     (tok_to_var # mk_lp_term `parameter`) : (tok # level_exp) -> (var # term)



We abstract out the matcher for several reasons.

1. Polarities of pat and inst term will vary. (Consider matching
hyps in FwdThruFmla and concl in BackThruFmla)

2. Want to allow `part soft' matches. 
     E.g. in wf lemma usage:
   pat =  s in S
   inst = t in T

   we want to do a hard match of s and t, but soft match of S and T.
   Polarities vary here too.

We abstract out the type inference function, since that function is defined
later and makes use of match_in_context_with...

%

% records pattern of match and list of variables needed to complete bindings. %

letref match_info = ([],void_term) :(var list # term) ;;

letref match_arg_info = 
  ([]
   ,void_term
   ,void_term
   ,[]
   ,null_env
  )
  :
  (var # term) list
  # term 
  # * 
  # (var # term) list 
  # env 
;;
   
let match_in_context_with_ti_and_ms type_match_fun type_inf_fun x_A_prs  =

  let le_vars,x_A_prs' = dest_full_context x_A_prs in  
  let xs = map fst x_A_prs' in
  let num_vars = length xs in
  let le_var_in_context_types =
    exists (\(),A.not null (level_vars A)) x_A_prs'
  in
    \matcher pat_tm inst_tm completing_bindings env. 
%
debug code:
%
        match_arg_info := x_A_prs,pat_tm,inst_tm,completing_bindings,env
        ;
        let prelim_parm_dset,preprelim_bindings = 
             matcher le_vars xs pat_tm inst_tm 
        in
        let prelim_bindings,bvar_bindings =
          divide_list
          (\v,t.sub_kind_of_term t = `regular`)
          preprelim_bindings
        in
        let completing_parm_bindings, completing_term_bindings =
             divide_list (is_term `parameter` o snd) completing_bindings 
        in
        let wild_completing_bindings, definite_completing_bindings =
             divide_list (is_null_var o fst) completing_term_bindings 
        in 
        let completed_prelim_bindings =
          priority_merge_alists 
            definite_completing_bindings 
            prelim_bindings
        in
        let parm_dset_from_context,extended_bindings = 
         (if (le_var_in_context_types & null completing_parm_bindings)
             or
             length completed_prelim_bindings 
             + length wild_completing_bindings
             < num_vars 
          then
            extend_match_using_context 
              type_match_fun
              type_inf_fun
              completed_prelim_bindings
              x_A_prs 
              env
          else
              [],completed_prelim_bindings
         ) 
        in
        let parm_bindings =
        ( % if null parm_dset_from_context & null prelim_parm_dset then
             [] %
          if not (null completing_parm_bindings) then
          (let completing_parm_vars = map fst completing_parm_bindings in
           if exists is_null_var completing_parm_vars then
            (zip (map tok_to_var le_vars) (map snd completing_parm_bindings)
             ?
             failwith 
               `match_in_context_with: wrong number of explicit level exp bindings`
            )
           if subset (map tok_to_var le_vars) completing_parm_vars then
             completing_parm_bindings
           else
             failwith 
               `match_in_context_with: need explicit bindings for all level vars`
          )
          else
          ( parm_sub_to_term_sub
              (match_parm_dset (parm_dset_from_context @ prelim_parm_dset))
            ?
            failwith `match_in_context_with: level exp match failed; supply explicit bindings`
          )
        )
        in
        % bindings here do not include variables. These are zipped on at 
          end %

        %   < result list ..>  <..       carry output                   ..> %

        let complete_bindings,(excess_completing_terms,vars_with_no_bindings) =
          ( map_with_carry 
             (\x (completing_tms, unbound_vars).
                apply_alist extended_bindings x
                , (completing_tms, unbound_vars)
                ? 
                hd completing_tms 
                , (tl completing_tms , unbound_vars)
                ?
                (void_term)
                , ([], x.unbound_vars)
             )
             %<..  carry input                 ..>%
             (map snd wild_completing_bindings, []) 
             %<input list>%
             xs 
          )
        in
        if not null excess_completing_terms then
          failwith `match_in_context_with: too many completing term bindings`
        if null vars_with_no_bindings then
          parm_bindings @ zip xs complete_bindings @ bvar_bindings
        else
        ( match_info := vars_with_no_bindings,pat_tm
          ; failwith `match_in_context_with: could not find complete match... see match_info`
        )
;;


%
NB: At end of type-inf.ml, we provide the closures for normal use of 
match_in_context...
%


