
% 
rel_rst_proc_input
~~~~~~~~~~~~~~~~~~~~~
Input:  e  (env)
        ts (known facts)
        c (concl)
Output: 
  list of info on relations in sequent.
  Each element of form:

   ps,r,i,v1,v2 
  where 
    ps: tok list - list of properties. see dest_known_rel_term 
     r: tok =  root relation name
     i:int  -  # of clause containing relation
     v1 v2:int - are numbers identifying the relation arguments
% 

let rel_rst_proc_input e ts c = 
  let cls =  ([0,dest_known_rel_term e true c] ? [])
                @ mapfilter (\i,t.i,dest_known_rel_term e false t) (number ts)
  in let tms = flatten (map (\(),(),(),a,b.[a;b]) cls)
  in let convert_tms (i,ps,rnam,a,b) = ps,rnam,i,term_position a tms,term_position b tms
  in 
    map convert_tms cls
;;



%
To remember:
1. if concl is in rchain, then must have been negated. Need to get it
into hyp list and make sure RSTJoinRels finds it.
2. If negated hyp is focus, then must be made conclusion (by ID to prevent
hyp #'s getting messed up) (however concl is already concl)
3. any reversed focus term must be put in regular sense before 
   doing strengthening.
4. After any chaining together of env, the solution technique is:

  Case 1 (a < b in env)
     chain cannot be empty (in a < a case, chain contains 1 element).
     Use irreflexivity lemma on result of chaining.
  Case 2
   Assume focus has been made concl.
   Focus is:
   a) (neg(a == b))
     if empty chain, then Strengthen concl to equality.
     o/w strengthen concl to result of chaining.
   b) (neg(a =< b))
     if empty chain, then Strengthen concl to equality.
     o/w strengthen concl to result of chaining.
   c) (neg(a < b))
     chain cannot be empty
     strengthen concl to result of chaining.

  Note 2a)b)c) all require compatible actions, so no need to distinguish
  between these cases.

  chaining always leaves result as last hyp
%

let NewRelReflSymTransAux2 f focus_r echain p = 
  let f_props,f_str,f_num,() = focus_r in
  let nconc = num_hyps p in
  let fix_edge (i,dir) = if i = 0 then nconc,dir else i,dir in

  let MaybeChain = 
    if null echain then Id else 
      let e = env_of_sequent p in
      let R,T = GeneralJoinRelChain e f (map fix_edge echain) in
    Assert R THENL [T; Id] 
  in
  let PostTac = 
     if not member `neg` f_props then
       IrreflHyp (-1)
     if null echain then
       StrengthenRel THENM (FoldTop `member` 0 THEN AddHiddenLabel `wf`)
     else
       StrengthenRelToHyp (-1) THENM NthHyp (-1)
  in
   (MaybeChain THENM PostTac) p
;;

let NewRelReflSymTransAux1 f sols p = 
  let focus_r = fst (hd sols) in
  let echains = map snd sols in
  let f_props,f_str,f_num,() = focus_r in
  let nconc = num_hyps p + 1 in
  let fix_edge (i,dir) = if i = 0 then nconc,dir else i,dir in

  let MaybeNegConclToHyp = 
    if member 0 (map fst (flatten echains)) then D 0 else AddHiddenLabel `main`
  in
  let MaybeNegHypToConcl = 
    if member `neg` f_props & not f_num = 0 then 
      let R,T = f f_num  in
      Assert R THENL [T ; D (-1)]
    else Id
  in
  let MaybeInvertFocusR = 
    if subset ``rev neg`` f_props then InvertRel 0 else Id
  in
  let MaybeSplitR = 
    if length echains = 2 then AntiSymConcl else Id
  in
    SeqOnM
     [MaybeNegConclToHyp
     ;MaybeNegHypToConcl
     ;MaybeInvertFocusR
     ;MaybeSplitR THENML (map (NewRelReflSymTransAux2 f focus_r) echains)
     ]
     p
;;

let NewRelReflSymTrans p = 
  let c = concl p in
  let e = env_of_sequent p in
  let ts = hs p in
  let rs = rel_rst_proc_input e ts c in
  let sols = rel_rst_find_solution rs  in
  let f i = nth i ts, NthHyp i in
    NewRelReflSymTransAux1 f sols p
;;



let NewRelRST p = NewRelReflSymTrans p ;;
