%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%
************************************************************************
New variable generation.
************************************************************************
Yet another version!

Recap:
See atomic-tactics.ml for a description of the current system of variables.

defined in sequent.ml
~~~~~~~~~~~~~~~~~~~~~
declared_vars p:proof = vs : var list
 
defined in primitives.ml
~~~~~~~~~~~~~~~~~~~~~~~~
bound_vars  t:term = vs : var list

%

% 
new_var old_v:var existing_vs:var list = new_v:var

Generate new variable, based on old_v, and disjoint from existing_vs.

If old_v is `v...` then new_v is v<n> where <n> is greater than any existing
index of v.

Invisible vars will always start with ($)percent. Do we want them to 
have general form $1 $2 ... ? 
%

%
let new_var old_v existing_vs =
  let root = (hd o explode o var_to_tok) old_v in
  let num x = number_suffixing_given_letter root (var_to_tok x) ? 0 in
  let index = max_value num existing_vs in
     tok_to_var (root ^ int_to_tok (index+1))
;;
%

let maybe_new_var old_v existing_vs =
  if member old_v existing_vs then
    new_var old_v existing_vs
  else
    old_v
;;

%
new temp var generation
%

letref indexed_ids = []: (tok # tok list) list ;;

let get_indexed_id_set id n =
  let existing_ids = apply_alist indexed_ids id ? [] 
  in
  firstn n existing_ids
  ?
  let len = length existing_ids 
  in 
  let augmented_ids = 
       existing_ids 
       @ map (\i.id ^ int_to_tok i)  
             (upto (len + 1) (n + 20))
  in
  (indexed_ids := update_alist indexed_ids id augmented_ids
   ;
   firstn n augmented_ids
  )
;;

let get_temp_vars n =
  map tok_to_var (get_indexed_id_set `#` n)
;;
