%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%


let mk_ml_update_object name term = 
 create_ml_obj_data
    (include_properties_term [`reference environment additions`, itoken_term `update`
			     ;`REDUCE`, itoken_term `ML`
			     ] term)
  name
;;



let create_pi_disp_content mname ab v prompt =
    let mk_pi_df_lhs v lhs_tm = 
	mk_df_format_list
	    [mk_df_slot_format
	         (tok_to_string (var_to_tok (dest_var (subterm_of_term lhs_tm 1))))
		 (tok_to_string prompt)
		 "E";
	     mk_text_term ("." J tok_to_string (var_to_tok v))]
    in
    mk_df_def_list 
        [mk_dform_def_term mname
	     (mk_pi_df_lhs v ab)
	     (mk_df_rhs_for_term ab)]
;;

let create_pi_disp_obj_data mname obname ab v prompt =
  create_disp_obj_data
    (create_pi_disp_content mname ab v prompt)
    obname
;;


let mk_func_def_term funcs funcbody =
 mk_text_seq `!text_cons`
  ( (itext_term ("let " J funcs J " = "))
  . newline_term
  . (itext_term "  ")
  . (funcbody @ [ itext_term ";;"])
  )
;;

let mk_defs_updates_content mnemonic defs upds =
 
 [ create_ml_obj_data defs (mnemonic J "_defs")
 ; create_ml_obj_data 
     (include_properties_term [`reference environment additions`, itoken_term `update`]
        upds)
     (mnemonic J "_updates")
 ]
;;

				   
let mk_tok_func_alist_term toks funcnames =
   mk_text_seq `!text_cons`
    (flatten
      [ [itext_term ("[ `" J (tok_to_string (hd toks)) J "`, " J (hd funcnames)); newline_term]
      ; flatten (map2 (\name s. [itext_term ("; `" J (tok_to_string name) J "`, " J s); newline_term]) (tl toks) (tl funcnames))
      ; [ itext_term "]"; newline_term ]
      ]) 
;;
