%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%
Rational Arithmetic Tactics.
%

let RatHD i p =
  let i' = get_pos_hyp_num i p in
  if not (is_term `rat` (h i' p)) then
    failwith `RatHD: hyp not a rational type`
  else
  let v = var_of_hyp i' p in
  let v_tm = mk_var_term v in
  let n = num_hyps p in
  let dep_clauses = 0 . (upto (i'+1) n) in
  let dep_clauses' = 0 . (upto (i'+2) (n+1)) 
  in
  ( OnClauses dep_clauses
    ( RW (TryC (HigherC (IfC (\e t. t = v_tm) (FoldTopC `guard`)))))
    THEN D i' 
    THEN
    OnClauses dep_clauses'
    ( RW (TryC (HigherC (UnfoldTopC `guard` ANDTHENC FoldTopC `qnum`))))
  ) p
;;
