%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
*****************************************************************************
*****************************************************************************
RECDEF.ML
*****************************************************************************
*****************************************************************************
Handling recursive definitions built using the Y combinator. 
]%

%[
Recursive definitions of form:

id{ps}(s1;...;sn) y1 ... ym  ==r g

are handled. Here:

  o id{ps}(...) is the new abstraction to be created.
  o s1,...,sn are each of form vsi.xi[vsi] where vsi is possibly empty.
  o x1,...,xn y1 ... ym are variables.  m,n >= 0
  o g contains free occurrences of xs and ys, and occurrences of id{ps}(...)

Each xi is either a constant parameter of the recursion, or an argument
on which the def is recursing. An argument xi must have an empty vsi.
The list of argument xi is xa1..xaq.

The abstraction created for such a recursive definition has form:

id{ps}(x1;...;xn)==   Y (\idv xa1 ... xaq y1 ... ym.
                               g[idv ta1 ... taq/id{ps}(t1;...;tn)])
                        xa1 ... xaq

g[idv ta1 ... taq/id{ps}(t1;...;tn)] means for all t1;...;tn 
occurrences of id{ps}(t1;...;tn) are replaced by idv ta1 ... taq
where the correspondence between the taj and the ti is the same as
that between the xaj and the xi.
]%


% 
-----------------------------------------------------------------------------
Recursive Folding / Unfolding conversions.
-----------------------------------------------------------------------------
%


let RecDefUnrollC opid = 
  UnfoldC opid
  ANDTHENC HigherC YUnrollC_bo
  ANDTHENC PrimReduceC
;;

let RecUnrollRollC opid t1 t2 = 
  DoubleMacroC 
   (opid ^ `rec_unfoldC`)
   (RecDefUnrollC opid)
   t1
   (UnfoldC opid)
   t2
;;

%
letref RecUnfoldFold_alist = [] : (tok # convn # convn) list;;

let update_RecUnfoldFold_alist id UnfoldC FoldC = 
  RecUnfoldFold_alist := update_alist RecUnfoldFold_alist id (UnfoldC,FoldC)
 ; ()
;;

let lookup_RecUnfoldC opid = 
  fst (apply_alist RecUnfoldFold_alist opid)
  ? failwith `lookup_RecUnfoldC: no conversion found`
;;
let lookup_RecFoldC opid = 
  snd (apply_alist RecUnfoldFold_alist opid)
  ? failwith `lookup_RecFoldC: no conversion found`
;;
%

letref RecUnfoldFold_alist_ref_state =
  new_alist_ref_state `RecUnfoldFold_alist`
    (nil : (tok # convn # convn) list)
;;

let ref_add_RecUnfoldFold_alist_aux index edges items =
 RecUnfoldFold_alist_ref_state
   := declare_ref_state_data_indirect `RecUnfoldFold_alist` RecUnfoldFold_alist_ref_state index items edges
;;

let ref_add_RecUnfoldFold_alist index =
 declare_ref_state_index index `RecUnfoldFold_alist` index;
 ref_add_RecUnfoldFold_alist_aux index
;;

update_ref_state_view
 (\(). RecUnfoldFold_alist_ref_state)
 (ref_state_view_list_entry (itoken_term o fst))
;;     

let ref_add_RecUnfoldFold_additions items index edges =
 RecUnfoldFold_alist_ref_state
   := ref_state_modify_state_aux (\data gedata. append gedata data)
         RecUnfoldFold_alist_ref_state items index edges
;;

let RecUnfoldFold_add_data oid data = 
  RecUnfoldFold_alist_ref_state
    := ref_state_set_data RecUnfoldFold_alist_ref_state [oid,  data]
;;

let ref_update_RecUnfoldFold oid data =	 
 reset_ref_environment_data oid;
 add_ref_environment_data oid `RecUnfoldFold_alist` RecUnfoldFold_add_data data
;;

let RecUnfoldFold_do_updates oid edges oids =
  RecUnfoldFold_alist_ref_state := ref_state_do_updates RecUnfoldFold_alist_ref_state oid oids edges
; ()
;;
let undeclare_RecUnfoldFold oid =
  (RecUnfoldFold_alist_ref_state := ref_state_remove RecUnfoldFold_alist_ref_state oid; ())
 ? ()
;;

let lookup_RecUnfoldFold_alist () = 
  ref_state_get RecUnfoldFold_alist_ref_state (current_ref_environment_index `RecUnfoldFold_alist`)
;;

let lookup_RecUnfoldC opid = 
  fst (apply_alist (lookup_RecUnfoldFold_alist ()) opid)
  ? failwith `lookup_RecUnfoldC: no conversion found`
;;
let lookup_RecFoldC opid = 
  snd (apply_alist (lookup_RecUnfoldFold_alist ()) opid)
  ? failwith `lookup_RecFoldC: no conversion found`
;;



let RecUnfoldTopC id e t = 
  lookup_RecUnfoldC id e t;;

let RecFoldTopC id e t = 
  lookup_RecFoldC id e t;;

let RecUnfoldsTopC ids = FirstC (map RecUnfoldTopC ids) ;;
let RecFoldsTopC ids = FirstC (map RecFoldTopC ids) ;;

let RecUnfoldsC ids = SweepUpC (RecUnfoldsTopC ids) ;;
let RecFoldsC ids = SweepUpC (RecFoldsTopC ids) ;;

let RecUnfoldC id = RecUnfoldsC [id] ;;
let RecFoldC id = RecFoldsC [id] ;;

let RecUnfold id i = Rewrite (RecUnfoldC id) i ;;
let RecFold id i = Rewrite (RecFoldC id) i ;;


% Uses AbReduce from simp-tactics %

let RecEvalC ids = RecUnfoldsC ids ANDTHENC AbReduceC ;;
let RecForceEvalC force ids = RecUnfoldsC ids ANDTHENC ForceReduceC force;;
let RecEval ids i p =
  let F = get_red_force p
  in
    Rewrite (RecForceEvalC F ids) i p ;;

%[
-----------------------------------------------------------------------------
Eta expanding/contracting a curried recursive definition.
-----------------------------------------------------------------------------
]%


let RecEtaExpandContractC opid t1 t2 = 
  DoubleMacroC 
   (opid ^ `rec_etaC`)
   (AllC [UnfoldTopC opid;HigherC YUnrollC_bo;PrimReduceC])
   t1
   (RecUnfoldC opid ANDTHENC UnfoldC opid)
   t2
;;

%NB: must only run after unfold/fold alist updated %
let can_build_RecEta_convs tm_ap = not (null (tl (dest_iterated_apply tm_ap)));;
	    
let build_RecEta_convs tm_ap = 
  let ab_tm.tm_args = dest_iterated_apply tm_ap in
  if null tm_args then [] else
  let eta_exp_ab_tm = mk_iterated_lambda (map dest_var tm_args) tm_ap in
  let id = opid_of_term ab_tm 
  in [(id, (RecEtaExpandContractC id ab_tm eta_exp_ab_tm))]
;;


%
letref RecEta_alist = [] : (tok # convn # convn) list
;;

%%NB: must only run after unfold/fold alist updated %%
let update_RecEta_alist tm_ap = 
  let ab_tm.tm_args = dest_iterated_apply tm_ap in
  if null tm_args then () else
  let eta_exp_ab_tm = mk_iterated_lambda (map dest_var tm_args) tm_ap in
  let id = opid_of_term ab_tm 
  in
    RecEta_alist := 
      update_alist RecEta_alist id 
      (RecEtaExpandContractC id ab_tm eta_exp_ab_tm)
    ; ()
    
;;

%
letref RecEta_alist_ref_state =
  new_alist_ref_state `RecEta_alist`
    (nil : (tok # convn # convn) list)
;;

update_ref_state_view
 (\(). RecEta_alist_ref_state)
 (ref_state_view_list_entry (itoken_term o fst))
;;     

let ref_add_RecEta_alist_aux index edges items =
 RecEta_alist_ref_state
   := declare_ref_state_data_indirect `RecEta_alist` RecEta_alist_ref_state index items edges
;;

let ref_add_RecEta_alist index =
 declare_ref_state_index index `RecEta_alist` index;
 ref_add_RecEta_alist_aux index
;;

let RecEta_add_data oid data = 
  RecEta_alist_ref_state
    := ref_state_set_data RecEta_alist_ref_state [oid,  data]
;;

let ref_update_RecEta oid data =	 
 reset_ref_environment_data oid;
 add_ref_environment_data oid `RecEta_alist` RecEta_add_data data
;;

let ref_add_RecEta_additions items index edges =
 RecEta_alist_ref_state
   := ref_state_modify_state_aux (\data gedata. append gedata data)
         RecEta_alist_ref_state items index edges
;;

let RecEta_do_updates oid edges oids =
  RecEta_alist_ref_state := ref_state_do_updates RecEta_alist_ref_state oid oids edges
; ()
;;
let undeclare_RecEta oid =
  (RecEta_alist_ref_state := ref_state_remove RecEta_alist_ref_state oid; ())
 ? ()
;;

let lookup_RecEta_alist () = 
  ref_state_get RecEta_alist_ref_state (current_ref_environment_index `RecEta_alist`)
;;


let RecEtaExpC id = 
  fst (apply_alist (lookup_RecEta_alist()) id)
  ?
  failwith `RecEtaExpC: no conversion found`
;;

let RecEtaConC id = 
  snd (apply_alist (lookup_RecEta_alist()) id)
  ?
  failwith `RecEtaExpC: no conversion found`
;;

% tell lib to insert object_id into term %
let indicate_insert_object_id t = 
 mk_simple_term `!insert_object_id_in_operator` [t]
;;

let mk_ref_state_update_term updates builds args = 
 indicate_insert_object_id
   (make_term ( `!ref_state_update`
              ,  [ mk_string_parm updates
                 ; mk_string_parm builds])
     [[], args])
;;

let include_re_update = include_properties_term [`reference environment additions`, itoken_term `update`];;

let mk_ref_update_RecUnfoldFold_term = mk_ref_state_update_term "ref_update_RecUnfoldFold" ;;
let mk_ref_update_RecEta_conv_term = mk_ref_state_update_term "ref_update_RecEta" ;;

  
