
let isrl x = isr x & isl (outr x);;
let isrr x = isr x & isr (outr x);;
abstype just = tactic + ((int # term # tactic list) list + sqjust)
  with form_tactic_just Tac = abs_just (inl Tac)
   and form_comp_seq_just cs = abs_just (inr (inl cs))
   and form_sqjust sq = abs_just (inr (inr sq))
   and open_tactic_just j =
                     (outl (rep_just j) ? failwith `open_tactic_just`)
   and open_comp_seq_just j =
                     (outl (outr (rep_just j)) ? failwith `open_comp_seq_just`)
   and open_sqjust j =
                     (outr (outr (rep_just j)) ? failwith `open_sqjust`)
   and is_tactic_just j = isl (rep_just j)
   and is_comp_seq_just j = isrl (rep_just j)
   and is_sqjust j = isrr (rep_just j)
;;


let just_to_comp_seq j =
 let l = (open_comp_seq_just j) in
 let eps = fst (snd (hd l)), fst (snd (last l)) in
 eps,
 map (\ (op, t, r).
	 (if op = FWD then true
	 else if op = REV then false
	 else failwith `just_to_comp_seq`), t)
     (filter (\ (op,t,r). not (op = NOP)) l) 
;;

%
abstype reln = tok # bterm list
   with form_rel_with_parms name parms = abs_reln (name,parms) 
   and name_of_rel r = fst (rep_reln r)
   and parms_of_rel r = snd (rep_reln r)
;;
%
abstype reln = (tok # parm list) # bterm list
   with form_rel_with_parms name prms parms = abs_reln ((name,prms),parms) 
   and name_of_rel r = fst (fst (rep_reln r))
   and prms_of_rel r = snd (fst (rep_reln r))
   and parms_of_rel r = snd (rep_reln r)
;;

let reln_to_term r =
  make_term (`reln`, ( (make_token_parameter (name_of_rel r))
		     . (prms_of_rel r)))
            (parms_of_rel r)
;;

let alpha_equal_relns x y =
 let xid = name_of_rel x and xbterms = parms_of_rel x and
     yid = name_of_rel y and ybterms = parms_of_rel y in
 xid = yid & equal_lists_p alpha_equal_bterms xbterms ybterms
;;
 
let form_untyped_rel name = form_rel_with_parms name [] [] ;;
let parm_of_rel r = snd (hd (parms_of_rel r)) ;;
let rel_to_term r = mk_term ((name_of_rel r),(prms_of_rel r)) (parms_of_rel r);;
let term_to_rel t = 
  let (op,prms),bts = dest_term t in
    form_rel_with_parms op prms bts
;;


%[
*****************************************************************************
Conversions
*****************************************************************************
A concrete type for now.
]%
lettype convn = env -> term -> (term # reln # just) ;;



letref rrrs_assoc =
 new_list_ref_state `rrrs_assoc` (nil : (tok # tok) list);;

update_ref_state_view
 (\(). rrrs_assoc)
 (ref_state_view_list_entry
   (\e. icons_term (itoken_term (fst e)) (itoken_term (snd e))))
;;     

let ref_add_rrrs_assoc index edges items =
 declare_ref_state_index index `rrrs_assoc` index;
 rrrs_assoc := declare_ref_state_data_indirect `rrrs_assoc` rrrs_assoc index items edges
;;

let ref_add_rrrs_assoc_aux index edges items =
 rrrs_assoc := declare_ref_state_data_indirect `rrrs_assoc` rrrs_assoc index items edges
;;

let ref_add_rrrs_additions items index edges =
 rrrs_assoc := ref_state_modify_state rrrs_assoc items index edges
;;

let rrrs_assoc_add_data oid data = 
 rrrs_assoc := ref_state_set_data rrrs_assoc [oid, data]
;;

let rrrs_add oid data =
 reset_ref_environment_data oid;
 add_ref_environment_data oid `rrrs_assoc` rrrs_assoc_add_data data
;;

let rrrs_assoc_do_updates oid edges oids =
  rrrs_assoc := ref_state_do_updates rrrs_assoc oid oids edges
; ()
;;
let undeclare_rrrs_assoc oid =
 (rrrs_assoc := ref_state_remove rrrs_assoc oid; ())
 ? ()
;;

let lookup_rrrs () = 
  ref_state_get rrrs_assoc (current_ref_environment_index `rrrs_assoc`)
;;


%
order relation info
~~~~~~~~~~~~~~~~~~~~
%

%
letref order_rel_families = [] : (tok # reln list) list ;;

let get_order_rel_family id = apply_alist order_rel_families id ;;
%

%    ((tok # reln list) list,(term # term # term # term # term) list)
%
let dummy_orf_append (data :(term # term # term # term # term) list) cdata =
 cdata
;;

letref order_rel_families_assoc = 
 new_ref_state
   `order_rel_families_assoc`
   flatten
   dummy_orf_append
   (nil : (object_id # (term # term # term # term # term) list) list)
   (nil : (tok # reln list) list)
;;

update_ref_state_view
 (\(). order_rel_families_assoc)
 (ref_state_view_list_entry (\e. (icons_term (itoken_term (fst e))
					     (map_to_ilist reln_to_term (icons_op) (snd e)))))
;;     

let get_order_rel_families () =
 (ref_state_get order_rel_families_assoc
			    (current_ref_environment_index `order_rel_families_assoc`)) 
;;

let get_order_rel_family id = apply_alist (get_order_rel_families ()) id;;

let ref_add_order_rel_families_assoc index edges items =
 declare_ref_state_index index `order_rel_families_assoc` index;
 order_rel_families_assoc := declare_ref_state_data_indirect `order_rel_families_assoc` order_rel_families_assoc index items edges
;;

let ref_add_order_rel_families_assoc_aux index edges items =
 order_rel_families_assoc := declare_ref_state_data_indirect `order_rel_families_assoc` order_rel_families_assoc index items edges
;;

let ref_add_order_rel_families_additions items index edges =
 order_rel_families_assoc := ref_state_modify_state order_rel_families_assoc items index edges
;;

let order_rel_family_add_data oid data = 
 order_rel_families_assoc := ref_state_set_data order_rel_families_assoc [oid, data]
;;
let RelFamily_add oid data =
 reset_ref_environment_data oid;
 add_ref_environment_data oid `order_rel_families_assoc` order_rel_family_add_data data
;;


let order_rel_family_do_updates oid edges oids =
 order_rel_families_assoc := ref_state_do_updates order_rel_families_assoc oid oids edges
; ()
;;
let undeclare_order_rel_family oid =
 (order_rel_families_assoc := ref_state_remove order_rel_families_assoc oid; ())
 ? ()
;;

let declare_rel_add oid (opid,r) =
 reset_ref_environment_data oid;
 add_ref_environment_data oid `order_rel_families_assoc` order_rel_family_add_data [r];
 add_ref_environment_data oid `rrrs_assoc` rrrs_assoc_add_data [opid,`equal`]
; ()
;;


% weaker relation on left %

%
letref order_rel_relative_strengths =  [] : (reln # reln) list ;;

let declare_order_rel_pair stronger_rtm weaker_rtm = 
  let get_r t = fst (dest_rel_term_without_check t) in
  let stronger_r = get_r stronger_rtm in
  let weaker_r = get_r weaker_rtm in
  if exists
       (\(r,r').rel_equal r stronger_r & rel_equal r' weaker_r)
       order_rel_relative_strengths 
  then
    ()
  else
  ( order_rel_relative_strengths :=
    (stronger_r,weaker_r) . order_rel_relative_strengths 
   ; ()
  )
;;

%

letref order_rel_relative_strengths_assoc = 
  new_ref_state `order_rel_relative_strengths_assoc`
                flatten
		% dummy to get types right. replaced later after add_order_rel_pairs defined %
                (\(data : (term # term) list) cdata . cdata)
                (nil : (object_id # (term # term) list) list)
		(nil : (reln # reln) list)
;;

update_ref_state_view
 (\(). order_rel_relative_strengths_assoc)
 (ref_state_view_list_entry (\e. (icons_term (reln_to_term (fst e))
					     (reln_to_term (snd e)))))
;;     

let ref_add_order_rel_relative_strengths_assoc index edges items =
 declare_ref_state_index index `order_rel_relative_strengths_assoc` index;
 order_rel_relative_strengths_assoc
     := declare_ref_state_data_indirect `order_rel_relative_strengths_assoc` order_rel_relative_strengths_assoc index items edges
;;

let ref_add_order_rel_relative_strengths_additions items index edges =
 order_rel_relative_strengths_assoc
     := ref_state_modify_state order_rel_relative_strengths_assoc items index edges
;;

let lookup_order_rel_relative_strengths () = 
  ref_state_get order_rel_relative_strengths_assoc (current_ref_environment_index `order_rel_relative_strengths_assoc`)
;;



let add_lin_order_check_funs l locf = 
 letrec aux locf l = 
  if (null l) then locf 
  else
  let fam_id, f = hd l in
  let nlocf = aux locf (tl l) in
     update_alist nlocf fam_id f
 in aux locf l
;;

letref lin_order_check_funs_assoc = 
  new_ref_state `lin_order_check_funs_assoc` 
                flatten
		add_lin_order_check_funs
                (nil : (object_id # (tok # (env -> reln -> bool)) list) list)
                (nil : (tok # (env -> reln -> bool)) list)
;;


update_ref_state_view
 (\(). lin_order_check_funs_assoc)
 (ref_state_view_list_entry (itoken_term o fst))
;;     


let ref_add_lin_order_check_funs_assoc index edges items =
 declare_ref_state_index index `lin_order_check_funs_assoc` index;
 lin_order_check_funs_assoc 
    := declare_ref_state_data_indirect `lin_order_check_funs_assoc` lin_order_check_funs_assoc index items edges
;;

let ref_add_lin_order_check_funs_additions items index edges =
 lin_order_check_funs_assoc 
    := ref_state_modify_state lin_order_check_funs_assoc items index edges
;;

let lin_order_check_fun_do_updates oid edges oids =
 lin_order_check_funs_assoc := ref_state_do_updates lin_order_check_funs_assoc oid oids edges
 ; ()
;;
let undeclare_lin_order_check_fun oid =
 (lin_order_check_funs_assoc := ref_state_remove lin_order_check_funs_assoc oid; ())
 ? ()
;;

let lin_order_check_fun_add_data oid data =
  lin_order_check_funs_assoc := ref_state_set_data lin_order_check_funs_assoc [oid, data]
;;

let lin_order_check_fun_add oid data =
 reset_ref_environment_data oid;
 add_ref_environment_data oid `lin_order_check_funs_assoc` lin_order_check_fun_add_data data
;;
let lin_order_check_fun_add_o oid data =
 lin_order_check_fun_add oid (map (\obid,r.name_of_abstraction obid, r) data)
;;

let lookup_lin_order_check_funs () = 
  ref_state_get lin_order_check_funs_assoc (current_ref_environment_index `lin_order_check_funs_assoc`)
;;




