%
Adapted from ~crary/kml/prl/subtype_1.thy as of 12/2/97
    Replaced SubtypeXXX by SubtypeRelXXX
    Replaced subtypeXXX by subtype_relXXX
%
let SubtypeRelEqCD p =
   let (t, e1, e2) = dest_equal (concl p)
   in
   let opid = opid_of_term e1
   in
      if opid = `subtype_rel` then
         Refine `subtype_relEquality` [] p
      else if opid = `axiom` & is_term `subtype_rel` t then
         Refine `subtype_rel_axiomEquality` [] p
      else
         failwith `SubtypeRelEqCD`
;;

update_EqCD_additions `SubtypeRelEqCD` SubtypeRelEqCD ;;

let SubtypeRelCD p =
   let c = concl p in
   let univ = get_universe p c in
      if opid_of_term c = `subtype_rel` then
         (Refine `subtype_rel_axiomFormation`
                 [mk_level_exp_arg (simplify_level_exp (snd (ti_dest_lp_term univ)));
                  mk_var_arg (get_var_arg `v1` p ? maybe_new_proof_var `x' p)]
          THENL [FoldTop `member` 0;
                 FoldTop `member` 0 THEN AddHiddenLabel `wf`;
                 FoldTop `member` 0 THEN AddHiddenLabel `wf`]) p
      else
         failwith `SubtypeRelCD`
;;

let SubtypeRelInd i p =
   Refine `subtype_relElimination` [mk_int_arg (get_pos_hyp_num i p)] p
;;

let SubtypeRelD i =
    if i = 0 then SubtypeRelCD else SubtypeRelInd i
;;

%update_D_additions `SubtypeRelD` SubtypeRelD ;;
%

let SubsumeC T p =
   if is_term `member` (concl p) then
      (UnfoldTop `member` 0 THEN
       Refine `subsumption` [mk_term_arg T]
       THENL [FoldTop `member` 0; AddHiddenLabel `subtype_rel`]) p
   else
      (Refine `subsumption` [mk_term_arg T] THENL [Id; AddHiddenLabel `subtype_rel`]) p
;;

let PrimSubsumeH T i p =
   let (T', e1, e2) = dest_equal (h i p)
   and var' = new_invisible_var p
   and i' = num_hyps p
   in  
      (Refine `cut`
              [mk_int_arg i'; mk_term_arg (mk_equal_term T e1 e2); mk_var_arg var']
       THENL
       [Refine `subsumption` [mk_term_arg T'] THENL [NthHyp i; Id]; Id]) p
;;

let SubsumeH T i p =
   if is_term `member` (h i p) then
      (UnfoldTop `member` i THEN
       PrimSubsumeH T i THENL
       [FoldTop `member` i THEN AddHiddenLabel `subtype_rel`;
        FoldTop `member` i THEN FoldTop `member` (num_hyps p + 1)]) p
   else
      (PrimSubsumeH T i THENL [AddHiddenLabel `subtype_rel`; Id]) p
;;

let Subsume T i =
   if i = 0 then
      SubsumeC T
   else
      SubsumeH T i
;;

let HypSubsume i_hyp i p =
   let hyp = h i_hyp p
   in
      if is_term `subtype_rel` hyp then
         let (T1, T2) = two_subterms hyp
         in
            ((if i = 0 then
                 SubsumeC T1
              else
                 SubsumeH T2 i) THEN
             IfLab `subtype_rel` (NthHyp i_hyp) Id) p
      else
         failwith `HypSubsume: bad hypothesis`
;;

let ExtSubsume T p =
   (Refine `extract_subsumption` [mk_term_arg T] THENL [Id; AddHiddenLabel `subtype_rel`]) p
;;

let HypExtSubsume i p =
   let hyp = h i p
   in
      if is_term `subtype_rel` hyp then
         let (T1, T2) = two_subterms hyp
         in
            (Refine `extract_subsumption` [mk_term_arg T1] THENL [Id; NthHyp i]) p
      else
         failwith `HypExtSubsume: bad hypothesis`
;;

let get_sub_lemma_names opid =
  names_of_statements_with_prefix (opid ^ `_sub`)
;;

let DecompSubtypeRelOnce p =
   let C = concl p
   in
      if is_term `subtype_rel` C then
         let (T1, T2) = two_subterms C
         in
         let opid1 = opid_of_term T1
         and opid2 = opid_of_term T2
         in
            if T1 = T2 then
               BLemma `subtype_rel_reflex` p
            else
               let lemmas = get_sub_lemma_names opid1
               in
                  Try (First (map BLemma lemmas)) p
      else
         Id p
;;

let DecompSubtypeRel =
   RepeatM (If (\p. opid_of_term (concl p) = `subtype_rel`) DecompSubtypeRelOnce (Try (D 0)))
;;

let ProveSubtypeRel hyp_nums p =
   let tacs = map (\i. BHyp (get_pos_hyp_num i p)) hyp_nums
   in
      (DecompSubtypeRel THENM Try (First tacs) THENW Auto) p
;;

let RephraseSubtypeRelC i p =
   let i' = get_pos_hyp_num i p
   in
   let C = concl p
   and (v, T1) = dest_hyp i' p
   in
      if is_member_term C then
         let (T2, vT) = two_subterms C
         in
            if vT = mvt v then
               (Assert (mk_simple_term `subtype_rel` [T1; T2])
                THENL
                [Thin i';
                 HypSubsume (-1) 0 THEN NthDecl i']) p
            else
               failwith `RephraseSubtypeRelC: bad conclusion variable`
      else
         failwith `RephraseSubtypeRelC: bad conclusion`
;;

let RephraseSubtypeRelH i p =
   let i' = get_pos_hyp_num i p
   in
   let H = h i' p
   in
   letrec rephrase T =
      if is_term `all` T then
         let (v, T1, T2) = dest_all T
         in
         let result = rephrase T2
         in
            if isl result then
               % in a series of quantifiers surrounding the real subtyping stuff %
               let (quants, T2') = outl result
               in             
                  inl (quants+1, mk_all_term v T1 T2')
            else
               % on the last quantifier %
               let (vT, T2') = outr result
               in
                  if vT = mvt v then
                     inl (0, mk_simple_term `subtype_rel` [T1; T2'])
                  else
                     failwith `RephraseSubtypeRelH: bad conclusion variable`
      else if is_member_term T then
         let (T2, vT) = two_subterms T
         in
            inr (vT, T2)
      else
         failwith `RephraseSubtypeRelH: bad hypothesis`
   in
   let (quants, H') =
      let result = rephrase H
      in
         if isl result then
            outl result
         else
            failwith `RephraseSubtypeRelH: bad hypothesis`
   in
      (AssertAtHyp i' H'
       THENL
       [RepeatMFor (quants+1) (D 0) THENM BHyp i';
        Thin (i'+1)]) p
;;
