%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%***************************************************************************
SYSTEM.ML
***************************************************************************%

%
Variants on system related ml functions
%

%  Most of this is vestigial, although we do need overwriting load eventually.
let loadt tok = load tok true and loadf tok = load tok false;;
let compilet tok = compile tok true and compilef tok = compile tok false;;

let owloadt tok = overwriting_load (tok,true) ;;
let owloadf tok = overwriting_load (tok,false) ;;

% 
% for debugging purposes, to save typing! %

% fttb : looks in ~nuprl/nuprl5/bin/patches
  overwriting_load (`owtemp`,true);;
%%

let ldt () = loadt `./lib/ml/standard/temp` ;;
let owldt () = owloadt `./lib/ml/standard/owtemp` ;;
%

% filenames for loading / compiling %

%
	Dilemma : general gets more recompiled for trivial reasons
	occasionally. Twould be nice if the tactics were not then
	recompiled by default. Tempted to leave general out of this list,
	but better strategy would be to do less trivial recompilation of
	general.
%

    
letref tactic_files =

[ %"general"
  ;"primitives"
  ;"term"
  ;"subst"

  ;"level-exp"
  ;"match"
  ;"compute-aux1"

  ;"utilities" 


  ; % "compatv4"

  ;"compute-aux2"

  %;"cache"
  %
  ;"new-var"
  ;"compatv4-2"

  ;"lib"
  ;"abstraction"
  ;"type-inc"
  ;"match-inc"

  ;"sequent"
  ;"commands-nv5" 
  ;"tactic-funs"
  ;"env"
  ;"match-ext"
  ;"type-inf"

  ;"tacticals"
  ;"new-then"
  ;"compute-aux3"
  ;"compute-tactics"
  ;"atomic-tactics"
  ;"basic-tactics"

  ;"wf-cache"
  ;"monitor"

  ;"inclusion-tactics"
  ;"basic-eq-tactics"
  ;"rec-type-tactics"


  ;"univ-fmla-tactics"
  ;"sqequal"
  ;"txform-tactics" 
  
  ;"equality-tactics"
  ;"general-tactics"
  ;"arith"
  ;"sup-inf"
  ;"induction-tactics"
  ;"quot-tactics"

% 
  ;"module-tactics-1"  
%

  % rewrite support %

  ;"sqequal-just"
  ;"rw-types-defs"
  ;"rw-types"
  ;"comp-seq-manips"
  ;"just-manips"
  ;"conversionals"
  ;"apply-conv"
  ;"atomic-convs"
  ;"compute-convs"
  ;"sqequal-convs"
  ;"algebra-convs"
  ;"rewrite-tactics"

  ;"lib-dep-1"

  ;"rel-rst"
  ;"new-rel-rst"
  ;"rat-arith"
  ;"bool-tactics"
  ;"simp-tactics"
  ;"inc-tactics-2"
  ;"inc-tactics-3"

  ;"autotactic"
  ;"auto-top"
  ;"auto-post"

  ;"subtype-tactics"

  ;"classical-tactics"

 ;"recdef" 

 ;"prog-util" 
 ;"prog-flatten" 
 ;"prog-case"  %need this%
 ;"prog-module" 
 ;"prog-union" 
 ;"prog-enum" 
 ;"prog-switch" 
 ;"prog-state" 

  ]
;;

letref refiner_files =
  
  [ "lib-calls"

% ;"chrono-ml" %
  ;"rec-def"  % add-rec-def %
  ;"module-tactics-2" 
  ;"algebra-subset"
  ;"algebra-tactics"

  % Tactics that load into hooks %
  ;"sqequal-2"
  ;"isect"
  ;"rfunction"

%
  ;"utilities-4"
%

  % Programming constructs %
 ;"ref-top"
 ;"prog-top" 
 % ;"prog-subset"%
 ; "refenv-top"

  % Jprover refinements %
 ; "tacticals-2"
 ; "logic"
 ; "jprover"]
;;

