%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
****************************************************************************
****************************************************************************
UNIV-FMLA-TACTICS.ML
****************************************************************************
****************************************************************************
Tactics for using general formulae as rules.

The simple formulae making up a universally quantified general formula in a 
theorem object or a hypothesis list can be used as derived rules of inference.
The tactics defined in this file allow one to work both forwards and backwards
through such rules.

See tactic-funs.ml file for definition of general formulae.
]%


%[
*******************************************************************************
Instantiation of universally quantified general formula in the hypothesis list.
*******************************************************************************
]%
% 
THIS DESCRIPTION IS OUT OF DATE
We take care so that behaviour is uniform for both n = 0 and n > 0


H1 ... Hi: x1:A1->...->xn:An->B ... Hk |- C

BY RepeatFunctionEThin [t1;...;tm] i   (m =< n)

... Hi-1, Hi+1 ... Hk |- t-j1 in A1   (or |- A1 if x1 = no_id)
 .     .         .
 .     .         .
... Hi-1, Hi+1 ... Hk |- t-jm in An   (or |- An if xn = no_id)

... Hi-1, Hi+1 ... Hk, B[t1...tn/x1...xn] |- C

Caveat:
If B is wrapped in a guard term, then remove the guard.

%

% 
Second order dependent function hyp decomposition. Takes care of computing 
away applications of second order terms.
%
%
let SODepFunHD bterm i p =
  let x,(),B = dest_function (h i p) in
  if null (fst bterm) then
    DepFunHD (snd bterm) null_var i p
  else
  let n = num_hyps p in
  let t = bterm_to_lambdas_term bterm in
  let tagged_B = tag_all_so_var_terms [x] B in
  let instantiated_and_tagged_B = fo_subst [x,t] tagged_B 
  in
 (  DepFunHD t null_var i 
    THENL
    [Id
    ;ComputeWithTaggedTerm instantiated_and_tagged_B n
    ]
 ) p
;;
%

% 
Decompose a dependent function type, using t as witness.
%

let SODepFunHD t i =
 DepFunHD t null_var i 
 THENL
 [Id
 ;if is_term `so_lambda` t then Try (SOReduce i) else Id
 ]
;;


% 
Assume formula is last hypothesis.
If address is null stop at `and` and `iff` terms 

sub is [v1,t1;...vn,tn] : (var # term) list

If instantiating 

 All x:A. B[x]

 1. if v1 is null_var we use t1 for x.
 2. if x = vi for some i, we use ti for x.
 3. Otherwise we stop where we are.

NB: This scheme is not good... since instantiation can cause renaming
of bound variables. so for now, we ignore the variables completely.
%

let InstGenFormulaByAddr address (sub: (var # term) list) p =
  let n = num_hyps p in

  letrec Aux addr sub p' = 
  (
   let t = h n p' in
   let t' = unfold_soft_abs t in
   let opid = opid_of_term t' in

   if opid = `function` then
   (let x,(),() = dest_function t' in
    if x = null_var then
      ( UnfoldTopSoftAbs n 
        THEN
        IndepFunHD null_var n 
        THENL
        [Id;Aux addr sub] 
      ) p'
    if not null sub then
      ( OnHyp n UnfoldTopSoftAbs
        THEN
        SODepFunHD (snd (hd sub)) n
        THENL
        [Id
        ;Aux addr (tl sub)
        ] 
      ) p'
    else
        Id p'
   )
   if opid = `product` & is_null_var (bvar_of_term t' 2 1) then 

   (  if null addr then
        Id p'
      else
      ( UnfoldTopSoftAbs n 
        THEN
        ProdHD null_var null_var n
        THEN

        % false = take left; true = take right %

        (if (hd addr) then Thin n else Thin (n+1))
        THEN
        Aux (tl addr) sub
      ) p'
   )
   if null sub & null addr then 

     ( Try (OnHyp n (UnfoldTop `guard`))
     ) p'

   if not null sub then

      failwith `InstGenFormulaByAddr: too many bindings`

   else  

      failwith `InstGenFormulaByAddr: address too long`
  )
  in
    Aux address sub p
;;




% make n = 0 a convenient option for simple formula. %
%[
*******************************************************************************
Instantiation of Lemmas
*******************************************************************************
]%

let InstGenLemmaByAddr obid addr sub =
  let psub,tsub = 
    divide_list
      (\v,t.sub_kind_of_term t = `level-expression`) sub 
  in
    AssertLemmaWithSub obid psub
    THEN InstGenFormulaByAddr addr tsub
;;

% make n = 0 a convenient option for simple formula. %

let InstGenLemmaWithSub obid n sub =
  let addr = 
    if n = 0 then []
    else get_addr_of_nth_simple_formula (main_goal_of_theorem_o obid) n 
  in
    InstGenLemmaByAddr obid addr sub 
;;

let InstLemmaWithSub obid sub = InstGenLemmaWithSub obid 0 sub 
;;

let InstGenLemma name n terms = 
  InstGenLemmaWithSub (lemma_lookup name) n (map (\t.null_var,t) terms) ;;

let InstLemma name terms = 
  InstLemmaWithSub (lemma_lookup name) (map (\t.null_var,t) terms) ;;

let InstLemma_o obid terms = 
  InstLemmaWithSub obid (map (\t.null_var,t) terms) ;;


% Variants which allow for initial unfolding of abstractions %

let UnfoldsAndInstGenLemmaByAddr obid abs addr sub =
  let psub,tsub = 
    divide_list
      (\v,t.sub_kind_of_term t = `level-expression`) sub 
  in
    AssertLemmaWithSub obid psub
    THEN RepUnfolds abs (-1)
    THEN InstGenFormulaByAddr addr tsub
;;

% make n = 0 a convenient option for simple formula. %

let UnfoldsAndInstGenLemmaWithSub name abs n sub =
  let addr = 
    if n = 0 then []
    else get_addr_of_nth_simple_formula 
      (unfolds abs (main_goal_of_theorem name)) n 
  in
    UnfoldsAndInstGenLemmaByAddr (lemma_lookup name) abs addr sub 
;;

%[
*******************************************************************************
Instantiation of Hyps
*******************************************************************************
]%

% 
NB unconventional position of hyp num i. Makes it easy making closures
of this have same type as closures of InstGenLemmaByAddr
%

let InstGenHypByAddr i addr sub =
  CopyToEnd i 
  THEN InstGenFormulaByAddr addr sub
;;

let InstGenHypWithSub n sub i p =
  let addr = 
    if n = 0 then []
    else get_addr_of_nth_simple_formula (h (-1) p) n 
  in
    InstGenHypByAddr i addr sub p
;;

let InstGenHyp n terms =
  InstGenHypWithSub n (map (\t.null_var,t) terms) 
;;

let InstHypWithSub = InstGenHypWithSub 0 
;;
let InstHyp = InstGenHyp 0 
;;



%[
****************************************************************************
Formula Preprocessing for step back tactics.
****************************************************************************

Basic function defined:

BackThruGenFormula
  type_inf_fun : env -> term -> term
  type_matcher : int -> tok list -> var list -> term -> term  ->
                   (parm # parm # int) list # (var # term) list
  con_matcher : tok list -> var list -> term -> term -> 
                   (parm # parm # int) list # (var # term) list
  formula : term
  InstFormula : int list -> (var # term) list -> tactic
  n : int
  = 
  Tac : (var # term) list -> tactic

n selects which simple formula and hence which consequent to match against.
(Numbering consequents from 1 starting at left.) If 0 is given for n, Tac 
will search all consequents for a match.

con_matcher is used to match the concl term against the 
consequent of the formula. type_inf_fun and type_matcher are used
to guess completing bindings for matches based on type information.

Tac first runs FormulaAdder which should assert  <formula> as the last 
hypothesis. Tac matches the nth consequent C of the formula against the 
conclusion term D to get a set of second order bindings a1,...,an for
the variables x1,...,xn in the nth simple formula completing the bindings 
if necessary by matching context types and using explicitly supplied bterms.

Tac then instantiates the formula appropriately with a1,...,an and runs the 
either the hypothesis tactic or inclusion to mop up the final subgoal.

Labelling: 
wf subgoals are labelled such.
All inclusion subgoals have labels on them.
Assumptions to recursively solve are unlabelled.

H1 ... Hk |- D 

  BY InstFormula <address> [a1;...;an]

  H1 ... Hk |- a1 in A1 []
  .      .     .     . 
  .      .     .     . 
  H1 ... Hk |- an in An [a1...an-1/x1...xn-1]

  H1 ... Hk |- B1 [as/xs]
  .      .     .
  .      .     .
  H1 ... Hk |- Bm [as/xs]

  H1 ... Hk, C[as/xs] |- D
  
    BY OnLastHyp Inclusion


]%
%letref mytsub = [(null_var, inil_term)];;%

let BackThruGenFormula 
      type_inf_fun 
      type_matcher
      con_matcher 
      formula 
      InstFormula 
      n
  =
  let matcher_list =
    map 
      (\addr,var_decls,ants,con.
          addr 
          , ants
          , match_in_context_with_ti_and_ms 
              type_matcher
              type_inf_fun
              var_decls 
              con_matcher 
              con
      )
      (nth_simple_formula n formula) 
  in
  \p. 
     let explicit_bindings = (get_sub_arg `sub` p ? []) in
     let addr,ants,sub = 
       first_value
          (\addr,ants,matcher. 
              addr 
              , ants
              , matcher 
                  (concl p)
                  explicit_bindings 
                  (env_of_sequent p)
          )
          matcher_list
     in
     let vsub,tsub = 
       divide_list
         (\v,t.sub_kind_of_term t = `variable`) sub 
     in
     let vsub' = map dest_bvar_binding vsub
     in
     %mytsub:= tsub;%
     ( InstFormula addr tsub
       THENLL 
        [`antecedent`, 
          map
            (\pata p.
               let insta = concl p
               in let new_bvs = format_bvar_pl_from_pat vsub' pata insta
               in
               ( SubstAlphaEqProp
                   (apply_alpha_conv_mi new_bvs insta)
                   0
                 THEN Try (UnfoldTop `guard` 0)
                 THEN AddHiddenLabel `main`
               ) p
            )
            ants
        ;`main`,[SoftNthHyp (-1) 
                 ORELSE Inclusion (-1)
%
                 ORELSE AddDebugLabel
                          `BackThruGenFormula: inclusion failed` 
%
                ]
        ]     
     ) p
;;



%[
****************************************************************************
Stepping Back Through Lemmas.
****************************************************************************
]%

% 
Careful here to leave off p arg since BackThruGenFormula
does preprocessing on the 1st 6 arguments.

But n arg doesn't help as callers generally need p to get n.
TODO : at least get obid refs called at compile time by abstracting n.
%

let BackThruGenLemma_o obid n = 
  BackThruGenFormula
     get_type_using_env
     (half_match_with_retry get_hard_and_supertype_alts)
     (regular_half_match 1)
     (main_goal_of_theorem_o obid)
     (InstGenLemmaByAddr obid)
     n
;;
let BackThruGenLemma name = BackThruGenLemma_o (lemma_lookup name);;

let BackThruLemma name p = 
  BackThruGenLemma name (get_int_arg `n` p ? 0) p ;;

let BLemma = BackThruLemma ;;

let BackThruLemma_o obid p =  BackThruGenLemma_o obid (get_int_arg `n` p ? 0) p ;;
let BLemma_o = BackThruLemma_o ;;


let BackThruLemmaWithUnfolds name abs p = 
  BackThruGenFormula
     get_type_using_env
     (half_match_with_retry get_hard_and_supertype_alts)
     (regular_half_match 1)
     (repeatf (unfolds abs) (main_goal_of_theorem name))
     (UnfoldsAndInstGenLemmaByAddr (lemma_lookup name) abs)
     (get_int_arg `n` p ? 0) 
     p 
;;

% This is ideal candidate for optional arg passing...
Should add such an option to standard BLemma %

let BLemmaWithUnfolds abs name p = 
  BackThruLemmaWithUnfolds name abs p 
;;


%[
****************************************************************************
Stepping Back Through Hypotheses
****************************************************************************
We have two versions here. The Quick* versions separate the
hypothesis processing from the application of the tactic. This is
useful for instance in backchaining.
]%

let QuickBackThruGenHyp p i n =
  BackThruGenFormula
     get_type_using_env
     (half_match_with_retry get_hard_and_supertype_alts)
     (regular_half_match 1)
     (h i p)
     (InstGenHypByAddr i)
     n
;;

let QuickBackThruHyp p i = QuickBackThruGenHyp p i 0 ;;

let BackThruGenHyp i n p = QuickBackThruGenHyp p i n p ;;
let BackThruHyp i p = QuickBackThruGenHyp p i (get_int_arg `n` p ? 0) p ;;
let BHyp = BackThruHyp ;;

%[
****************************************************************************
Formula Preprocessing for step forward tactics.
****************************************************************************
THIS NEEDS UPDATING: Can Forward chain through general formulae.
Functions defined:

let FwdThruFormula
  type_inf_fun : env -> term -> term
  type_matcher : int -> tok list -> var list -> term -> term  ->
                   (parm # parm # int) list # (var # term) list
  ant_matcher : tok list -> var list -> term -> term -> 
                   (parm # parm # int) list # (var # term) list
  formula : term
  InstFormula: (var # term) list -> tactic
  pair_list : (int # int) list
  completing_bindings (var # term) list
  = 
  Tac : tactic

For now, the tactic returned works only with simple formulae.

pair_list specifies which hypotheses to match against which antecedents of
the formula. The first element of each pair is a hypothesis number. The second
is an antecedent number. (numbering antecedents from outside in.) If
the antecedent number for some hyp is 0 the tactic searches the 
antecedents for a match. Naively if we forward chain using nh hyps and
we have to find matches for them amongst na antecedents, we might have
to try na * (na-1) * ... * (na - nh + 1) matches (of order  na^nh).
We attempt to reduce this number in the typical case by only considering
those pairings of hyps with antecedents in which independently each hyp 
matches the antecedent it is paired with.

semi_matcher governs how the matching of lemma antecedent patterns and
hyp instances is carried out.

Tac first runs FormulaAdder which should assert  <formula> as the last 
hypothesis. 

Tac tries to find a consistent match of the hyps to the antecedents,
and gets a set of second order bindings a1,...,an for the variables
x1,...,xn in the simple formula by if necessary completing the bindings 
by matching context types.
 
Tac then instantiates the formula appropriately with a1,...,an and runs  
NthHyp or Inclusion to mop up the subgoals for antecedents which 
matched hyps.


H1 ... Hk |- D 

  BY InstFormula 0 [a1;...;an]

  H1 ... Hk |- a1 in A1 []
  .      .     .     . 
  .      .     .     . 
  H1 ... Hk |- an in An [a1...an-1/x1...xn-1]

  H1 ... Hk |- B1 [as/xs]
  .      .     .
  .      .     .
  H1 ... Hk |- Bm [as/xs]

  H1 ... Hk, C[as/xs] |- D
  

Need to fix this for forward chaining through lemmas and inferring level
expression bindings correctly.

]%

let FwdThruFormulaPart
      type_inf_fun 
      type_matcher
      ant_matcher 
      (addr,var_type_prs,ants,conseq)
      InstFormula 
      hyp_ant_num_prs 
  =
  let range_of_ants = upto 1 (length ants) in
  let range_of_ants_for_each_hyp =
     map 
       (\(),i. if i = 0 then range_of_ants else [i]) 
       hyp_ant_num_prs 
  in
  let le_vars,x_A_prs = dest_full_context var_type_prs in  
  let term_vars = map fst x_A_prs in
  \match_hint_sub p. 
     % filter out ants which don't match given hyp. %

     let hyps_for_match =  map 
                             (\i,().h i p) 
                             hyp_ant_num_prs 
     in 
     let pruned_range_of_ants_for_each_hyp =
           map2
             (\hyp ant_range.
                map_omitting_failures 
                  (\i.ant_matcher le_vars term_vars (nth i ants) hyp ; i)
                  ant_range
             )
             hyps_for_match
             range_of_ants_for_each_hyp
     in
     let set_of_ant_num_lists =
           all_distinct_permutations pruned_range_of_ants_for_each_hyp 
  
     in
     let hyp_conjunction = mk_iterated_and hyps_for_match in
     let ant_nums,sub =
         ( first_value
           (\ant_nums.
               ant_nums
               ,
               match_in_context_with_ti_and_ms
                  type_matcher
                  type_inf_fun
                  var_type_prs
                  ant_matcher 
                  (mk_iterated_and (map (\i.nth i ants) ant_nums))
                  hyp_conjunction
                  match_hint_sub
                  (env_of_sequent p)
            )
            set_of_ant_num_lists
         ?
         failwith `FwdThruFormulaUsingMatcher: no antecedents match hyps`
         )
     in
     let vsub,tsub = 
       divide_list
         (\v,t.sub_kind_of_term t = `variable`) sub 
     in
     let vsub' = map dest_bvar_binding vsub
     in
     let ant_hyp_num_prs_in_match = zip ant_nums (map fst hyp_ant_num_prs) in
     let AntecedentTacs =
          map
          (\n.( let hyp_num = apply_alist ant_hyp_num_prs_in_match n 
                in
                  SoftNthHyp hyp_num 
                  ORELSE Inclusion hyp_num
%
                  ORELSE AddDebugLabel
                           `FwdThruFormulaUsingMatcher: inclusion failed` 
%
              ) ? Id
          )
         (upto 1 (length ants))
     in
     (InstFormula addr tsub 
      THENLL 
      [`antecedent`,AntecedentTacs
      ;`main`,
        [\p.
           let instc = h (-1) p
           in let new_bvs = format_bvar_pl_from_pat vsub' conseq instc  
           in 
             SubstAlphaEqProp (apply_alpha_conv_mi new_bvs instc) (-1) p
        ]  
      ] 
     ) p
;;

let FwdThruGenFormula
      type_inf_fun 
      type_matcher
      ant_matcher 
      formula
      InstFormula 
      n
      hyp_ant_num_prs 
  =
  let Tacs = 
    map
    (\analyzed_simple_part.
        FwdThruFormulaPart
            type_inf_fun 
            type_matcher
            ant_matcher 
            analyzed_simple_part
            InstFormula 
            hyp_ant_num_prs 
    )
    (nth_simple_formula n formula)
  in
    \p.
     let explicit_bindings = get_sub_arg `sub` p ? [] 
     in
       First (map (\T.T explicit_bindings) Tacs) p
;;

%[
****************************************************************************
Stepping Forward Through Lemmas.
****************************************************************************
]%


let FwdThruGenLemmaAnts obid n hyp_ant_prs =
  FwdThruGenFormula
     get_type_using_env
     (half_match_with_retry get_hard_and_supertype_alts)
     (regular_half_match (-1))
     (main_goal_of_theorem_o obid)
     (InstGenLemmaByAddr obid)
     n
     hyp_ant_prs
;;

let FwdThruGenLemma_o obid n hyp_nums =
      FwdThruGenLemmaAnts obid n (map (\i.i,0) hyp_nums) 
;;
let FwdThruGenLemma name  = FwdThruGenLemma_o (lemma_lookup name);;
  
let FwdThruLemma name hyp_nums p =
      FwdThruGenLemma_o (lemma_lookup name) (get_int_arg `n` p ? 0) hyp_nums p
;;
let FwdThruLemma_o obid hyp_nums p =
      FwdThruGenLemma_o obid (get_int_arg `n` p ? 0) hyp_nums p
;;

let FLemma = FwdThruLemma ;;

%[
****************************************************************************
Stepping Forward Through Hypotheses
****************************************************************************
]%
let FwdThruGenHypAnts i n hyp_ant_prs p =
  FwdThruGenFormula
     get_type_using_env
     (half_match_with_retry get_hard_and_supertype_alts)
     (regular_half_match (-1))
     (h i p)
     (InstGenHypByAddr i)
     n
     hyp_ant_prs
     p
;;

let FwdThruGenHyp i n hyp_nums =
      FwdThruGenHypAnts i n (map (\i.i,0) hyp_nums) 
;;

let FwdThruHyp i hyp_nums p =
      FwdThruGenHyp i (get_int_arg `n` p ? 0) hyp_nums p
;;

let FHyp = FwdThruHyp ;;


%[
*******************************************************************************
Instantiation of Concl
*******************************************************************************
]%

letrec InstConcl ts p = 
  if null ts then 
    Id p
  else
  let c = concl p
  in let c' = unfold_soft_abs c
  in 
  if is_term `product` c' & not is_null_var (bvar_of_term c' 2 1) then

  ( UnfoldTopSoftAbs 0 
    THEN DepProdCD (hd ts) null_var 
    THENM InstConcl (tl ts)

  ) p
  if is_term `set` c' & not is_null_var (bvar_of_term c' 2 1) then
  ( UnfoldTopSoftAbs 0 
    THEN DepSetCD (hd ts) null_var
    THENM InstConcl (tl ts)

  ) p
  else 
    failwith `InstConcl`
;;


% can't work as is if there is >1`exists' or `or' terms underneath `and's %

let InstConclByAddr address tms p =

  letrec Aux addr tms p' = 
  (
   let t = concl p' in
   let t' = unfold_soft_abs t in
   let opid = opid_of_term t' in

   if opid = `function` then
   (let x,(),() = dest_function t' in
      if x = null_var then
        ( UnfoldTopSoftAbs 0 
          THEN
          FunCD null_var  
          THENM Aux addr tms
        ) p'
      else
        Id p'    
    )
   if opid = `product` then
   ( if is_null_var (bvar_of_term t' 2 1) then 

     (  UnfoldTopSoftAbs 0
        THEN Refine `independent_pairFormation` []
        THENL [Aux addr tms;Aux addr tms]
     ) p'
     if not null tms then
      ( UnfoldTopSoftAbs 0
        THEN
        DepProdCD (hd tms) null_var
        THENL
        [Id
        ;Aux addr (tl tms)
        ;Id
        ] 
      ) p'
    else
        Id p'
   )
   if opid = `union` then

   (  if null addr then
        Id p'
      else
      ( UnfoldTopSoftAbs 0 
        THEN
        (if (hd addr) = false then
           (  let le_arg,WFTac = mk_le_arg_and_wf_tac p' (snd (dest_union t'))
              in
                Refine `inlFormation` [le_arg] 
                THENL [Aux (tl addr) tms;WFTac]
           ) 
         else
           (  let le_arg,WFTac = mk_le_arg_and_wf_tac p' (fst (dest_union t'))
              in
                Refine `inrFormation` [le_arg] 
                THENL [Aux (tl addr) tms;WFTac]
           ) 
        )
      ) p'
   )
   if null tms & null addr or not null tms then 

     Try (UnfoldTop `guard` 0) p'

   else  

      failwith `InstConclByAddr: address too long`
  )
  in
    Aux address tms p
;;

% need to fix up to take branch # as Sel argument %


let InstConcl' tms p = InstConclByAddr [] tms p ;;

let Inst tms i p = if i = 0 then InstConcl' tms p else InstHyp tms i p ;;

%[
*******************************************************************************
Auto Instantiation of Concl
*******************************************************************************
]%

%
If tas = ta1...tan,
   tbs = tb1...tbm then

returns list of tuples, each of form:

[i1,...,in]

where all i's are distinct,  and are between 0 and m.

Each tuple indicates a suggested match to try of subset of tas patterns
against tbs instances. 

ij = 0 it means to leave taj out of suggested match.
o/w ij means match taj against tb(ij)
%
                               
let find_match_sets_a tas tbs (match : term -> term -> bool) = 
  let anums = upto 1 (length tas) 
  in let bnums = upto 1 (length tbs)
  in let all_anum_bnum_prs = map (\[i;j].i,j) (all_permutations [anums;bnums])
  in let mfilter (i,j) = match (nth i tas) (nth j tbs)
  in let good_anum_bnum_prs = filter mfilter all_anum_bnum_prs
  in let dummy_anum_bnum_prs = zip anums (replicate 0 (length anums))
  in
    dummy_anum_bnum_prs @ good_anum_bnum_prs
;;

let find_match_sets_b anum_bnum_prs = 
  let bnum_seqs = map snd (group_alist_entries anum_bnum_prs)
  in let sfilter seq = all_distinct (remove_if (\x.x=0) seq)
  in let good_bnum_seqs = filter sfilter (all_permutations bnum_seqs)
  in let seq_lt s1 s2 = 
      length (remove_if (\x.x=0) s1) < length (remove_if (\x.x=0) s2)
  in
     tl (mergesort seq_lt good_bnum_seqs)
;;

let find_match_sets tas tbs (match : term -> term -> bool) = 
  find_match_sets_b (find_match_sets_a tas tbs match)
;;
                               

let build_pat_inst_terms tas tbs seq = 
  let ta_tb_prs = 
    mapfilter
      (\i,ta. ta,nth i tbs) (zip seq tas)
  in let tas',tbs' = unzip ta_tb_prs
  in
    mk_iterated_and tas', mk_iterated_and tbs'
;;


let AutoInstConclPart  
      type_inf_fun 
      type_matcher
      prop_matcher 
      hs
      n
      match_hint_sub
      p
      =
  let c = concl p
  in let e = env_of_sequent p
  in let addr,xAs,ptms = nth n (dest_general_ex_formula c)
  in let xs = map fst xAs
  in let itms = map (\i.type_of_hyp i p) hs
  in let match_p ptm itm = 
    (prop_matcher [] xs ptm itm ; true) ? false
  in let itm_num_seqs = find_match_sets ptms itms match_p 
  in let match_itm_num_seq seq =
         let ptm,itm = build_pat_inst_terms ptms itms seq
         in
           seq
           ,match_in_context_with_ti_and_ms
                  type_matcher
                  type_inf_fun
                  xAs
                  prop_matcher 
                  ptm
                  itm
                  match_hint_sub
                  e
  in let good_seq,sub = 
       first_value match_itm_num_seq itm_num_seqs
       ? failwith `AutoInstConcl: no match found`
  in 
  ( InstConclByAddr addr (map snd sub)
    THENM Try Trivial
  ) p
;;


let AutoInstConcl hs p = 
  let hs' = if null hs then (upto 1 (length (hyps p))) else hs
  in let match_hint_sub = get_sub_arg `sub` p ? [] 
  in let n = get_int_arg `n` p ? 1
  in
     AutoInstConclPart  
      get_type_using_env
      (half_match_with_retry get_hard_and_supertype_alts)
      (regular_half_match (-1))
      hs'
      n
      match_hint_sub
      p
;;
     
