package FDL.term;

import FDL.term.*;

// chars in java are UNICODE! so convert ascii to unicode as bytes are read.
public class SParameter extends Parameter {

    private String value;

    public String getValue() {
	return value; 
    }

    public SParameter (String t, String v) {
	type = t;
	value = v;
    }

    public String toString() {
	return value + ":" + type;
    }

    public boolean equals(SParameter p) {
	//System.out.println(p.type + " " + type + " " + (p.type).equals(type));
	return ((p.type).equals(type)  && (p.value).equals(value));
    }

    public static SParameter natParm (int i) throws Exception {
	if (i < 0) { throw new Exception("natParm int not nat"); }
	return new SParameter("n", Integer.toString(i,10));
    }

    public static SParameter boolParm (boolean b) throws Exception {
	if (b) { return new SParameter("b", "T"); }
	else { return new SParameter("b", "F"); }
    }
    
    public static SParameter opidParm (String opid) {
	return new SParameter("OPID",opid);
    }

    public static SParameter tokParm (String tok) {
	return new SParameter("t", tok);
    }

    public static SParameter stringParm (String s) {
	return new SParameter("s", s);
    }

    //Lori added XML here
    public String XMLStringOf() {
	String xml = "\n\t\t&lt;fdl:param&gt;";
	
	//type
	xml = xml.concat("\n\t\t\t&lt;fdl:paramtype&gt;");
	xml = (xml.concat(type)).concat("&lt;/fdl:paramtype&gt;");

	//val
	xml = xml.concat("\n\t\t\t&lt;fdl:paramvalue&gt;");
	xml = (xml.concat(value)).concat("&lt;/fdl:paramvalue&gt;");
	
	return (xml.concat("\n\t\t&lt;/fdl:param&gt;"));
    }
}
