package FDL.term;

import java.io.*;

// need to covert any non-trivial char to unicode.
// non-trivial?

public class TermWriter extends TermSyntax {

    private OutputStream writer;
    private char cur;
    private boolean readaheadp = false;

    private StringBuffer charsread = new StringBuffer ();

    public TermWriter (OutputStream s) { writer = s; }

    public void writeByte (byte b) throws IOException {
	writer.write(b);
    }

    public void write (String s) throws IOException { 

	char c;

	boolean unip = false;
	String unistring;
	int uniint;

	for ( int i=0; i < s.length(); i++) {
	    c = s.charAt(i);
	    if (special(c)) {
		writeByte(escape);
		writeByte((byte)c);
	    }
	    else if (standard(c)) {
		writeByte((byte)c);
	    }
	    else {
		// unicode. ie \xxxx

		writeByte(escape);

		uniint = (int)c;
		unistring = Integer.toString(uniint,16);

		for (int j= (4 - unistring.length()); j > 0; j--) {
		    writeByte((byte)'0');
		}
		
		for (int j=0; j < unistring.length(); j++) {
		    writeByte((byte)unistring.charAt(j));
		}
	    }
	}
    }


}

