
package FDL.workingmap;

import java.util.*;
import FDL.term.*;

public class ObjectProperty {
 
    private String skey;
    private ObjectId okey;
    private Term value;

    private boolean okeyed = false;

    public ObjectProperty (ObjectId key, Term v) {
	okeyed = true;
	okey = key;
	value = v;
    }

    public ObjectProperty (String key, Term v) {
	skey = key;
	value = v;
    }

    public String toString () {
	String keystr;
	if (okeyed) { keystr = okey.toString(); }
	else { keystr = skey; }

	return "{ObjectProperty " + keystr + "}";
    }

    public Term toTerm () {
	Parameter[] p = new Parameter[2];
	p[0] = SParameter.opidParm("!property");

	if (okeyed) { p[1] = new OParameter(okey); }
	else { p[1]= SParameter.tokParm(skey); }

	Term[] ts = { value };
	return (new Term(p, ts));
    }

    public Term getValue()    { return value;  }
    public ObjectId getOKey() { return okey;   }
    public String getSKey()   { return skey;   }
    public boolean okeyed ()  { return okeyed; }
}

//public abstract interface propToTerm {
//    public abstract Term f(ObjectProperty p);
//}
