%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%
%
******************************************************************************
Invisible variables
******************************************************************************
%

let mk_invisible_var tok = 
  mkv (`%` ^ tok)
;;

let basic_invisible_var = mkv `%` ;;

let is_invisible_var v =
  let h.t = explode (var_to_tok v) in
    h = `%`
;;

let is_visible_var v = not is_null_var v & not is_invisible_var v
;;

let lib_unfold_ap = null_ap (itext_term "lib_unfold ");;
let lib_unfold term = lib_eval_to_term (term_ap lib_unfold_ap term);;

let unfold_ab t = lib_unfold t
;;
