
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;*************************************************************************
;*                                                                        *
;*      Projet     Formel                       LCF    Project            *
;*                                                                        *
;**************************************************************************
;*                                                                        *
;*            Inria                         University of Cambridge       *
;*      Domaine de Voluceau                   Computer Laboratory         *
;*      78150  Rocquencourt                    Cambridge CB2 3QG          *
;*            France                                England               *
;*                                                                        *
;**************************************************************************



; F-parsml.lisp   Original code: parsml (lisp 1.6) part of Edinburgh LCF
;                 by M. Gordon, R. Milner and C. Wadsworth   (1978)
;                 Transported by G. Huet in Maclisp on Multics, Fall 1981
; V4-1 Added primitive type obj  GH
;      Corrected bug sec-rtn


#-dontinline
(eval-when (compile)
  (proclaim '(inline
	      istypedec isabstypedec
	      declnchk idchk
	      mlinf-rtn mlcinf-rtn exfix-rtn appl-rtn lparen-rtn 
	      dupl-rtn failwith-rtn mltyp-rtn mlt mljuxt
	      )))




(defun parseml (pl)
       (prog (atom-rtn juxtlevel juxt-rtn *read-base* parsedepth)
	  (let ((*equal-parse-properties* nil)
		(*period-parse-properties* nil)
		(*semicolon-parse-properties* nil))
	    (setq atom-rtn '(mlatomr))
	    (setq juxtlevel 1010)
	    (setq juxt-rtn '(mljuxt arg1))
	    (setq *read-base* 10.)
	    (setq parsedepth 0)
	    (return (parse-pop pl)))))

(defun istypedec (class)
 (member class '(mk-deftype mk-defrectype mk-abstype mk-absrectype)))  ;istypedec

(defun isabstypedec (class)
  (member class '(mk-abstype mk-absrectype)))  ;isabstypedec

(defun declnchk (x msg)
  (cond ((member (car x) declnconstrs) x) (t (fail msg))))  ;delnchk

(defun ultabstr (e)
  (or (eql (car e) 'mk-abstr)
      (and (eql (car e) 'mk-straint) (ultabstr (cadr e)))))  ;ultabstr

(defun idchk (id msg)
      (cond ((or (numberp id) (member id spec-syms) (member id rsvdwds)) (fail msg))
          (t id)))  ;idchk




(defun mlt () (mlt1 (mlt2 (mlt3 (mlt4)))))  ;mlt

(defun mltyp-rtn () (list 'mk-straint arg1 (mlt)))  ;mltyp-rtn

(defun mlt1 (x)
    (cond ((eql token arrow-sym) (gnt) (list 'mk-funtyp x (mlt))) (t x)))  ;mlt1

(defun mlt2 (x)
     (cond ((eql token sum-sym) (gnt) (list 'mk-sumtyp x (mlt2 (mlt3 (mlt4)))))
         (t x)))  ;mlt2

(defun mlt3 (x)
    (cond ((eql token prod-sym) (gnt) (list 'mk-prodtyp x (mlt3 (mlt4))))
        (t x)))  ;mlt3

(defun mlt4 ()
    (prog       (x)
        (gnt)
        (cond ((eql ptoken lparen) (setq x (cond ((eql token rparen) (gnt) nil)
                                        (t (mlt5)))) (go l)))
        (setq x
              (list
                (cond
		  ((eql ptoken null-sym) '(mk-nulltyp))
		  ((eql ptoken mul-sym) (list 'mk-vartyp (vartype-rtn)))

		  ((not (eql ptoktyp 1))
		   (fail (concat ptoken '| is not allowed in a type|)))
		  ((eql ptoken '|int|) '(mk-inttyp))
		  ((eql ptoken '|bool|) '(mk-booltyp))
		  ((eql ptoken '|string|) '(mk-stringtyp))

		  ((member ptoken '(|token| |tok|)) '(mk-toktyp))
		  ((eql ptoken arrow-sym)
		   `(mk-null-funtyp ,(mlt)))
		  
		  ((name-to-abstract-type-mkid ptoken))

		  (t (list 'mk-consttyp ptoken)))))
l
	(cond ((or (not (eql toktyp 1)) (member token rsvdwds))
               (return
                 (cond ((not (eql (length x) 1)) (fail '(missing type constructor)))
		       (t (return (car x))))))
              (t (gnt)))
	(setq x (cond ((eql ptoken '|list|) (list (cons 'mk-listyp x)))
                 (t (list (cons 'mk-consttyp (cons ptoken x))))))
	(go l)))  ;mlt4

(defun mlt5 ()
    (prog       (x)
        (setq x (list (mlt)))
     loop       (cond ((eql token rparen) (gnt) (return x))
              ((eql token comma) (gnt) (setq x (append x (list (mlt)))) (go loop))
              (t (fail '|missing separator or terminator in type|)))))  ;mlt5

(defun mljuxt (x) (list 'mk-appn x (parse-pop 1020)))  ;mljuxt





(defun sec-rtn (x)
   (let ((l '||))
      (ifn (eql parsedepth 1)
         (fail '|sections can only be opened or closed at top level|))
      (do () ((eq token tml-sym))
           (ifn (or (eql token period) (eql toktyp 1))
                (fail '|bad section name|))

           (setq l (concat l token))
           (gnt))
      (cons x (if (null l) nil (list l)))))  ;sec-rtn   ;GH

(defun mlinfix2 (x typ)
  ;;(setf -x x -typ typ) (break "mlinfix2")
  (new-mldef (make-ml-definition :id x
				 :parse-properties
				 (new-ml-parse-properties 450 nil
							  (list (if (eql typ 'paired)
								    'mlinf-rtn
								    'mlcinf-rtn)
								(list 'quote x))))))  
#|  (binop x 450
	 (list (cond
		 ((eql typ 'paired) 'mlinf-rtn)
		 (t 'mlcinf-rtn))
	       (list 'quote x)))
|#

(defun mlinf-rtn (x)
   (list 'mk-appn (list 'mk-var x) (list 'mk-dupl arg1 (parse-pop 460))))  ;mlinf-rtn

(defun mlcinf-rtn (x)
   (list 'mk-appn (list 'mk-appn (list 'mk-var x) arg1) (parse-pop 460)))  ;mlcinf-rtn

(defun exfix-rtn ()
       (gnt)
       (list 'mk-var (cond ((eql ptoken tokbearer) (get tokbearer 'tokval))
                       (t ptoken))))  ;exfix-rtn


(defvar *sml-ast-p* nil)

(defmacro with-sml-ast (&body body)
  `(let ((*sml-ast-p* t))
    ,@body))

(defun sml-ast-term (term)
  (list 'MK-APPN (list 'MK-VAR '|sexprToTerm|)
	(list 'MK-STRINGCONST
	      (prin1-to-string (term-to-sexpr term)))))

(defun mlatomr ()
  (cond
    ((member ptoken spec-syms)
     ;;(break "mlatomr")
     (fail (concat ptoken '| cannot be a var|)))
    ((numberp ptoken) (list 'mk-intconst ptoken))
    ((eql ptoken tokbearer)
     (list 'mk-tokconst
	   (let ((x (get tokbearer 'tokval)))
	     (setf (get tokbearer 'tokval) (cdr x))
	     (car x))))
    ((eql ptoken toklbearer)
     (cons 'mk-list
	   (mapcar (function (lambda (x) (list 'mk-tokconst x)))
		   (let ((x (get toklbearer 'toklval)))
		     (setf (get toklbearer 'toklval) (cdr x))
		     (car x)))))
    ((eql ptoken string-bearer)
     (list 'mk-stringconst
	   (let ((x (get string-bearer 'string-val)))
	     (setf (get string-bearer 'string-val) (cdr x))
	     (car x))))

    (t (let ((const (bearer-to-abstract-type-constant ptoken)))
	 ;; RLE TODO This sml-ast-term stuff should be moved to the term add-primitive type in mlt-defs.
	 ;; RLE TODO otherwise bml depends on mlt.
	 (if const
	     (if (and *sml-ast-p* (eql const 'MK-TERM-CONST))
		 (sml-ast-term (abstract-type-pop-bearer ptoken))
		 (list const (abstract-type-pop-bearer ptoken)))
	     (list 'mk-var ptoken))))))		;mlatomr


(defun appl-rtn (pl rn)
 (let ((x arg1)) (parse-pop pl) (list 'mk-binop rn x arg1)))  ;appl-rtn

(defun lparen-rtn ()
       (cond ((eql token rparen) (gnt) '(mk-empty))
           (t (check rparen (parse-pop 15) '|bad paren balance|))))  ;lparen-rtn

(defun test-rtn  nil
       (prog (x1 x2 xl xt)
  loop (setq x1 (parse-pop 30))
       (setq xt token)
       (cond ((not (member xt '(|then| |loop|)))
            (fail '|missing then or loop after if|))
           (t (gnt)))
       (setq x2 (parse-pop 320))
       (setq xl (cons (cons (if (eql xt '|then|) 'once 'iter) (cons x1 x2)) xl))
       (cond ((member token '(|test| |if|)) (gnt) (go loop)))
       (setq xt token)
       (cond ((member xt '(|else| |loop|)) (gnt)
              (return (list 'mk-test
                        (reverse xl)
                        (cons (if (eql xt '|else|) 'once 'iter) (parse-pop 320)))))
           (t (return (list 'mk-test (reverse xl)))))))  ;test-rtn

;;;;	
;;;;	PERF : all these list calls will construct new lists each time the trap-rtn is called.
;;;;	PERF : probably other code like this in bml-*.
;;;;	
;;;;	

(defun trap-rtn (trap)
   (prog        (x x1 x2 xl)
        (setq x arg1)
   loop (setq x1 (parse-pop 1020))
          (if (member token trap-syms) (fail '|missing trap body|))
        (setq x2 (parse-pop 270))
        (setq xl (cons (cons trap (cons x1 x2)) xl))
        (cond ((member token trap-syms)
               (setq trap (if (member token (list trap-then-sym trapif-then-sym trapbind-then-sym))
			      'once
			      'iter))))
        (cond ((member token (list trapif-then-sym trapif-loop-sym)) (gnt) (go loop)))
        (cond ((member token (list trap-then-sym trap-loop-sym))
               (gnt)
               (return (list 'mk-trap x (reverse xl) (cons trap (parse-pop 240))))))
        (cond ((member token (list trapbind-then-sym trapbind-loop-sym))
               (gnt)
               (return
                 (list 'mk-trap x (reverse xl)
                     (cons (cons trap token) (prog2 (gnt) (parse-pop 270)))))))
        (return (list 'mk-trap x (reverse xl)))))  ;trap-rtn

(defun trapbind-rtn (trap)
  (list 'mk-trap arg1 nil
        (cons (cons trap (idchk token (concat token '| cannot be bound|)))
            (prog2 (gnt) (parse-pop 270)))))  ;trapbind-rtn

(defconstant *semicolon-list-ml-parse-properties*
  (new-ml-parse-properties 20 nil '(seq-rtn)))

(defun list-rtn ()
  (prog (l)

     loop

       (when (eql token rbrkt)
	 (gnt)
	 (return (cons 'mk-list (reverse l))))

       (let ((*semicolon-parse-properties* *semicolon-list-ml-parse-properties*))
	 (setq l (cons (parse-pop 30) l)))

       (if (eql token rbrkt)
	   (go loop)
	   (progn
	     (check scolon arg1 '|funny list separator|)
	     (go loop)))))

(defun seq-rtn ()
  (let ((xl (list arg1)))

    (tagbody

     loop

       (setq xl (cons (parse-pop 160) xl))
       (when (eql token scolon)
	 (gnt)
	 (go loop))
       (return-from seq-rtn (list 'mk-seq (reverse (cdr xl)) (car xl))))))

(defun let-rtn (class)
       (setq arg1 (bind-rtn class))
       (cond ((eql token '|in|) (gnt) (in-rtn))
           ((< 1 parsedepth)
            (fail '|non top level decln must have in clause|))
           (t arg1)))  ;let-rtn

(defconstant *equal-bind-ml-parse-properties*
  (new-ml-parse-properties 30 nil '(fail '|= inside definiend|)))

(defun bind-rtn (class)
    (prog       (dl x y)

       (cond ((isabstypedec class) (return (abstypbind-rtn class)))
	     ((istypedec class) (return (typbind-rtn class))))
       
       l1

       (let ((*equal-parse-properties* *equal-bind-ml-parse-properties*))
	 (setq x (check eq-sym (parse-pop 50) '|lost = in decln|)))
       
       (setq y (parse-pop 120))
	
      l2        (cond ((eql (car x) 'mk-straint)
               (setq y (list 'mk-straint y (caddr x)))
               (setq x (cadr x))
               (go l2))
              ((eql (car x) 'mk-appn) (go l4))
              ((eql (car x) 'mk-var) (go ok))
              ((eql class 'mk-letrec) (fail '|illegal form of letrec|))
              (t nil))
          (chkvarstr x
               '|multiple binding occurence of var in decln|
               '|illegal form of declaration|)
        (go ok)
      l4        (setq y (list 'mk-abstr
                    (chkvarstr (caddr x)
                             '|multiply occurring fn param|
                             '|bad fn param structure|)
                    y))
          (setq x (cadr x))
      l5        (cond ((eql (car x) 'mk-straint)
               (setq y (list 'mk-straint y (caddr x)))
               (setq x (cadr x))
               (go l5))
              ((eql (car x) 'mk-appn) (go l4))
              ((eql (car x) 'mk-var) (go ok))
              (t (fail '|bad definiend of function|)))
      ok        (cond
          ((and (eql class 'mk-letrec) (not (ultabstr y)))
           (fail '|letrec of non-function|)))
          (setq dl (cons (cons x y) dl))
        (cond ((eql token '|and|) (prog2 (gnt) (go l1))))
        (setq x (caar dl))
        (setq y (cdar dl))
      l9        (setq dl (cdr dl))
        (cond
          ((null dl)
           (return (list class (chkvarstr x '|multiply occurring var in declaration| nil) y))))
        (setq x (list 'mk-dupl (caar dl) x))
        (setq y (list 'mk-dupl (cdar dl) y))
        (go l9)))  ;bind-rtn

(defun typbind-rtn (class)
    (prog       (dl)
     loop       (cond ((not (eql toktyp 1)) (fail (concat token '| not allowed as a type|)))
              ((member token bastypes) (fail (concat token '| must not be redefined|)))
	      ((abstract-type-name-p token)
	       (fail (concat token '|defined abstract type. must not be redefined|)))

	      ((not (null (assoc token dl))) (fail (concat token '| defined more than once|)))
              ((not (eql (gnt) eq-sym)) (fail '|missing = in type declaration|)))
     (setq dl (cons (cons ptoken (prog2 (gnt) (mlt))) dl))
     (cond ((eql token '|and|) (gnt) (go loop)))
     (return (list class dl))))  ;typbind-rtn

(defun abstypbind-rtn (class)
   (prog        (tyargs dl)
    loop        (setq tyargs nil)
          (cond ((eql token mul-sym) (gnt) (setq tyargs (list (vartype-rtn))))
              ((eql token lparen) (if (eql (gnt) rparen) (gnt) (go l2))))
      l1        (cond ((not (eql toktyp 1)) (fail '|bad type constructor|))
              ((not (eql (gnt) eq-sym)) (fail '|bad type constructor|)))
          (setq dl (cons (cons ptoken (cons tyargs (prog2 (gnt) (mlt)))) dl))
        (cond ((eql token '|and|) (gnt) (go loop))
              ((eql token '|with|) (gnt))
              (t (fail '|missing with|)))
        (return (list class dl (bind-rtn 'mk-let)))
      l2        (cond ((not (eql token mul-sym)) (fail '|type constructor's args not variables|)))
          (gnt)
        (setq tyargs (append tyargs (list (vartype-rtn))))
        (cond ((eql token comma) (gnt) (go l2))
              ((eql token rparen) (gnt) (go l1))
              (t (fail '|bad args to type constructor|)))))  ;abstyp-rtn

(defun chkvarstr (x msg1 msg2)
       (chkvarstrx x nil msg1 msg2) x)  ;chkvarstr

(defun chkvarstrx (x idlst msg1 msg2)
    (cond       ((eql (car x) 'mk-straint) (chkvarstrx (cadr x) idlst msg1 msg2))
        ((eql (car x) 'mk-var)
         (if (member (cadr x) idlst) (fail msg1) (cons (cadr x) idlst)))
        ((eql (car x) 'mk-dupl)
         (chkvarstrx (caddr x) (chkvarstrx (cadr x) idlst msg1 msg2) msg1 msg2))
        ((eql (car x) 'mk-empty) idlst)
        ((eql (car x) 'mk-list)
         (itlist (function (lambda (x idlst) (chkvarstrx x idlst msg1 msg2))) (cdr x) idlst))
        ((and (eql (car x) 'mk-binop) (eql (cadr x) '|.|))
         (chkvarstrx (cadddr x) (chkvarstrx (caddr x) idlst msg1 msg2) msg1 msg2))
        (t (fail msg2))))  ;chkvarstrx

(defun in-rtn ()
    (list       (cond ((isabstypedec (car arg1)) 'mk-ina)
              ((istypedec (car arg1)) 'mk-ind)
              (t 'mk-in))
        (declnchk arg1 '|in must follow decln|)
        (parse-pop 100)))  ;in-rtn

(defun where-rtn (class)
    (let ((e arg1))
         (list (cond ((isabstypedec class) 'mk-ina)
                 ((istypedec class) 'mk-ind)
                 (t 'mk-in))
             (declnchk (bind-rtn class) '|bad decln in where|)
             e)))  ;where-rtn

(defconstant *lambda-period-ml-parse-properties*
  (new-ml-parse-properties 220 nil '(appl-rtn 210 '|.|)))

(defun lamb-rtn ()
  ;;(break "lamb-rtn0")
  (let ((iter nil)
	(nullaryp (eql token period)) ;-- nullary lambda.
	)

    (let ((*period-parse-properties* *lambda-period-ml-parse-properties*))
      
      ;;(break "lamb-rtn")
      (if nullaryp
	  (gnt)
	  (setq iter (parse-pop 230))))
	
    ;;(break "lamb-rtn2")
    (if nullaryp
	`(mk-null-abstr ,(parse-pop 130))
	(iter-rtn (check period iter '|lost period in abstrn|)
		  (parse-pop 130)))))

(defun iter-rtn (a b)
    (cond       ((eql (car a) 'mk-appn)
         (iter-rtn (cadr a)
                (list 'mk-abstr
                      (chkvarstr (caddr a)
                               '|multiple lambda binding for var|
                               '|bad var structure in iterated abstrn|)
                      b)))
        (t (list 'mk-abstr
                 (chkvarstr a
                        '|multiple lambda binding for var|
                        '|bad var structure in abstrn|)
                 b))))  ;iter-rtn

(defun assign-rtn ()
    (list       'mk-assign
        (chkvarstr arg1
                 '|var duplicated on left of assgt|
                 '|bad left hand side of assgt|)
        (parse-pop 350)))  ;assign-rtn

(defun dupl-rtn () (list 'mk-dupl arg1 (parse-pop 370)))  ;dupl-rtn

(defun cond-rtn ()
    (prog       (x1 x2 xl)
     loop       (setq x1 arg1)
          (setq x2 (parse-pop 30))
        (setq xl (cons (cons 'once (cons x1 x2)) xl))
        (cond ((not (eql token else-sym)) (fail (list 'missing else-sym))) (t (gnt)))
        (parse-pop 430)
        (cond ((eql token condl-sym) (gnt) (go loop)))
        (return (list 'mk-test (reverse xl) (cons 'once arg1)))))
    ;cond-rtn

(defun failwith-rtn () (list 'mk-failwith (parse-pop 340)))  ;failwith-rtn

; quotations       REMOVED BY PRL
;-- (defun cnr-rtn ()
;--     (check endcnr-sym
;--      (selectq token
;--           (|:| (gnt) (list 'mk-tyquot (olt)))
;--           (t (list 'mk-quot (parse-ol)))) 
;--      '|cannot find end of quotation|))  ;cnr-rtn




(setq bastypes '(|int| |bool| |token| |tok| |.| |string|)) ;-- PRL
(setq metaprec 20)

(defun make-ml-parse-prop2 (sym llp l2)
  (new-mldef-pp sym llp nil l2))
	
(defun make-ml-parse-prop1 (sym llp l1)
  (new-mldef-pp sym llp l1 nil))
	
(defun make-ml-parse-prop-lang1 (sym l1)
  (new-mldef-pp sym nil l1 nil))

(defun make-ml-parse-prop-lang2 (sym l2)
  (new-mldef-pp sym nil nil l2))

(defun make-ml-parse-prop-langlp (sym llp)
  (new-mldef-pp sym llp nil nil))

(defun make-ml-parse-prop12 (sym llp l1 l2)
  (new-mldef-pp sym llp l1 l2))

	 
(progn
  (make-ml-parse-prop2 eq-sym 540 '(appl-rtn 550 '=))
  (make-ml-parse-prop2 period 650  '(appl-rtn 640 '|.|))
  (make-ml-parse-prop2 scolon 150 '(seq-rtn))
  (make-ml-parse-prop2 trap-then-sym 250
			     '(list 'mk-trap arg1 nil (cons 'once (parse-pop 240))))
  (make-ml-parse-prop2 trap-loop-sym 250
			     '(list 'mk-trap arg1 nil (cons 'iter (parse-pop 240))))
  (make-ml-parse-prop2 trapif-then-sym 260 '(trap-rtn 'once))
  (make-ml-parse-prop2 trapif-loop-sym 260 '(trap-rtn 'iter))
  (make-ml-parse-prop2 trapbind-then-sym 260 '(trapbind-rtn 'once))
  (make-ml-parse-prop2 trapbind-loop-sym 260 '(trapbind-rtn 'iter))
  (make-ml-parse-prop2 '|in| 60 '(in-rtn))
  (make-ml-parse-prop2 '|where| 150 '(where-rtn 'mk-let))
  (make-ml-parse-prop2 '|whererec| 150 '(where-rtn 'mk-letrec))
  (make-ml-parse-prop2 '|whereref| 150 '(where-rtn 'mk-letref))
  (make-ml-parse-prop2 '|wheretype| 150 '(where-rtn 'mk-deftype))
  (make-ml-parse-prop2 '|whereabstype| 150 '(where-rtn 'mk-abstype))
  (make-ml-parse-prop2 '|whereabsrectype| 150 '(where-rtn 'mk-absrectype))
  (make-ml-parse-prop2 asgn-sym 360 '(assign-rtn))
  (make-ml-parse-prop2 comma 400 '(dupl-rtn))
  (make-ml-parse-prop2 condl-sym 440 '(cond-rtn))
  (make-ml-parse-prop2 conj-sym 520 '(appl-rtn 510 '%&))
  (make-ml-parse-prop2 lt-sym 600 '(appl-rtn 610 lt-sym))
  (make-ml-parse-prop2 gt-sym 560 '(appl-rtn 570 gt-sym))
  (make-ml-parse-prop2 conc-sym 630 '(appl-rtn 620 conc-sym))
  (make-ml-parse-prop2 plus-sym 700 '(appl-rtn 710 plus-sym))
  (make-ml-parse-prop2 mul-sym 740 '(appl-rtn 750 mul-sym))
  (make-ml-parse-prop2 div-sym 720 '(appl-rtn 730 div-sym))
  (make-ml-parse-prop2 colon 770 '(mltyp-rtn))
  (make-ml-parse-prop2 disj-sym 500 '(appl-rtn 470 '|%or|))

  (make-ml-parse-prop1 tml-sym 0 '(fail '(stuff missing)))
  (make-ml-parse-prop1 '|if| 310 '(test-rtn))
  (make-ml-parse-prop1 '|else| 20 '(list 'mk-test nil (cons 'once (parse-pop 320))))
  (make-ml-parse-prop1 '|loop| 20 '(list 'mk-test nil (cons 'iter (parse-pop 320))))

  (make-ml-parse-prop12  mns-sym 660
			      '(list 'mk-unop '%- (parse-pop 760))
			      '(appl-rtn 710 mns-sym)) ;-- 710 was 670.  caused bug 4-4+1=-1

  (make-ml-parse-prop-lang1 '|begin| '(sec-rtn 'mk-begin))
  (make-ml-parse-prop-lang1 '|end| '(sec-rtn 'mk-end))
  (make-ml-parse-prop-lang1 '|true| ''(mk-boolconst t))
  (make-ml-parse-prop-lang1 '|false| ''(mk-boolconst nil))
  (make-ml-parse-prop-lang1 '|fail| ''(mk-fail))
  (make-ml-parse-prop-lang1 '|break| ''(mk-fail))
  (make-ml-parse-prop-lang1 exfix-sym '(exfix-rtn))
  (make-ml-parse-prop-lang1 lparen '(lparen-rtn))
  (make-ml-parse-prop-lang1 '|do| '(list 'mk-unop '|do| (parse-pop 410)))
  (make-ml-parse-prop-lang1 lbrkt '(list-rtn))
  (make-ml-parse-prop-lang1 '|let| '(let-rtn 'mk-let))
  (make-ml-parse-prop-lang1 '|letrec| '(let-rtn 'mk-letrec))
  (make-ml-parse-prop-lang1 '|letref| '(let-rtn 'mk-letref))
  (make-ml-parse-prop-lang1 '|deftype| '(let-rtn 'mk-deftype))
  (make-ml-parse-prop-lang1 '|lettype| '(let-rtn 'mk-deftype))
  (make-ml-parse-prop-lang1 '|abstype| '(let-rtn 'mk-abstype))
  (make-ml-parse-prop-lang1 '|absrectype| '(let-rtn 'mk-absrectype))
  (make-ml-parse-prop-lang1 lam-sym '(lamb-rtn))
  (make-ml-parse-prop-lang1 '|failwith| '(failwith-rtn))
  (make-ml-parse-prop-lang1 '|breakwith| '(failwith-rtn))
  (make-ml-parse-prop-lang1 '|not| '(list 'mk-unop '|not| (parse-pop 530)))
  ;;(make-ml-parse-prop-lang1 cnr-sym '(cnr-rtn))       ;--  not used by prl.
	    
  (make-ml-parse-prop-langlp rparen 10)
  (make-ml-parse-prop-langlp '|eqindec| 30)
  (make-ml-parse-prop-langlp '|and| 70)
  (make-ml-parse-prop-langlp '|perinlam| 140)
  (make-ml-parse-prop-langlp rbrkt 20)
  (make-ml-parse-prop-langlp '|perinvs| 220)
  (make-ml-parse-prop-langlp '|then| 20)
  (make-ml-parse-prop-langlp else-sym 20)
  (make-ml-parse-prop-langlp '|mlinfix| 450)
  (make-ml-parse-prop-langlp '|primary| 1010)
  )
