
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)


;**************************************************************************
;*                                                                        *
;*      Projet     Formel                       LCF    Project            *
;*                                                                        *
;**************************************************************************
;*                                                                        *
;*            Inria                         University of Cambridge       *
;*      Domaine de Voluceau                   Computer Laboratory         *
;*      78150  Rocquencourt                    Cambridge CB2 3QG          *
;*            France                                England               *
;*                                                                        *
;**************************************************************************

; F-writml.lisp   Original code: writml (lisp 1.6) part of Edinburgh LCF
;                 by M. Gordon, R. Milner and C. Wadsworth   (1978)
;                 Transported by G. Huet in Maclisp on Multics, Fall 1981
;
; Changed top level declaration printing.  8/27 MB


#-dontinline
(eval-when (compile)
  (proclaim '(inline
	      ml-print_int ml-print_bool ml-print_tok ml-print_void ml-print_string     
	      )))

(defun prlet (descriptors)
  (dolist (desc descriptors)
    (pstring (desc-id desc))
    (ptoken | = |) (pbreak 0 0)
    (prvalty (symbol-value (desc-name desc))
	     (tidy1 (get-mltype (desc-id desc))))))

; Print value, type of top-level expression
(defun prvalty (x ty)
  (prinml x ty nil)
  (pbreak 1 0)
  (ptoken |: |)
  (printmty ty)
  (pnewline))  ;prvalty

; Print result of "lettype"
(defun prdefty (idtyl)
  (ptoken |type |)
  (mapc #'(lambda (idty) (pstring (car idty))(pbreak 1 0)) idtyl)
  (ptoken |defined|)(pnewline))  ;prdefty


(defunml (|print_int| (n) :error-wrap-p nil) (int -> |.|)
  (pstring (princ-to-string n)))

(defunml (|print_tok| (tok) :error-wrap-p nil) (token -> |.|)
  (ptoken |`|)(pstring tok)(ptoken |`|))


(defunml (|print_bool| (b) :error-wrap-p nil) (bool -> |.|)
  (if b (ptoken true) (ptoken false)))

(defunml (|print_void| (unit)
		       :error-wrap-p nil
		       :declare ((declare (ignore unit))))
    (|.| -> |.|)

  (ptoken |()| ))

(defunml (|print_string| (str) :error-wrap-p nil) (string -> |.|)
  (pstring (concatenate 'string "\"" str "\"")))

; needs better treatment of tuples
; the parameter "cl" requests surrounding parentheses
(defun prinml (x ty cl)
      (if (atom ty)
	  (ptoken |-|)
	  (or (let ((s (print-abstract-type-instance (car ty) x)))
		(when s
		  (if (stringp s)
		      (pstring s)
		      (ppmsg s))
		  t))
	      (case (car ty)
		(mk-nulltyp (ml-print_void x))
		(mk-inttyp (ml-print_int x))
		(mk-toktyp (ml-print_tok x))
		(mk-booltyp (ml-print_bool x))
		(mk-stringtyp (ml-print_string x))
		(mk-listyp (print_list x (cadr ty)))
		(mk-sumtyp (print_sum x ty cl))
		(mk-prodtyp (print_prod x ty cl))
		(otherwise (ptoken |-|))
		))))			;prinml



; Print a list x whose ELEMENTS have type ty
(defun print_list (x ty)
    (pbegin 1)
    (ptoken |[|)
    (cond (x
            (prinml(car x) ty nil)
            (mapc #'(lambda (y) (ptoken |;|) (pbreak 1 0) (prinml y ty nil))
               (cdr x))))
    (ptoken |]|)
    (pend))     ; print_list



; Print value x of sum type ty
(defun print_sum (x ty cl)
    (if cl (ptoken |(|))
    (cond
     ((car x)(ptoken |inl |)(prinml (cdr x)(cadr ty) t))
     (t (ptoken |inr |)(prinml (cdr x)(caddr ty) t)))
    (if cl (ptoken |)|)))



; Print value x of product type ty
(defun print_prod (x ty cl)
    (if cl (ptoken |(|))
    (prinml(car x)(cadr ty) t)
    (ptoken |,|) (pbreak 0 0)
    (prinml (cdr x)(caddr ty) nil)
    (if cl (ptoken |)|)))


