
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;;; RLE TODO need to rethink these equalities
;;; RLE TODO inline??

;;;; -docs- (mod mlt)
;;;;
;;;;	New primitive ML types for terms :
;;;;
;;;;	variable
;;;;	level_expression
;;;;	parameter
;;;;	term
;;;;
;;;;	In a break with tradition, the polymorphic equality for defined primitive types
;;;;	will be eq. If this entails to much milling of ML code, then I may reconsider.
;;;;
;;;;
;;;;	ml-term (<text-term> &optional (<bool:displayp}> t))	: <ml-result>
;;;;	vml-term (<text-term> &optional (<bool:displayp}> t))	: (values <ml-type> <ml-print>)
;;;;	ast-ml-term (<text-term> &optional (<bool:displayp}> t))
;;;;	 : (values <ml-ast> <ml-type> <ml-print>)
;;;;
;;;;	ml-term-apply(<text-term> <term> list &optional (<bool:displayp}> t))
;;;;	 : <ml-result>
;;;;	vml-term-apply(<text-term> <term> list &optional (<bool:displayp}> t))
;;;;	 : (values <ml-type> <ml-print>)
;;;;
;;;; -doce-

;;; RLE NAP do we need ast-ml-term-apply ??

;;; level-expressions
(defvar *no-wrap* nil)
(defvar *level-expression-unique-id* (cons 'level-expression nil))

;; removing wrappers temporarily as no need to identify currently.
(defun ml-level-expression (le)
  (if *no-wrap*
      le
    (cons *level-expression-unique-id*
	  le)))

(defun ml-level-expression-p (le)
  (and (consp le)
       (eql *level-expression-unique-id* (car le))))

(defun unml-level-expression (ml-le)
   (if *no-wrap*
       ml-le
     (cdr ml-le)))

;;(defmacro with-ml-level-expression (f expr)
;;  `(ml-level-expression (funcall ,f (unml-level-expression ,expr))))


(defun define-ml-term-primitive-types ()

  (add-primitive-type *variable*
		      #'(lambda (v)
			  (let ((s (parameter-value-to-pretty-string v *variable-type*)))
			    (if (string= "" s) "~" s))))

  (add-tok-parse-hook *variable* 
		      #'(lambda (ch tokchs)
			  (when (and (eql ch '|'|) (not (ml-escape-p)))
			    (values t
				    `(get-variable-id ,(implode-toks-to-string (reverse tokchs)))))))
  

  (add-primitive-type '|level_expression|
		      #'(lambda (l) (parameter-value-to-pretty-string (unml-level-expression l)
								      *level-expression-type*))
		      )

  (add-primitive-type '|parameter|
		      ;; could inject into a term instead??
		      #'(lambda (p) (parameter-to-pretty-string p :include-type-id t))
		      :member-p #'parameter-p
		      :eq-func #'(lambda (p q)
				   (if *process-break*
				       (break "parameter-=")
				       (format t "parameter-="))
				   (message-emit (warn-message '(= parameter)))
				   (eql p q)))

  (add-primitive-type '|term|
		      #'(lambda (term)
			  (itext-term-literal-term term))
		      :parse-func #'(lambda (term) (when (term-p term) (values t term)))
		      :member-p #'term-p
		      :eq-func #'(lambda (a b)
				   ;;(funmlcall (ml-text "view_oid") (current-object-id))
				   (if (or nil *process-break*)
				       (break "term-=")
				       (format t  "term-="))
				   (message-emit (warn-message '(= term)))
				   (eql a b)))
  )



(define-ml-term-primitive-types)

(defun define-ml-float-primitive-type ()
    (add-primitive-type '|float|
		      #'(lambda (x)
			  ;;(setf -x x) (break "printf")
			  (format nil "~a" x))
		      :member-p #'floatp
		      :eq-func #'eql
		      ))

(define-ml-float-primitive-type)

(defunml (|string_to_float| (s))
    (string -> float)

  (let ((v (let ((vv (read-from-string s)))
	     (if (integerp vv)
		 (coerce vv 'single-float)
		 vv))))
    (unless (floatp v)
      (raise-error (error-message '(string float not) s)))
    v))

(defunml (|float_to_string| (f))
    (float -> string)
  (princ-to-string f))

(defunml (|add_floats| (a b))
    (float -> (float -> float))
  (+ a b))

(defunml (|subtract_floats| (a b))
    (float -> (float -> float))
  (- a b))

(defunml (|multiply_floats| (a b))
    (float -> (float -> float))
  (* a b))

(defunml (|divide_floats| (a b))
    (float -> (float -> float))
  (/ a b))

(defunml (|float_less| (a b))
    (float -> (float -> bool))
  (< a b))

(dml |float_round| 1 round (float -> int))
(dml |float_truncate| 1 truncate (float -> int))
(dml |float_ceiling| 1 ceiling (float -> int))
(dml |float_floor| 1 floor (float -> int))


;;; mlt-eval
(defun ml-term (term &optional (displayp t))
  (ml-text (term-to-text term) displayp))

(defun ml-term-apply (term terms  &optional (displayp t))
  (if terms
      (ml-text (list "("
		     (term-to-text term)
		     ") ["
		     (car terms)
		     (mapcar #'(lambda (term) (cons ";" term))
			     (cdr terms))
		     "]")
	       displayp)
      (ml-text (list "(" (term-to-text term) ")[]") displayp)))

(defun ml-terms-to-term (term args)
  (let ((value (ml-term-apply term args nil)))
    (if (term-p value)
	value
      (raise-error (error-message '(ml terms-to-term term not))))))

(defun vml-term (term &optional (displayp t))
  (vml-text (term-to-text term) displayp))

(defun vml-term-apply (term terms &optional (displayp t))
     (if terms
      (vml-text (list "("
		      (term-to-text term)
		      ") ["
		      (car terms)
		      (mapcar #'(lambda (term) (cons ";" term))
			      (cdr terms))
		      "]")
		displayp)
      (vml-text (list "ap (" term ")[]") displayp)))


(defun ast-ml-term (term)
  (ast-ml-text (term-to-text term)))

(defun ast-ml-term-apply (term terms)
  (if terms
      (ast-ml-text (list "("
			 (term-to-text term)
			 ") ["
			 (car terms)
			 (mapcar #'(lambda (term) (cons ";" term))
				 (cdr terms))
			 "]"))
      (ast-ml-text (list "ap (" term ")[]"))))



;;;;
;;;;	Pathnames :
;;;;

(defunml (|system_path_prefix| (unit) :declare ((declare (ignore unit))))
  (unit -> string)

  (namestring *system-path-prefix*))
  

(defunml (|extend_path| (path dirs) :error-wrap-p nil)
    (string -> ((string list) -> string))

  (prl-extend-pathname path dirs))

;; "" type -> null type
(defunml (|make_filename| (path dirs fname type))
    (string -> ((string list) -> (string -> (string -> string))))
  (prl-make-filename path dirs fname (unless (string= "" type) type)))




(defunml (|failure_message| (unit) :declare ((declare (ignore unit))))
    (unit -> term)
  (let ((m (if (boundp `*trap-message*)
	       *trap-message*
	       (basic-message '(ml-trap message unbound)))))
    ;;(break "fm")
    (cond
      ((or (symbolp m)
	   (stringp m))
       (message-to-term (basic-message '(ml-trap) m)))
      ((basic-message-p m)
       (message-to-term m))
      (t (message-to-term (basic-message '(ml-trap message not)))))))






(define-primitive |!ml_file_description| ((string . name) (time . src-date) (time . bin-date)))
(define-primitive |!mltype| ((token . type)) (subtype))

(defun subtypes-of-imltype-term (term) (mapcar #'term-of-bound-term-f (bound-terms-of-term term)))

(defun imltype-term-pp (term)
  (and (eql *imltype* (id-of-term term))
       (let ((parms (parameters-of-term term)))
	 (and parms
	      (null (cdr parms))
	      (token-parameter-p (car parms))))
       (forall-p #'(lambda (bt) (null (bindings-of-bound-term bt)))
		 (bound-terms-of-term term))))

(defun type-sexpr-to-term (tsexpr)
  (labels
      ((visit (tsexpr)
	 (if (consp tsexpr)
	     (if (consp (car tsexpr))
		 ;; do not expect this?
		 (icons-term (visit (car tsexpr)) (visit (cdr tsexpr)))
		 (instantiate-term (imltype-op (car tsexpr))
				   (mapcar #'(lambda (tsexpr) (instantiate-bound-term (visit tsexpr)))
					   (cdr tsexpr))))
	     (itoken-term tsexpr))))

    (visit tsexpr)))

(defun term-to-type-sexpr (tsexpr)
  (unless (ivoid-term-p tsexpr)
    (labels
	((visit (tsexpr)
	   (if (imltype-term-pp tsexpr)
	       (cons (type-of-imltype-term tsexpr)
		     (mapcar #'(lambda (bt)
				 (visit (term-of-bound-term bt)))
			     (bound-terms-of-term tsexpr)))
	       (if (itoken-term-p tsexpr)
		   (token-of-itoken-term tsexpr)
		   (if (icons-term-p tsexpr)
		       (cons (visit (icar tsexpr)) (visit (icdr tsexpr)))
		       (progn ;;(setf a tsexpr)
			      (break "tts")
			      'unknown-at-unmarshall))))))

      (visit tsexpr))))


(defunml (|mlbreak| (s) :declare ((declare (ignore unit))))
    (tok -> unit)

  (format t "~%MLbreak called :  ~a~%~%" s)
  (when (or ;;t
	 ;;(eql '|graph_find| s)
	 *process-break*)
    (break (string s))
    ))
  



;;;;	
;;;;	
;;;;	
;;;;	
;;;;	


(defunml (|decimal_string| (l num denom))
    (int -> (int -> (int -> string)))
  (ratio-to-decimal l num denom))


;; if casep t then case matters.
;; expects m to be substring of s otherwise bombs to lisp debugger.
(defunml (|string_split_by_char| (m s))
    (string -> (string -> (string |#| (tok |#| string))))

  (let ((ichars (istring m)))
    (block found
      (dotimes (i (length s))
	(when (member (ichar (char s i)) ichars)
	  ;;(break "ssbc")
	  (return-from found
	    (cons (subseq s 0 i) (cons (implode-to-string (list (char s i))) (subseq s (1+ i)))))))
    
      (raise-error (error-message '(string_split_by_char search found not) m s))))) 

(defunml (|string_split| (casep m s))
    (bool -> (string -> (string -> (string |#| string))))

  (string-split m s casep))
			 
(defunml (|string_match_f| (casep m))
    (bool -> (string -> (string -> bool)))

  (make-closure (string-pattern-search #'identity m casep)
		1)
  )

(dml |string_length| 1 length (string -> int))

(defunml (|string_lt| (a b))
    (string -> (string -> bool))
  (and (string< a b) t))

(defunml (|is_substring| (s1 s2))
  (string -> (string -> bool))
  (and (search s1 s2) t))

(defunml (|is_string_prefix| (s1 s2))
  (string -> (string -> bool))

  (let ((l1 (length s1)))
    (unless (> l1 (length s2))
      (string= s1 s2 :end2 (length s1)))))

(defunml (|is_string_suffix| (s1 s2))
    (string -> (string -> bool))

  (let ((l1 (length s1))
	(l2 (length s2)))
    (unless (> l1 l2)
      (string= s1 s2 :start2 (- l2 l1)))))

(defunml (|string_to_int_list| (s))
    (string -> (int list))

  (with-string-scanner (s)
    (scan-delimited-list
     #'(lambda () (scan-num))
     ilsquare irsquare
     #'(lambda ()
	 (scan-byte isemicolon)))))


;; looks at opid and parameters, does not look at bindings.
(defunml (|string_match_op| (f term))
    ((string -> bool) -> (term -> bool))

  ;;(format t "OPID ~%~a " (string (id-of-term term)))
  (or (funmlcall f (string (id-of-term term)))
      (exists-p #'(lambda (p)
		    ;;(format t "PARM ~%~a " (parameter-to-string p))
		    (funmlcall f (parameter-to-string p)))
		(parameters-of-term term))))
		


(defunml (|tok_upcase| (tok)  :error-wrap-p nil)
    (tok -> tok)

  (intern-system (string-upcase (string tok))))

(defunml (|string_upcase| (s) :error-wrap-p nil)
    (string -> string)

  (string-upcase s))

(defunml (|string_downcase| (s) :error-wrap-p nil)
    (string -> string)

  (string-downcase s))


;; PERF replace = with one of
;;  also do member and apply_alist.
(dml |equal_toks| 2 eql (token -> (token -> bool)))
(dml |equal_ints| 2 equal-ints-p (int -> (int -> bool)))

(defun new-var-index-aux (oldch xs)
  (let ((l (length xs))
	(index 0)
	(donep nil))
    (declare (integer index))
    (if (or (zerop l) (not (eql (char xs 0) oldch)))
      0
	(do ((i 1 (1+ i)))
	    ((or (= l i) donep)
	     index)
	  (let ((code (char-code (char xs i))))
	    (if (numeric-digit-code-p code)
		(let ((j (numeric-digit-code-to-int code)))
		  (setf index (if (zerop index)
				  j
				  (+ j (* index 10)))))
		(setf index 0
		      donep t)))))))

(defun new-var-aux (ch index)
  (declare (integer index))
  (let ((is (princ-to-string (1+ index))))
    (let ((l (length is)))
      (let ((s (make-string (1+ l))))
	(setf (char s 0) ch)
	(dotimes (i l)
	  (setf (char s (1+ i)) (char is i)))

	(get-variable-id s))) ))


#|
(defunml (|new_var| (old-var existing-vars) :error-wrap-p nil)
    (variable -> ((variable list) -> variable))

  ;;(setf -old-var old-var -existing-vars existing-vars) (break "new_var")

  (let ((olds (string old-var)))
    (when (zerop (length olds))
      (breakout evaluation '|HD|))
	  
    (let ((oldch (char olds 0))
	  (max-index 0))

      (declare (integer max-index))

      (dolist (xvar existing-vars)
	(let ((xs (string xvar)))
	  (let ((l (length xs))
		(index 0)
		(donep nil))
	    (declare (integer index))
	    (unless (zerop l)
	      (when (eql (char xs 0) oldch) 
		(do ((i 1 (1+ i)))
		    ((or (= l i) donep)
		     (setf max-index (max max-index index)))
		  (let ((code (char-code (char xs i))))
		    (if (numeric-digit-code-p code)
			(let ((j (numeric-digit-code-to-int code)))
			  (setf index (if (zerop index)
					  j
					  (+ j (* index 10)))))
			(setf index 0
			      donep t)))))))))

      ;;(let ((numdigits (1+ (floor (log 0 10))))) )
      (let ((is (princ-to-string (1+ max-index))))
	(let ((l (length is)))
	  (let ((s (make-string (1+ l))))
	    (setf (char s 0) oldch)
	    (dotimes (i l)
	      (setf (char s (1+ i)) (char is i)))

	    (get-variable-id s))) ))))

|#
(defunml (|new_var| (old-var existing-vars) :error-wrap-p nil)
    (variable -> ((variable list) -> variable))

  (let ((olds (string old-var)))
    (when (zerop (length olds))
      (breakout evaluation '|HD|))
	  
    (let ((oldch (char olds 0))
	  (max-index 0))

      (declare (integer max-index))

      (dolist (x existing-vars)
	(setf max-index
	      (max max-index
		   (new-var-index-aux oldch (string x)))))

      (new-var-aux oldch max-index) )))

      
(defunml (|read_text_file| (fname) )
    (string -> (string list))

  (mapcar #'(lambda (s)
	      (implode-to-string (mapcan #'(lambda (ich)
					     (cond
					       ((member ich '(inewline ireturn ispace))
						nil)
					       ((eql ich itab)
						(list ispace ispace ispace ispace ispace ispace ispace ispace)) 
					       (t (list ich)))
					     )
					 (istring s))))
	  (read-text-file fname)))

(defun well-formed-list (p l)
  (labels ((aux (l)
	     (or (null l)
		 (and (consp l)
		      (funcall p (car l))
		      (aux (cdr l))))))
    (aux l)))

(defun divide (p l)
  (let ((pp nil)
	(notpp nil))

    (dolist (x l)
      (if (funcall p x)
	  (push x pp)
	  (push x notpp)))

    (cons (nreverse pp) (nreverse notpp))))
  

(defunml (|read_proof_addresses| (fname))
  (string -> ((tok |#| ((int list) list)) list))
 (let* ((aa (read-sexpr-file fname))
	(a (mapcar #'(lambda (x)
		       (let ((xx (divide #'symbolp x)))
			 (when (cddr xx)
			   (raise-error
			    (error-message '(read_proof_addresses bad file extra) fname)))
			 (cons (let ((n (car xx)))
				 ;;(format t "n : ~a~%" n)
				 ;;(setf -n n)
				 (if (cdr n)
				     (intern-system
				      (apply #'concatenate 'string
					     (cons (string (car n))
						   (mapcan #'(lambda (s)
							       (list " " (string s)))
							   (cdr n)))))
				     (car n)))
			       (cadr xx))))
		   aa)))
   (unless (well-formed-list
	    #'(lambda (x)
		(and (symbolp (car x))
		     (well-formed-list
		      #'(lambda (addr)
			  (well-formed-list #'integerp addr))
		      (cdr x))))
	    a)
     (raise-error (error-message '(bad file) fname)))
   ;;(mapcar #'(lambda (x) (cons (car x) (cadr x))) a)
   ;;(setf -aa aa -a a)
   ;;          `ISECT2_DECOMP`,[(2 1 1); (1 1 1)] : (tok # int list)
   a
   ))

(defunml (|home_pathname| (unit)  :declare ((declare (ignore unit))))
    (unit -> string)
  (namestring (truename (user-homedir-pathname))))


(defunml (|append_to_file| (fname s))
    (string -> (string -> unit))

  ;;(setf -s s -pathname (parse-namestring fname) -fname fname) (break "atf")
  (handle-file-error
   (with-open-file (stream (parse-namestring fname)
			   :direction :output
			   :if-exists :append
			   :if-does-not-exist :create)
     (write-string s stream)
     (terpri stream)))

  nil)

(defunml (|write_to_file| (fname s))
    (string -> (string -> unit))

  ;;(break "wtf")
  (handle-file-error
   (with-open-file (stream (parse-namestring fname)
			   :direction :output
			   :if-exists :supersede
			   :if-does-not-exist :create)
     (write-string s stream)
     (terpri stream)))

  nil)

;; with_spool "~/fu" (\outf. outf "fu"; ())
(defunml (|with_spool_aux| (overwritep fname f))
    (bool -> (string -> (((string -> unit) -> *) -> *)))
  ;;(break "wsa")
  (handle-file-error
   (with-open-file (stream (parse-namestring fname)
			   :direction :output
			   :if-exists (if overwritep :supersede :append)
			   :if-does-not-exist :create)
     (funmlcall f (make-closure #'(lambda (s)
				    ;;(setf -s s -stream stream) (break "fu")
				    (write-string s stream)
				    nil)
				1)))))

(defunml (|occurs_free| (x term))
  (variable -> (term -> bool))

  (occurs-free-p x term))

(defunml (|list_occurs_free| (x term))
  ((variable list) -> (term -> bool))

  (list-occurs-free-p x term))


(defunml (|term_to_file| (fname term))
  (string -> (term -> unit))

  (write-term-to-file fname term))

(defunml (|file_to_term| (fname))
    (string -> term)

  (read-term-from-file fname))

(defunml (|file_to_term_list| (fname))
    (string -> (term list))

  (read-terms-from-file fname))

(defunml (|list_directory| (dir))

   (string -> ((string |#| string) list))

  (mapcar #'(lambda (pname)
	      (cons (pathname-name pname)
		    (pathname-type pname)))
	  
	  (directory (pathname
		      (if (eql #\/ (char dir (1- (length dir))))
			  dir
			  (concatenate 'string dir "/"))))))

(defunml (|escape_string| (escapethese escapechar))
    (string -> (token -> (string -> string)))
  (let ((sbits (standard-character-sbits (map 'list #'char-code escapethese)))
	(esch (char (string escapechar) 0)))
    
  (make-closure
   #'(lambda (s)
       (with-byte-accumulator ('standard-string)
	 (string-to-byte-accumulator s sbits #'accumulate-byte esch)))
   1)))

				   
