
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;;;;	
;;;;	Terminology : {} interspersed in type expression are comments.
;;;;	
;;;;	----------------------------------------------------
;;;;	
;;;;	Overview:
;;;;	
;;;;	Directives : 
;;;;	
;;;;	lettype completion = (unit -> unit)
;;;;	lettype directive = (unit -> (completion{undo} # completion{commit}))
;;;;
;;;;	an ordered list of uncompleted completions per transaction is maintained.
;;;;	
;;;;	running a commit, commits all prior commits as well.
;;;;	running an undo, undoes all later undos as well.
;;;;
;;;;	it is an error to complete a completed completion.
;;;;	
;;;;	If a transaction fails it implicitly undoes all pending completions.
;;;;	If a transaction succeeds it implicitly commits all pending completions.
;;;;
;;;;	While it is possible to undo or commit pending completions during a transaction
;;;;	it is not usually done.
;;;;	
;;;;	
;;;;	Core Directives :
;;;;	
;;;;	There are only six directives :
;;;;	
;;;;	The library consists of a an association of abstract object ids with data.
;;;;	This association is referred to as the library table.
;;;;	The data is encapsulated in the primitive type object_contents.
;;;;	We will see later the methods for creating object_contents.
;;;;	
;;;;	lib_bind	: object_id -> object_contents -> directive
;;;;	lib_unbind	: object_id -> directive
;;;;	
;;;;	The library implements garbarge collection to remove unwanted objects from
;;;;	the library table. Each object can be considered to have a sticky bit.
;;;;	object_contents may contain concrete occurences of object_ids. Any object
;;;;	which does not occur in the closure of concrete references of the sticky
;;;;	objects are collectable.
;;;;	
;;;;	lib_allow	: object_id -> directive { sticky <- false, ie allow collection}
;;;;	lib_disallow	: object_id -> directive { sticky <- true }
;;;;	  
;;;;	Implementation notes :
;;;;	  - object_contents can be represented as a term, object_id is a
;;;;	    primitive parameter type.  Then to find concrete references,
;;;;	    simply walk the term representation of the object_contents and
;;;;	    collect the object_ids.
;;;;	
;;;;	  - there are generally only a handful of sticky objects. These are the 
;;;;	    root objects you see in the navigator.
;;;;	
;;;;	There is also a bit to indicate liveness of an object. 
;;;;	
;;;;	lib_activate	: object_id -> directive
;;;;	lib_deactivate	: object_id -> directive
;;;;
;;;;	The following functions round out what we might call the directive api:
;;;;
;;;;	create_object_id	: unit -> object_id
;;;;
;;;;	lib_bound_p		: object_id -> bool
;;;;	lib_active_p		: object_id -> bool
;;;;	lib_collectable_p	: object_id -> bool
;;;;	
;;;;	lib_object_contents	: object_id -> object_contents
;;;;	
;;;;	----------------------------------------------------
;;;;	
;;;;	ObjectContents :
;;;;	
;;;;	object_contents are constructive. You can not destructively modify object_contents.
;;;;	Thus to modify an object, you must instantiate a new object_contents
;;;;	and then rebind the new contents to the object_id.
;;;;	
;;;;	There are several object_contents modify functions which follow the
;;;;	pattern : object_contents -> *{data} -> object_contents.
;;;;	
;;;;	kind : object_contents have a kind.
;;;;	  - COM{Comment} | TERM  | CODE | DISP{Display} |
;;;;	    RULE | INF{Inference} | STM{Lemma} | PRF{Proof}
;;;;	
;;;;	term : object_contents have a term. For PRF contents the term is ignored.
;;;;
;;;;	properties : object_contents have an associated property list.
;;;;	  currently (tok # term) list, but will soon be extended to
;;;;	  ((tok + object_id) # term) list.
;;;;	
;;;;	Some kinds of object contents have extra data:
;;;;	 PRF : inference tree
;;;;	 STM : PRF list
;;;;	 INF : inference step
;;;;	
;;;;	
;;;;	OBJC API GLOSS :
;;;;	Common :
;;;;
;;;;	objc_contents		: tok{kind} -> object_contents
;;;;	objc_kind		: object_contents -> tok
;;;;
;;;;	objc_modify_source	: object_contents -> term -> object_contents
;;;;	objc_source		: object_contents -> term
;;;;	
;;;;	objc_get_properties	: object_contents -> (tok # term) list
;;;;	objc_set_properties	: object_contents -> (tok # term) list -> object_contents
;;;;
;;;;
;;;;	STM : source is statement of lemma.	
;;;;	
;;;;	stm_objc_modify_proofs	: object_contents -> object_id list -> object_contents
;;;;	stm_objc_proofs		: object_contents -> object_id list
;;;;	
;;;;	Inf Step : encapsulation of call to inference engine.
;;;;	
;;;;	inf_step		: term -> inf_step
;;;;	inf_step_goal		: inf_step -> term
;;;;
;;;;	inf_step_refine		: term{desc} -> inf_step ->
;;;;					term{tactic} -> term{context} -> inf_step
;;;;	  * desc identifies kind of inference engine.
;;;;	
;;;;	inf_step_refined_p	: inf_step -> bool
;;;;	inf_step_tactic 	: inf_step -> term
;;;;	inf_step_subgoals 	: inf_step -> term list
;;;;	inf_step_extract 	: inf_step -> term
;;;;	inf_step_references 	: inf_step -> (tok # object_id list) list
;;;;	
;;;;	
;;;;	INF : Source is Tactic.
;;;;
;;;;	inf_objc_modify_step	: object_contents -> inf_step -> object_contents
;;;;	inf_objc_delete_step	: object_contents -> object_contents
;;;;	inf_objc_step		: object_contents -> inf_step
;;;;	
;;;;	
;;;;	Inference Trees :
;;;;
;;;;	inf_tree			: object_id{INF} -> inf_tree list -> inf_tree
;;;;	inf_tree_object_id		: inf_tree -> object_id
;;;;	inf_tree_children		: inf_tree -> inf_tree list
;;;;	
;;;;	PRF :
;;;;	
;;;;	prf_objc_modify_inf_tree	: object_contents -> inf_tree -> object_contents
;;;;	prf_objc_delete_inf_tree	: object_contents -> object_contents
;;;;	prf_objc_inf_tree		: object_contents -> inf_tree
;;;;
;;;;
;;;;	OBJC API:
;;;;
;;;;	Translation :
;;;;	  - expand library macros.
;;;;	  - validate object_contents (specific to object kind).
;;;;	  * object_contents must be translated for object to be active.
;;;;
;;;;	Description : one distinquished property of an object is the description. The
;;;;	  description property describes the kinds of clients which can "interpret"
;;;;	  the object.
;;;;
;;;;	client validation : a library client may register to have relevant objects validated.
;;;;	  This may be done by coding a validation function within the library, or by
;;;;	  having the library call the client. If a client register a description to be validated
;;;;	  by callback but no matching client is available to be  called at translation time then
;;;;	  the translation fails. 
;;;;	 
;;;;	 Implementaton note : client validation currently only done by hardcoded fdl clients
;;;;	   ie, the registration facility is non-existent.
;;;;	 
;;;;	objc_translate : object_contents -> object_contents
;;;;
;;;;	
;;;;	Common :
;;;;
;;;;	objc_contents		: tok{kind} -> object_contents
;;;;	objc_kind		: object_contents -> tok{STM|PRF|DISP|ABS|COM|CODE|PREC|INF}
;;;;
;;;;	objc_modify_source	: object_contents -> term -> object_contents
;;;;	objc_source		: object_contents -> term
;;;;	
;;;;	objc_get_properties	: object_contents -> (tok # term) list
;;;;	objc_set_properties	: object_contents -> (tok # term) list -> object_contents
;;;;	
;;;;	translation : if object has DESCRIPTION property and there is a syntax checker
;;;;	  registered for description then syntax is validated. 
;;;;	
;;;;	
;;;;	STM : source is statement of lemma.	
;;;;	
;;;;	stm_objc_src_modify_proofs	: object_contents -> object_id list -> object_contents
;;;;	stm_objc_src_proofs		: object_contents -> object_id list
;;;;	
;;;;	Translation :
;;;;	  - filters inactive PRFs.
;;;;	  - checks that goal of top INF of PRF matches goal of STM.
;;;;	  - caches extract of first active PRF. 
;;;;	
;;;;	Following will fail of objc not translated :
;;;;	stm_objc_proofs			: object_contents -> object_id list
;;;;	stm_objc_extract		: object_contents -> term
;;;;	  * cache of extract of first active proof.
;;;;
;;;;
;;;;	Inf Step : encapsulation of call to inference engine.
;;;;	
;;;;	inf_step		: term -> inf_step
;;;;	inf_step_goal		: inf_step -> term
;;;;	  * currently goal is (term # term list) but that should be generalized to term
;;;;	    so that is how will present it.
;;;;	
;;;;	call_inference_engine : 
;;;;	    term{goal} -> term {tactic} -> term {context}
;;;;		-> term list{subgoals} 
;;;;		   # term{extract} 
;;;;		   # (token # object_id list) list{references}
;;;;		   # term{proof}
;;;;	  * the extract is a partial extract, containing placeholders
;;;;	    for the subgoal extracts. 
;;;;	  * the proof can be anything but one interesting result is a term 
;;;;	    which can be unmarshalled into an inf_tree. It would be possible
;;;;	    to save primitive trees in this way but that is discouraged due to
;;;;	    the space cost.
;;;;	
;;;;	inf_step_refine		: term{desc} -> inf_step ->
;;;;					term{tactic} -> term{context} -> inf_step
;;;;	  * desc identifies kind of inference engine.
;;;;	  * inference engine is implicitly called. By having lib implicitly call
;;;;	    inference engine we have more assurance that the result is an actual refinement.
;;;;	
;;;;	inf_step_refined_p	: inf_step -> bool
;;;;	inf_step_tactic 	: inf_step -> term
;;;;	inf_step_subgoals 	: inf_step -> term list
;;;;	inf_step_extract 	: inf_step -> term
;;;;	inf_step_references 	: inf_step -> (tok # object_id list) list
;;;;
;;;;	
;;;;	INF : Source is Tactic.
;;;;
;;;;	inf_objc_src_modify_step	: object_contents -> inf_step -> object_contents
;;;;	inf_objc_src_delete_step	: object_contents -> object_contents
;;;;	inf_objc_src_step		: object_contents -> inf_step
;;;;	
;;;;	Translation :
;;;;	  - must have refined inf_step.
;;;;	  - inf_objc_source must match inf_step_tactic
;;;;	
;;;;	Following will fail of objc not translated :
;;;;	inf_objc_step			: object_contents -> inf_step
;;;;	
;;;;	
;;;;	Inference Trees :
;;;;
;;;;	inf_tree			: object_id{INF} -> inf_tree list -> inf_tree
;;;;	inf_tree_object_id		: inf_tree -> object_id
;;;;	inf_tree_children		: inf_tree -> inf_tree list
;;;;	
;;;;	Translation :
;;;;	  at each node :
;;;;	    - inf object must be active.
;;;;	    - subgoals of inf_step of INF must match goals of inf_tree_children.
;;;;
;;;;	PRF :
;;;;	
;;;;	prf_objc_src_modify_inf_tree	: object_contents -> inf_tree -> object_contents
;;;;	prf_objc_src_delete_inf_tree	: object_contents -> object_contents
;;;;	prf_objc_src_inf_tree		: object_contents -> inf_tree
;;;;
;;;;	Translation : 	
;;;;	  - inf-tree must be translated.
;;;;	
;;;;	Following will fail of objc not translated :
;;;;	prf_objc_extract	: object_contents -> term
;;;;	
;;;;	
;;;;	CODE :
;;;;	
;;;;	Translation : requires connected client with appropriate compiler
;;;;	  for code language.
;;;;	  - compile
;;;;
;;;;	More needs to be said here concerning:
;;;;	  syntax checking vs compiling.
;;;;	  managing of cross-references.
;;;;	  dependencies and order of compilation
;;;;	
;;;;	ABS : 
;;;;	  
;;;;	 Lib/Edit Macros vs refiner definitions
;;;;	 Descriptions
;;;;	
;;;;	-------------------------
;;;;	
;;;;	Transactions
;;;;	
;;;;	Atomicity   : commit/undo
;;;;	Consistency : 
;;;;	Isolation - Serializability : locking
;;;;	Durability  : logs at commit.
;;;;	
;;;;	-------------------------
;;;;	
;;;;	Distributed 
;;;;	
;;;;	Push vs Demand
;;;;
;;;;	maintaining consistency of data amoung connected components : not easy.
;;;;	  - current protocol is complex and no one else will want to implement it.
;;;;	  - may be able to use some more standard distributed db protocol 
;;;;



;;;;	
;;;;	Comments on using fdl as software development environment.
;;;;
;;;;	  - embed invariants as comments in code.
;;;;	  - robust dependencies, ie new types of xref.
;;;;	
;;;;	adds robust macro facility to any language.
;;;;	
;;;;	version control	
;;;;	  - fine grained : reduces conflicts.
;;;;	     - reduces unnecessary recompilation.
;;;;	  - expansion
;;;;	      * expand away comments.
;;;;	      * expand away macros
;;;;	        -ie various forms of identity.
;;;;	 	if two funcs equal after expansion then choice of versions
;;;;		not terribly important.
;;;;	  - availability of logic tools to assist in merge: match/substitution.
;;;;	
;;;;	inscrutable identifiers : 
;;;;	  - multiple versions available simultaneously.
;;;;	  - merge conflict : temporary/permanent resolution via multiple versions.
;;;;	
;;;;	
;;;;	

;;;;	Notes for seminar 2/98
;;;;	
;;;;	Intro;
;;;;	
;;;;	open repository for all logical data.
;;;;	
;;;;	
;;;;	Goals : 
;;;;	  - easy access - can inherit from
;;;;	  - no loss of data, ie crash does not loose unsaved data.
;;;;	      * save is invisible and continuous. (consider disk crash to be adm's problem).
;;;;	  - no corruption of data
;;;;	      * cannot overwrite own or anyone else's data.
;;;;	  - complete archive : 
;;;;	      * recent data browseable.
;;;;	      * old data saved on CD's.
;;;;	
;;;;	
;;;;	Architecture assumes interprocess and disk IO are slow.
;;;;	Ie coarse interaction.
;;;;
;;;;	
;;;;	There are some questions about the way some coherent set of objects
;;;;	is produced that deserve some debate.
;;;;
;;;;	There may be features here which are necessary for working map
;;;;	But there should be enough functionality to implement WM.
;;;;	This is not tailored as a system to support working maps.
;;;;	
;;;;	However, it seems likely that incoherent maps will be convenient
;;;;	if not unavoidable during the execution of coherency safe procedures.
;;;;	
;;;;	
;;;;	Generality : as few preconceived notions as possible.
;;;;	  Ie, what is a sequent. Is the goal of a proof a sequent or a conlusion.
;;;;
;;;;	  Nuprl4 is a sample of the types of data and relationships
;;;;	   we need to manage.
;;;;	
;;;;	
;;;;	Nuprl4 deficencies
;;;;
;;;;	durability : 
;;;;	  Loose data :
;;;;	    - crash
;;;;	    - quit without save.
;;;;	    - overwrite;
;;;;		isectElim
;;;;	
;;;;	atomicity :
;;;;	 failure during some build procedure leaves half built garbage.
;;;;	
;;;;	concurrency : ability to continue edit/lib work while refiner is busy.
;;;;	 isolation not a prob since not concurrent.
;;;;	
;;;;	accounting : replayability
;;;;	
;;;;	
;;;;	0-------------------------------------------------------------
;;;;	
;;;;	Topics
;;;;	
;;;;	  Database
;;;;	    ACID
;;;;	
;;;;	  Distributed
;;;;	    Connectivity
;;;;	    Multiple compute servers.
;;;;	
;;;;	  Working Maps
;;;;
;;;;	  Accounting
;;;;	
;;;;	
;;;;	* by connectivity, the ability to connect other systems via socket.
;;;;	
;;;;	  talk about split into edd lib ref.
;;;;	 some variations possible.
;;;;	
;;;;	Following describes manipulations of library instance
;;;;	later describe loading/saving/finding.
;;;;	
;;;;	    
;;;;	1-------------------------------------------------------------
;;;;	
;;;;	Library :
;;;;	
;;;;	ObjectId	
;;;;	ObjectContents
;;;;	
;;;;	Bind 	: ObjectId -> ObjectContents -> unit
;;;;	Lookup	: ObjectId -> ObjectContents
;;;;	New	: unit -> ObjectId
;;;;	
;;;;	
;;;;	
;;;;	1* what I'm calling and objectid might be more like a proxy
;;;;	  for an objectid where objc  stamp is oid.
;;;;	
;;;;	** intuitive. 
;;;;	** Stuart covered oid pretty well previously.
;;;;	
;;;;	
;;;;	2-------------------------------------------------------------
;;;;	
;;;;	
;;;;	ObjectContents :  Constructive.
;;;;	
;;;;	EG:
;;;;	ModifyTerm 	: object_contents -> term -> object_contents
;;;;	
;;;;	
;;;;	2*
;;;;	
;;;;	**  ie no destructive modifications, makes it easy to do atomicity.
;;;;	**
;;;;	**  update lib by unbind/bind or bind/new
;;;;	**
;;;;	**  
;;;;
;;;;	3-------------------------------------------------------------
;;;;	
;;;;	let modify obid term = 
;;;;	  let newobid = New () in 
;;;;	    Bind newobid (ModifyTerm (Lookup obid) term);
;;;;	    newobid
;;;;	
;;;;	: ObjectId -> term -> ObjectId
;;;;	
;;;;
;;;;
;;;;	  - difficult to maintain relationships between objects.
;;;;	  + easy to ensure consistency or relationships.
;;;;	
;;;;
;;;;	3*
;;;;
;;;;	** constructively pure approach
;;;;	** lib primitives support model, however have not developed further support.
;;;;	
;;;;	
;;;;
;;;;	4-------------------------------------------------------------
;;;;	
;;;;	Unbind	: ObjectId -> unit
;;;;	
;;;;	
;;;;	  - error to bind bound ObjectId.
;;;;	  
;;;;	  let mybind obid objc =
;;;;	    (Bind obid objc) ? (Unbind obid; Bind obid objc) 
;;;;	
;;;;	4*
;;;;	
;;;;	** why error ? could've gone either way.
;;;;	**
;;;;	
;;;;
;;;;	5-------------------------------------------------------------
;;;;	
;;;;
;;;;	ObjectContents : primitive type
;;;;	
;;;;	  kind : Comment | Term  | Code | Display |
;;;;		 Rule | Inference | Lemma | Proof
;;;;	  
;;;;	  source
;;;;	    - term
;;;;	    - properties
;;;;	    - other inf_step/proof list/inference_tree/xref
;;;;
;;;;	
;;;;	  substance : restricted access.
;;;;	    - dependencies : eg, lemmas used by proof.
;;;;	    - term : reduced 
;;;;	    - properties : subset of source properties
;;;;	    - other : extract of proof/proofs of statement/identifiers of code
;;;;	  
;;;;	  Only reference to substance is recorded.
;;;;
;;;;	5* 
;;;;	   Distinquishing substance from source makes references more durable.
;;;;
;;;;	Why not single type of term.
;;;;	
;;;;	Could be, but we know we need these and allows us to build in 
;;;;	some functionality.
;;;;	
;;;;	Why not allow multiple definitions per object ? 
;;;;	Then multiple substances per object. 
;;;;	
;;;;	This is more primitive, you can make a term object contain a list of 
;;;;	object_ids  and add edit support to look like one object.
;;;;	
;;;;	
;;;;	
;;;;
;;;;	ObjectContents : 
;;;;	
;;;;	** restricted access? To enable dynamic recording of ephemeral dependencies.
;;;;	** dependencies are those deemed to be semantically meaningful for substance type.
;;;;	** thus lemmas of proof needed to allow cycle dectection.
;;;;	
;;;;	
;;;;	**	the essence of the object.
;;;;	**
;;;;
;;;;	**  could objectcontents be super type and rule, etc be subtypes? probably.
;;;;	**  inf-inf_step/stm-proof list/prf-inference_tree/code-xref
;;;;	
;;;;	
;;;;
;;;;
;;;;	6-------------------------------------------------------------
;;;;	
;;;;	Event : an interval during which access to substance is recorded.
;;;;	  contains mutable list of dependencies recorded.
;;;;	
;;;;	
;;;;	with_event : Library -> (Event -> *) -> (* # dependency list)
;;;;	
;;;;	access_X : Event -> ObjectId -> X
;;;;	
;;;;	
;;;;	
;;;;
;;;;	7-------------------------------------------------------------
;;;;	
;;;;	
;;;;	Translate : the event which produces the substance.
;;;;	
;;;;	  abbreviate/extract
;;;;	
;;;;	  translation : all dependencies
;;;;	    - source : objects required to interpret source.
;;;;	    - compile/refinement : objects referenced while compiling source.
;;;;	
;;;;	
;;;;	Translate may noop if substance to be produced would be similar 
;;;;	to current.
;;;;
;;;;	Similar :
;;;;	  - only cosmetic changes in dependencies.
;;;;	  - equivalent term.
;;;;	  - other
;;;;
;;;;	
;;;;	7*  Any guarauntee of replayability will be conditional.
;;;;
;;;;
;;;;	8-------------------------------------------------------------
;;;;	
;;;;
;;;;	Activate
;;;;	
;;;;	For data in the substance to be accessed it must be active.
;;;;	
;;;;
;;;;	activate	: ObjectId -> unit	
;;;;	deactivate	: ObjectId -> unit
;;;;	
;;;;	
;;;;	  Active objects can not be unbound
;;;;
;;;;	  Objects must be translated prior to activation.
;;;;	
;;;;
;;;;	8*
;;;;
;;;;	** allows fine grain control without having to delete. Makes invisible.
;;;;
;;;;	** activate could force translation, but this deemed more primitive.
;;;;
;;;;	**
;;;;
;;;;
;;;;	9-------------------------------------------------------------
;;;;	
;;;;	
;;;;	Sticky bit :
;;;;	
;;;;	  Library will periodically garbage collect unreferenced inactive objects.
;;;;	  If sticky bit is on, then object is not collected 
;;;;	  even if unreferenced and inactive.
;;;;
;;;;
;;;;	allow		: ObjectId -> unit	
;;;;	disallow	: ObjectId -> unit
;;;;	
;;;;	
;;;;	9*
;;;;
;;;;	** roots
;;;;	
;;;;	** allow - turn sticky bit on.
;;;;	** disallow turn sticky bit off.
;;;;	 
;;;;
;;;;	10-------------------------------------------------------------
;;;;	
;;;;	Review :
;;;;
;;;;	Bind 	: ObjectId -> ObjectContents -> unit
;;;;	Unbind	: ObjectId -> unit
;;;;
;;;;	Activate	: ObjectId -> unit	
;;;;	Deactivate	: ObjectId -> unit
;;;;
;;;;	Allow		: ObjectId -> unit	
;;;;	Disallow	: ObjectId -> unit
;;;;
;;;;	Lookup	: ObjectId -> ObjectContents
;;;;	New	: unit -> ObjectId
;;;;
;;;;	
;;;;	
;;;;	Desire : Atomicity
;;;;	
;;;;	
;;;;	
;;;;	10* very easy to add atomicity because of construct objectcontents.
;;;;
;;;;	** weak_save = deactivate ... bind activate. if activate fails want state original back.
;;;;
;;;;
;;;;	11-------------------------------------------------------------
;;;;	
;;;;
;;;;	Directives : 
;;;;
;;;;	
;;;;	with_atomicity : Library -> (atomicity -> *) -> *
;;;;	
;;;;	
;;;;	lettype directive = (unit -> ((unit -> unit) # (unit -> unit)))
;;;;
;;;;	  completion == undo # commit
;;;;	  directive == unit -> completion 
;;;;	
;;;;	an ordered list of uncompleted completions is maintained.
;;;;	
;;;;	running a commit, commits all prior commits as well.
;;;;	running an undo, undoes all later undos as well.
;;;;
;;;;	it is an error to complete a completed completion.
;;;;	
;;;;	normal exit of with_atomicity implicitly commits all uncompleted completions.
;;;;	failing out of with_atomicity implicitly undoes  all uncompleted completions.
;;;;
;;;;
;;;;	12-------------------------------------------------------------
;;;;	
;;;;	
;;;;	Bind 	: ObjectId -> ObjectContents -> directive
;;;;	Unbind	: ObjectId -> directive
;;;;
;;;;	Activate	: ObjectId -> directive
;;;;	Deactivate	: ObjectId -> directive
;;;;
;;;;	Allow		: ObjectId -> directive
;;;;	Disallow	: ObjectId -> directive
;;;;
;;;;
;;;;	This is the complete list.	
;;;;	
;;;;	
;;;;
;;;;	12*
;;;;	
;;;;	neat thing is they are totally obvious, but it was a long strange trip
;;;;	to get here. What finally made it obvious was removing the ordering from the lib.
;;;;	
;;;;
;;;;	** allow/disallow are second-class.
;;;;	
;;;;	** most of the real work is off-loaded into objc.
;;;;	
;;;;	time slider : possible and interesting, particularly with merge ability.
;;;;	
;;;;	  One of the first things I attempted with version 4 was to
;;;;	make the lib cmds more OO. not succesful.
;;;;	I think because they share only very basic types of operations.
;;;;	This comes out in the paucity of directives. allow/disallow
;;;;	has no parallel in v4 so v4 directives are bind/unbind activate/deactivate.
;;;;	
;;;;
;;;;
;;;;	13-------------------------------------------------------------
;;;;	
;;;;	Concurrency :
;;;;
;;;;	with_transaction  : Library -> (transaction -> *) -> *
;;;;	
;;;;	  Transaction is ticket that allows access to library.
;;;;	
;;;;	  Consistent View : within a transaction the state of the
;;;;	   library does not change except for modifications made by the transaction.
;;;;
;;;;	   Modification by a transaction are visible only to the transaction.
;;;;	
;;;;	   Modification by a transaction are visible immediately. 
;;;;	   Table is updated prior to lib request responding.
;;;;
;;;;	
;;;;	 Undo is trivial.
;;;;	
;;;;	
;;;;
;;;;	13*
;;;;
;;;;	** subsumes with_event and with_atomicity
;;;;	**
;;;;
;;;;	Any object_id involved in a directive is locked. 
;;;;
;;;;	Attempting to lock an object locked by another causes failure.
;;;;	
;;;;	
;;;;	Single phase commit, but inadequate and two phase will be added.
;;;;	
;;;;	two independent transactions simultaneously create conflicting definitions.
;;;;	can not detect conflict until commit of second, thus commit needs to be
;;;;	able to fail.
;;;;	
;;;;	something you read may have changed, you can not see that until
;;;;	commit
;;;;	Transaction A completes, Transaction B changes value used by A.
;;;;	
;;;;	
;;;;	14-------------------------------------------------------------
;;;;	
;;;;	
;;;;	Locks : No Read Locks.
;;;;	
;;;;	  Assume : 
;;;;	    A lot is read.
;;;;	    Little is written.
;;;;
;;;;	  If write over of read data, then we desire 
;;;;	     - ignore, we can detect stale references.
;;;;		  - may be easier to refresh references than rerun transaction.
;;;;		  - fewer failures.
;;;;	     - failure of reading transaction.
;;;;	
;;;;	  
;;;;	  Consistent View ensures isolation.
;;;;	
;;;;	  Directives lock ObjectIds.
;;;;	
;;;;	  Access records equivalent
;;;;	    - at commit if an accessed object has been written than fail.
;;;;	
;;;;	14 * This results in some problems for serializability
;;;;
;;;;	Yes we are allowing an inconsistent state
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	read locks : can fail if value changed.
;;;;	However not a bank acct.
;;;;	 read values not always important. if concurrent transaction changes value
;;;;	 then as though value changed afterwards.
;;;;
;;;;	
;;;;	Other failure policies could easily be implemented.
;;;;
;;;;	
;;;;	Long been a point of uncertainty, basis for supposing that
;;;;	not traditional database. Basis for distibuted table design.
;;;;	
;;;;
;;;;	15-------------------------------------------------------------
;;;;	
;;;;	Durability : Database : library instances share database.
;;;;	
;;;;	  Sharing : planned and opportunistic.
;;;;	    allows verbose storage of proofs.
;;;;	
;;;;	  A library database will contain multiple library instances.
;;;;
;;;;	  Clients have direct access to database.
;;;;	  Library distributes addresses.
;;;;	
;;;;	  dbwrite : term{data} -> term{address}
;;;;	  dbread  : term{address} -> term{data}
;;;;	
;;;;	  Security : no provision for writing over data.
;;;;	
;;;;	  Durability : At commit, all data is on disk.
;;;;	
;;;;	  
;;;;	  GC moves files to less accessible area.
;;;;
;;;;	  Files referenced in recent library instances will not be gc'ed. 
;;;;	
;;;;	** this has proved quite succesful.
;;;;	
;;;;	  if address returned by write appears in sticky object in lib
;;;;	  then file will remain accessible.
;;;;	
;;;;	**
;;;;	 note no ability to write
;;;;	
;;;;
;;;;	
;;;;	gc.
;;;;	
;;;;	currently
;;;;	  can preserve data
;;;;	  can start up from any recent checkpoint.
;;;;	cannot restoring or browsing old data
;;;;	
;;;;
;;;;	1*
;;;;
;;;;	**	Lots of other stuff to talk about here.
;;;;	**	when source code of system itself is preserved than can 
;;;;	**      guarauntee reconstruction.
;;;;	
;;;;	working map allows freedom for changes without worry for backward compatability.
;;;;	
;;;;	
;;;;
;;;;	16-------------------------------------------------------------
;;;;	
;;;;	
;;;;	Accounting : 
;;;;	
;;;;	Stamp	: Global unique
;;;;	  host ipaddr, process-id, universal time
;;;;	  slow count 
;;;;	  fast count : library tick.
;;;;	  time
;;;;	
;;;;	Allocating certain data structures bumps library tick and stamps data.
;;;;	  ObjectContents
;;;;	  substance
;;;;
;;;;	
;;;;	7* before I talk about serializability.
;;;;
;;;;	** global : ipaddrs and as long as process-ids do not rollover faster than
;;;;	**   granularity of universal time.
;;;;	
;;;;	
;;;;	
;;;;
;;;;	17-------------------------------------------------------------
;;;;	
;;;;	Accounting : 
;;;;	
;;;;	Dependency 
;;;;	  substance stamp
;;;;	  ObjectContents  stamp
;;;;	  ObjectId
;;;;	
;;;;	
;;;;	All references between objects recorded as dependencies.
;;;;	  - must have access to substance to create a dependency.
;;;;	  - Object Contents stamp can be null.
;;;;	  - ObjectId can be null.
;;;;	
;;;;	
;;;;	By recording the ObjectId and ObjectContents stamp at 
;;;;	time of reference you can detect if object has since
;;;;	been modified.
;;;;	
;;;;	Having stamp of ObjectContents in a reference prevents
;;;;	the ObjectContents from being GC'd.
;;;;	
;;;;	
;;;;	8*
;;;;	
;;;;	** there's that access word again.
;;;;	**
;;;;	
;;;;	Why allow rebinding of ObjectId? 
;;;;	 could simply add comments to new object which references old. But 
;;;;	 then old references not updated. 
;;;;	
;;;;	Why allow substantive rebinding? why prohibit.
;;;;	  - why prohibit activity, which though risky, may allow otherwise
;;;;	    impossible procedures.
;;;;	
;;;;	analogy : create a Caml Module, define a bunch of dependent modules.
;;;;	 Now decide you want to change interface of module.
;;;;	  do you reuse the same name or define a new name? Usually yes you reuse
;;;;	  the name and then mill all references to it.
;;;;
;;;;	now, that is the type of thing we would like to avoid. But I think it's
;;;;	a little presumptuous to outlaw it altogher.
;;;;
;;;;	
;;;; This is where I hope things go awry.
;;;;	
;;;;	I think there are two situations,
;;;;
;;;;	  - stable set of objects such as the standard theories. 
;;;;	  
;;;;	    * do not want to perturb.
;;;;		want object id and substance to remain.
;;;;	     
;;;;	    * may still want to annotate such that old pointers see annotations.
;;;;	      ie orginal author wants to update.
;;;;		- then objc stamp changes but substance and object id do not.
;;;;	      then when user updates by seeing objc change they can detect 
;;;;	      know it is safe to dump old.
;;;;	   maybe not a crucial capability but certainly convenient.
;;;;	
;;;;	  - an unstable set of objects under development.
;;;;	    I claim, and this may be the debatable point, that inconsistent
;;;;	    states are ok, as long as the inconsistency is identifiable.
;;;;	   
;;;;	  Yes I can redefine a function as long as I know which callers have
;;;;	  not been replayed (tested with new definition).
;;;;
;;;;	  For example, I have some proofs using some tactic T.
;;;;	  I want to redefine T in such a way that I suspect the proofs will
;;;;	  survive. 
;;;;	   Do I define T' and mill all calling proofs to use T'. That's one way.
;;;;
;;;;	  Or do I live dangerously and modify T and then replay all dependent
;;;;	  proofs to see where the chips fall.
;;;;	
;;;;	  if this capability is not in working map then I think it should be.
;;;;	
;;;;	
;;;;	If I do redefine a definition, 
;;;;	I want to see the callers of the old
;;;;	
;;;;	
;;;;	I redo a proof so that the extract computes the same result
;;;;	but does so by a more efficient algorithm. 
;;;;	
;;;;	
;;;;	While programming I redefine more functions than I define.
;;;;
;;;;	To me programming is an incremental process where the increments are 
;;;;	generally redefinition.
;;;;
;;;;	Certainly, the capability of forking at redefinition is lacking.
;;;;	
;;;;	But only allow forking is not very good either.
;;;;	
;;;;	
;;;;
;;;;	 OTOH, the other is quite useful as well.
;;;;	 
;;;;	 At the moment rules are still found via their mnemonic names.
;;;;	 However, when a rule is looked up the transaction can record a reference.
;;;;	 
;;;;	 Thus all proofs using a rule can contain a dependency to it.
;;;;	 We determine some rule is in error, and fix it, 
;;;;	
;;;;	  - bind it to a new id
;;;;	    replay all proofs depending on old and they find new reference.
;;;;	
;;;;	
;;;;	 
;;;;	
;;;;	
;;;;   danger below.	
;;;;
;;;;	no reason to remove a degree of freedom, it is easier to not use
;;;;	something you do not need then to need something which is not available.
;;;;	
;;;;	
;;;;	dependency dissonance :
;;;;	  objectid of dependency is not bound or
;;;;	  stamp of substance of objectcontents of objectid of dependency
;;;;		is not equal to substance stamp of dependency
;;;;
;;;;	You can change object contents in non-substantive ways without
;;;;	creating dissonance.  If you change an object substantively,
;;;;	you can deduce what other objects are affected by testing them
;;;;	for dissonance.
;;;;	
;;;;	For the constructivists : you can test if substantive change and
;;;;	create new object so that dissonance is avoided.
;;;;	
;;;;	
;;;;	
;;;;	dissonance is created when you rebind an object_id.
;;;;	
;;;;	
;;;;	substance is bin file
;;;;	
;;;;	objectid is a path to the substance, if the path used in referring
;;;;	to the substance is altered then the event which made the reference
;;;;	needs to be replayed to ensure that a path still exists.
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	18-------------------------------------------------------------
;;;;	
;;;;	
;;;;	Serializability : 
;;;;	
;;;;	
;;;;	
;;;;	Ramakrishnan defines serializability :
;;;;	
;;;;	A serializable schedule is a schedule whose effect on any
;;;;	consistent database instance is identical to that of some
;;;;	complete serial schedule.
;;;;
;;;;	
;;;;	Can a referenced ObjectId be unbound?
;;;;	
;;;;	
;;;;	Library admits both answers.
;;;;
;;;;
;;;;	If no, then define consistency of library to be that no
;;;;	stale references are allowed. 
;;;;
;;;;	Then, fail at commit when read data has been written by a
;;;;	concurrent transaction to ensure serializability.
;;;;	
;;;;
;;;;	If yes, then define consistency of library to be	
;;;;	that stale references are detectable.
;;;;	
;;;;	But still not technically serializable, as there are interleaved
;;;;	executions which result in a different consistent state that any
;;;;	serial schedule.
;;;;	
;;;;	However, given the weak form of consistency the lack of
;;;;	serializability is not very troublesome, ie the resulting state
;;;;    is just as acceptable as any of the serial ones.
;;;;	
;;;;	Pragmatically, the second form is probably more useful than the 
;;;;	first.
;;;;	
;;;;
;;;;	1* It's not a bank acct.
;;;;
;;;;	**   originally this I considered dissonant serializability 
;;;;	**   very important for purposes of long running transactions like a prove all
;;;;	**   where you want a consistent view and in which literally
;;;;	**   everything is referenced.
;;;;	**  but those types of transactions do not seem very important any more.
;;;;	
;;;;	however dissonance is important during development.
;;;;	advantage : long running transaction not messed up by read locks.
;;;;	 might be able to do quick fix after the fact. 
;;;;
;;;;	is defined as the existence of a schedule such that results in consistent state.
;;;;	unclear if the state must be reachable with a serial schedule.
;;;;	
;;;;	serializability does not require that all schedules result in same state.
;;;;	
;;;;	
;;;;	19-------------------------------------------------------------
;;;;	
;;;;	Table : partial view of library state.
;;;;	
;;;;	
;;;;	  Distributable.
;;;;
;;;;	  Collects access data.
;;;;	
;;;;	  Each table contains substances of single type. 
;;;;	  Does not need to contain all substances of a type.
;;;;	
;;;;	  Indexed by ObjectID or Term and parameterized by transaction.
;;;;
;;;;	  
;;;;	  Description : filter.
;;;;	    Client has description.
;;;;	    Object may have description.
;;;;	
;;;;	    Client only sees table entries for matching descriptions.
;;;;	
;;;;	
;;;;	1*
;;;;
;;;;	**
;;;;	** description filters.
;;;;
;;;;
;;;;	20-------------------------------------------------------------
;;;;	
;;;;	Distributed :
;;;;	
;;;;	  Participant : can fail first phase of 2-phase commit.
;;;;
;;;;	  Listener : receives broadcasts but can not fail.
;;;;	
;;;;	  Atomic : recieves atomic broadcasts of committed actions.
;;;;	
;;;;	  Demand : receives no broadcasts.
;;;;
;;;;	    refiner is participant.
;;;;	    editor could be listener or atomic.
;;;;	
;;;;	  Participants and listeners may be called upon to process
;;;;      requests by the library. Eg, refinement, compilation, 
;;;;	  pretty printing.
;;;;	
;;;;	At connect, client informs library of table types and description.
;;;;	Library then transmits snapshot of current state and starts
;;;;	broadcasts for requested tables.
;;;;	
;;;;	
;;;;	When a lib request modifies library state, the broadcasts
;;;;	are sent prior to rsp so that client has updated state
;;;;	prior to receiving rsp.
;;;;
;;;;	
;;;;	Vaporware : only single phase commits implemented at the moment.
;;;;	
;;;;	there may be degrees of freedom which are no needed and may never
;;;;	be needed.
;;;;	
;;;;
;;;;
;;;;	22-------------------------------------------------------------
;;;;
;;;;	
;;;;	Working Map : 
;;;;	
;;;;	  Policies and procedure for ensuring consistency in a
;;;;	  library instance.
;;;;	
;;;;	Zipping : 
;;;;	
;;;;	Dependency 
;;;;	  Substance stamp
;;;;	  ObjectContents  stamp
;;;;	  ObjectId
;;;;	
;;;;	Assuming no stale references,
;;;;	  then identical stamps ==> identical data.
;;;;	
;;;;	Thin  : define = to be ObjectId bound to identical ObjectContents.
;;;;      Then for each equivalence class, distinquish a member and replace all
;;;;	  references to the other members with the distinquished member. Unbind
;;;;	  all undistinquished.
;;;;
;;;;	Re-Source : similar procedure with ObjectContents containing Substances.
;;;;	
;;;;	Merge : import ObjectContents with new ObjectIds. Then Re-Source and Thin.
;;;;	
;;;;	Can define other equivalences on substance, but cannot replace substance
;;;;	references. Must replay event to produce new references to distinquished
;;;;	substance.
;;;;	
;;;;	
;;;;	If two maps derived from comon ancestor then sub-maps which have not been
;;;;	rebound will be trivially identifiable.
;;;;	
;;;;
;;;;	
;;;;	* unbind GC is a reflexive zip of sorts. need more flavors.
;;;;
;;;;	a) Minimal coherency:
;;;;      every object address in any term of a coherent map addresses an
;;;;      object in that map.
;;;;	
;;;;	This implementation does allow dangling ObjectId's.
;;;; 	but maybe define coherency as all referenced substances occur active objects.
;;;;
;;;;	SFA:
;;;;	  a) The smallest coherent submap including specified objects.
;;;;	  b) The biggest coherent submap excluding specified objects.
;;;;	  c) Zipping two coherent map along an initial correspondence,
;;;;	     identifies some ob addresses, then enlarges the correspondence
;;;;	     by matching corresponding object contents. Failure is possible.
;;;;	     (Also there may be safe zipping operations that allow the object
;;;;	      contents to be merged, but we have to have more refined modes
;;;;	      of dependency implemented (such as depending on the actual term
;;;;	      in the objects versus some feature of the term, like its full
;;;;	      expansion).
;;;;	
;;;;	
;;;;	 what if substances equal but dependencies not? 
;;;;	 doesn't matter since I'm saying I can produce same substance with objects I have.
;;;;	
;;;;	objc zip good for situation where you've started with some map and evolved but
;;;;	now want to fold in with new version of start map
;;;;	
;;;;	Assume Zip(A,B) where A has precedence.
;;;;	objc : ObjectId -> Stamp
;;;;	substance : ObjectId -> Stamp
;;;;	
;;;;	if  objc(a) = objc(b) then assert a == b
;;;;	find all bi = aj wrt assertions.
;;;;	Import remainder substituting a's for b's.
;;;;	
;;;;	Substance Zip : find equivialent substances and then fix-up
;;;;	  if substance(a) = substance(b) then assert a = b
;;;;					      assert objc(a) = objc(b)
;;;;	  find all a =r b wrt assertions.
;;;;	
;;;;	
;;;;	  =s : Substance -> Substance -> bool
;;;;	
;;;;	
;;;;	  =r : ObjectId -> ObjectId -> bool
;;;;	  a =r b if substance(a) =s substance(b) & objc(a) = objc(b)
;;;;
;;;;	  =d : Dependency -> Dependency -> bool
;;;;	  c =d d if substance(c) = substance(d) & objc(c) = objc(d) & oid(a) =r oid(b)
;;;;
;;;;	23------------------------------------------------------------
;;;;	
;;;;	
;;;;	Accting : references used for ordering.
;;;;
;;;;	  - dynamic : better odds of replay.
;;;;	  - no single order. 
;;;;	  - open ended, write a new func over the references.
;;;;	
;;;;	1*
;;;;
;;;;	some zip variations could look at refs rather than data.
;;;;	used the same lemmas proved, the same goal, I don't care
;;;;	what he named his variables.
;;;;
;;;;
;;;;	24-------------------------------------------------------------
;;;;	
;;;;
;;;;	Inference Trees.
;;;;	
;;;;	destruct_inf_tree : InfTree -> ObjectId -> InfTree list
;;;;	
;;;;	inf_objc_src_step                : object_contents -> inf_step
;;;;	
;;;;	inf_step_goal                : inf_step -> (term # term list)
;;;;	inf_step_tactic              : inf_step -> term
;;;;	inf_step_subgoals            : inf_step -> (term # term list) list
;;;;	inf_step_references          : inf_step -> (tok # dependency list) list
;;;;	inf_step_extract             : inf_step -> term
;;;;	
;;;;	inf_step_inf_tree            : inf_step -> inf_tree
;;;;	
;;;;	inf_step_refine	: term -> inf_step -> term -> inf_step
;;;;	  1st arg is used to choose refiner, 
;;;;	  2nd arg contains sequent.
;;;;	  3rd is tactic.
;;;;	
;;;;	inf_tree_replace_tree      : inf_tree -> inf_tree -> int list
;;;;	                                          -> inf_tree
;;;;	   * using int list as address, replaces tree in first arg at
;;;;	     address with second arg.
;;;;	   * if target tree is direct or unrefined
;;;;	       -  then goal of target must match goal of second arg.
;;;;	   * if target tree is indirect
;;;;	       -  then target tree must match second arg.
;;;;	   * fails if replacement would violate uniformity of direct flag
;;;;	     in resulting tree.
;;;;
;;;;	1*
;;;;	splice conditions.
;;;;	  - goal match : identical sequents
;;;;
;;;;	tactic top trees can be modified non-substantively, ie can be annotated.
;;;;
;;;;	**
;;;;	**
;;;;
;;;;
;;;;	1-------------------------------------------------------------
;;;;	
;;;;	Performance :
;;;;	
;;;;	  Functionality primary goal.
;;;;	  Then tune for performance.
;;;;	
;;;;
;;;;	11-------------------------------------------------------------
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	slow count : transaction tick.
;;;;	
;;;;	building blocks : tables  term tables tents etc.
;;;;	
;;;;	
;;;;	
;;;;	new edition of book in lib : new isbn but same title.
;;;;	
;;;;	locks/transactions.
;;;;	
;;;;	oid's can be direct or indirect in object-contents
;;;;	ie a{o:oid} or all{} where o binds all{} == x.
;;;;	translation makes indirect direct via dependency-store.
;;;;	
;;;;	
;;;;	neither fast nor small, but allows clients to be both.
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;; -docs- (mod lib)
;;;;	
;;;;	
;;;;	Transactions, Directives, Components, and Broadcasts.
;;;;
;;;;	FDL guarauntees some degree of atomicity, serializability, and
;;;;	dependency tracking.
;;;;
;;;;	Object		: A modifiable atom.
;;;;	Event		: An Event is an identifiable action, eg, modification of an
;;;;			  object.
;;;;	Transaction 	: All events occur within the scope of a transaction.
;;;;	Directive	: a method of building an atomic complex sequence of
;;;;			  events within a transaction.
;;;;
;;;;	It is important to be able to distinquish events and transactions.
;;;;	This is accomplished throught the use of transaction stamps:
;;;;
;;;;	A transaction stamp consists of two parts: an id and a sequence.
;;;;	 * all transactions have globally (literally worldwide) unique ids.
;;;;	 * all stamps produced during the same transaction have the same id.
;;;;	 * all events occuring within the same transaction have distinct sequences.
;;;;
;;;;	Transaction stamps are used pervasively:
;;;;	 - objects are stamped at modification.
;;;;	 - all dependency references contain stamps.
;;;;	 - all messages will be stamped.
;;;;	 - some dynamic system data structures may be stamped as a means of
;;;;	   identification
;;;;
;;;;	Dependency : the combination of an object reference and a transaction stamp.
;;;;	
;;;;
;;;;	Transaction Serialization :
;;;;	 - All execution done within a interpreter level thread.
;;;;	  * this does allow for multiple threads within a single interpreter.
;;;;	 - Sequential statements within top-level eval.
;;;;	 - system provides serialization primitives to serialize transactions
;;;;	   from distinct evaluations.
;;;;	  * editor will use primitives to provide serial/asynch evaluation primitives.
;;;;
;;;;	Transaction Model:
;;;;	 - Presume :
;;;;	  * Persistent objects :
;;;;	   - modifications to referenced objects are uncommon.
;;;;	   - deletion and creation of objects is uncommon.
;;;;	   Thus infer : modification clashes uncommon.
;;;;	  * Short Transactions :
;;;;	   - most transactions will consist of single act and commit.
;;;;	   Thus infer : undo uncommon.
;;;;	  * Dependency Tracking.
;;;;	   - all object dependencies are always known.
;;;;
;;;;	 - Directives: act -> commit | undo.
;;;;
;;;;	  Act makes a modification to library. Modification can be made
;;;;	  permanent by commit, or can be undone by undo. Directives may
;;;;	  be combined to construct an atomic sequence of modifications.
;;;;	  By atomic, they can all be undone or committed to atomically.
;;;;
;;;;	  The commit or undo will be refered to as the completion.
;;;;
;;;;	  An act, a sequence of commits, and a sequence of undos are each distinct events.
;;;;
;;;;	  An action which has be taken but has not been completed will be
;;;;	  called pending.
;;;;
;;;;	  Pending actions are lazily reflected among connected interpreters
;;;;	  with the following invariant:
;;;;	   * the effects of pending actions are seen by any interpreter
;;;;	     processing requests of the transaction which produced the actions.
;;;;
;;;;	   - It is unpredictable what version of an object other asynchronous transactions will
;;;;	     see. Thus transactions are not serializable wrt references, only modifications.
;;;;	   - It is possible that a dependency may be made upon an event which is undone.
;;;;	     It is left to dependency tracking to identify stale dependencies.
;;;;
;;;;	  Transaction Locks : key is transaction stamp.
;;;;
;;;;	   Act : requests lock of object to be modified.
;;;;	   Undo : releases lock.
;;;;
;;;;	   Otherwise locks releases when transaction is exited.
;;;;
;;;;	   Request to lock an object locked by another transaction results in failure.
;;;;
;;;;	   Request to reference an object locked by another transaction results in failure.
;;;;
;;;;	   Invariant : journal acts are replayable.
;;;;	    * acts will be replayable if state is same as at record time.
;;;;	    * acts modify state.
;;;;	    * act to be replayed completed.
;;;;	    * Thus by requiring locks to make references, guarauntees replayability.
;;;;	      RLE ??? activate act stores export term so abs dependencies not an issue ???
;;;;	
;;;;	    * remote handling of broadcasts not an issue as no remote processing
;;;;	      is done by an act. 
;;;;
;;;;	 - Dependency Tracking :
;;;;
;;;;	  By assuming a robust dependency tracking system, some simplifications
;;;;	  to the transaction model were made. Mainly, the anarchic approach to
;;;;	  pending actions wrt asynch transactions.
;;;;
;;;;	  To phrase it more colloquially, we can willy-nilly step on whatever we
;;;;	  want, as we can rely on the dependency system to inform us of what we
;;;;	  squashed.
;;;;
;;;;	 - No Nested Transactions :
;;;;	  * simplifies implementation and explaination.
;;;;	  * no compelling need.
;;;;	  * One could simulate single threaded nested transactions using directives.
;;;;
;;;;	 The transaction model is meant to  balance these concerns:
;;;;	  - utility/robustness.
;;;;	  - programming effort.
;;;;	  - computational throughput.
;;;;	  - user complexity.
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Directives: details.
;;;;
;;;;	<completion>	: completion[<stamp> <undo> <commit> <primitive-cmd>]
;;;;	 * <stamp> - transaction stamp at action.
;;;;
;;;;	Commit <completion>  : Commits all pending completions from first to arg. 
;;;;	 * updates action journal.
;;;;
;;;;	Undo <completion>  : Undoes all pending completions from last to arg.
;;;;
;;;;	Later attempt to complete a completed completion in the alternate manner,
;;;;	is an error. Ie, if a an action is committed, it is then an error to attempt
;;;;	undo.
;;;;	Attempt to complete a completion not produced in current transaction scope
;;;;	is an error.
;;;;
;;;;	Failing out of command scope undoes all pending completions.
;;;;	Returning out of command scope commits all pending completions.
;;;;
;;;;	with-completions (&body)
;;;;	 * binds *completions*
;;;;	 * binds locks.
;;;;	 * unwinds on failure (must do lisp crash/abort).
;;;;	   - ie frees locks and undoes pending completions.
;;;;	 * all pending completions must be from same transaction.
;;;;	   And such transaction must be current at dischage.
;;;;
;;;;	completion-emit	(<completion>)		: NULL
;;;;
;;;	commit-completions(<stamp>)		: NULL
;;;;	 * commits pending completions up to and including completion containing <stamp>.
;;;;	undo-completions(<stamp>)
;;;;	 * undoes pending completions starting with completion containing <stamp>.
;;;;
;;;;  -page- 
;;;;
;;;;
;;;;	Inter-interpreter concerns:
;;;;
;;;;	Library Broadcast :
;;;;	
;;;;	Broadcasts : method of implementing connected interpreter action effects
;;;;		by communicating table updates.
;;;;
;;;; -doct- (mod lib data)
;;;;
;;;;	Two types of tables ordered and unordered.
;;;;
;;;;	Ordered:
;;;;	 - create, move, assign, delete
;;;;	     Position in order has meaning irrespective of assigned value.
;;;;	  - invariant : 
;;;;	      If delete undone, the element following the deleted element will
;;;;	      be present at time of undo.  Ie, lib locks following element for
;;;;	      duration of transaction, this in conjunction with directive
;;;;	      constraints guarauntees presence.
;;;;
;;;;	UnOrdered:
;;;;	 - insert, delete,  activate, deactivate.
;;;;
;;;;	Completion: 
;;;;	 - commit and undo.
;;;;	
;;;;	Broadcast templates :
;;;;	  place ... oa oa
;;;;	  value ... def
;;;;	  oaddr ... oa
;;;;
;;;;	Note that the stamp is not necessary. It is included to add assurance that
;;;;	broadcasts are being properly routed and affect only the intended tables.
;;;;
;;;;	These may be abstractions which expand to appropriate ml-expression.
;;;;	Any ml expression is valid. However, these may be treated more
;;;;	efficiently by an astute interpreter.
;;;;
;;;;	<broadcast>
;;;;		: !table_insert<parms>(<stamp-term>; <definition-term>)
;;;;
;;;;		| !table_create    <lparms>(<stamp-term>; <oa-term>; <oa-term>)
;;;;		| !table_move  	   <lparms>(<stamp-term>; <oa-term>; <oa-term>)
;;;;
;;;;		| !table_store     <lparms>(<stamp-term>; <definition-term>)
;;;;
;;;;		| !table_activate  <lparms>(<stamp-term>; <oa-term>)
;;;;		| !table_deactivate<lparms>(<stamp-term>; <oa-term>)
;;;;
;;;;		| !table_delete<parms>(<stamp-term>; <oa-term>)
;;;;
;;;;		| !table_commit<cparms>(<stamp-term>; <oa-term>)
;;;;		| !table_undo  <cparms>(<stamp-term>; <oa-term>)
;;;;
;;;;	<lparms>	: {<sequence>:n, LIBRARY:t}
;;;;	<parms>		: {<sequence>:n, <table>:t}
;;;;	<cparms>	: {<sequence>:n, <table>:t, <id>:t}
;;;;
;;;;	<id> is opid of broadcast being completed.
;;;;	<sequence> : Every non-completion broadcast will eventually be discharged with
;;;;	  a completion broadcast. The completion can be matched with the broadcast
;;;;	  being discharged by matching the sequence numbers.
;;;;	<table> is kind of table, ie LIBRARY, STATEMENTS, ABSTRACTIONS, RULES, PROOFS,
;;;;	  DFORMS, or PRECEDENCES.
;;;;
;;;;	Consider adding new broadcast: At end of a transaction after all
;;;;	completions completed, send to any table having received any committed
;;;;	broadcasts during the transaction. This could be used to trigger
;;;;	rehashing of non-essential caches, ie caches which are not required to
;;;;	be continuously fresh (eg, dforms and precedence).
;;;;	  - !table_end {<sequence>:n, <table>:t}(<stamp-term>)
;;;;
;;;;  -page- 
;;;;
;;;;	Comment export term:
;;;;
;;;;	It is anticipated that comment objects may be used as a static means of
;;;;	pooling dependencies. To facilitate such use the export term will
;;;;	contain the dependencies of objects statically referenced at translation
;;;;	time. Comment broadcasts will be sent to refiner components, ie:
;;;
;;;;	!table_insert{<sequence>:n, COMMMENTS:t}(<stamp-term>; <definition-term>)
;;;;
;;;;	The comment export term embedded in the definition term will be:
;;;;
;;;;	<comment-export-term>	: <dependency-term-list>
;;;;
;;;;
;;;; -doct- (mod lib)
;;;	 * simultaneous, non blocking.
;;;;	 * transmits effects of modifications.
;;;;	 * produced at act, commit, and undo.
;;;;	   - as undo contains no data, remote table must remember old values until
;;;;	     commit or undo.
;;;;
;;;;	Library order is should be irrelevant in refiner.
;;;;	However, the editor requires order of display objects.
;;;;
;;;;
;;;;	<broadcast-listeners>	: <closure{f}> list
;;;;	 * f (<broadcast>)	: (values)
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	Transaction consistency : all effects of events are globally felt
;;;;			    	  prior to any remote requests being processed.
;;;;	 * Effected by blocking <req>'s at io links if there are pending <ack>'s for
;;;;	   broadcasts.
;;;;	   -  reliable ordering is not sufficient as a <req> may jump ahead of a 
;;;;	      broadcast when passing through an intermediate (wrt <req>) node.
;;;;	 * An ml-evaluation (ie the *completions* scope) will not be exited
;;;;	   until all acks are received. RLE ??? is ml-eval right for *completions*.
;;;;	
;;;;  -page-
;;;;	
;;;;	Macros used to build primitive directives:
;;;;
;;;;	build-directive((<oas> <term{cmd}>) &body{act} &body{undo} &body{commit})
;;;;	 * when evaluated, instance returns 	: <completion>
;;;;	 * when evaluated, commit returns	: <broadcast> | nil
;;;;	build-sequence-directive ($body)
;;;;	 * when evaluated, instance returns	: (<completion{undo}> . <completion{commit}>)
;;;;	 * used to encapsulate a body which may emit multiple completions.
;;;
;;;;
;;;;	make-ml-directive (&body)
;;;;	 * when evaluated, body returns		: <completion>
;;;;						| (<completion{undo}> . <completion{commit}>)
;;;;	 * when evaluated, instance returns	: Directive
;;;;
;;;;	Thus, the way usual to make a directive would be:
;;;;
;;;;	(defun <lisp-cmd> (<args>)
;;;;	 (build-directive <code>))
;;;;
;;;;	(defunml (<ml-cmd>) <args>
;;;;	  ([<arg-types> -> directive])
;;;;	 (make-ml-directive <lisp-cmd>))
;;;;
;;;;
;;;;  -page-
;;;;	
;;;;	
;;;;	Library Journal : Journal of committed action requests.
;;;;
;;;;	 Journal is a list of table update broadcasts.
;;;;
;;;;	In the event of a failure, replay from a checkpoint allows re-establishment of
;;;;	library state.
;;;;	
;;;;  -page-
;;;;	
;;;;	
;;;;	Dependencies : text abstraction statement proof
;;;;
;;;;	modifying object nullifies current dependencies.
;;;;	which is distinguishable from depending on nothing.
;;;;
;;;;
;;;; -doct- (mod lib)
;;;;
;;;;	Library : exist in interpreter state. Manipulated through primitive
;;;;	          functions. Consists of an ordered list of objects.
;;;;
;;;;	Objects contain varying amounts of data from simple text comments to
;;;;	entire proof trees. Object data is organized into several distinct
;;;;	primitive types. All manipulation of object data is done functionally.
;;;;	
;;;;	 * modifications include:
;;;;	  - changing source, also nullifies dependency list.
;;;;	  - translating source.
;;;;	  - changing attributes.
;;;;	
;;;;	Translation : source -> substance. 
;;;;	  - dependency check??
;;;;	  substance : distrubuted when active.
;;;;	Activation : check coherency contraints.
;;;;	  - check that adding substance to library does not violate 
;;;;	
;;;;
;;;;	Before an object may be used it must be activated. Usage includes:
;;;;	 - using an abstraction to expand a term.
;;;;	 - using a rule to perform a primitive refinement.
;;;;	 - using a statement as a lemma in a proof.
;;;;	 - using a proof extract to expand a termof.
;;;;	 - using a display form to format a term.
;;;;
;;;;	Prior to activation, objects must be translated. Once translation is
;;;;	done the results are cached. Thus translation only needs to be done only
;;;;	once after a modification. Translation is done implicitly by activation
;;;;	if the object has been modified.  However, it may be performed
;;;;	asynchrounously as well. Translation may refresh the dependency list.
;;;;
;;;;	
;;;;	Substantive Change: some modifications to objects have no effect on the
;;;;	 interpretation of the object. A substantive change is a modification
;;;;	 which may have an effect on the interpretation of the object.
;;;;
;;;;	 A change to the source of an any object is a substantive change if
;;;;	 after source reduction the old and new values differ. Some objects
;;;;	 recognize additional modifications as substantive.
;;;;
;;;;	 Functions which may make substantive changes have a force flag.  If a
;;;;	 substantive change is made and the flag is false, then the function
;;;;	 will fail. An object must not be active to be modified substantively.
;;;;	 The function will fail if force is true and object is active even
;;;;	 if the change would not have be substantive.
;;;;
;;;;	DDag Change: A modification which changes the dependencies referenced
;;;;	 by an object is not a substantive change. However, in order to make a
;;;;	 ddag change the object must not be active. If a ddag change is made
;;;;	 and the object is active a failure will occur.
;;;;
;;;;
;;;;
;;;;	object_contents	: an abstraction for manipulating an object without
;;;;			  modifying the library.
;;;;
;;;;	inf_tree	: an abstraction for manipulating a tree of objects 
;;;;			  representing a proof.
;;;;	  * nodes of an inf tree are object contents.       
;;;;
;;;;	inf_step	: an abstraction for manipulating proof specific data of object
;;;;			  contents.
;;;;	  * contains tactic, goal, partial extract, interior proof top, etc.
;;;;	  * the proof top is itself an inf-tree.
;;;;	
;;;;  -page-
;;;;
;;;;	
;;;;	All objects have following fields:
;;;;	
;;;;	* Kind:
;;;;	 - COM	: comment
;;;;	 - ABS	: abstraction
;;;;	 - STM	: statment
;;;;	 - PRF	: proof
;;;;	 - INF	: inference
;;;;	 - CODE	: code
;;;;	 - PREC	: precedence
;;;;	 - RULE	: rule
;;;;	
;;;;	 * Source : Term, modifiable.
;;;;
;;;;	 * Status : determined by state of object.
;;;;	  - translated	: there is a cached translation.
;;;;
;;;;	 * Dependency	: object address, transaction stamp pair when object last modified.
;;;;
;;;;	 * References	: list of dependencies when object last interpreted.
;;;;	   - text dependendencies on abstraction objects.
;;;;
;;;;	 * Advice : system recognized properties.
;;;;	  - geometry		: geometry of edit window.
;;;;	  - implicit		: implicit variables for display.
;;;;	  - description		: term : description of environment suitable for
;;;;				  interpreting object.
;;;;
;;;;	 * Property List : 
;;;;	  - (<tok> . <term>) list
;;;;
;;;;  -page-
;;;;
;;;;
;;;;	STM Objects have additional :
;;;;
;;;;	 * Statement	: statment of theorem.
;;;;	   - produced by translation.
;;;;
;;;;	 * Proof List	: list of object addresses of proofs.
;;;;	   - modifiable.
;;;;
;;;;	 * references : PRF objects contained in proof list.
;;;;	  - prevents proofs from referencing statement as lemma.
;;;;
;;;;	 * translation fails if any proof does not match lemma.
;;;;
;;;;  -page-
;;;;
;;;;
;;;;	PRF Objects have additional :
;;;;
;;;;	 * source is goal. Source may not be substantively modified
;;;;	   if there is an inf tree.
;;;;
;;;;	 * Inf Tree	: inf_tree
;;;;	   - modifiable, substantive change extract or goal.
;;;;	    * top goal must match reduced source.
;;;;
;;;;	 * Extract	: extract term for proof.
;;;;	
;;;;	 * Advice: 
;;;;	  - extract : indicates whether extract should be maintained.
;;;;
;;;;	 * Or source is meaningless. inf tree tree is treated similar to source. 
;;;;	   substantive change would be change in goal of top inf of tree
;;;;	   change in extract.
;;;;
;;;;	 * References : cumulative references of INF objects contained in inf tree.
;;;;
;;;;
;;;;  -page-
;;;;
;;;;
;;;;	INF objects have additional : Could be derived from an intp(currently ML) object.
;;;;
;;;;	 * source is tactic.
;;;;	  - in top most refinements. We'll call these lib-level refinements.
;;;;	    !void() would imply unrefined or source built by tactic for
;;;;	    tactic refiner call.
;;;;
;;;;	 * refine 	: an additional translation step.
;;;;
;;;;	 * inf_step	: refinement.
;;;;
;;;;	 * References :
;;;;	  - from tactic eval and refinement.
;;;;
;;;;	 * activate/deactivate are no-ops. except possible ddag updates?
;;;;
;;;;  -page-
;;;;
;;;;
;;;;	ABS objects have additional :
;;;;
;;;;	 * abstraction 
;;;;
;;;;  -page-
;;;;
;;;;
;;;;	RULE objects have additional :
;;;;
;;;;	 * rule def. 
;;;;
;;;;  -page-
;;;; -doct- (mod lib ml)
;;;;
;;;;
;;;;	ML objects : Maybe should be EVAL or INTP (interpreter)
;;;;
;;;;	 * Activating an ML object causes evaluation of expression contained
;;;;	   in object.
;;;;	 * component-advice :
;;;;	   tok list - `REF`, `LIB`, `EDD`, or `COM`
;;;;
;;;;  -page-
;;;;
;;;;	References:
;;;;
;;;;	The references contained in objects are only the immediate
;;;;	dependencies. There is dependency dag maintained with the dependencies
;;;;	of active objects. Additional dependency information is available from
;;;;	the dag. See DDAG.
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	ML primitives for manipulating library and library objects.
;;;;
;;;;	lettype directive = (unit -> ((unit -> unit) # (unit -> unit)))
;;;;	 * unit -> undo # commit
;;;;
;;;;
;;;;  -page-
;;;;
;;;;
;;;;	Primitives for accessing library :
;;;;
;;;;	lib_begin_address		: unit -> object_address
;;;;	lib_end_address			: unit -> object_address
;;;;	lib_range			: object_address
;;;;						-> object_address -> object_address list
;;;;	 * lib_range lib_begin_address() lib_end_address() returns whole library.
;;;;	lib_next_address		: object_address -> object_address
;;;;	lib_prev_address		: object_address -> object_address
;;;;
;;;;	dependency_to_object_addresses	: dependency -> object_address list
;;;;	
;;;;  -page-
;;;;
;;;;	Object_contents are accessed in library	via an object_address.
;;;;	Library is modified by storing object contents to an address.
;;;;
;;;;
;;;;	Primitives for accessing library contents:
;;;;
;;;;	lib_object_contents 	: object_address -> object_contents
;;;;
;;;;	lib_export_term	: object_address -> term
;;;;	  * object_contents must have been translated.
;;;;
;;;;	lib_definition_term	: object_address -> term
;;;;	  * object must be active.
;;;;
;;;;
;;;;	Primitives for modifying library:
;;;;	
;;;;	lib_create	: object_address -> object_address{place} -> directive
;;;;	 * Object is inserted before place.
;;;;
;;;;	lib_delete	: object_address list -> directive
;;;;	 * fails if any objects addressed are active.
;;;;
;;;;	lib_move	: object_address list -> object_address -> directive
;;;;	 * move each member of list prior to object_address in listed order.
;;;;	 * the members of the list do not need to be adjacent.
;;;;
;;;;	lib_store	: object_address  -> object_contents -> bool{force} -> directive
;;;;
;;;;	lib_activate		: object_address -> directive
;;;;	 * fails if translation required and translate fails.
;;;;	 * fails if not translated. 
;;;;	lib_deactivate		: object_address -> directive
;;;;	lib_active_p		: object_address -> bool
;;;;
;;;;  -page-
;;;;
;;;;
;;;;	Primitives for manipulating common object_contents :
;;;;
;;;;	objc_contents		: tok{kind} -> object_contents
;;;;	
;;;;	objc_source		: object_contents -> term
;;;;	objc_kind		: object_contents -> tok{STM|PRF|DISP|ABS|COM|CODE|PREC|INF}
;;;;	& objc_status        	: object_contents -> bool list {modified}
;;;;	objc_modified_p        	: object_contents -> bool
;;;;	objc_references      	: object_contents -> dependency list{text}
;;;;	objc_dependency		: object_address -> object_contents -> dependency
;;;;	 * dependency at last substantive store into library.
;;;;	 * object address does not have to be current address of contents.
;;;;
;;;;	objc_modify_source	: object_contents -> term -> object_contents
;;;;	objc_translated_p	: object_contents -> bool
;;;;	 * objc must be translated for references/extract/statement to be available.
;;;;	objc_translate		: object_contents -> object_contents.
;;;;	 * unconditionally performs translation.
;;;;	 * if inf object then any objects in contained trees must have been translated
;;;;	   previously.
;;;;
;;;;	%objc_parse		: object_contents -> unit
;;;;	 * fails if parse fails.
;;;;	 * parses ml and inf objects, no-op otherwise.
;;;;
;;;;	objc_geometry_advice	: object_contents -> int list {x y width height}
;;;;	objc_geometry_advise	: object_contents -> int list -> object_contents
;;;;
;;;;	objc_implicit_advice	: object_contents -> variable list
;;;;	objc_implicit_advise	: object_contents -> variable list -> object_contents
;;;;
;;;;	objc_description_advice	: object_contents -> term
;;;;	objc_description_advise	: object_contents -> term -> object_contents
;;;;
;;;;	objc_get_properties	: object_contents -> (tok # term) list
;;;;	objc_set_properties	: object_contents -> (tok # term) list -> object_contents
;;;;
;;;;	objc_property		: object_contents -> tok -> term
;;;;	objc_add_property	: object_contents -> tok -> term -> object_contents
;;;;	objc_remove_property	: object_contents -> tok -> object_contents
;;;;
;;;;  -page-
;;;;
;;;;	statement source
;;;;	  - term : goal source
;;;;	  - object_id {proof} list, 
;;;;
;;;;	statement substance
;;;;	  - object_id {proof} list
;;;;	      * subset of the source proofs
;;;;		  - substance goals match.
;;;;		  - prf active (and thus complete)
;;;;	  - reduced term : goal
;;;;	
;;;;
;;;;	STM special primitives:
;;;;
;;;;	stm_objc_src_proofs		: object_contents -> object_id list
;;;;	stm_objc_src_modify_proofs	: object_contents -> object_id list -> object_contents
;;;;
;;;;	stm_objc_goal		: object_contents -> term
;;;;	stm_objc_proofs		: object_contents -> object_id list
;;;;
;;;;	
;;;;  -page-
;;;;	
;;;;	Proof source : inf tree.
;;;;	Proof substance : goal, extract, dependencies, ???
;;;;
;;;;	PRF special primitives:
;;;;
;;;;	prf_objc_src_inf_tree		: object_contents -> inf_tree
;;;;	prf_objc_src_modify_inf_tree	: object_contents -> inf_tree 
;;;;						-> object_contents
;;;;	prf_objc_src_delete_inf_tree	: object_contents -> object_contents
;;;;
;;;;	?prf_objc_src_extract_advice	: object_contents -> bool
;;;;	?prf_objc_src_extract_advise	: object_contents -> bool -> object_contents
;;;;	 * default is false.
;;;;
;;;;
;;;;	prf_objc_goal		: object_contents -> goal
;;;;	prf_objc_extract	: object_contents -> term
;;;;
;;;;
;;;;  -page-
;;;;
;;;;	inf :
;;;;	
;;;;	
;;;;	<inf-source>	: <term{tactic}> <goal> <annotations> <inf-step>
;;;;	
;;;;	<inf-substance>	: <inf-step{abbrev}>
;;;;	
;;;;	source inf-step is produced by reducing tactic and goal and refining.
;;;;	translate fails if source inf-step does not match goal and tactic.
;;;;	
;;;;	translate derives new substance if source and substance differ in any 
;;;;	discernable way. FTTB, this may be if they are not in fact identical.
;;;;	ie the substance inf step is the abbreviation of the source.
;;;;
;;;;
;;;;	INF primitives:
;;;;
;;;;	inf_objc_src_step		: object_contents -> inf_step
;;;;
;;;;	inf_objc_src_modify_step	: object_contents -> inf_step -> object_contents
;;;;	 * source of object must match tactic of inf_step.
;;;;
;;;;	inf_objc_src_delete_step	: object_contents -> object_contents
;;;;
;;;;	
;;;;	<inf-tree>		: <objc{inf}> <inf-tree> list
;;;;	
;;;;	<goal>			: <term> <term>list
;;;;	
;;;;	<source{inf}>		: <term{tactic-source>} <goal{source}> <inf-step>
;;;;	<substance{inf}>	: <term{!void()>} <inf-step-abbrev>
;;;;	
;;;;	<inf-step>		: <goal{reduced}> <refinement> <term{annotation}>list 
;;;;	<inf-step-abbrev>	: <goal{reduced}> <abbrev-refinement>
;;;;
;;;;	<refinement>		: <top-refinement>
;;;;				| <abbrev-refinement>
;;;;				| <primitive-refinement>
;;;;	
;;;;	<refinement-super>	: <stamp> <dependencies> <subgoals>
;;;;	
;;;;	<top-refinement>	: <refinement-super> <tactic> <inf-tree{interior}
;;;;	<abbrev-refinement>	: <refinement-super> <tactic> <extract>
;;;;	<primitive-refinement>	: <refinement-super> <extract>
;;;;	
;;;;
;;;;	inf-step has annotation list to allow refiner to return info annotations, 
;;;;	inf-step may occur outside of objc so need property list available.
;;;;	
;;;;	
;;;;	Each inf-step may need to be interacted with. Thus each inf-step can
;;;;	be coereced into an objc. Thus an inf-tree term is unrolled into a tree of
;;;;	object_id's bound to object contents.
;;;;	  
;;;;	Using infs : choice of copy or link, link makes a reference via the oid.
;;;;
;;;;	
;;;;
;;;;  -page-
;;;;
;;;;
;;;;	ABS special primitives:
;;;;
;;;;	objc_abs_abstraction	: object_contents -> term
;;;;	 * source reduced version of source.
;;;;
;;;;  -page-
;;;;
;;;;
;;;;	RULE special primitives:
;;;;
;;;;	objc_rule_rule	: object_contents -> term
;;;;	 * term suitable for interpretation.
;;;;
;;;;  -page-
;;;;
;;;;
;;;;	During refinement tactics may annotate proofs. These annotations may be
;;;;	returned in the subgoals produced by the refiner.
;;;;
;;;;	We would like to maintain an invariant that a proof is reproducible from
;;;;	the sequent of the main goal and the tactic tree. For the sake of this
;;;;	invariant, goals match when grafting inf_trees together, only if the
;;;;	sequents and tactic annotations are identical.
;;;;	Also, if interior trees are replaced, the trees must match.
;;;;	
;;;;
;;;;	Two dimensions to an inf_tree:
;;;;
;;;;	 exterior : the inf_tree
;;;;	 interior : an inf_tree in a node of an inf_tree.
;;;;
;;;;	  all inf_tree's are exterior. Inf trees which are not part of an interior will
;;;;	  be referered to as non-interior or outermost exterior trees.
;;;;
;;;;
;;;;	Two types of refinement:
;;;;
;;;;	 direct   : Library called a refiner directly to produce inf_step.
;;;;	 indirect : inf_step was created to represent a recursive call of a
;;;;	 	    refiner by a refiner.
;;;;
;;;;	 indirect steps are necessarily interior.
;;;;	 all inf_steps of an outermost exterior tree are necessarily direct.
;;;;	 Note though that one may build an interior tree within the library
;;;;	 consisting of direct inf steps.
;;;;
;;;;	All refined inf steps contain a stamp. The stamp is unique to the
;;;;	refinement and is assigned when the refined inf-step is created. Copying
;;;;	of inf-steps does not change the stamp. Thus is it possible to have
;;;;	multiple inf steps with identical stamp.
;;;;	The stamp also survives a disk write then read.
;;;;
;;;;	All nodes of an exterior inf-tree will be similar wrt directness.
;;;;
;;;;	Then a direct inf tree is an inf tree where the steps of nodes are
;;;;	direct.
;;;;
;;;;	These preceding invariants are guaraunteed by the constructors.
;;;;
;;;;	All exterior parents of a direct tree must be direct also, ie an
;;;;	indirect tree may not contain a direct tree in its interior.
;;;;
;;;;	Modifications of indirect refinements require identical stamps.
;;;;	Unrefined leaves or an indirect tree will have no stamp, thus
;;;;	goal match is tested instead.
;;;;
;;;;	Certain modifications require matching of inf_trees or inf_step goals:
;;;;
;;;;	goal_match_p		: (term # term list) ->
;;;;					(term # term list) -> bool
;;;;	 * true when :
;;;;	  - sequents are identical.
;;;;	   * May need to allow the more liberal sequent equality as in refiner.
;;;;	   * Could allow alpha-equality if extractor does renaming.
;;;;	  - annnotation term list is identical, including order.
;;;;
;;;;	inf_tree_match_p	: inf_tree -> inf_tree -> bool
;;;;	 * true when
;;;;	  - exterior trees muust have identical structure.
;;;;	  - indirect
;;;;	   * all refined nodes of inf trees must have same stamps.
;;;;	  - direct
;;;;	   * all goals match.
;;;;
;;;;
;;;;	inf_tree primitives:
;;;;
;;;;	inf_tree			: object_id{inf} -> inf_tree list -> inf_tree
;;;;	 * inf_tree list must match subgoals of inf_step of object_contents of inf id.
;;;;	 * fails if uniformity of direct flag would be violated in resulting tree.
;;;;
;;;;	inf_tree_object_contents	: inf_tree -> object_contents{inf}
;;;;	inf_tree_object_id		: inf_tree -> object_id{inf}
;;;;	inf_tree_children		: inf_tree -> inf_tree list
;;;;
;;;;
;;;;	inf_tree_extract		: inf_tree -> term
;;;;	 * may be partial, partial addresses will be relative to argument.
;;;;
;;;;	TODO Fttb: following are unreliable.
;;;;
;;;;	inf_tree_replace_node		: inf_tree -> object_contents -> int list
;;;;						-> inf_tree
;;;;	 * using int list as address, replaces object contents of tree in first arg at address
;;;;	   with second arg.
;;;;	 * goal of inf-step of target must match goal of inf-step of second arg.
;;;;	 * if target objc is unrefined
;;;;	   -  then second arg must be unrefined.
;;;;	 * if target inf-step is indirect
;;;;	   -  then refinement stamps of inf-steps must be equal.
;;;;	 * fails if replacement would violate uniformity of direct flag in resulting tree.
;;;;
;;;;	inf_tree_replace_tree		: inf_tree -> inf_tree -> int list
;;;;						-> inf_tree
;;;;	 * using int list as address, replaces tree in first arg at address with second arg.
;;;;	 * if target tree is direct or unrefined
;;;;	   -  then goal of target must match goal of second arg.
;;;;	 * if target tree is indirect
;;;;	   -  then target tree must match second arg.
;;;;	 * fails if replacement would violate uniformity of direct flag in resulting tree.
;;;;
;;;;	inf_tree_find		: inf_tree -> int list -> inf_tree
;;;;
;;;;	inf_tree_abbreviate	: inf_tree -> int list -> inf_tree
;;;;	 * abbreviates inf_tree at address. Last int of address must be zero.
;;;;	 * RLE ??? maybe trivial to define this wrt other available functions
;;;;	   RLE ??? ie replace_node abbrev_inf_step.
;;;;
;;;;
;;;;	Other functions of this nature are desirable. When the needed funtionality becomes
;;;;	apparent they will be added. Also, one ought to be able to code up what they need
;;;;	using the primitives supplied here.
;;;;
;;;;  -page-
;;;;
;;;;	
;;;;	inf_step primitives : goals are (term # term list) where the term list is the
;;;;	 		      annotations added by the tactic during refinement.
;;;;
;;;;	inf_step			: (term # term list) -> inf_step
;;;;	 * term is goal.
;;;;	 * term list is proof annotation list.
;;;;
;;;;	inf_step_type		: inf_step -> tok
;;;;	 * one of TOP, ABBREV, PRIMITIVE, or UNREFINED.
;;;;
;;;;	inf_step_goal			: inf_step -> (term # term list)
;;;;	 * present in all inf_steps.
;;;;
;;;;	inf_step_info_annotations	: inf_step -> term list
;;;;	 * present in all inf_steps.
;;;;	 * annotations added by refiner, editor (user).
;;;;
;;;;	inf_step_refined_p	inf_step -> bool
;;;;
;;;;	inf_step_tactic		: inf_step -> term
;;;;	 * present in TOP and ABBREV inf_steps.
;;;;
;;;;	inf_step_subgoals		: inf_step -> (term # term list) list
;;;;	 * present in TOP, ABBREV, and PRIMITIVE inf-steps.
;;;;
;;;;	inf_step_references 		: inf_step -> (tok # dependency list) list
;;;;
;;;;	inf_step_inf_tree	: inf_step -> inf_tree
;;;;	 * present in TOP inf_steps.
;;;;
;;;;	inf_step_extract	: inf_step -> term
;;;;	 * present in ABBREV and PRIMITIVE inf_steps.
;;;;	
;;;;	
;;;;
;;;;	inf_step_modify_inf_tree	: inf_step -> inf_tree -> inf_step
;;;;	 * inf_tree must match current inf_tree in inf_step.
;;;;	
;;;;	inf_step_abbreviate		: inf_step -> inf_step
;;;;	 * abbreviates interior proof. fails if interior proof is direct.
;;;;
;;;;	inf_step_refine			: term {description} ->
;;;;					    inf_step ->
;;;;					      term{tactic} ->
;;;;						object_address list  -> inf_step
;;;;	 * fails if refinement fails.
;;;;	
;;;;	The correctness of the proofs is assured through the proper handling of
;;;;	the inf_steps's. The only way to produce a refined inf_step is through
;;;;	refinement.
;;;;
;;;;	Users may decorate their proof trees with data through the object advice
;;;;	and other modification procedures. Careful merging of refined inf_trees
;;;;	with old inf_trees should preserve such user data.
;;;;
;;;; -doce-


;;;;
;;;; -docs- (mod lib)
;;;;	
;;;;	Oid : an abstact id which can be used to locate object contents.
;;;;
;;;;	 Oids are implemented as stamps, an oid could be considered an
;;;;	equivalence class of stamps where the members of the class consist of the
;;;;	closure of the oid maps. As stamps are persistent and the map is
;;;;	persistent old data does not need to be fixed up when new data is
;;;;	associated with an oid. Eg, object contents A may contain an occurence
;;;;	of oid b.  b may be mapped b' which labels object contents B. When the
;;;;	map is extended b now refers to B without requiring modification of A.
;;;;	
;;;;	
;;;;	oid is stamp.
;;;;	stamp need not be from current process.
;;;;	oid is bound to object contents.
;;;;	oc is persistent data, oc is stamped.
;;;;	oid and oc stamp are not the same.
;;;;	an oid may be rebound to another oc.
;;;;	the stamp of an oc can not be changed.
;;;;	the interpretaion of the oids in an oc depend on the bindings of the oids.
;;;;	a set of oid bindings defines an environment.
;;;;	two env may share the persistent data of an oc but their interpretations
;;;;	may differ.
;;;;	an environment may be distributed.
;;;;	an oid is intepreted when referenced not when instantiated.
;;;;	  - thus reading of persistent data does not require map
;;;;
;;;;	within an environment we could represent oids as natural numbers.	
;;;;	but then we need centralized control over allocation of numbers and
;;;;	mapping and unmapping when exporting and importing from environment.
;;;;	read/write to persistent store would require import/export.
;;;;	
;;;;	the mapping of oids to oids is apparently not a good idea.
;;;;	
;;;;	Stamps now serve double duty as direct references to immutable data
;;;;	and indirect mutable references. The role of the stamp is determined
;;;;	by the prescence of an oid wrapper and oid map.
;;;;	
;;;;	Until some obvious benefit is apparent, stamps used as oids will not
;;;;	overlap the stamps used as direct references.
;;;;	
;;;;	
;;;;	Note abscence of ordering from directives. If ordering required
;;;;	it can be done via properties containing oids. Or wrappers on source
;;;;	containing oids which will then show in dependency graph.
;;;;	
;;;;
;;;;	
;;;;	Event : an evaluation or computation during which reference data is collected.
;;;;
;;;;	Static reference : occurence of object id in data.
;;;;	Event reference : a use of an object id during an event.
;;;;	
;;;;	Events may be contained in object data or may occur independently in ddag.
;;;;	Dependency data should not be duplicated in ddag and object.
;;;;
;;;;	DDag must have table to hold independent events and independent events must
;;;;	be broadcast so as to be persistent.
;;;;
;;;;	At the moment there are no independent events.
;;;;	??? It is not clear yet if events will occur in store which are not
;;;;	??? referenced by object data. There is no difficulty in allowing it.
;;;;	??? Even if no need is currently found, such capability ought to be
;;;;	??? supported
;;;;	
;;;;	Thus events will be named by stamps and stored independently in the 
;;;;	DB. Object data will indirectly include events by containing the stamps
;;;;	of events.
;;;;
;;;;	It is not true that at eval time a static reference in an event
;;;;	argument results in an event reference. For example, an abstraction
;;;;	instance may occur in source but may not be expanded during translation.
;;;;
;;;;	Also, event references may be made to oids which do not occur statically
;;;;	in data.  For example, during refinement references are made to rules
;;;;	which do not occur in refinement args. Stuart has suggested a method
;;;;	whereby rule sentinels are specified as args to refinement so that such
;;;;	references are statically apparent. However even in such a case
;;;;	recording of the actual refencences made is beneficial so as to detect
;;;;	which rules in the sentinel where actually used. The sentinel is
;;;;	sufficient, though, for dependency analysis. Similar methods could be
;;;;	employed to cause most if not all references to be static.
;;;;	
;;;;	
;;;;	Data :
;;;;
;;;;	<description>	: <term>
;;;;	  * attributes of and environment or an event.
;;;;
;;;;	<data>		: <term>
;;;;
;;;;	<source>	: <stamp> <data>
;;;;
;;;;	<substance>	: <stamp> <data>
;;;;
;;;;	<event>		: <stamp> <description{event}> <ddag-fragment>
;;;;
;;;;
;;;;	<dependency>	: <stamp{referenced}>
;;;;			  <stamp{oc of referenced at time of reference}>
;;;;			  <oid{of object of oc at time of reference}>
;;;;
;;;;	<ddag-link>	: <stamp{referencer{data?}}> <env-dependencies> list
;;;;
;;;;	<ddag-fragment> : <ddag-link> list
;;;;	
;;;;
;;;;	<oc>		: <stamp> <token{kind}> <stamp{translate-event}> <source> <substance>
;;;;
;;;;	<oc-abbrev>	: <stamp{oc}> <token{kind> <stamp{translate-event}> <stamp{source} <stamp{substance}>
;;;;
;;;;	<object>	: <oid> <oc>
;;;;	
;;;;
;;;;	Stamps are universal persistent abstract identifiers for data.
;;;;	Data is preseved as much as possible.
;;;;	Dependencies among data are accounted in detail.
;;;;	Stamps are used as addresses to data.
;;;;
;;;;	Object contents : 
;;;;	  - substance : data needed to activate
;;;;	      * could reference source used to produce substance.
;;;;	      * stamped when produced.
;;;;	      * effort is expended to preserve the stamp of the substance in the
;;;;		face of non-substantive modifications.
;;;;	  - source :  data needed to produce substance.
;;;;	      * could reference a previous version.
;;;;	
;;;;	Library :
;;;;	  - manage bindings of object ids to contents.
;;;;	  - manages tables of data, broadcasts.
;;;;	  - provide interface to ddag. {could be done independently}
;;;;
;;;;
;;;;	Directives : 
;;;;
;;;;	bind (<oid> <oc>)	: <directive>
;;;;	unbind (<oid> <oid>)	: <directive>
;;;;	
;;;;	allow (<oid>)		: <directive>
;;;;	disallow (<oid>) 	: <directive>
;;;;
;;;;	activate (<oid>)	: <directive>
;;;;	deactivate (<oid>) 	: <directive>
;;;;	
;;;;	create ()		: <oid>
;;;;	lookup (<oid>)		: <oc>
;;;;	equal(<oid> <oid>)	: BOOL
;;;;
;;;;
;;;;	
;;;;
;;;;			| !definition_insert{<seq>:n, LIBRARY:t}(<definition{object}>)
;;;;			| !definition_delete{<seq>:n, LIBRARY:t, <oid>:o}
;;;;	
;;;;	
;;;;	<definition{object}>	: !definition(<dependency{oc}>; <export-term{oc}>
;;;;	
;;;;	<export-term>d	| !oc{<kind>:t}(%<stamp{oc}>;% in dependency.
;;;;					<stamp{source};
;;;;					<stamp{translate-event}>;
;;;;					<stamp{substance}>)
;;;;
;;;;	<dependency>	| !dependency{<oid>:o}(<stamp{oc}; !void())
;;;;	
;;;;	
;;;;	source includes properties, changing properties may be a substantive
;;;;	change depending on property. non-substantive changes must be apparent
;;;;	when comparing source and substance and judging if retranslation required.
;;;;	substantive change loses substance and translate event, but does have
;;;;	history pointer.
;;;;
;;;;	requiring write of source with each property change may be excessive.
;;;;	if so then implement property lookup in odb via stamp of source. ie
;;;;	stamp names source in db and names properties as well. Ie properties in
;;;;	separate file or in a log file with other object's properties.
;;;;	
;;;;	edit short display strings could be maintained separately in
;;;;	assoc list of stamp of source and string. any mod to source then
;;;;	would require recompute of string.
;;;;	
;;;;	lib_ act/deact could be done as definitions where act first deletes
;;;;	inactive and inserts active and deact does opposite. However, more
;;;;	concise to send distinct and interpret as defs. Avoids transmission of data.
;;;;	OTOH if data is transmitted as stamp then why not.

;;;;	consider insert then activate : insert inactive then delete then insert active. 
;;;;	 could compress to insert active.
;;;;	
;;;;	
;;;;	

;;;;		  
;;;;	TODO : expound: begin should establish a transaction state and broadcasts should
;;;;	lookup and eval within t-state.
;;;;	supply method of calling hooks at transaction-end, ie process touch-history
;;;;
;;;;	There is no order of objects in the library. If order is desired among data
;;;;	then it must be coded into the data or into the ddag.
;;;;	
;;;;	
;;;;	Persistent Store : the persistent store serves two primary functions
;;;;	  - recovery : ability to reconstruct library state after crash or shutdown.
;;;;	  - access : ability to access object data from disk so as that data
;;;;		    need not reside in memory.
;;;;	  - share : it may be possible to transmit data by stamp addresses rather than
;;;;		by sending data itself. As file io appears faster than stream io or 
;;;;		at least may prevents the some io this could be significant. One interesting
;;;;		possibility would be for store start read of substance when it sees activate
;;;;		since it's likely that activate will require substance off disk.
;;;;
;;;;	Data on disk is never modified. New versions may be written but
;;;;	overwrites never occur.  GC should move and compress data not remove
;;;;	data.
;;;;	
;;;;	Data (object content components) is kept in random access database
;;;;	keyed on stamps.
;;;;
;;;;	Directives are logged such that essential information is kept in log
;;;;	but data itself is not. Intent is that log data will be in memory
;;;;	but data need not be.
;;;;	
;;;;	Directives are logged. Checkpoints are possible, a checkpoint
;;;;	is a point from which you can restore. Unwinding of library
;;;;	not supported but you can restore a checkpoint and then move forward.
;;;;	Which is equivalent to unwind.
;;;;	
;;;;	
;;;;	Data direct write : 
;;;;
;;;;	All data object or otherwise is addressed by stamps. All persistent data
;;;;	is stored on disk.  Frequently data needs to be passed about without
;;;;	examination. For processes with a shared filesystem it might be
;;;;	beneficial to simply pass around the stamps and not the data. Then when
;;;;	a process needs to examine the actual data the data can be read from
;;;;	disk using the stamp.
;;;;
;;;;	Complications:
;;;;	  - serializing writes and read among remote processes.
;;;;	  - disk thrashing.
;;;;	  - undone data left on disk (wasted space).
;;;;	
;;;;	Environments need direct access to store.
;;;;
;;;;	An example, edit writes source to disk, sends stamp to lib. Lib updates
;;;;	object_contents with stamp for source, and starts translate. Assume,
;;;;	object contains dform souce. Then translate may send source stamp back
;;;;	to edit to request translate. Edit does translate (finds source in
;;;;	memory) and writes event and substance to disk and replies with event
;;;;	and substance stamps to Lib. Lib updates object contents and adds to
;;;;	library. Add broadcast generated and written to disk by store. Broadcast
;;;;	causes DDag to read event data. Lib avoided reading data into memory. It
;;;;	is possible that writes to disk could be multiplixed with socket io. Ie
;;;;	when edit writes source it need not wait for write to complete before
;;;;	sending request to lib.
;;;;
;;;;	This could be a big win, but it does add complexity and may require some
;;;;	careful tuning.
;;;;	
;;;;	Other notes :
;;;;	  - read-ahead : in some instances it may be possible to identify
;;;;	    situations where you know data will be needed later. It would be a
;;;;	    simple matter to prod the log into reading the data into memory or
;;;;	    preventing data from being flushed from cache.
;;;;	
;;;;	
;;;;
;;;;	History/GC : 
;;;;	
;;;;	Soft reference : does not preclude GC of referenced data.
;;;;	Hard reference : does preclude GC of referenced data.
;;;;
;;;;	References are hard by default. Soft references must be declared.
;;;;
;;;;	Soft references are used to implement version control or history
;;;;	features.  Eg, if oid a is mapped to oid b, a soft reference from b to a
;;;;	could be recorded.
;;;;	
;;;;	
;;;;	Version control can be done by searching logs to find earlier binds.
;;;;	Thus no need for a soft link. A pointer to an objc is lost when the objc
;;;;	is unbound and then the log closed. On restore, the initial dump to the new
;;;;	log will not contain reference.
;;;;	
;;;;	
;;;;	Data which is not accessible via hard links is eligible for Garbage
;;;;	Collection.
;;;;
;;;;	GC'ed data is not lost but compressed and moved to less accessible
;;;;	storage, eventually to be moved to removable media (CD).
;;;;
;;;;	Functionality must be supplied to allow GC'ed data to be located and
;;;;	recovered.
;;;;	
;;;;	Folder folding : Each process creates a directory in the store.  Need a
;;;;	method of combining multiple directories into a single directory.  Could
;;;;	work in conjunction with GC.
;;;;	
;;;;	Objects should have a collectable bit. Collectable bit can be turned on/off ala
;;;;	activate/deactivate. If not active and collectable then can be collected.
;;;;	collectable bit could be specified at bind and be part of bind broadcast.
;;;;	Unbound objects are implicitly collectable (collected?).
;;;;	
;;;;	
;;;;	Journal : record or replay broadcasts.
;;;;
;;;;	journal-create (<environment> <tok{table-type}> list)
;;;;	  : <journal>
;;;;	  * journals broadcasts for tables specifed by table-type list.
;;;;
;;;;	journal-open (<stamp>)			: <journal>
;;;;	  * ie restore.
;;;;
;;;;	journal-checkpoint (<journal>)	: <stamp>
;;;;	  * needs to come via broadcast for serialization?
;;;;	    assume lib call checkpoint only at sensible junctures.
;;;;	  * can be restored.
;;;;
;;;;	journal-close (<journal>)	: <stamp>
;;;;
;;;;	journal-query () : (<environment-address> . (<description> . <stamp>)) list
;;;;	  * or use db-query???
;;;;
;;;;	
;;;; -doce- (mod lib)


;;;;	
;;;;	older probably irrelevant comments about oids:
;;;;	

;;;;	
;;;;	ObjectIds :
;;;;
;;;;	affects :
;;;;	  - address tables.
;;;;	  - term-sig tables -> basis tables.
;;;;	  - references/dependencies.
;;;;	  - messages.
;;;;	  - lib directives.
;;;;	  - persistent store/export/import : oids stored as stamps? or maybe filenames.
;;;;	    filenames and stamps should be interchangeable.
;;;;	    diskname would be diii where iii is an integer. diii is used as alias
;;;;	    for stamp. diii contains stamp.
;;;;
;;;;	Broadcasts : begin end transaction, etc. see com-ent.lsp
;;;;	
;;;;	Also with persistent store
;;;;	  - desire sharing among environments.
;;;;
;;;;	
;;;;	Working Map == Environment.
;;;;	
;;;;	Object identifiers:
;;;;	  - object-id [oid] : abstract id. Meaningful only within a working map.
;;;;	  - object-address [oa] : mnemonic not necessarily unique. 
;;;;	  - stamp : universally unique id for object contents.

;;;;	want to keep the lib-bcast record as method of finding history links or make
;;;;	history links explicit in disk data?
;;;;	
;;;;	any two oc's with same stamp must have identical term representations modulo stids.
;;;;	this may be key to merging working maps.
;;;;	
;;;;	an annoying scenario. Load object from disk make changes store. Reload original.
;;;;	second load gets new oid and first and second very similar but distinct objects.
;;;;	blowsup object space. Twould be nice to be able to detect multiple occurences of derived
;;;;	objects so as to be able to merge. need to detect multiple objects with same or equivalent
;;;;	substance.
;;;;	
;;;;	
;;;;	
;;;;	stid is stamp + int, all writes contain stamp of cur env but a map
;;;;	is maintained for stid to stid. Eg A has stid s,i and is read into t,j.
;;;;	B contains t,j and is written with t,j but there is a t,j -> s,i log
;;;;	written as well, if a store happens at t,j then a t,j -> t,j recored shadows the former.
;;;;
;;;;	could write the t,j -> s,i log at B write as if Store to A happens first then log not
;;;;	needed or if no store to B happens then no log needed, ie we may load up a bunch of 
;;;;	stuff not referenced which need not have oid map records logged. But read sets map
;;;;	so when writing first step is to write log map records of oids in write.
;;;;	
;;;;	
;;;;	  - want terms with same stamps to be same terms.
;;;;	  - need oid within term to map to oid of current environment.
;;;;	  - write of any term writes current oids? If no intervening store why not leave
;;;;	     as old oid to prevent map log and increase likelihood of compression. or even 
;;;;	    if there has been a store map log will cause map to new version so leave for benefit of compression.
;;;;	    so meaning of diskoid is dependent on mapping context. ie can include old disk term by wrapping	  
;;;;	    in oid map.
;;;;	
;;;;	
;;;;	boot-state-log(<tok{kind}>)		: 
;;;;	  * creates initial log for state.
;;;;	
;;;;	library-log-state(<tok{kind}> <update{term}>)
;;;;	  * writes term to log file.
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	


(defstruct library-sub-environment
  (table-logs)
  (oid-graph nil)
  (events)
  )


(defun oid-graph-of-lib-environment (env)
  (library-sub-environment-oid-graph (sub-of-environment env)))


(defun lib-environment-set-oid-graph (env og)
  (setf (library-sub-environment-oid-graph (sub-of-environment env)) og))

(defun reset-oid-graph ()
  (setf (library-sub-environment-oid-graph (sub-of-environment (current-environment))) nil))


(defstruct table-log
  (status nil)
  (stamp)
  (stream)
  (term)
  )

(defun stamp-of-table-log (tl) (table-log-stamp tl))
(defun stream-of-table-log (tl) (table-log-stream tl))
(defun term-of-table-log (tl) (table-log-term tl))

(defun table-log-journal (term)
  (make-table-log :status 'journal
		  :stamp (stamp-of-itable-log-term term)
		  :term term))

(defun table-log-active (stamp stream)
  (make-table-log :status 'active
		  :stamp stamp
		  :stream stream))


(defun table-log-open-p (tl)
  (and (table-log-stream tl) t))


(defun environment-log-push (env kind log)
  (let ((lib-sub (sub-of-environment env)))

    ;;(setf -log log) (break "elp")
    (setf (library-sub-environment-table-logs lib-sub)
	  (acons kind log
		 (delete-if #'(lambda (a)
				(and (eql kind (car a))
				     (not (table-log-open-p (cdr a)))))
			    (library-sub-environment-table-logs lib-sub))))))


(defun environment-state-out (term)
  (journal-state-out (ienvironment-state-term term)))
  
(defun new-environment-log (env kind log)
  (environment-log-push env kind log)
  (environment-state-out
   (itable-log-term kind 0
		    (idata-persist-term 'log (stamp-of-table-log log))) ))

(defun old-environment-log (env term)
  (environment-log-push env
			(kind-of-itable-log-term term)
			(table-log-journal term)))

(defun environment-log-lookup (env kind &optional allp)
  (let ((lib-sub (sub-of-environment env)))

    (if allp
	(mapcan #'(lambda (e)
		    (when (eql kind (car e)) (list (cdr e))))
		(library-sub-environment-table-logs lib-sub))
	(cdr (assoc kind (library-sub-environment-table-logs lib-sub))))))

;; to be used is suspect log is corrup. can be expensive.
(defun lose-log (kind)
  (let ((env (current-environment)))
    (let ((lib-sub (sub-of-environment env)))
      (let ((logs (mapcan #'(lambda (e)
				(when (eql kind (car e)) (list e)))
			    (library-sub-environment-table-logs lib-sub))))
	
	(if (null logs)
	    (raise-error (error-message '(lose log none) kind)) 
	    (dolist (alog logs)
	      (let ((log (cdr alog)))
		(when (table-log-open-p log)
		  (close-table-log kind log env nil))

		(setf (library-sub-environment-table-logs lib-sub)
		      (remove alog (library-sub-environment-table-logs lib-sub)))) ))))))


(defun lose-logs ()
  (lose-log 'ostates)
  (lose-log 'ddg))


    
(defun open-table-log (env kind olog)
  (let ((tstamp (stamp-to-term (new-transaction-stamp))))
    (let ((log (lite-log-open-write (term-to-stamp tstamp))))

      ;; check if status is journal???
      (unless (null olog)
	(log-write-record log (or (term-of-table-log olog)
				  (itable-log-term kind 0 (stamp-of-table-log olog)))))

      (let ((nolog (table-log-active tstamp log)))
		  
	;; remove old from env.
	(new-environment-log env kind nolog)

	nolog))))

(defun find-state-log (kind)

  (let ((env (current-environment)))

    (let ((olog (environment-log-lookup env kind)))
      ;; if not open then read from journal, thus replace with new linked.

      (when olog
	(if (table-log-open-p olog)
	    olog	    
	    (open-table-log env kind olog))))))


(defun boot-state-log (kind)

  (let ((env (current-environment)))

    (let ((tstamp (stamp-to-term (new-transaction-stamp))))
      (let ((log (lite-log-open-write (term-to-stamp tstamp))))
	    
	;;(setf -log log -env env -tstamp tstamp) (break "fol")

	(let ((nolog (table-log-active tstamp log)))

	  (new-environment-log env kind nolog)

	  nolog))) ))





;; table log is chain of log files.
;;
;; each file can be oid . term assoc
;;
;; some want to combine small files and
;; rehash those containing some percentage of shadowed entries.
;;
;; if more than %10 shadowed then rehash.
;; if 

;;;;	
;;;;	Size of file   :
;;;;	Number of files : 
;;;;	
;;;;	rehash when accumulated size of environment files exceeds some threshold
;;;;	or number of files exceeds some threshold.
;;;;
;;;;	after rehash desire 3 files.
;;;;	  - Stable (may actually be multiple files.
;;;;	  - stage : accumulate those to combine with stable : ie all those not shadowing
;;;;		or shadowed in last x generations.
;;;;	  - volatile
;;;;	
;;;;	a rehash increments generation counts.
;;;;	
;;;;	stage becomes stable after exceeding some size threshold and generation threshold.
;;;;	
;;;;	
;;;;	
;;;;	if more than 3 sequential files containing less than 10%
;;;;	then combine
;;;;	
;;;;	generations :
;;;;	
;;;;	  - distance down chain
;;;;	  - if rehashed but not shadowed then should have generation of curr + distance.
;;;;	
;;;;	  - if shadowed and not combined with shadower then
;;;;	
;;;;	
;;;;	stable -> those not shadowed last time stable rehashed.
;;;;	
;;;;	stage  : those not shadowed in some number of generations
;;;;	
;;;;	volative : those sh
;;;;	
;;;;	
;;;;	simple 3 :
;;;;	
;;;;	each file will be categorized : 
;;;;	
;;;;	  - dynamic : 
;;;;	  - volatile : 
;;;;	  - stage
;;;;	  - stable
;;;;	
;;;;	when 3 dynamics 
;;;;	  - compress into a stage and a volatile
;;;;	  - when 3 stages compress into one stage.
;;;;	  - when 
;;;;	
;;;;	v1, v2, v3, t1, t2, t3, s1, s2, s3
;;;;	
;;;;	dynamic compression : 
;;;;	  for each o in di, and v-old
;;;;	    if o shadows any si then v-new <- o.
;;;;	    else s-new <- o
;;;;
;;;;	stage-compression :
;;;;	  for each o in si
;;;;	    if not in vi then include in s-new.
;;;;	volatile compression combines all volatile and stages into one each.
;;;;	
;;;;	
;;;;	if a is in t1 then at last dynamic compression it was not shadowed.
;;;;	if b is in s1 then at last stage compression it was not shadowed.
;;;;	
;;;;	at some interval, if not shadowed more recently then move closer to stable.
;;;;	
;;;;	intervals : get larger by some progression.
;;;;	 combine with next to produce new next if new next exceeds then recurse.
;;;;	
;;;;	
;;;;	look only at more recent and infrequently disturb large files.
;;;;	
;;;;	consider combining a and b where a is smaller, and b is older.
;;;;	env contains most recent and may shadow b but known then do not shadow a.
;;;;	 foreach o in b if not shadowed by env or a then put in b'
;;;;	 foreach o in a put in b' then b' is bigger or same size and
;;;;	 no members are shadowed by earlier sets.
;;;;	
;;;;	
;;;;	if o in env then occurs previously 
;;;;	if o in result then added to env but did not occur before then.
;;;;	
;;;;	
;;;;	
;;;;	Simpler scheme : 
;;;;	
;;;;	 - have levels like 100 300 900 8100 24300
;;;;	
;;;;	desire sequence of files where newer are smaller and older bigger.
;;;;	   - expection is a small working set will be frequently written while
;;;;	     larger stable files will be less frequently updated.
;;;;	at the time a file is dumped then it contains no elements contained in earlier files.
;;;;	
;;;;	
;;;;	if no next then dump and quit
;;;;	elseif current exceeds threshold
;;;;       then dump and rehash next at higher threshold
;;;;	     - we avoid absorbing next to preclude makeing single monolithic file.
;;;;	elseif next exceeds threshold
;;;;	   then dump and quit.
;;;;	else ( current does not exceed threshold and next does exeed threshold)
;;;;	  dump and quit.
;;;;	
;;;;	Nots never lost, if object deleted then not entry written to shadow
;;;;	older entries. But if all shadowed removed still have not since no
;;;;	judgement is made if not is "real" entry.
;;;;	
;;;;	

;; assume file format is link to previous followed by updates.
;; returns list of log entries in reverse order from file order.
(defun table-log-load (tstamp)
  (let ((acc nil)
	(link nil))
    
    (let ((rlog (lite-log-open-read (term-to-stamp tstamp))))
      (let ((r (log-read-record rlog)))
	(cond
	  ((null r) nil)
	  ((itable-log-term-p r)
	   (setf link r))
	  ((itable-log-list-aux-p r)
	   (setf acc (nconc (nreverse (mapcar #'term-of-bound-term-f (bound-terms-of-term r))) acc))
	   )
	  (t ;;(format t "ReadLog ~a~%" (term-op-count rec))
	     (push r acc)))

	(when r
	  (do ((rec (log-read-record rlog) (log-read-record rlog)))
	      ((null rec))
	    ;;(format t "ReadLog ~a~%" (term-op-count rec))
	    (if (itable-log-list-aux-p rec)
		(setf acc (nconc (nreverse (mapcar #'term-of-bound-term-f (bound-terms-of-term rec))) acc))
		(push rec acc))))

	(log-close rlog)))

    (cons link acc)))
    

(defun table-log-dump (kind l link)
  ;;(setf -l l) (break "tld")
  (format t "tld ~a~%" (length l))
  (let ((stamp (new-transaction-stamp)))
    (let ((log (lite-log-open-write stamp)))
      (when link
	(log-write-record log link))
      (log-write-record log (instantiate-term (itable-log-list-op) (mapcar #'instantiate-bound-term l))) 
      ;;(dolist (m l) (log-write-record log m)) 
     (log-close log))
    (itable-log-term kind (length l) (stamp-to-term stamp))))


;; log : link , list.
;; env : hash table containing entries visible in ancestor logs.
(defun table-log-compress (kind factor oidkeyf threshold env a inlink &optional forcep)

  (let ((keyf #'(lambda (v) (stamp-of-oid (funcall oidkeyf v)))))

    (labels ((bound-p (v) (library-oid-bound-p (funcall oidkeyf v)))
	     (hash-member-p (m) (and (gethash (funcall keyf m) env) t))
	     (hash-put (m) (setf (gethash (funcall keyf m) env) m))
	     )
      ;;(setf -inlink inlink) (break "cp")
      ;; need to loop until ?

      (let ((log (table-log-load (stamp-of-itable-log-term inlink))))

	(let ((link (car log))
	      (b (cdr log)))
      
	  (let ((bacc a))
	    (dolist (m b)
	      (unless (hash-member-p m)
		(hash-put m)
		(when (or (not forcep) (bound-p m)) (push m bacc))))
	
	    ;;(setf -b b -bacc bacc -link link -inlink inlink) (break "cp2")

	    ;; 64 256 1024 4096 16384 65536
	    ;; 100 300 900 2700 8100 24300
	    ;; if new table size greater than threshold & next link smaller than next threshold then
	    ;; include next file, ie do we bump this one into the next threshold
	    (cond

	      ;; end 
	      ((null link)
	       (table-log-dump kind bacc link))

	      ;; recurse
	      ((> (length bacc) threshold)
	       (table-log-dump kind bacc
			       (table-log-compress kind factor oidkeyf (* factor threshold) env nil link forcep)))


	      ;; loop.  cur <= threshold.
	      ((< (size-of-itable-log-term link) threshold)
	       (table-log-compress kind factor oidkeyf threshold env bacc link forcep))

	      (forcep
	       (table-log-dump kind bacc
			       (table-log-compress kind factor oidkeyf (* factor threshold) env nil link forcep)))


	      ;; stop.  cur <= threshold, next > threshold.
	      (t (table-log-dump kind bacc link)))))))))


;;;;	
;;;;	
;;;;	<log-file>	: <link> . <entry> list
;;;;	  entries are from later to recent.
;;;;	  link is an earlier log.
;;;;
;;;;	to build hash table from log file :
;;;;	  - read logs from earliest to latest.
;;;;	  - read entries from earliest to latest
;;;;	  - overwrite clashing entries.
;;;;	
;;;;	
;;;;	compressing a file :
;;;;	  - read log and push resulting in list of lates to earliest entries.
;;;;	  - add to hash if not present.
;;;;	hash has latest entries.
;;;;	

;; union until find next with a non-zero size.
(defun table-log-rehash (factor threshold kind oidkeyf log &optional (forcep nil))

  (let ((keyf #'(lambda (v) (stamp-of-oid (funcall oidkeyf v)))))
    
    (let ((contents (table-log-load (stamp-of-table-log log))))
      (let ((link (car contents))
	    (l (cdr contents)))

	(let ((env (make-hash-table :test #'equal)))
	
	  (labels ((bound-p (v) (library-oid-bound-p (funcall oidkeyf v)))

		   (hash-member-p (m) (and (gethash (funcall keyf m) env) t))

		   (hash-put (m) (setf (gethash (funcall keyf m) env) m))

		   (hash-union (l) (dolist (m l)
				     (unless (hash-member-p m) (hash-put m)))))

	    ;; init env hash to be root log.
	    (hash-union l)
	    (let ((firstp t))
	    
	      ;;(setf -contents contents -env env -threshold threshold -log log) (break "ad")

	      ;; if first link small, then add to environment.
	      (do ()
		  ((or (null link)
		       ;; prevents accumulating too much in initial log by forcing link to large next.
		       (if firstp
			   (> (size-of-itable-log-term link) threshold) ; if link is bigger then threshold then leave.
			   (not (zerop (size-of-itable-log-term link))))))
	      
		(setf firstp nil)

		(let ((contents (table-log-load (stamp-of-itable-log-term link))))
		  (let ((curlink (car contents))
			(l (cdr contents)))
		  
		    ;;(setf -contents contents) (break "ae")

		    (hash-union l)
		    (setf link curlink))))


	      ;; dump environment as new log.
	      (let ((acc nil))
		(maphash #'(lambda (k v) (declare (ignore k))
				   (when (or (not forcep) (bound-p v))
				     (push v acc)))
			 env)
	    
		;;(setf -contents contents -link link) (break "af")

		(if (and link
			 (or forcep (> (length acc) threshold)))
		    (table-log-dump kind
				    acc
				    ;;(let ((contents (table-log-load (stamp-of-itable-log-term link))))
				    ;;(let ((curlink (car contents))
				    ;;(l (cdr contents)))))
				    (table-log-compress kind factor oidkeyf (* factor threshold) env nil link forcep))
		    (table-log-dump kind acc link))))))))))


(defun state-table-log-rehash (kind env log &optional forcep)

  (when (stream-of-table-log log)
    (message-emit (warn-message '(table log rehash closed not)))
    (let ((stream (stream-of-table-log log)))
      (log-close stream)
      (setf (table-log-stream log) nil)))

  ;;(setf -env env -log log) (break "otlr")
  (let ((table-log (table-log-rehash 3 100 kind
				     #'(lambda (term)
					 (setf -term term)
					 (oid-of-idependency-term (dependency-of-idefinition-term term)))
				     log
				     forcep)))

    (setf (table-log-stamp log) (stamp-of-itable-log-term table-log)
	  (table-log-term log) table-log)
 
   (environment-state-out table-log)

    table-log))

(defun test-table-log-rehash (kind)
  (let ((env (current-environment)))
    (let ((log (find-first #'(lambda (olog)
			       (when (eql kind (car olog))
				 (cdr olog)))
			   (library-sub-environment-table-logs (sub-of-environment env)))))
      (state-table-log-rehash kind env log)
      )))

(defun close-table-log (kind log env rehashp) 
  (let ((stream (when log (stream-of-table-log log))))
    (when stream
      (log-close stream)
      (setf (table-log-stream log) nil)
      ;;(break "ctl")
      (when rehashp
	(case kind
	  (event nil)    
	  (otherwise (state-table-log-rehash kind env log));; 'ostate
	  )))))

(defun close-table-logs (env rehashp)
  (let ((lib-sub (sub-of-environment env)))
    (dolist (a (library-sub-environment-table-logs lib-sub))
      (close-table-log (car a) (cdr a) env rehashp))))


(defun table-log-reset (kind)
  (let ((env (current-environment)))
    (let ((lib-sub (sub-of-environment env)))
      (let ((cur (find-first #'(lambda (e)
				 (when (eql kind (car e)) (cdr e)))
			     (library-sub-environment-table-logs lib-sub))))

	(unless cur
	  (raise-error (error-message '(table log rehash log not) kind)))

	(close-table-log kind cur env nil)
	(let ((log (state-table-log-rehash kind env cur t)))
	  ;;(setf -new log) (break "tlr")
	  (old-environment-log env log)))))
  nil)


;; close logs and return list of log (stamp # kind).
(defun checkpoint-table-logs-begin (kinds)
  (let ((env (current-environment)))
    (mapcan #'(lambda (log)
		(let ((kind (car log))
		      (tlog (cdr log)))
		  (when (member kind kinds)
		    (list (cons kind (stamp-of-table-log tlog))))))
	  (library-sub-environment-table-logs (sub-of-environment env)))))

(defun checkpoint-table-logs-finish (logs)
  (io-db-buffer-flush)
  
  (let ((env (current-environment)))
    (mapcar #'(lambda (log)
		(let ((kind (car log))
		      (tlog (cdr log)))
		  ;;(setf -log log -kind kind -tlog tlog) (break "ctlf")
		  (let ((bstamp (cdr (assoc kind logs))))
		    (when bstamp
		      (unless (compare-terms-p bstamp (stamp-of-table-log tlog))
			(raise-error (error-message '(checkpoint logs finish) bstamp (stamp-of-table-log tlog)))))
		    (close-table-log kind tlog env nil)
		    )))
	    (library-sub-environment-table-logs (sub-of-environment env)))))

(defun show-table-logs ()
  (labels ((get-link (tstamp)
	     (let ((rlog (lite-log-open-read (term-to-stamp tstamp))))
	       (let ((r (log-read-record rlog)))
		 (prog1
		     (when (itable-log-term-p r) r)
		   (log-close rlog)))
	       ))

	   (print-link (link)
	     (format t ";;;~TSize ~a Path ~a~%"
		     (size-of-itable-log-term link)
		     (stamp-to-pathname (term-to-stamp (stamp-of-itable-log-term link)) 'log t)))

	   (visit (tstamp)
	     (let ((l (get-link tstamp)))
	       (when l
		 (cons l
		       (visit (stamp-of-itable-log-term l)))))))
    
    (mapc #'(lambda (a)
	      (let ((logs (visit (stamp-of-table-log (cdr a))))) 
		(format t "~%;;;~%;;;~TPath ~a : ~a~%;;;~%"
			(car a)
			(stamp-to-pathname (term-to-stamp (stamp-of-table-log (cdr a))) 'log t))
		(mapc #'print-link logs)
		(format t ";;;~%;;;~%")))
	  
	  (library-sub-environment-table-logs (sub-of-environment (current-environment)))
	  )
    nil))

(defun collect-table-log-stamps (stamp)
  (labels ((get-link (stamp)
	     (let ((rlog (lite-log-open-read stamp)))
	       (let ((r (log-read-record rlog)))
		 (prog1
		     (when (and r (itable-log-term-p r)) r)
		   (log-close rlog)))
	       ))
	   (visit (stamp)
	     (let ((l (get-link stamp)))
	       (when l
		 (let ((s (term-to-stamp (stamp-of-itable-log-term l))) )
		 (cons s
		       (visit s)))))))
    
    (setf -c (cons stamp (visit stamp)))
    (format t "~%collect-table-logs ~a ~a " (length -c) (cdar stamp))
    ;;(break "ctls")
    -c))

(defun show-table-log-stamps (&optional unit)
  (declare (ignore unit))
    
  (mapcar #'(lambda (a)
	      (cons (car a)
		    (stamp-of-table-log (cdr a))))
	  (library-sub-environment-table-logs
	   (sub-of-environment (current-environment))) ))

(dml |table_log_stamps| 1 show-table-log-stamps (unit -> ((tok |#| term) list)))



   

;; have create log add something to lib log which when read 
;; causes lib-sub environment to be aware of it.
;; or expect to find some log file relative to parent log file.
(defun library-environment (address purposes resources table-types rtags)
  (new-environment address purposes resources table-types rtags
		   (make-library-sub-environment)))


;; do not want to open if none, since want to let producer catch us up.
;; however if one exists we want to stay caught up.
(defun library-log-state (kind update)
  (let ((log (find-state-log kind)))
    (when (null log) (format t  "null library-log-state ~a ~%" kind))
    (when log
      (log-write-record (stream-of-table-log log) update)
      t)))

(defun library-log-ostate (ostate) (library-log-state 'ostates ostate))


(defun add-lib-lettypes ()
  (ml-text "lettype DIRECTIVE = (. -> ((. -> .) # (. -> .)))")
  (ml-text "lettype directive = DIRECTIVE"))

(insys (add-lib-lettypes))


(defun define-ml-lib-primitive-types ()
  (add-primitive-type '|object_contents|
		      #'(lambda (objc) (format-string "ObjectContents[~a]" (kind-of-objc objc)))
		      :member-p #'(lambda (x) (eql (type-of x) 'objc))
		      :eq-func #'(lambda (o p) (eq o p))
		      )
  (add-primitive-type '|inf_tree|
		      #'(lambda (it)
			  (declare (ignore it))
			  "Inf_Tree"))
  (add-primitive-type '|inf_step|
		      #'(lambda (is)
			  (declare (ignore is))
			  "Inf_Step"))
  )

(define-ml-lib-primitive-types)


;;;;	
;;;;	Ostate log : 
;;;;
;;;;	Balance
;;;;	  - minimize number files.
;;;;	  - garbarge in files.
;;;;	  - garbage in data base, ie try to reuse old files.
;;;;	
;;;;	At close create two files : 
;;;;	   - stable ostates : ostates not modified this session (some number of sessions)
;;;;	     may refer to an older stable file.
;;;;	   - dynamic ostates : ostates modified recently.
;;;;	     should point to stable files.
;;;;	       * incremental updates both broadcast and logged.
;;;;		 Then log used to reinit on restart.
;;;;	
;;;;	   How do we know what's changed recently. Could have some generation number in ostate
;;;;	   which gets set to 0 when modified. Then stable file also has generation number which
;;;;	   gets added to individual disk ostate value to produce in memory value.
;;;;	
;;;;	   Maybe some reference generation as well then sort things such that the least recently
;;;;	   referenced are somehow further away.
;;;;	
;;;;	any objc mod will be considered an ostate mod.
;;;;	update ostate at commit of objc bind?  
;;;;	whereever broadcast.
;;;;	
;;;;	
;;;;	broadcast can be an !object-state-term or an !object-state-log?
;;;;	log means read log file.
;;;;	
;;;;	
;;;;	writetime : at lib-producer bound-term find old log and create new.
;;;;	  - find : in object ? 
;;;;	      * appealing to have state directly accessible.
;;;;	      * dangerous to allow user modification.
;;;;	
;;;;	
;;;;	
;;;;	

(define-primitive |!environment_state| () (update))

(defun environment-state-in (term)

  ;;(setf -term term) (break "esi")
  
  (let ((u (update-of-ienvironment-state-term term)))
    (cond
      ((itable-log-term-p u)
       (old-environment-log (current-environment) u))
      (t (message-emit (warn-message '(environment state update unknown) u))))))



;; return nil or #'acc
;; nil means we have up-to-date log.
;; return def which is pointer to log and optional acc.
;; #'acc means we'll build one.
(defvar *produce-max-check* nil)

(defun produce-object-attr (kind acc)

  (let ((log (find-state-log kind)))
    
    (if log
	(progn
	  (funcall acc kind (itable-log-term kind 0 (stamp-of-table-log log)))
	  nil)

	(let ((log (boot-state-log kind)))
	  (let ((stream (stream-of-table-log log))
		(tstamp (stamp-of-table-log log)))

	    ;;(setf -acc acc -ostate ostate -log log) (break "po")

	    ;; this works as long as caller does not sent log term until
	    ;; done calling back with ostates. True now and only need callbacks for
	    ;; old environments.
	    (funcall acc kind (itable-log-term kind 0 tstamp))

	    #'(lambda (o)
		(when *produce-max-check* (funcall *produce-max-check* o))
		(log-write-record stream o)) )))))


;;;;	objc_state
;;;;	  - objc-stamp
;;;;	  - source-stamp
;;;;	  - active-p
;;;;	  - allow-p
;;;;	  - translated-p
;;;;      - substance stamp if translated.
;;;;	  - some subset of properties of objc.
;;;;	 - other subclass data. eg proof-complete-p, should be passed as 
;;;;	   prop list to allow continued extensibility.
;;;;
;;;;

(defparameter *object-state-description*
  (description-to-term (new-description '(|ObjectState|))))

(defparameter *ddg-state-description*
  (description-to-term (new-description '(|DDG|))))

;; todo
;; geo, name and short-display  properties
;; short display : single property say 60 char by 3 lines then edd can use what it wants.
;; PERF : would be nice to avoid reading of source to get description and other properties.
;; PERF : however not necessarily good to have in log as rarely change.
;; PERF : some sort of ostate log might be good.

;; definite kludge here, might reinstate when ostate broadcasts more efficient.
(defun ostateable-p (oid  &optional aobj)
  (or (not (library-oid-bound-p oid))
      (let* ((obj (or aobj (library-lookup oid t)))
	     (objc (objc-of-library-object obj)))
	(not (eql 'inf (kind-of-objc objc))))))

(defvar *ddg-kind-execptions* '(prf inf)) ; disallow prf, reduce size of ddg table.
;;(setf *ddg-kind-execptions* '(inf)) ; allow prf, need it for thy graphs.

(defun object-attr-able-p (kind oid &optional aobj)
  (or (not (library-oid-bound-p oid)) ;; want t so as to put out not-state.
      (case kind

	;; expect dependency summary in proof?
	(ddg	(let* ((obj (or aobj (library-lookup oid t)))
		       (objc (objc-of-library-object obj)))
		  ;;(setf -kind kind -oid oid -objc objc) (break "oaap")
		  (not (member (kind-of-objc objc) *ddg-kind-execptions*))))

	(ostate	(let* ((obj (or aobj (library-lookup oid t)))
		       (objc (objc-of-library-object obj)))
		  (not (eql 'inf (kind-of-objc objc)))))

	(otherwise t))))
	
(defmacro with-objc-of-library-object ((objc o) &body body)
  (let ((provided-p (gensym)))
    `(let ((,objc (library-object-objc ,o)))
      (let ((,provided-p (data-provided-p objc)))
	(unless ,provided-p
	  (io-echo ":")
	  (setf ,objc (provide-data ,objc 'objc)))
	,@body))))
    
(defmacro with-source-of-objc ((src objc) &body body)
  (let ((provided-p (gensym)))
    `(let ((,src (objc-source ,objc)))
      (let ((,provided-p (data-provided-p ,src)))
	(unless ,provided-p
	  (io-echo ";")
	  (setf ,src (provide-data ,src (type-of-source (kind-of-objc ,objc)))))
	,@body))))

(defmacro with-substance-of-objc ((sub objc) &body body)
  (let ((provided-p (gensym)))
    `(let ((,sub (objc-substance ,objc)))
      (let ((,provided-p (or (null ,sub) (data-provided-p ,sub))))
	  (unless ,provided-p
	    (io-echo "|")
	    (setf ,sub (provide-data ,sub (type-of-substance (kind-of-objc ,objc)))))
	  ,@body))))

(defmacro with-translation-of-objc ((trans objc) &body body)
  (let ((provided-p (gensym)))
    `(let ((,trans (objc-translation ,objc)))
      (let ((,provided-p (data-provided-p ,trans)))
	(unless ,provided-p
	  (io-echo ";")
	  (setf ,trans (provide-data ,trans 'dependency-store)))
	,@body))))


;; expect dependency summary in proof?
(defun ddgable-p (oid  &optional aobj)
  ;;(setf -oid oid -aobj aobj) (break "dp")
  (object-attr-able-p `ddg oid aobj))


(defun accumulate-object-attrs (accumulate-states oid &optional aobj)

  (when accumulate-states
    (let* ((obj (or aobj (library-lookup oid t))))
      (with-objc-of-library-object (objc obj)

	(dolist (as accumulate-states)
	  (case (car as)

	    ;; TODO PERF : combining & streamlining ref environments and dependency store could
	    ;;   be a big win.
	    (ddg	(when (not (member (kind-of-objc objc) *ddg-kind-execptions*))
			  (funcall (cdr as)
				   (idefinition-term (idependency-term oid (ivoid-term) (ivoid-term))
						     (build-ddg-aux oid objc)))))
	  
	    (ostates (when (not (eql 'inf (kind-of-objc objc)))
		       (funcall (cdr as)
				(idefinition-term (idependency-term oid (ivoid-term) (ivoid-term))
						  (build-iobject-state-aux oid obj objc)))))

	    (otherwise nil)))))))

	


(defun build-object-attrs (kind oid &optional aobj)
  (if (library-oid-bound-p oid)
      (let* ((obj (or aobj (library-lookup oid t)))
	     (objc (objc-of-library-object obj)))
	
	(case kind
	  (ddg	(if (objc-translated-p objc)
		    (iddg-state-term
		     (idependency-term oid
				       (stamp-to-term (stamp-of-data objc))
				       (stamp-to-term (stamp-of-data (objc-substance objc))))
		     (inline-persists-dump (persist-data (objc-translation objc)))
		     (or (when (eql `code (kind-of-objc objc))
			   (let ((s (source-of-objc objc)))
			     ;;(setf -s s) (break "ddg")
			     (when (typep s `code-source)
			       (code-xrefs-to-term (language-of-code-source s)
					   (xref-of-code-source s))))) 
			 (ivoid-term)))
		    (iobject-attr-state-not-term oid)))

	  (otherwise ;;(break "boa")
	   nil)))
      
      (iobject-attr-state-not-term oid)))

(defun build-ddg-aux (oid objc)
  (if (objc-translated-p objc)
      (iddg-state-term
       (idependency-term oid
			 (stamp-to-term (stamp-of-data objc))
			 (stamp-to-term (stamp-of-data (objc-substance objc))))
       (inline-persists-dump (persist-data (objc-translation objc)))
       (or (when (eql `code (kind-of-objc objc))
	     (with-source-of-objc (s objc)

	       ;;(setf -s s) (break "ddg")
	       (when (typep s `code-source)
		 (code-xrefs-to-term (language-of-code-source s)
				     (xref-of-code-source s)))))
	   (ivoid-term)))
      (iobject-attr-state-not-term oid)))

;; when writing to log file need to expand data-persists.
(defun build-ddg (oid &optional aobj)
  (if (library-oid-bound-p oid)
      (let ((obj (or aobj (library-lookup oid t))))
	(with-objc-of-library-object (objc obj)
	  ;;(setf -objc objc) (break "bd")
	  (build-ddg-aux oid objc)))
      (iobject-attr-state-not-term oid)))

(defun lib-active-p (oid)
  (library-object-active-p (library-lookup oid)))

(defun objc-translated-extra-p (objc)
  (case (kind-of-objc objc)
    (stm (and (objc-translated-p objc)
	      (exists-p #'(lambda (oid) (lib-active-p oid))
			;; maybe should be substance proofs, but do not want to require stm translation
			;; because some proof has changed. Ie substance of lemma does not really
			;; rely on proof.
			(proofs-of-statement-substance
			 (substance-of-objc objc)))))
    (otherwise (objc-translated-p objc))
  ))


(defun build-iobject-state-aux (oid obj objc)
  (iobject-state-term oid
		      (library-object-active-p obj)
		      (library-object-collectable-p obj)
		      (kind-of-objc objc)
		      (objc-translated-extra-p objc)
		      (description-property-term-of-objc objc);; requires source.
		      (stamp-to-term (stamp-of-objc objc))
		      (stamp-to-term (stamp-of-data (objc-source objc)))
		      (if (objc-translated-p objc)
			  (stamp-to-term (stamp-of-data (objc-substance objc)))
			  (ivoid-term))
		      (properties-to-term (ostate-properties-of-objc objc))
		      (ivoid-term)))

(defun build-iobject-state (oid &optional aobj)
  (if (library-oid-bound-p oid)
      (let* ((obj (or aobj (library-lookup oid t))))
	(with-objc-of-library-object (objc obj)
	  (build-iobject-state-aux oid obj objc)))
      (iobject-state-not-term oid)))


;; should be distinct transaction with atomic broadcast. why.
;; Currently, sends all as single broadcast
;; At some point may want finer grained broadcast as clients may discriminate.

(defparameter *object-states-op* (instantiate-operator '|!object_states| nil))

;; twould be better to accumulate oids then merge with those substantively changed at
;; transaction end.



;;;; events
;;;;	
;;;;	
;;;;	quick start
;;;;	  : need to know oids touched since commit event synchro.
;;;;	
;;;;	
;;;;	

(define-primitive |!event| () (stamp desc one others))
(defvar *commit-event* (itoken-term 'commit))

(defun icommit-event-term-p (term)
  (and (ievent-term-p term)
       (compare-terms-p (desc-of-ievent-term term) *commit-event*)))


;;(defclass event ()
;;  term)

;;(defclass commit-event (event)
;;  prev)

(defstruct oid-graph
  g
  reverse
  fhash
  rhash
  list
  touched
  dirhash
  breadthaddrs)

(defstruct event-table
  hash
  last-commit	; need last to link next.
  )

(defmacro last-commit-of-event-table (et) `(event-table-last-commit ,et))
(defmacro hash-of-event-table (et) `(event-table-hash ,et))
(defmacro new-event-table ()
  `(make-event-table :hash (make-hash-table :test #'equal)
		     :last-commit (ievent-term  (ivoid-term) (ivoid-term) (ivoid-term) (ivoid-term))))
		       

(defun read-event-log (ilog et)
  (apply-log #'(lambda (event)
		 (add-event (term-to-stamp (stamp-of-ievent-term event)) event et))
	     (term-of-table-log ilog)))

(defun init-event-table (ilog)
  (let ((etable (new-event-table)))
    (when ilog
      (read-event-log ilog etable))
    etable))

(defun events-of-lib-environment (env)
  (let ((subenv (sub-of-environment env)))
    (or (library-sub-environment-events subenv)
	(setf (library-sub-environment-events subenv)
	      (init-event-table (environment-log-lookup env 'event))))))

(defun find-event-log ()
  (let ((env (current-environment)))
    (let ((olog (environment-log-lookup env 'event)))
      (if olog
	  (if (table-log-open-p olog)
	      olog	    
	    (open-table-log env 'event olog))
	(let ((tstamp (stamp-to-term (new-transaction-stamp))))
	  (let ((log (lite-log-open-write (term-to-stamp tstamp))))
	    (let ((nolog (table-log-active tstamp log)))
	      (new-environment-log env 'event nolog)
	      nolog)))))))

(defun add-event (stamp event-term &optional et)
  (let ((etable (or et (events-of-lib-environment (current-environment)))))
    (let ((ehash (hash-of-event-table etable)))
      (setf (gethash stamp ehash) event-term)
      (when (icommit-event-term-p event-term)
	(setf (event-table-last-commit etable) event-term)))))

(defun write-log-event (et)
  (log-write-record (stream-of-table-log (find-event-log)) et))

;; FTTB: only record events for current session.
(defun log-event (stamp et &optional etable)
  (add-event stamp et etable)
  ;;(write-log-event et)
  )


(defvar *in-checkpoint-scope-p* nil)

(defun commit-event (oids estamp)
  (when (and oids *in-checkpoint-scope-p*)
    (let ((evtable (events-of-lib-environment (current-environment))))
      (let ((stamp (or estamp (new-transaction-stamp))))
	(let ((s (stamp-to-term stamp)))
	  (let ((term (ievent-term s *commit-event* (stamp-of-ievent-term (last-commit-of-event-table evtable)) (icut-oid-list oids))))
	    (setf (event-table-last-commit evtable) term)
	    (log-event stamp term evtable)))))))

(defun with-checkpoint (ckp hookf)
  (setf *in-checkpoint-scope-p* t)
  (if (and ckp
	   (compare-terms-p (event-of-ievent-checkpoint-term ckp)
			    (stamp-of-ievent-term
			     (last-commit-of-event-table
			      (events-of-lib-environment (current-environment))))))
      (event-of-ievent-checkpoint-term ckp)
      (let ((fs (future-transaction-stamp 1000))
	    (logs (checkpoint-table-logs-begin '(ddg ostates event))))
	(let ((fsterm (stamp-to-term fs)))
	
	  (funcall hookf
		   (ievent-checkpoint-term
		    fsterm
		    (map-list-to-ilist logs
				       (inil-term)
				       #'(lambda (kind-stamp)
					   (ilog-checkpoint-term (car kind-stamp) (cdr kind-stamp))))))

	  (check-jump-transaction-stamp fs)

	  (when (completions-p)
	    (commit-completions (completion-peek-first) fs))

	  (checkpoint-table-logs-finish logs)

	  (jump-transaction-stamp fs)

	  fsterm
	  ))))


(defunml (|with_checkpoint| (hook lastckp))
  ((term -> unit) -> (term -> term))

  (let ((r (with-checkpoint (unless (ivoid-term-p lastckp) lastckp) #'(lambda (s) (ap hook s)))))
    (setf -r r)
    ;;(break "wc")
    r))
		   

(define-primitive |!event_checkpoint| () (event logs))
(define-primitive |!log_checkpoint| ((token . kind)) (stamp))
#|
(defunml (|event_and_logs_checkpoint| (unit) :declare ((declare (ignore unit))))
  (unit -> term)

  (ievent-checkpoint-term
   (stamp-of-ievent-term (last-commit-of-event-table (events-of-lib-environment (current-environment))))
   (map-list-to-ilist (checkpoint-table-logs)
		 (inil-term)
		 #'(lambda (kind-stamp)
		     (ilog-checkpoint-term (car kind-stamp) (cdr kind-stamp))))))
|#
(defun map-events (f)
  (let ((events (events-of-lib-environment (current-environment))))
    (let ((ehash (hash-of-event-table events)))
      (maphash f ehash))))

(defun commit-events-assoc ()
  (let ((acc nil))
    (map-events #'(lambda (k e)
		    (when (icommit-event-term-p e)
		      (let ((tstamp (one-of-ievent-term e)))
			(push (cons k (unless (ivoid-term-p tstamp)
					(term-to-stamp tstamp)))
			      acc)))))
    acc))

(defun oids-of-commit-event (e)
  (oids-of-icut-list (others-of-ievent-term e)))

(defun commit-event-touched (stamp)
  (let ((ehash (hash-of-event-table (events-of-lib-environment (current-environment)))))
  (let ((eassoc (commit-events-assoc))
	(ohash (make-hash-table :test #'equal)))
    
    (labels ((visit-event (s)
	      (when s
		(let ((e (gethash s ehash)))
		  ;;(setf -e e) (break "cet")
		  (when e
		    (dolist (o (oids-of-commit-event e))
			    (hashoid-set ohash o t))
		    (visit-event (car (rassoc s eassoc :test #'equal))))))))

	    ;; if checkpoint event
	    (visit-event (car (rassoc stamp eassoc :test #'equal)))

	    ohash))))

(defun lib-state-touched (oids event-stamp)

  (commit-event oids event-stamp)

  ;;(break "lst2")
    (let ((seq (current-sequence)))
      ;;(setf a oids) (break "lst")
      (let ((ostate-bts (mapcan #'(lambda (oid)
				    (when (ostateable-p oid)
				      (list 
				       (instantiate-bound-term
					(let ((defterm (idefinition-term
							(idependency-term oid (ivoid-term) (ivoid-term))
							(build-iobject-state oid))))
					  (library-log-ostate defterm)
					  defterm)))))
				oids)))
	(when ostate-bts
	  (orb-broadcast 
	   'object-state
	   (ipassport-term 'ostates
			   (table-stamp-term-of-definition-table (resource 'library))
			   *object-state-description*
			   (idefinition-replace-term seq
						     (instantiate-term
						      *object-states-op*
						      ostate-bts)))
	   (current-transaction-stamp))))

      (let ((ddg-bts (mapcan #'(lambda (oid)
				 (when (ddgable-p oid)
				   (list 
				    (instantiate-bound-term
				     (let ((defterm (idefinition-term
						     (idependency-term oid (ivoid-term) (ivoid-term))
						     (build-ddg oid))))
				       (library-log-state 'ddg defterm)
				       defterm)))))
			     oids)))
	(when ddg-bts
	  (orb-broadcast 
	   'ddg-state
	   (ipassport-term 'ddg
			   (table-stamp-term-of-definition-table (resource 'library))
			   *ddg-state-description*
			   (idefinition-replace-term seq
						     (instantiate-term
						      *object-attr-states-op*
						      ddg-bts)))
	   (current-transaction-stamp)))))

    
    (let ((og (oid-graph-of-lib-environment (current-environment))))
      (when (and og oids)
	(setf (oid-graph-touched og) (append oids (oid-graph-touched og)))
	))

    nil)


;;;
;;; completions
;;; 

;; discharged completions will not occur in pending completions.
;; completions in reverse order of emission.

;;;;	<completion>	: [<stamp>,  ...]
;;;;	
;;;;	
;;;;	

(defstruct completion
  (stamp (transaction-stamp))
  
  (status 'uncompleted)
  
  (cmd nil)	; term 

  (environment nil)
  
  (oid nil)
  (undo nil)
  (commit nil))


(defun status-of-completion (c) (completion-status c))
(defun stamp-of-completion (c) (completion-stamp c))
(defun environment-of-completion (c) (completion-environment c))
(defun cmd-of-completion (c) (completion-cmd c))
(defun oid-of-completion (c) (completion-oid c))
(defun commit-of-completion (c) (completion-commit c))
(defun undo-of-completion (c) (completion-undo c))
	  

(defun unwind-transaction (ok &optional tstate)
  (when (completions-p tstate)
    (if ok
	(commit-completions (completion-peek-first tstate))
	(undo-completions (completion-peek-last tstate)))))

    
;; finds completion with stamp.
;; removes tail beginning with stamp.
;; returns reversed tail.
(defun completions-for-commit (stamp)
  (labels ((locate-and-cut (completions)
	     (cond
	       ((null completions)
		(raise-error (error-message '(completions suffix))))
	       ;; danger! destructive modification alert!
	       ((equal-sequence-p stamp (stamp-of-completion (cadr completions)))
		(values (nreverse (cdr completions))
			(progn (setf (cdr completions) nil)
			       completions)))
	       (t (locate-and-cut (cdr completions))))))
    
    (let ((completions (completions-get)))
      (cond
	((equal-sequence-p stamp (stamp-of-completion (car completions)))
	 (completions-put nil)
	 (nreverse completions))
	(t (locate-and-cut completions))))))

(defun completions-for-undo (stamp)
  (labels ((locate (completions)
	     (cond

	       ((null completions)
		(raise-error (error-message '(completions prefix))))

	       ;; danger! destructive modification alert!
	       ((equal-sequence-p stamp (stamp-of-completion (car completions)))
		(completions-put (cdr completions))
		(setf (cdr completions) nil))

	       (t (locate (cdr completions))))))

    (let ((completions (completions-get)))
      (locate completions)
      completions)))


;;
;; these functions expect only uncompleted completions.
;;

;;;;	Desire contiguous commits to be bundled.
;;;;	
;;;;	If there are a sequence of commits be completed then
;;;;	the commit messages should be bundled as a single message
;;;;	to save io and allow clients to optimize.
;;;;	


(defun do-sneak-commit (completion)
  (io-echo "C")

  (let ((cl (commit-of-completion completion)))
    ;;(setf a cl b completion) (break "dsc")
    (when cl
      (funcall cl)
      (setf (completion-commit completion) nil
	    (completion-undo completion) nil))))



;; Is it possible for transaction to span multiple environments?
;; Assume yes then do we need to bind environment during commit.
;; also we apparently do need to bind environment during lib-state-touched
;; alsoe need to lock relative to environment.

(defun commit-completions (completion &optional event-stamp)

  ;;(break "cc")
  (let ((stamp (stamp-of-completion completion))
	(touched nil))
    
    (labels ((commit (completion)
	       (case (status-of-completion completion)
		 (uncompleted (do-commit completion))
		 (otherwise (system-error (error-message '(commit completion status)
							(status-of-completion completion))))))

	     (update-touched (completion)
	       (let ((oid (oid-of-completion completion)))
		 (when oid
		   (let ((e (environment-of-completion completion)))
		     (let ((et (assoc e touched :test #'eql)))
		       (if et
			   (push oid (cdr et))
			   (push (cons e (list oid)) touched))))
		   oid)))

	     (do-commit (completion) ;(break "do-commit")
	       (io-echo "c")
	       
	       (with-environment-actual (environment-of-completion completion)

		 ;;(setf a completion) (break "cc")
		 (let ((oid (update-touched completion)))
		   (when oid
		     (unlock oid)))
		 (let ((cl (commit-of-completion completion)))
		   ;;(setf a cl b completion) (when *process-break* (break "cc"))
		   (when cl (funcall cl)))
		 (setf (completion-status completion) 'committed))))

      (unless (in-transaction-p stamp (current-transaction-stamp))
	(raise-error (error-message '(commit stamp stale))))

      (case (status-of-completion completion)
	(uncompleted (dolist (completion (completions-for-commit stamp))
		       (commit completion)))
	(undone (raise-error (error-message '(commit completion undone))))
	(committed nil)
	(otherwise (system-error (error-message '(undo completion status)
					       (status-of-completion completion)))))

      (dolist (et touched)
	(with-environment-actual (car et)
	  (lib-state-touched (remove-duplicates (cdr et) :test #'equal-oids-p) event-stamp))))))



(defun undo-completions (completion)
  (let ((stamp (stamp-of-completion completion)))
    (labels ((undo (completion)
	       (case (status-of-completion completion)
		 (uncompleted (do-undo completion))
		 (otherwise (system-error (error-message '(undo completion status)
							(status-of-completion completion))))))

	     (do-undo (completion)
	       (with-environment-actual (environment-of-completion completion)
		 (io-echo "o")
		 ;;(setf -c completion) (break "uc")
		 (let ((oid (oid-of-completion completion)))
		   (when oid (unlock oid)))
		 (let ((cl (undo-of-completion completion)))
		   (when cl (funcall cl)))
		 (setf (completion-status completion) 'undone))))


      (unless (in-transaction-p stamp (current-transaction-stamp))
	(raise-error (error-message '(undo stamp stale))))

      ;;(setf -stamp stamp) (break "uc2")

      (case (status-of-completion completion)
	(uncompleted (dolist (completion (completions-for-undo stamp))
		       (undo completion)))
	(undone nil)
	(committed (raise-error (error-message '(undo completion committed))))
	(otherwise (system-error (error-message '(undo completion status)
					       (status-of-completion completion))))))))



;;;;	
;;;;	Broadcasts : 
;;;;	
;;;;	
;;;;	
;;;;	(((definition) (<tag{table}>)) (<oid>) ('insert) <def>)
;;;;
;;;;	<bcast>	: !definition_insert(<seq>:n}(<def>)
;;;;		| !definition_delete(<seq>:n, <oid>:o}
;;;;
;;;;		| !definition_allow	(<seq>:n, <oid>:o}
;;;;		| !definition_disallow	(<seq>:n, <oid>:o}
;;;;		| !definition_activate	(<seq>:n, <oid>:o}
;;;;		| !definition_deactivate(<seq>:n, <oid>:o}
;;;;
;;;;		| !definition_commit(<seq>:n, <oid>:o}(<stamp>)
;;;;		| !definition_undo  (<seq>:n, <oid>:o}
;;;;
;;;;	!passport{<tag>}(<stamp>; <description>; <bcast>)

;;;;	(((oid) (<tag{table}>)) (<oid>) ('map) <def>)
;;;;
;;;;	<bcast>	: !oid_map(<seq>:n, <oid-o>:o, <oid-n>:o}()
;;;;		| !definition_commit(<seq>:n, <oid-o>:o}(<stamp>)
;;;;		| !definition_undo  (<seq>:n, <oid-o>:o}
;;;;
;;;;	!passport{<tag>}(<stamp>; <description>; <bcast>)



;; following appears to be misguided proper
;; solution is to delay io when broadcast and combine at write-time.

(defvar *library-broadcasts*)
(defvar *library-broadcasts-stamp*)
(defvar *library-broadcasts-collecting-p* nil)

(defun library-collect-flush ()
  (break)
  )

(defun library-collect-broadcast (stamp bcast)
  (if *library-broadcasts-collecting-p*
      (cond
	((null *library-broadcasts-stamp*)
	 (setf *library-broadcasts-stamp* stamp
	       *library-broadcasts* (list bcast)))
	
	((equal-stamps-p stamp *library-broadcasts-stamp*)
	 (push bcast *library-broadcasts*))
	(t (library-collect-flush)))

      (broadcast stamp bcast 'lib)
      ))

(defmacro with-collect-library-broadcasts (&body body)
  `(let ((*collecting-library-broadcasts-p* t)
	 (*library-broadcasts* nil)
	 (*library-broadcasts-stamp* nil))

    (multiple-value-prog1 (progn ,@body)

      ;; if stamp changes then flush?
      flush
      )))


(defun library-broadcast (stamp bcast)
  ;;(break)
  (broadcast stamp bcast 'lib))


(defmacro build-directive ((type	; one of value oid
			     tag
			     update)
			   (inoid &optional inother)
			    desc
			    &optional def-term
			    )
  (let ((stamp (gensym))
	(sequence (gensym))
	(update-id (gensym))
	(args-type (gensym))
	(table-tag (gensym))
	(parms (gensym))	
	(cparms (gensym))	
	(oid (gensym))
	(other-oid (gensym))
	(oid-parm (gensym))
	(other-oid-parm (gensym))
	(def-bterm (gensym))
	(stamp-term (gensym))
	(description (gensym))
	(completion (gensym))
	(tstate (gensym)))

    `(progn

      ;; recently (3/99) changed to (new-transaction-stamp) from (transaction-stamp)
      ;; problem was multiple completions with same sequence, in such a case some completions
      ;; not undone if failure. Could fix that but seems like each dir invoc deserves unique stamp.
      (let* ((,stamp (new-transaction-stamp))
	     (,sequence (current-sequence))

	     (,oid ,inoid)
	     (,other-oid ,inother)

	     (,update-id (map-update-to-broadcast-opid ',update))
	     (,args-type ',type)
	     (,table-tag ,tag)

	     (,description ,desc)

	     (,stamp-term (table-stamp-term-of-definition-table
			   (resource 'library)))

	     (,oid-parm (instantiate-parameter-r ,oid *oid-type*))
	     (,other-oid-parm (when ,other-oid
				(instantiate-parameter-r ,other-oid *oid-type*)))

	     (,parms (cons (instantiate-parameter-r ,sequence *natural-type*)
			   (when (eql ,args-type 'oid)
			     (cons ,oid-parm
				   (when ,other-oid-parm
				     (list ,other-oid-parm))))))
			      
	     (,cparms (list (car ,parms)
			    (instantiate-parameter-r ,oid *oid-type*)))
	     (,def-bterm (when (eql ,args-type 'definition)
			   (instantiate-bound-term ,def-term)))
	     (,tstate (transaction-state)))

	(when (weak-tstate-p ,tstate ,stamp)
	  ;;(break "de")
	  (raise-error (error-message '(directive transaction weak) (itext-term ,tag))))
      
	(lock ,oid)		
	
	;;(setf a ,parms b ,args-type) (break)
	(with-unwind-error ((unlock ,oid))
	  (library-broadcast
	   ,stamp
	   (ipassport-term ,table-tag
			   ,stamp-term
			   ,description
			   (instantiate-term (instantiate-operator ,update-id ,parms)
					     (when (eql ,args-type 'definition)
					       (list ,def-bterm)))))
	  (let ((,completion
		 (make-completion
		  :stamp ,stamp
		  :environment (current-environment)
		  :oid ,oid
		  :undo #'(lambda ()
			    (library-broadcast
			     ,stamp
			     (ipassport-term ,table-tag
					     ,stamp-term
					     ,description
					     (instantiate-term
					      (instantiate-operator *iundo* ,cparms)))))
		  :commit #'(lambda ()
			      (library-broadcast
			       ,stamp
			       (ipassport-term ,table-tag
					       ,stamp-term
					       ,description
					       (instantiate-term
						(instantiate-operator *icommit* ,cparms)
						(list (instantiate-bound-term
						       (stamp-to-term ,stamp))))
					       )))
			       )))
	    (completion-push ,completion)
	    ,completion))))))


(defmacro build-sequence-directive (&body body)
  (let ((undo-completion (gensym))
	(commit-completion (gensym)))
    `(progn
      (advance-sequence)
      (let* ((,undo-completion (make-completion :stamp (transaction-stamp)
						:environment (current-environment))))
	(completion-push ,undo-completion) 
	(with-handle-error (()
			    (undo-completions ,undo-completion)
			    (raise-error (error-message '(directive sequence))))
	  ,@body
	  (advance-sequence)
	  (let* ((,commit-completion (make-completion :stamp (transaction-stamp)
						      :environment (current-environment))))
	    (completion-push ,commit-completion)
	    (cons ,undo-completion ,commit-completion)))))))


(defmacro make-ml-directive (&body body)
  (let ((completion (gensym))
	(commit (gensym))
	(undo (gensym)))
    `(make-closure
      #'(lambda (unit)
	  (declare (ignore unit))
		       
	  (let* ((,completion (with-handle-error (() (breakout evaluation 'library-command))
				,@body))
		 (,undo (if (consp ,completion)
			      (car ,completion)
			      ,completion))
		 (,commit (if (consp ,completion)
			      (cdr ,completion)
			      ,completion)))
	    (cons (make-closure #'(lambda (unit)
				    (declare (ignore unit))
				      (with-handle-error (() (breakout evaluation 'library-command-undo))
					(undo-completions ,undo)))
				1)
		  (make-closure #'(lambda (unit)
				    (declare (ignore unit))
				    (with-handle-error (() (breakout evaluation 'library-command-commit))
				      (commit-completions ,commit)))
				1))))
      
      1)))
  

;;;;	prf is indentical to trees in that sequents are goals not just concls and
;;;;	could allow prf to have frontier.
;;;;	
;;;;	inf-tree-merge-term		: inf_tree -> term {!inf_tree} -> inf_tree
;;;;	inf-tree-merge(splice)???	: inf_tree -> inf_tree -> inf_tree
;;;;	
;;;;	iinf-tree-term-to-inf-tree	: term {!inf_tree} -> inf_tree
;;;;	  * import from refiner.
;;;;	
;;;;	
;;;;	all mods are constructive, saving objc into inf-tree produces new inf-tree.
;;;;	saveing inf-tree into inf-step produces new inf-step, saving inf-step into objc
;;;;	produces new objc. It is possible that some mods are recognized is inconsequential
;;;;	and returns eq object. It is more possible that substance stamps are not updated.
;;;;	
;;;;	inf-step occurs in !inf_tree's and inf-objc-tree's.
;;;;	However, we can use the same term encoding, however this is not optimal
;;;;	
;;;;
;;;;	inf-objc is carrier for inf-step.
;;;;	inf-step is node of inf-tree.
;;;;	
;;;;	inf-source contains inf-step
;;;;	 + goal and tactic, inf-source projects into inf-step which is refined into refined inf-step 
;;;;
;;;;	need to be able to detect dissonance between inf-source and contained step.
;;;;	do not want inf-step to be in inf-objc data? as inf-objc exists as annotation on inf-tree containing
;;;;	inf-step.
;;;;
;;;;	if inf-objc exists outside of tree then need inf-step in data? Or inf-objc data is inf-tree stub.
;;;;	

;;;;	to-proxy
;;;;
;;;;	Want to optimize by rolling entire inf-tree into single itp term
;;;;	  - preserve inf obids if referenced outside of tree.
;;;;	      fttb only 
;;;;	  - unbind any inf obid whose only pointer is inf_tree.
;;;;	  - do not unroll itp if reading.
;;;;	  - unroll itp if modifying inf tree.
;;;;	     - bind sneak ???
;;;;	  - cache xref/dependencies ???
;;;;	  - wish to be able to mill/filter without unrolling.
;;;;		pass !cons(<goal>;<itp>) term to prf mill 
;;;;	  - want ephemeral unrolls that can be garbage collected.
;;;;	
;;;;	find prfs to proxy by :
;;;;	  for each prf if and all prf has no inf oid
;;;;	  - not alreay proxy
;;;;	  - prf complete
;;;;	  - prf has no inf oid pointers except for those in inf_tree
;;;;	  - no other object has pointers to any inf object.
;;;;	
;;;;	lazy-sneak-binding : add binding to table but only log if a lookup happens.
;;;;	
;;;;	unroll itp with lazy-bindings at read and destructively modify objc since 
;;;;	only need to save if modified, but will be saved by modifying
;;;;	  - except that lazy bindings will not be logged by saving prf-objc.
;;;;	    thus would need to log all lazy bindings of inf-tree if inf-tree moved
;;;;	    to new objc (ie cloned or modify-inf-tree), or maybe persists of objc checks
;;;;	    for lazy bindings?
;;;;
;;;;	or unroll to inf_tree without obids but then add obids if an obid requested.
;;;;	or unroll to inf_tree with obids but mill callers to try to avoid unroll
;;;;	
;;;;	last is best fttb, lazy-sneak-binding may be better long term.
;;;;	
;;;;	
;;;;
;;;;	inf-tree is a tree of object ids.
;;;;
;;;;	inf-tree-proxy : a term representing an inf-tree. Also self persistent, ie 
;;;;	proxy corresponds to file. persistence also avoids loading term unless necessary.
;;;;	
;;;;	Lib may compress inf_tree into proxy.
;;;;	
;;;;	Refiner may return interior trees of refinement as term. Likely to be large and
;;;;	may be infrequently acessed. Thus, stored as proxy until accessed at which time
;;;;	it becomes inf-tree.
;;;;
;;;;	Once unrolled, it will persist as an inf-tree.
;;;;	Until unrolled, the !inf_tree term will remain on disk and a proxy will reside
;;;;	in its place. 
;;;;	
;;;;	could have children of inf-tree be proxy? thus only unroll what has been visible.
;;;;	maybe later fttb, proxies may only occur in top-refinement.
;;;;	
;;;;	
;;;;	iinf-tree-term-to-inf-tree unrolls proxy
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	<prf>		: ... <proof-source> ...
;;;;	<proof-source>	: Source(...; !proof_source(inf_object_tree{<inf>}; <xref> ilist); ...)
;;;;	  * why list of xref?
;;;;	
;;;;	<inf>		: <inf-source> ... <inf-substance>
;;;;	
;;;;	<inf-substance>	: !void
;;;;			; !event_dependencies(<date>; <desc>; <ENV-DEPS>)
;;;;			; <properties>
;;;;			; !inf_tree(<goal>
;;;;				   ; !inf_abbrev(<ENV-DEPS>)
;;;;				   ; <inf_tree> ilist {children}
;;;;				   ; <annotations{including refine stats}>)
;;;;	
;;;;	<inf-source>	: Source(...PreProcessSource(...XrefSource(<xref> ilist; <!inf_source>)))
;;;;	
;;;;	<!inf_source>	: !inf_source(<goal{ivoid}>; <annotations>; <topstep>)
;;;;	<topstep>	: !inf_tree(<inf-goal>; <inf-top>; <inf_tree> ilist{children}; <annos>)
;;;;	<inf-top>	: !inf_top(<ENV-DEPS>; <ITP>; <tac>)
;;;;	<ITP>		: !inf_tree(!inf_goal(); !inf_primitive(<ENV-DEPS>; <extract>))
;;;;	
;;;;	All ENV-DEPS appear to be identical????
;;;;	 inf-top's is summary of ITP,
;;;;	 inf-abbrev is identical to inf-top?
;;;;	 substance-deps identical to inv abbrev.
;;;;	
;;;;	
;;;;	inf-tree of inf-substance always single inf-abbrev node ?
;;;;	inf-tree of topstep always single top node?
;;;;	
;;;;	frontier of ITP would be children of topstep and inf-substance inf-tree.
;;;;	

;;;;	inf-tree term vs inf-tree
;;;;	
;;;;	inf-tree terms are distinct from library. Library unrolls inf-tree terms
;;;;	to inf-trees. 
;;;;	

(defclass inf-tree-proxy (data)
  ((tree :reader tree-of-inf-tree-proxy
	 :writer set-inf-tree-proxy-tree
	 :initarg tree
	 :initform nil
	 )
   ))


(define-primitive |!complete_inf_tree_proxy| () (tree goal dependencies extract))
(defmethod data-import ((itp inf-tree-proxy) super)
  (let ((term (call-next-method itp super)))
    (if (icomplete-inf-tree-proxy-term-p term)
	term
	(set-inf-tree-proxy-tree term itp))))

;; this is a one-way street, no export of inf-objc-tree's  to !inf_tree's.
;; this would be called a persist-data on the inf-tree proxy class with the provided bit on.
;; the result of the data-provide should be the inf-objc-tree and should replace the proxy,
;; not be contained by it.
;; or not. data is !inf_tree term export is no-op
(defmethod data-export ((itp inf-tree-proxy) sub)
  ;;(setf -itp itp -sub sub) (break "itpex")
  (if (icomplete-inf-tree-proxy-term-p sub)
      (call-next-method itp sub)
      (call-next-method itp (tree-of-inf-tree-proxy itp))))

;;  (raise-error (error-message '(inf-tree proxy export))))
;; (call-next-method itp (inf-tree-to-iinf-tree-term (tree-of-inf-tree-proxy itp) t t))

(defclass complete-inf-tree-proxy (inf-tree-proxy)
  (
   (goal :reader goal-of-inf-tree-proxy
	 :writer set-inf-tree-proxy-goal
	 :initarg goal
	 :initform nil
	 )

   (dependencies :reader dependencies-of-inf-tree-proxy
		 :writer set-inf-tree-proxy-dependencies
		 :initarg dependencies
		 :initform nil
		 )

   (extract :reader extract-of-inf-tree-proxy
	 :writer set-inf-tree-proxy-extract
	 :initarg extract
	 :initform nil
	 )
   ))


(defmethod data-import ((itp complete-inf-tree-proxy) super)
  (let ((term (call-next-method itp super)))
    (setf -term term)
    (set-inf-tree-proxy-tree (tree-of-icomplete-inf-tree-proxy-term term) itp)
    (set-inf-tree-proxy-goal (iinf-goal-term-to-goal
			      (goal-of-icomplete-inf-tree-proxy-term term)) itp)
    (set-inf-tree-proxy-dependencies (term-to-event-dependencies
				      (dependencies-of-icomplete-inf-tree-proxy-term term))
				     itp)
    (let ((e (extract-of-icomplete-inf-tree-proxy-term term)))
      (unless (ivoid-term-p e) 
	(set-inf-tree-proxy-extract e itp)))))

(defmethod data-export ((itp complete-inf-tree-proxy) sub)
  (call-next-method itp
		    (icomplete-inf-tree-proxy-term
		     (tree-of-inf-tree-proxy itp)
		     (goal-to-term (goal-of-inf-tree-proxy itp))
		     (event-dependencies-to-term (dependencies-of-inf-tree-proxy itp))
		     (or (extract-of-inf-tree-proxy itp) (ivoid-term)))))

(defun complete-inf-tree-proxy-p (tree)
  (eql 'complete-inf-tree-proxy (type-of tree)))

(defun verify-proof (inf-tree goal)
  
  (let ((oid (oid-of-inf-tree inf-tree)))
    ;; don't note : avoid having prf depend on inf obid. depends on inf-step which not inf obid.
    (if (and (library-object-active-p (library-lookup oid t))
		 (let ((objc (objc-of-inf-tree inf-tree)))
		   (let ((source (source-of-objc objc)))
		     (let ((step (step-of-inf-source source)))
		       (and (similar-goals-p goal (goal-of-inf-step step))
			    (apply-predicate-to-list-pair (children-of-inf-tree inf-tree)
							  (subgoals-of-inf-step step)
							  #'verify-proof))))))
	t
	(progn ;;(setf -oid oid -inf-tree inf-tree -goal goal)  (break "vp")
	       nil
	       ))))

(defun prf-tree-dependencies (inf-tree)
  (let ((acc nil))
    (labels ((visit (inf-tree)
	       (setf acc (append (list-of-stamp-dependencies
				  (dependencies-of-substance
				   (substance-of-objc (objc-of-inf-tree inf-tree))))
				 acc))
	       (mapc #'visit (children-of-inf-tree inf-tree))))
      (visit inf-tree))

    (event-dependencies (current-transaction-stamp)
			(new-event-description *system* *version* '(proof translate))
			acc)))

(defun squash-dependency-store-list-to-event-dependencies (tags events &optional types)
  (event-dependencies
   (current-transaction-stamp)
   (new-event-description *system* *version* tags)
   (list (environment-dependencies-normal
	  (current-transaction-stamp)
	  (let ((deps-list (reduce #'append
				   (mapcar #'(lambda (x)
					       (dependencies-of-dependency-store x))
					   events))))
	    (if types
		(mapcan #'(lambda (deps)
			    (when (member (tag-of-dependencies deps) types)
			      (list deps)))
			deps-list)
		deps-list))))))


(defun inf-tree-collect-dependencies (inf-tree)
  (let ((acc nil))
    (labels ((visit (inf-tree)
	       (let ()
		 (push (translation-of-objc (objc-of-inf-tree inf-tree))
		       acc)
		 (mapc #'visit (children-of-inf-tree inf-tree)))))
      (visit inf-tree))

    acc))

(defun inf-tree-dependencies (inf-tree)
  (squash-dependency-store-list-to-event-dependencies
   '(translate prf inf_tree)
   (inf-tree-collect-dependencies inf-tree)))

(defun dependencies-of-inf-tree-or-proxy (tree)
  (cond
    ((inf-tree-p tree)
     (inf-tree-dependencies tree))
    ((complete-inf-tree-proxy-p tree)
     (dependencies-of-inf-tree-proxy tree))
    (t (raise-error (error-message '(dependencies inf-tree complete not))))))



(defun filter-event-dependencies-of-inf-tree-or-proxy (kinds tree)
  ;;(setf -kinds kinds -tree tree) (break "fedoitop")
  (let ((topdeps (dependencies-of-inf-tree-or-proxy tree)))
    (let ((nevdeps 
	   (mapcan #'(lambda (evdeps)
		       (setf -evdeps evdeps)
		       (let ((deps (mapcan #'(lambda (deps)
					       (when (member (tag-of-dependencies deps) kinds)
						 (list deps)))
					   (list-of-stamp-dependencies evdeps))))
			 (when deps
			   (list (environment-dependencies-normal
				  (stamp-of-stamp-dependencies evdeps)
				  deps)))))
		   (list-of-stamp-dependencies topdeps))))
      (event-dependencies (stamp-of-stamp-dependencies topdeps)
			  (description-of-event-dependencies topdeps)
			  nevdeps))))


(defun stm-prf-dependencies-of-inf-tree-or-proxy (tree)
  (filter-event-dependencies-of-inf-tree-or-proxy '(proof statement) tree))

;; kinda-odd but evolved this way. maybe better
;; to change caller and remove this defun.
(defun other-dependencies-of-inf-tree-or-proxy (tree)
  (list (dependencies-of-inf-tree-or-proxy tree)))

#|(defun inf-tree-stm-prf-dependencies (inf-tree)
  (squash-dependency-store-list-to-event-dependencies
   '(translate prf inf_tree)
   (inf-tree-collect-dependencies inf-tree)
   '(proof statement)))
|#
(defun extract-of-inf-tree-or-proxy (tree)
  (cond
    ((inf-tree-p tree)
     (extract-from-inf-tree tree))
    ((complete-inf-tree-proxy-p tree)
     (extract-of-inf-tree-proxy tree))
    (t (raise-error (error-message '(extract inf-tree complete not))))))

(defun goal-of-inf-tree-or-proxy (tree)
  (cond
    ((inf-tree-p tree)
     (goal-of-inf-tree tree))
    ((complete-inf-tree-proxy-p tree)
     (goal-of-inf-tree-proxy tree))
    (t (raise-error (error-message '(goal inf-tree complete not))))))

(defun set-proof-source-xref-or-proxy (tree source)
  ;;(setf -tree tree -p (inf-tree-p tree)) (break "spsxop")
  (cond
    ((inf-tree-p tree)
     (set-proof-source-xref (prf-tree-xref tree) source))
    ((complete-inf-tree-proxy-p tree)
     ;; expect it to be there. if inf tree activated via some other
     ;; path though it is possible that it is not.
     (unless (xref-of-proof-source source)
       (raise-error (error-message '(xref inf-tree not)))))
    (t (raise-error (error-message '(xref inf-tree complete not))))))

(defun new-inf-tree-proxy (tree)
  ;;(setf -tree tree) (break "nitp")
  (make-instance 'inf-tree-proxy 'stamp (new-transaction-stamp) 'tree tree))

(defun new-complete-inf-tree-proxy-aux (tree)
  (make-instance 'complete-inf-tree-proxy
		 'stamp (new-transaction-stamp)
		 'tree (inf-tree-to-iinf-tree-term tree nil t)
		 'goal (goal-of-inf-tree tree)
		 'dependencies (inf-tree-dependencies tree)
		 'extract (extract-from-inf-tree tree))
  )

(defun new-complete-inf-tree-proxy (tree)
  ;;(setf -tree tree) (break "nitp")
    (let ((g (goal-of-inf-tree tree)))
      
      (if (and (not (exists-p #'(lambda (term) (term-walk-p term #'iplaceholder-term-p)) g))
	       (verify-proof tree g))
	  (new-complete-inf-tree-proxy-aux tree)

	  ;; this looks very suspicious the tree should be a term? not an inf-tree
	  (make-instance 'inf-tree-proxy 'stamp (new-transaction-stamp) 'tree tree))))

;;;
;;;	Refinement : 
;;;

;; current stamp not persistent. could be an annotation added to !inf_tree term??
;; RLE TODO reset stamp when refinement instantiated.

(defstruct refinement
  (stamp (new-transaction-stamp))	;; used for equality check. 
  direct-p
  references				; dependency store
  subgoals				; (term . term list) list
  )

(defun direct-refinement-p (r) (refinement-direct-p r))
(defun references-of-refinement (r) (refinement-references r))
(defun subgoals-of-refinement (r) (refinement-subgoals r))
(defun stamp-of-refinement (r) (refinement-stamp r))

(defstruct (abbrev-refinement (:include refinement))
  tactic
  extract )

(defun tactic-of-abbrev-refinement (r) (abbrev-refinement-tactic r))
(defun extract-of-abbrev-refinement (r) (abbrev-refinement-extract r))

(defstruct (certified-refinement (:include abbrev-refinement))
  (certification 'not))

(defun new-certified-refinement (cert tactic subgoals &optional extract references)
  (make-certified-refinement :certification cert
			     :tactic tactic
			     :subgoals subgoals
			     :references references
			     :extract extract))
  
(defstruct (rule-refinement (:include refinement))
  rule
  )

(defun rule-of-rule-refinement (r) (rule-refinement-rule r))

(defun abbrev-refinement (stamp direct-p references subgoals tactic extract)
  (make-abbrev-refinement :stamp stamp
			  :direct-p direct-p
			  :references references
			  :subgoals subgoals
			  :tactic tactic
			  :extract extract))


(defstruct (top-refinement (:include refinement))
  tactic
  inf-tree	;; either inf-tree-proxy or inf-objc-tree.
  )

(defun tactic-of-top-refinement (r) (top-refinement-tactic r))

(defun tactic-of-refinement (r)
  (cond
    ((top-refinement-p r) (tactic-of-top-refinement r))
    ((abbrev-refinement-p r) (tactic-of-abbrev-refinement r))
    (t (raise-error (error-message '(refinement tactic not))))))


(defun inf-tree-of-top-refinement (r g &optional peekp)
  (let ((it (top-refinement-inf-tree r)))
    (if (inf-tree-p it)
	it
	;; builds new tree and new inf-objc and rebinds inf oid to new inf-objc?
	;; but how do we know oid of inf-objc??
	(let ((nit (let ((subgoals (top-refinement-subgoals r)))
		     ;; (if (same-goals-p (car s) g) (combine-annos (car s) g))
		     ;; not goal anno, prf anno?
		     (iinf-tree-term-to-inf-tree (tree-of-inf-tree-proxy
						  (provide-data it 'inf-tree-proxy))
						 subgoals						 
						 g
						 ))))
	  ;; some  refinements simply add annotations
	  (if peekp
	      nit
	      (setf (top-refinement-inf-tree r) nit))))))

(defun iinf-tree-of-top-refinement (r)
  (let ((it (top-refinement-inf-tree r)))
    (if (inf-tree-p it)
	(inf-tree-to-iinf-tree-term it t t)
	(tree-of-inf-tree-proxy (provide-data it 'inf-tree-proxy)))))


(defun inf-tree-term-of-top-refinement (r)
  (let ((it (top-refinement-inf-tree r)))
    (if (inf-tree-p it)
	(inf-tree-to-term it)

	;; should just pull out unmarshalled term, fails otherwise.
	(persist-data it))))


(defun refinement-modify-inf-tree (r it)
  (let ((newr (copy-top-refinement r)))
    (setf (top-refinement-inf-tree newr) it)

    newr))


(defstruct (primitive-refinement (:include refinement))
  extract
  )

(defun extract-of-primitive-refinement (r) (primitive-refinement-extract r))




;; inf-objc containing inf-step will have cumulative refs and extract.
;;
(defstruct (inf-step (:copier weak-copy-inf-step))
  goal	; (term . term list)
  info-annotations 
  refinement				; analogous to translation
  ;;dependencies refine
  )


(defun inf-step (goal)
  (when (not (consp goal))
    (break "isg")
    (fooe))
  (make-inf-step :goal goal))


(defun goal-of-inf-step (s) (inf-step-goal s))
(defun annotations-of-inf-step (s) (inf-step-info-annotations s))

(defun refinement-of-inf-step (s) (inf-step-refinement s))

(defun copy-inf-step (step)
  (weak-copy-inf-step step))

;; destructive mod.
(defun inf-step-annotate (step term)
  (push term (inf-step-info-annotations step))
  step)

(defun inf-step-set-annotations (step terms)
  (setf (inf-step-info-annotations step) terms))
  

;; stamp will be an annotation added to !inf_tree term??

(defun type-of-inf-step (s)
  (let ((r (refinement-of-inf-step s)))
    (cond
      ((top-refinement-p r) 'top)
      ((abbrev-refinement-p r) 'abbrev)
      ((primitive-refinement-p r) 'primitive)
      ((rule-refinement-p r) 'rule)
      ((null r) 'unrefined)
      (t (raise-error (error-message '(step type not)))))))

(defun refined-inf-step-p (s) (and (refinement-of-inf-step s) t))
(defun unrefined-inf-step-p (s) (null (refinement-of-inf-step s)))

(defun tactic-of-inf-step (s)
  (let ((r (refinement-of-inf-step s)))
    (cond
      ((top-refinement-p r) (tactic-of-top-refinement r))
      ((abbrev-refinement-p r) (tactic-of-abbrev-refinement r))
      (t (raise-error (error-message '(step tactic not) (type-of-inf-step s)))))))

(defun rule-of-inf-step (s &optional nil-ok-p)
  (let ((r (refinement-of-inf-step s)))
    (cond
      ((top-refinement-p r) (tactic-of-top-refinement r))
      ((abbrev-refinement-p r) (tactic-of-abbrev-refinement r))
      ((rule-refinement-p r) (rule-of-rule-refinement r))
      (t (unless nil-ok-p
	   (raise-error (error-message '(step tactic not) (type-of-inf-step s))))))))


;;;;	
;;;;	!incomplete{<i>} terms were being incorrectly quoted
;;;;	by refiner at extract time. Rather than re-refine
;;;;	defined func to fixup extracts primitive refinement inf-steps buy un-quoting extracts.
;;;;	
;;;;	remove erase-quotes at some later date (current date is 8/98);;

(defun extract-of-inf-step (s)
  (let ((r (refinement-of-inf-step s)))
    (erase-quotes
     (cond
       ((abbrev-refinement-p r) (extract-of-abbrev-refinement r))
       ((primitive-refinement-p r) (extract-of-primitive-refinement r))
       (t (raise-error (error-message '(step extract not) (type-of-inf-step s)))))
     'extract)))


(defun subgoals-of-inf-step (s)
  (let ((r (refinement-of-inf-step s)))
    (cond
      ((top-refinement-p r) (subgoals-of-refinement r))
      ((abbrev-refinement-p r) (subgoals-of-refinement r))
      ((primitive-refinement-p r) (subgoals-of-refinement r))
      ((rule-refinement-p r) (subgoals-of-refinement r))
      (t (raise-error (error-message '(step subgoals not) (type-of-inf-step s)))))))

(defun references-of-inf-step (s)
  (let ((r (refinement-of-inf-step s)))
    (cond
      ((top-refinement-p r) (references-of-refinement r))
      ((abbrev-refinement-p r) (references-of-refinement r))
      ((primitive-refinement-p r) (references-of-refinement r))
      (t (raise-error (error-message '(step references not) (type-of-inf-step s)))))))


(defun direct-inf-step-p (s)
  (let ((r (refinement-of-inf-step s)))
    (unless r
      (raise-error (error-message '(step direct not-refined))))

    (direct-refinement-p r)))
 
 
(defun stamp-of-inf-step (s)
  (let ((r (refinement-of-inf-step s)))
    (unless r
      (raise-error (error-message '(step stamp not-refined))))
  
    (stamp-of-refinement r)))


(defun inf-tree-of-inf-step (s &optional peekp)
  (let ((r (refinement-of-inf-step s)))
    (cond
      ((top-refinement-p r)
       (inf-tree-of-top-refinement r (goal-of-inf-step s) peekp))

      (t (raise-error (error-message '(step inf-tree not) (type-of-inf-step s)))))))

(defun iinf-tree-of-inf-step (s)
  (let ((r (refinement-of-inf-step s)))
    (cond
      ((top-refinement-p r)
       (iinf-tree-of-top-refinement r))
      
      (t (raise-error (error-message '(step inf-tree not) (type-of-inf-step s)))))))


(defun new-inf-step-inf-tree (old-step tree)
  (let ((step (copy-inf-step old-step)))
    (setf (inf-step-refinement step)
	  (refinement-modify-inf-tree (refinement-of-inf-step step) tree))
    step))


(defun goal-match-p-old (a b)
  (unless (and (null (cdr a)) (null (cdr b)))
	  (raise-error (error-message '(goal match annotations not-implemented-yet) (cadr a) (cadr b)))
	  )
  (if (and (compare-terms-p (car a) (car b))
	   (or 
	    (not (= (length (cdr a)) (length (cdr b))))
	    (apply-predicate-to-list-pair (cdr a) (cdr b) #'compare-terms-p)))
      t  
      (progn (setf aa a bb b) (break "g") nil)))

(defun goal-match-p (a b)
  (if (and
       ;; compare goals, hyps in term may be numbered so need to modify the sequents 
       (or (compare-terms-p (car a) (car b))
	   (compare-terms-p (modify-sequent-term (car a)) (modify-sequent-term (car b)))
	   (and (imp-msequent-term-p (car a)) (compare-terms-p (car a) (unmodify-sequent-term (car b))))
	   (and (imark-term-p (car b)) 
	    (compare-terms-p (modify-sequent-term (car a))
	    (term-of-imark-term (modify-sequent-term (car b)))))

	   )
       ;; LAL TODO: how to match annotations stil needs work
       (or 
	(imp-msequent-term-p (car a))
	(not (= (length (cdr a)) (length (cdr b))))
	(apply-predicate-to-list-pair (cdr a) (cdr b) #'compare-terms-p)))
      t  
      (progn (setf aa a bb b) ;;(break "g")
	nil)))

(defun term-to-inf-objc-step (term)
  (let ((new-step (inf-step (iinf-goal-term-to-goal
			     (goal-of-iinf-tree-term term))))
	(node (node-of-iinf-tree-term term)))

    (setf

     (inf-step-info-annotations new-step)
     (map-isexpr-to-list (annotations-of-iinf-tree-term term)
			 (iannotation-cons-op))
	    

     (inf-step-refinement new-step)
     (unless (iinf-unrefined-term-p node)
       (let ((subgoals (map-isexpr-to-list (children-of-iinf-tree-term term)
					   (iinf-tree-cons-op)
					   #'iinf-goal-term-to-goal))
	     (references (term-to-environment-dependencies
			  (dependencies-of-iinf-top-term node))))

	 (cond
	   ((iinf-top-term-p node)

	    (make-top-refinement :direct-p (direct-of-iinf-top-term node)
				 :subgoals subgoals
				 :references references
				 :tactic (tactic-of-iinf-top-term node)
				 :inf-tree (let ((top (tree-of-iinf-top-term node)))
					     ;; can be inf-tree-proxy of !inf_tree
					     (if (or (idata-persist-inline-term-p top)
						     (idata-persist-term-p top))
						 (term-to-data top)
						 (term-to-inf-tree top)))))

	   ((iinf-primitive-term-p node)
	    (make-primitive-refinement :direct-p nil
				       :subgoals subgoals
				       :references references
				       :extract (term-to-inf-extract
						 (extract-of-iinf-primitive-term node))))

	   ((iinf-abbrev-term-p node)
	    (make-abbrev-refinement :direct-p (direct-of-iinf-abbrev-term node)
				    :subgoals subgoals 
				    :references references 
				    :tactic (tactic-of-iinf-abbrev-term node)
				    :extract (term-to-inf-extract
					      (extract-of-iinf-abbrev-term node))))

	   (t (raise-error (error-message '(inf-step objc term node) term)))))))

    new-step))


;;	embedded inf-tree in top refinement may be proper !inf_tree term or
;;	may be !cons tree of !data_persists of inf objc's.
(defun inf-objc-step-to-node-term (step)

  (case (type-of-inf-step step)

    (unrefined	(iinf-unrefined-term))

    (top	(iinf-top-term (direct-inf-step-p step)
			       (environment-dependencies-to-term (references-of-inf-step step))
			       (inf-tree-term-of-top-refinement (refinement-of-inf-step step))
			       (tactic-of-inf-step step)))

    (primitive	(iinf-primitive-term (environment-dependencies-to-term (references-of-inf-step step))
				     (inf-extract-to-term (extract-of-inf-step step))))

    (abbrev	(iinf-abbrev-term nil
				  (environment-dependencies-to-term (references-of-inf-step step))
				  (inf-extract-to-term (extract-of-inf-step step))
				  (tactic-of-inf-step step)))))


;; export form of step of inf source and inf-substance.
(defun inf-objc-step-to-term (step)

  (iinf-tree-term
   (goal-to-term (goal-of-inf-step step))
   (inf-objc-step-to-node-term step)
   (if (refined-inf-step-p step)
       ;; note that this differs from usual !inf_tree in that children
       ;; are goals and not !inf_tree's.
       (map-list-to-ilist (subgoals-of-inf-step step)
			    (iinf-tree-nil-term)
			    #'goal-to-term)
       (iinf-tree-nil-term))
   (map-sexpr-to-isexpr (annotations-of-inf-step step)
			(iannotation-nil-term))))

(defun inf-objc-to-step-subgoals-term (isrc)
  (let ((step (step-of-inf-source isrc)))
    (if (refined-inf-step-p step)
	;; note that this differs from usual !inf_tree in that children
	;; are goals and not !inf_tree's.
	(map-list-to-ilist (subgoals-of-inf-step step)
			   ;;(iinf-tree-nil-term)
			   (inil-term)
			   #'goal-to-term)
	(inil-term)
	;;(iinf-tree-nil-term)
	)))


;;;;	
;;;;	
;;;;	
;;;;	
;;;;	

;; to avoid rewrite entire source for prop change, properties could be distinct?
;; or substantive props included in source but others not? or rely on compression
;; to recognize and reuse. FTTB, keep together. Maybe edd keeps short display strings
;; in own log file and not in object itself.

(defclass source (data)
  ;; source
  ((term :reader term-of-source
	 :writer set-source-term
	 :initarg term
	 :initform nil
	 )

  (properties :reader properties-of-source
	      :writer set-source-properties
	      :initarg properties
	      :initform nil
	      )
   ))

(defmethod clone-copy ((old-source source) (new-source source))
  (set-source-term (term-of-source old-source) new-source)
  (set-source-properties (properties-of-source old-source) new-source)
  (call-next-method old-source new-source))


(defun new-source (term &optional kind properties)
  (make-instance (type-of-source kind) 'type (type-of-source kind) 'stamp (transaction-stamp) 'term term 'properties properties))

(define-primitive |!source| () (term properties sub))

(defmethod data-import ((source source) super)
  (let ((term (call-next-method source super)))
    
    (let ((data-term (term-of-isource-term term)))
      (unless (ivoid-term-p data-term)
	(set-source-term (term-of-idata-term data-term) source)))
    
    (set-source-properties (term-to-properties (properties-of-isource-term term)) source)

    (sub-of-isource-term term)))


#|(defmethod data-export ((source source) sub)
  (call-next-method source
		    (isource-term (let ((term (term-of-source source)))
				    (if term
					(idata-term term)
					(ivoid-term)))
				  (properties-to-term (properties-of-source source))
				  sub)))|#

(defmethod data-export-aux ((source source) sub)
  (call-next-method source
		    (isource-term (let ((term (term-of-source source)))
				    (if term
					(idata-term term)
					(ivoid-term)))
				  (properties-to-term (properties-of-source source))
				  sub)))

(defmethod data-export ((source source) sub)
  (data-export-aux source sub))


(defun similar-substantive-properties (asource asubstance)
  (cond
    ((null asource) t)
    ((null asubstance) nil)
    (t
     (equal-properties-p (substantive-properties-of-source asource)
			 (properties-of-substance asubstance)))))


;; returns t, nil, or data. t or data should cause translation. data should be passed to translate func.
(defmethod translation-required ((source source) substance term)
  ;;(break "trn")
  (or (null substance)
      (not (compare-terms-p term (term-of-substance substance)))
      (not (similar-substantive-properties source substance))))



(defun equal-properties-p (soprops suprops)
  (and (= (length soprops) (length suprops))
       (forall-p #'(lambda (soprop)
		     (let ((suterm (cdr (assoc (car soprop) suprops))))
		       (and suterm
			    (compare-terms-p suterm (cdr soprop)))))
		 soprops)))

;; term is reduced term-of-source
(defmethod translation-required ((source source) (substance substance) term)

  (let ((substance-term (term-of-substance substance)))

    ;;(setf -substance-term substance-term -source source -term term -substance substance) (break "trss")

    ;; should check if substance dependencies touched, as they affect translation.

    (or (not (or (eq substance-term term)
		 (compare-terms-p substance-term term)))
	      
	(not (similar-substantive-properties source substance)
	     ))))


(defclass statement-source (source)
  ((proofs :reader proofs-of-statement-source
	   :writer set-statement-source-proofs
	   :initform nil
	   :initarg proofs)
   ))

;;(define-primitive |!statement_source| () (proofs))

(defmethod data-import ((source statement-source) super)
  (let ((term (call-next-method source super)))
    (set-statement-source-proofs (oids-of-ioids-term term) source))

  (values))

(defmethod data-export ((source statement-source) sub)
  (call-next-method source
		    (ioids-term (proofs-of-statement-source source))))


(defmethod clone-copy ((old-source statement-source) (new-source statement-source))
  (set-statement-source-proofs (proofs-of-statement-source old-source) new-source)
  (call-next-method old-source new-source))

(defun extract-required-p (source)
  (let ((extprop (cdr (assoc '|extract_required| (properties-of-source source)))))
    (and extprop
	 (ibool-term-p extprop)
	 (bool-of-ibool-term extprop))))

(defun extract-supplied-p (substance)
  (and (extract-of-statement-substance substance) t))

(defun extract-available-p (prfs)
  (exists-p #'(lambda (prf)
		(let ((prf-obj (library-lookup prf)))
		  (and (library-object-active-p prf-obj)
		       (maybe-extract-of-prf-objc (objc-of-library-object prf-obj))
		       t)))
	     prfs))

(defmethod translation-required ((source statement-source) (substance statement-substance) term)

  (with-handle-error (('(translate stm prf)) t)
    
    (let ((prfs (proofs-of-statement-substance substance)))
      (or (call-next-method source substance term)
	  ;;(progn (setf -source source -substance substance) (break "stmtr") nil)

	  (not (equal-bags-p #'equal-oids-p
			     prfs
			     (let ((acc nil))
			       (dolist (prf (proofs-of-statement-source source))
				 (let ((prf-obj (library-lookup prf)))
				   (when (library-object-active-p prf-obj)
				     (push prf acc))))
			       acc)))
	
	  ;;(setf -source source -substance substance -prfs prfs) (break "trs")
	  ;; todo  : required if available extract not identical to substance extract!
	  (and (extract-required-p source)
	       (not (extract-supplied-p substance))
	       (extract-available-p prfs))))))





;; Expected proxy ok as inf-tree but doesn't look ok.
;; inf-tree is tree of oids. !inf_tree is hidden as proxies inside inf objc's.

(defclass proof-source (source)
  ((inf-tree :reader inf-tree-of-proof-source
	     :writer set-proof-source-inf-tree
	     :initform nil
	     :initarg inf-tree)

   ;; xref : while not necessaily related related to pre-process
   ;;	     the current applications do have xref in common.
   ;;  finer grained dependencies of sub substance
   ;; left as term, unmarshalled when needed.
   (xref :reader xref-of-proof-source
	 :writer set-proof-source-xref
	 :initform nil
	 :initarg xref)
   ))


(define-primitive |!proof_source| () (inf-tree xref))

(defmethod data-import ((source proof-source) super)
  (let ((term (call-next-method source super)))
    (if (iproof-source-term-p term)
	(progn
	  (set-proof-source-inf-tree
 	   (let ((itt (inf-tree-of-iproof-source-term term)))
	     (if (or (idata-persist-inline-term-p itt)
		     (idata-persist-term-p itt))
		 (term-to-data itt)
		 (term-to-inf-tree itt)))
	   source)
	  (set-proof-source-xref (xref-of-iproof-source-term term)
				 source))
	(set-proof-source-inf-tree (term-to-inf-tree term)
				   source)))
  (values))

;; this is defunt fttb.
;;  - difficult to force export of proof-source if containing objc is persistent.
;;  - need to filter inf oids made unnecessary from dump list.
(defvar *proxize-inf-tree-dynamically-default* nil)
(defvar *proxize-inf-tree-dynamically* nil)
(defmacro with-proxize-inf-tree (&body body)
  `(let ((*proxize-inf-tree-dynamically* *proxize-inf-tree-dynamically-default*))
    ,@body))

(defun complete-inf-tree-eph-proxy-or-inf-tree-of-proof-source (psrc)
  ;;(break "ceitpoitops")
  (format t "~%complete-inf-tree-eph-proxy-or-inf-tree-of-proof-source")
  (let ((itree (inf-tree-of-proof-source psrc)))
    (if (inf-tree-p itree)
	(let ((g (goal-of-inf-tree itree)))
      
	  (if (and (not (exists-p #'(lambda (term) (term-walk-p term #'iplaceholder-term-p)) g))
		   (verify-proof itree g))
	      (new-complete-inf-tree-proxy-aux itree)
	      itree))
	(provide-inf-tree-proxy itree))))


(defmethod data-export ((source proof-source) sub)
  (let ((xref (xref-of-proof-source source)))
    ;;setf -source source -xref xref) (break "dep")
    (let ((inf-tree (if (and *proxize-inf-tree-dynamically* xref)
			(complete-inf-tree-eph-proxy-or-inf-tree-of-proof-source source)
			(inf-tree-or-proxy-of-proof-source source))))

      (format t "~%Exporting Prf Source")
      ;;(setf -inf-tree inf-tree) (break "data-export prf")
      (call-next-method source
			(cond
			  ((complete-inf-tree-proxy-p inf-tree)
			   (unless xref
			     (raise-error (error-message '(proof-source export inf-tree complete xref not))))
			   (iproof-source-term (persist-data inf-tree) xref))
			  ((inf-tree-p inf-tree)
			   (if xref
			       (iproof-source-term (inf-tree-to-term inf-tree)
						   (xref-of-proof-source source))
			       (inf-tree-to-term inf-tree)))
			  (t (raise-error
			      (error-message
			       '(proof-source export inf-tree complete not)))))))))


		    #|(if (xref-of-proof-source source)
			(iproof-source-term
			 (let ((it (inf-tree-of-proof-source source)))
			   (if (member (type-of it)
				       '(complete-inf-tree-proxy inf-tree-proxy))
			       (persist-data it)
			       (inf-tree-to-term
				(inf-tree-of-proof-source source))))
			 (xref-of-proof-source source))
			(inf-tree-to-term
			 (inf-tree-of-proof-source source)))|#


;; could lazily unroll proof tree from term.
;; not really important as most of proof-tree remains on disk.
(defun new-proof-source (stamp inf-tree)
  (make-instance 'proof-source
		 'stamp stamp
		 'term (ivoid-term)
		 'inf-tree inf-tree))
		  
(defmethod clone-copy ((old-source proof-source) (new-source proof-source))
  (set-proof-source-inf-tree (inf-tree-of-proof-source old-source) new-source)
  (set-proof-source-xref (xref-of-proof-source old-source) new-source)
  (call-next-method old-source new-source))





(defun mltype-to-term (type)
  (type-sexpr-to-term (mltype-to-sexpr type)))

;; tok # bool{mutable} # term{type} # (tok # (unit + object_id) list)
(defunml (|xrefs_of_objc| (objc))
    (object_contents
     -> ((((tok |#| term) list)
	  |#| (bool |#| ((tok |#| (unit |+| object_id)) list))) list))

  (unless (eql 'PRF (kind-of-objc objc))
    (raise-error (error-message '(objc xrefs not) (kind-of-objc objc))))
  (let ((xrefst (xref-of-proof-source (source-of-objc objc))))
    (when xrefst
      (let ((xrefs
	     (mapcar #'(lambda (xref)
			 (list*
			  (list
			   (cons (id-of-xref xref)
				 (let ((xtype (type-of-xref xref)))
				   (if xtype
				       (type-sexpr-to-term xtype)
				       (ivoid-term)))))
			  (mutable-of-xref xref)
			  (mapcar #'(lambda (c)
				      (cons (id-of-xref-id c)
					    (let ((oid (oid-of-xref-id c)))
					      (if oid
						  (cons nil oid)
						  (cons t nil)))))
				  (called-of-xref xref))))
		     ;; old prfs have !mlxef !xref_cons list
		     ;; new prfs have (xref_cons list) !xref_cons list
		     ;; presumably xref_cons list is lists of callers for a node.
		     ;;  this is some artifact of the ability to mutally define a list of callers in a def.
		     ;;  or the effect of flatten the tree to a list ?
		     ;;  or the combination ?
		     (if (and (ixref-cons-term-p xrefst)
			      (xref-cons-term-p (icar xrefst)))
			 (progn
			   ;;(setf -xrefst xrefst)
			   ;;(when *process-break* (break "xrefst"))
			   (mapcan #'(lambda (xrefst)
				       (copy-list (term-to-code-xrefs xrefst)))
				   (map-ilist-to-list xrefst (ixref-cons-op))))
			 (term-to-code-xrefs xrefst)))))
    
	;;(setf -objc objc
	;;	  -xrefs (xref-of-proof-source (source-of-objc objc))
	;;	  -xxrefs xrefs)
	;;(break "xoo")
	xrefs
	)) ))

(defun source-properties-of-objc (o)
  (properties-of-source (source-of-objc o)))


(defun property-of-source (source name)
  (cdr (assoc name (properties-of-source source))))

(defun description-property-of-objc (o)
  (let ((p (property-of-objc o 'description)))
    (when p (term-to-description p))))

(defun language-property-of-objc (o)
  (let ((p (property-of-objc o 'language)))
    (when p (token-of-itoken-term p))))

(defun description-property-term-of-objc (o)
  (or (property-of-objc o 'description) (ivoid-term)))

(defun reduce-property-of-objc (o)
  (let ((p (property-of-objc o 'reduce)))
    
    ;; 1/01 should let lang compile do this.
    ;;(append (list (language-property-of-objc o)))
    (when p
      (map-isexpr-to-list p (icons-op) #'token-of-itoken-term))))



;;;;	Some effort should be put forth such that mods to non-direct
;;;;	steps can be saved with re-refinement by matching trees and using
;;;;	source data form former tree.


;;;;	
;;;;	Some objects need a pre process step prior to translation :
;;;;	  notably inf refinements and code compiles
;;;;	
;;;;	- might think inf-source should be subclass of but code is 
;;;;	  compiled and inf is interpretd ie no bin file possibility.
;;;;	- could have code-aux-source with inf code common, ie 
;;;;	  xref and language. 
;;;;	FTTB, just include xref in preprocess source and have inf and code 
;;;;	subclass preprocess.
;;;;	
;;;;	
;;;;	If Preprocess arrives at same processed data then need to be able to
;;;;	avoid retranslation.
;;;;	
;;;;	Can avoid process as well if input to preprocess is same.
;;;;	
;;;;	Seems like some general method of source/process/substance where
;;;;	substance may be source for next process could treat all
;;;;	process and translation abstractly.

(defclass preprocess-source (source)

  (
   ;; reduced term, ie term sent to pre-process.  required to detect if
   ;; pre-process needed after source mod.  differs from substance
   ;; term in that substance may not be present even if pre-processed. as
   ;; we are treating pre-process and activation distinctly.
   (reduced :reader reduced-of-source
	    :writer set-source-reduced
	    :initform nil
	    :initarg reduced)

   ;; list of event-dependency terms for pre-process dependencies.
   ;; eg, reduce prior to pre-process or by pre-process.
   ;; may want to distinquish, ie if change abstraction needed to produce
   ;; input to preprocess then do not need to preprocess but if changed abstraction
   ;; used by preprocess then need to preprocess. Assume dependencies by preprocess
   ;; contained is subclass??
   (reduce-dependencies :reader reduce-dependencies-of-source
		 :writer set-source-reduce-dependencies
		 :initform nil
		 :initarg dependencies)

   #|
   ;; would prevent call to client if minor mod made, ie one which did not
   ;; change reduced term. would need force to capture new abs defined.
   (static-dependencies :reader static-dependencies-of-source
			:writer set-source-static-dependencies
			:init-form nil
			:initarg static)
   |#

   ))

(defmethod clone-copy ((old-source preprocess-source) (new-source preprocess-source))
  (set-source-reduced (reduced-of-source old-source) new-source)
  (set-source-reduce-dependencies (reduce-dependencies-of-source old-source) new-source)
  (call-next-method old-source new-source))


(define-primitive |!preprocess_source| () (term dependencies sub))

(defmethod data-import ((source preprocess-source) super)
  (let ((term (call-next-method source super)))

    (if (ipreprocess-source-term-p term)
	
	(let ((data-term (term-of-ipreprocess-source-term term)))
	  (unless (ivoid-term-p data-term)
	    (set-source-reduced (term-of-idata-term data-term) source))
    
	  (set-source-reduce-dependencies (term-to-event-dependencies (dependencies-of-ipreprocess-source-term term)) source)
	  (sub-of-ipreprocess-source-term term))

	;; some subtypes previously were derived directly from source thus pass it on down.
	term)))

#|(defmethod data-export ((source preprocess-source) sub)
  (call-next-method source
		    (ipreprocess-source-term (let ((term (reduced-of-source source)))
					       (if term (idata-term term) (ivoid-term)))
					     (event-dependencies-to-term (reduce-dependencies-of-source source))
					     sub)))|#

(defmethod data-export-aux ((source preprocess-source) sub)
  (call-next-method source
		    (ipreprocess-source-term (let ((term (reduced-of-source source)))
					       (if term (idata-term term) (ivoid-term)))
					     (event-dependencies-to-term (reduce-dependencies-of-source source))
					     sub)))

(defmethod data-export ((source preprocess-source) sub)
  (data-export-aux source sub))



(defclass xref-source (preprocess-source)
  (
   ;; xref : while not necessaily related related to pre-process
   ;;	     the current applications do have xref in common.
   ;;  finer grained dependencies of sub substance
   ;; left as term, unmarshalled when needed.
   (xref :reader xref-of-source
	 :writer set-source-xref
	 :initform nil
	 :initarg xref)
   ))

(defun xrefs-of-source (s)
  (term-to-code-xrefs (xref-of-source s)))

(defmethod clone-copy ((old-source xref-source) (new-source xref-source))
  (set-source-xref (xref-of-source old-source) new-source)
  (call-next-method old-source new-source))

(define-primitive |!xref_source| () (xref sub))

(defmethod data-import ((source xref-source) super)
  (let ((term (call-next-method source super)))

    (if (ixref-source-term-p term)
	(let ((xterm (xref-of-ixref-source-term term)))
	  (unless (ivoid-term-p xterm)
	    (set-source-xref xterm source))
    
	  (sub-of-ixref-source-term term))

	;; some subtypes previously were derived directly from source thus pass it on down.
	term)))

(defmethod data-export ((source xref-source) sub)
  (let ((xref (xref-of-source source)))
    (call-next-method source
		      (ixref-source-term (or xref (ivoid-term))
					 sub))))

(defun preprocess-objc-modify-source (objc reduced reduce-dependencies)
  (let ((news (clone (source-of-objc objc))))
  
    (set-source-reduced reduced news)
    (set-source-reduce-dependencies reduce-dependencies news)

    (objc-modify-source objc news)
    ))

(defun xref-objc-modify-source (objc xref)
  (let ((news (clone (source-of-objc objc))))
  
    (set-source-xref xref news)

    (objc-modify-source objc news)))


;; source term is tactic.
(defclass inf-source (xref-source)
  (
   ;; need reduced goal??
   ;; should be whole other preprocess-source instance
   ;; and we should allow editing, STM then could be instance of an inf.
   ;; and proof becomes predominent structure for theorems.
   ;; FTTB no editing and no reduction.
   (goal :reader goal-of-inf-source
	 :writer set-inf-source-goal
	 :initform nil
	 :initarg goal)

   ;; not used at the moment, may expect the time stats to be here??
   (annotations :reader annotations-of-inf-source
		:writer set-inf-source-annotations
		:initform nil
		:initarg annotations)

   ;; contains reduced source term
   (step :reader step-of-inf-source
	 :writer set-inf-source-step
	 :initform nil
	 :initarg step)
   ))


(define-primitive |!inf_source| () (goal annotations step))

(defmethod data-import ((source inf-source) super)
  (let ((term (call-next-method source super)))

    (when (iinf-source-term-p term)
      (let ((igoal (goal-of-iinf-source-term term)))
	(unless (ivoid-term-p igoal)
	  (set-inf-source-goal (iinf-goal-term-to-goal igoal) source)))

      (set-inf-source-annotations (term-to-annotations (annotations-of-iinf-source-term term))
				  source)

      (let ((istep (step-of-iinf-source-term term)))
	(unless (ivoid-term-p istep)
	  (set-inf-source-step (term-to-inf-objc-step istep)
			       source)))

      (values))))

(defmethod data-export ((source inf-source) sub)
  (call-next-method source
		    (iinf-source-term (let ((goal (goal-of-inf-source source)))
					(if goal
					    (goal-to-term goal)
					    (ivoid-term)))
				      (annotations-to-term (annotations-of-inf-source source))
				      (let ((step (step-of-inf-source source)))
					(if step
					    (inf-objc-step-to-term step)
					    (ivoid-term))))))

(defun new-inf-source (goal tactic)
  (make-instance 'inf-source 'term tactic 'goal goal))
  
(defmethod clone-copy ((old-source inf-source) (new-source inf-source))
  (set-inf-source-goal (goal-of-inf-source old-source) new-source)
  (set-inf-source-annotations (annotations-of-inf-source old-source) new-source)
  (set-inf-source-step (step-of-inf-source old-source) new-source)
  (call-next-method old-source new-source))



;;;
;;;
;;;

(defclass inf-substance (substance)
  ((step :reader step-of-inf-substance
	 :writer set-inf-substance-step
	 :initform nil
	 :initarg step)
   ))

(defun new-inf-substance (step props)
  (make-instance 'inf-substance 'term (ivoid-term) 'step step 'properties props))

;;(define-primitive |!inf_substance| () (term dependencies step))

(defmethod data-import ((substance inf-substance) super)
  (let ((term (call-next-method substance super)))
    (set-inf-substance-step (term-to-inf-objc-step term)
			    substance))

  (values))

(defmethod data-export ((substance inf-substance) sub)
  (call-next-method substance (inf-objc-step-to-term (step-of-inf-substance substance))))


;;;
;;;	Code : source contains xref.
;;;	

;; at activate for ml bin if bin already loaded client may still
;; reload if any defs shadowed?! Thus substance needs ids of defs defined.? What about ref-vars
;; modified?
(defclass compilation (source)
  (
   (language :reader language-of-code-source
	     :writer set-code-source-language
	     :initform nil
	     :initarg language)

   ;; todo : for ml, allow compilation without load such that
   ;; compilation does not effect state. Then load will
   ;; happen at activate. (need to fix global type info bound unstamp mlid).
   (bins :reader bins-of-code-source
	 :writer set-code-source-bins
	 :initform nil
	 :initarg bins)

   ;; list of event-dependency terms.
   (dependencies :reader dependencies-of-code-source
		 :writer set-code-source-dependencies
		 :initform nil
		 :initarg dependencies)))


(defclass code-source (source)
  (
   (language :reader language-of-code-source
	     :writer set-code-source-language
	     :initform nil
	     :initarg language)

   ;; reduced term, ie term sent to compiler.  required to detect if
   ;; recompilation needed after source mod.  differs from substance
   ;; term in that substance may not be present even if compiled. as
   ;; we are treating compilation and activation distinctly.
   (reduced :reader reduced-of-code-source
	    :writer set-code-source-reduced
	    :initform nil
	    :initarg reduced)
   
   (xref :reader xref-of-code-source
	 :writer set-code-source-xref
	 :initform nil
	 :initarg xref)

   ;; todo : for ml, allow compilation without load such that
   ;; compilation does not effect state. Then load will
   ;; happen at activate. (need to fix global type info bound unstamp mlid).
   (bins :reader bins-of-code-source
	 :writer set-code-source-bins
	 :initform nil
	 :initarg bins)

   ;; list of event-dependency terms.
   (dependencies :reader dependencies-of-code-source
		 :writer set-code-source-dependencies
		 :initform nil
		 :initarg dependencies)
   ))


(defun source-to-code-source (source)
  (let ((csource (make-instance 'code-source 'type 'code-source)))

    (clone-copy source csource)

    ;; clone-copy resets type!
    (set-data-type 'code-source csource)

    csource))


(defun new-code-source-compiled (source language reduced xref bins dependencies)
  (let ((csource (source-to-code-source source)))
    (set-code-source-language language csource)
    (set-code-source-reduced reduced csource)
    (set-code-source-xref xref csource)
    (set-code-source-bins bins csource)
    (set-code-source-dependencies dependencies csource)

    csource))
	

(define-primitive |!code_source| ((token . language)) (reduced xref bins dependencies))

(defmethod clone-copy ((old-source code-source) (new-source code-source))
  (set-code-source-language (language-of-code-source old-source) new-source)
  (set-code-source-reduced (reduced-of-code-source old-source) new-source)
  (set-code-source-xref (xref-of-code-source old-source) new-source)
  (set-code-source-bins (bins-of-code-source old-source) new-source)
  (set-code-source-dependencies (dependencies-of-code-source old-source) new-source)
  (call-next-method old-source new-source))


;; save to assume that !void() is not going to be valid source
;; term for any language.
(defmethod data-export ((source code-source) sub)
  ;;(break "de-csource")
  (let ((lang (language-of-code-source source)))
    (call-next-method source
		      (icode-source-term lang
					 (or (reduced-of-code-source source) (ivoid-term))
					 (xrefs-to-term (xref-of-code-source source))
					 (iterms (bins-of-code-source source))
					 (map-list-to-ilist (dependencies-of-code-source source) (inil-term))))))


(defun xrefs-of-code-source (o)
  (let ((s (objc-source o)))
    ;;(setf -s s) (break "xomcs")
    (if (data-provided-p s)
	(if (eql 'code-source (type-of s))
	    (xrefs-to-term (xref-of-code-source s))
	    (raise-error (error-message '(source code not))))
	(let ((term (term-of-data s)))
	  (let ((isource (term-of-idata-term term)))
	    (let ((code-source (sub-of-isource-term isource)))
	      (if (icode-source-term-p code-source)
		  (xref-of-icode-source-term code-source)
		  (raise-error (error-message '(source code not))))))))))

(defunml (|xref_of_code_source| (objc))
    (object_contents -> term)

  (xrefs-of-code-source objc))

(defmethod data-import ((source code-source) super) 
  (let ((term (call-next-method source super)))

    (let ((lang (language-of-icode-source-term term)))

      ;;(setf -term term -lang lang) (break "csdi")

      (set-code-source-language lang source)
      (set-code-source-reduced (let ((rterm (reduced-of-icode-source-term term)))
				 (unless (ivoid-term-p rterm) rterm))
			       source)
      (set-code-source-xref (term-to-code-xrefs (xref-of-icode-source-term term)) source)
      (set-code-source-bins (subterms-of-iterms-term (bins-of-icode-source-term term)) source)
      ;; dependencies added later. this prevents problems with source produced prior to dependency change.
      (when (> (length (bound-terms-of-term term)) 3)
	(set-code-source-dependencies (map-isexpr-to-list (dependencies-of-icode-source-term term) (icons-op))
				      source))

      (values))))


(defun idents-of-xrefs (xrefs)
  (let ((acc nil))
    (dolist (xref xrefs)
      (cond
	((xref-entry-p xref)
	 (dolist (caller (callers-of-xref xref))
	   (id-of-xref-id caller)))
	(t ; backwards compatability.
	 (dolist (caller (callers-of-mlxref xref))
	   (push (id-of-mlxref-caller caller) acc))) ))
    acc))

(defun idents-of-code-source (source)
  ;; is nil right when not code source? source but not code source is vestigial.
  (when (eql 'code-source (type-of-data source))
    (idents-of-xrefs (xref-of-code-source source))
    ))

(defun dependencies-of-xrefs (xrefs)
  (let ((acc nil))
    (dolist (xref xrefs)
      (cond
	((xref-entry-p xref)
	 (dolist (called (called-of-xref xref))
	   (let ((d (source-of-xref-id called)))
	     (cond
	       ((oid-p d) (push (dependency d nil nil) acc))
	       ((term-p d) nil)
	       ((null d) nil)
	       (t (break "dox"))
	       ))))
	(t (dolist (called (called-of-mlxref xref))
	     (let ((d (dependency-of-mlxref-called called)))
	       (cond
		 ((null d))
		 ((eql 'this d))
		 ;; ((dependency-p d) (push d acc))
		 ((oid-p d) (push (dependency d nil nil) acc))
		 (t nil)))))))
    acc))
  
(defun xref-dependencies-of-code-source (source)
  (dependencies-of-xrefs (xref-of-code-source source)))

  

;;;;	Desire compilation to happen as request and not as broadcast
;;;;	thus force translation.
(defmethod translation-required ((source code-source) (substance code-substance) term)
  t)


;; stamp should never differ from that in dependency of definition of object
;; containing objc.

;;; objc is small enough that there is no need to defer read. But it does need to be
;;; persistent so it is derived from data.

(defclass objc (data)
  ((kind :reader kind-of-objc
	 :writer set-objc-kind
	 :initform nil
	 :initarg kind)
   (source :reader objc-source
	   :writer set-objc-source
	   :initform (new-source nil)
	   :initarg source)
   (translation :reader objc-translation
		:writer set-objc-translation
		:initform nil
		:initarg translation)
   (substance :reader objc-substance
	      :writer set-objc-substance
	      :initform nil
	      :initarg substance)

   (history :reader objc-history
	    :writer set-objc-history
	    :initform nil)

   ;; subset of essential source properties
   (properties
    :reader objc-properties
    :writer set-objc-properties
    :initform nil
    )
	
   ))


;;;;	
;;;;	Weak mod : known not to force translation and add dependencies.
;;;;	  - modify source without nullify translation.
;;;;	



(defun require-objc-kind (objc kind)
  (or (eql kind (kind-of-objc objc))
      (raise-error (error-message '(require objc kind not) kind (kind-of-objc objc)))))

;; force complete-prf-tree-proxy to disk??
(defun term-to-objc (term)
  ;;(setf -a term) (break "too")
  (let ((objc (provide-data (term-to-data term) 'objc)))

    (when (eql 'PRF (kind-of-objc objc))
      (let ((s (source-of-objc objc)))
	(let ((itree (inf-tree-of-proof-source s)))
	  (unless (inf-tree-p itree)
	    (when (eql 'complete-inf-tree-proxy (type-of-data itree))
	      (provide-data itree 'complete-inf-tree-proxy))))))

    objc))

(defun stamp-of-objc (o) (stamp-of-data o))

(defunml (|objc_stamp_of_oid| (o))
    (object_id -> term)
  (stamp-to-term (stamp-of-data (library-object-objc (library-lookup o t)))))

(defun type-of-source (kind)
  (case kind 
    (stm 'statement-source)
    (inf 'inf-source)
    (prf 'proof-source)
    (otherwise 'source)))


(defun source-of-objc (o)
  (let ((s (objc-source o)))
    (when s
      (if (data-provided-p s)
	  s
	  (set-objc-source (provide-data s (type-of-source (kind-of-objc o))) o)))))

(defunml (|reset_prf_src| (objc))
    (object_contents -> unit)

  (let ((s (objc-source objc)))
    (set-objc-source (provide-data s (type-of-source (kind-of-objc objc)) t) objc)))
			  

(defun translation-term-of-objc-r (o)
  (let ((e (objc-translation o)))
    ;;(setf -e e) (break "ttoor")
    (if e
	(term-of-idata-term (term-of-data e))
	(raise-error (error-message '(objc references not))))))

(defun translation-of-objc (o)
  (let ((e (objc-translation o)))
    (when e
      (if (data-provided-p e)
	  e
	  (set-objc-translation (provide-data e 'dependency-store) o)))))


(defun type-of-substance (kind)
  (case kind
    (disp 'display-substance)
    (rule 'rule-substance)
    (prf 'proof-substance)
    (stm 'statement-substance)
    (inf 'inf-substance)
    (code 'code-substance)
    (otherwise 'substance)))


(defun substance-of-objc (o &optional nil-ok-p) 
  (let ((ss (let ((s (objc-substance o)))
	      (when s
		(if (data-provided-p s)
		    s
		    (with-ignore (set-objc-substance (provide-data s (type-of-substance (kind-of-objc o))) o)))))))
    (or ss
	(unless nil-ok-p
	  (raise-error (error-message '(substance not)))))))

(defun objc-translated-p (o) (not (null (objc-translation o))))

(defmethod clone-copy ((old objc) (new objc))

  (when (null (type-of-data old))
    (setf -old old -new new) (break "cc-objc"))
  (set-objc-source (objc-source old) new)
  (set-objc-kind (kind-of-objc old) new)
  (set-objc-translation (objc-translation old) new)
  (set-objc-substance (objc-substance old) new)
  (set-objc-properties (objc-properties old) new)
  (call-next-method old new)
  )

;; inclusion of name is efficiency consideration. Old code depends heavily on name
;; so efficient access is needed.
(define-primitive |!objc| ((token . kind)) (source translation substance history property-cache))

(defun import-objc-properties (term)
  ;;(break "iop")
  (let ((bt (nth 4 (bound-terms-of-term term))))
    (if (null bt)
	'cache-not
	(let ((pterm (term-of-bound-term bt)))
	  (if  (itoken-term-p pterm)
	       'cache-not
	       (term-to-properties pterm))))))

(defun cache-properties-of-objc (objc)
  (let ((props (objc-properties objc)))
    (cond
      ((eql 'cache-not props)
       ;;(break "eop")
       (let ((props (objc-properties-of-source (source-of-objc objc))))
	 (set-objc-properties props objc)
	 props))
      (t props))))

(defun export-objc-properties (objc)
  (properties-to-term 
   (cache-properties-of-objc objc)))


(defun property-of-objc (o name)
  (if (member name *objc-properties*)
      (cdr (assoc name (cache-properties-of-objc o)))    
      (cdr (assoc name (source-properties-of-objc o)))))


(defun name-of-objc (o)
  (let ((n (property-of-objc o 'name)))
    (when n
      (if (itoken-term-p n)
	  (token-of-itoken-term n)
	  (progn
	    (message-emit (warn-message '(objc name !token not) n)))))))


(defun description-term-of-objc (o)
  (or (property-of-objc o 'description) (ivoid-term)))
  


(defmethod data-import ((objc objc) super)
  (let ((term (call-next-method objc super)))
    ;;(setf -term term) (break "di")
    (set-objc-kind (kind-of-iobjc-term term) objc)
    (set-objc-source (term-to-data (source-of-iobjc-term term)) objc)
    (set-objc-translation (term-to-data (translation-of-iobjc-term term)) objc)
    (set-objc-substance (term-to-data (substance-of-iobjc-term term)) objc)
    (set-objc-history (history-of-iobjc-term term) objc)
    (set-objc-properties (import-objc-properties term) objc)
    (values)))


(defmethod data-export ((objc objc) sub)
  ;;(setf -objc objc) (break "de objc")
  (call-next-method objc
		    (iobjc-term
		     (kind-of-objc objc)
		     ;; if proxize then directly export prf?
		     (if (and *proxize-inf-tree-dynamically*
			      (eql `prf (kind-of-objc objc)))
			 (progn (format t "~%MaybeProxizePRF ~a " (name-of-objc objc))
				(force-inline-export-data objc))
			 (persist-data (objc-source objc) nil nil))
		     (persist-data (objc-translation objc) nil nil)
		     (persist-data (objc-substance objc) nil nil)
		     (or (objc-history objc) (ivoid-term))
		     (export-objc-properties objc)
		     )))


;;;	cached name : older iobjc-terms may not have name cached.
;;;	objc instance must be able to detect non-cached name from null name.
;;;	name is a token.
;;;	  
;;;	  - null -> not cached.
;;;	  - !void() : cached but no name.
;;;	  - !token{<name>:t}


(defvar *default-contents*
  (progn (new-transaction-id)
	 ;; data init will allocate new stamp.
	 (make-instance 'objc)))


(defun object-contents (kind term)
  (if (null kind)
      (progn
	;;(setf a term) (break "oc")
	*default-contents*
	)
      (progn
	(unless (member kind  *library-object-content-types*)
	  (raise-error (error-message '(objc kind unknown) kind)))
	(make-instance 'objc 'kind kind
		       'stamp (transaction-stamp)
		       'source (new-source term kind)))))
	


(defun translation-of-objc-r (o)
  (let ((translation (translation-of-objc o)))
    (if translation
	translation
	(raise-error (error-message '(objc references not))))))


;; add reduction dependencies to source then compare reduced, dependencies, and
;; description property to judge if new translation required.
;; actually I like this better, force the translation but only update substance if
;; things change.
(defun objc-modify-source (objc new-source &optional weakp)
  (let ((new-objc (clone objc)))

    (set-objc-source new-source new-objc)
    ;;(setf -new-objc new-objc -new-source new-source) (break "oms")
    (set-objc-properties (objc-properties-of-source new-source) new-objc)

    (unless weakp
      (set-objc-translation nil new-objc))

    new-objc))
  
(defun objc-modify-source-term (objc term)
  (let ((new-source (clone (source-of-objc objc))))

    (set-source-term term new-source)
    (objc-modify-source objc new-source)))
	
;; only diffs can be non-substantive properties.
(defun very-similar-objcs (o p)
  (equal-stamps-p (stamp-of-data o) (stamp-of-data p)))



;;;;	substantive properties :
;;;;	
;;;;	Modification of a substantive property causes translation.
;;;;
;;;;	some substantive properties may be migrated to substance for distribution.
;;;;

(defvar *objc-properties* '(description name))
(defvar *substantive-properties*
  '(description language reduce name dynamicrefresh
    |reference_environment| |reference_environment_index|
    |reference environment additions|
    |order_in_refleqcd_cache|
    
    ;; suspect following does not need to be substantive. 9/02
    |reference_environment_relative_minimal|

    ;; suspect following is not used. 9/02
    ;; |reference environment update| 
    ))

(defvar *ostate-properties*
  '(name language implicit geometry editrefresh |TopLoop| evalet display1 display2 display3 isablob))

(defun add-substantive-property (id)
  (pushnew id *substantive-properties*))

(defun substantive-properties-of-source (source)
  (mapcan #'(lambda (prop)
	      (when (member (car prop) *substantive-properties*)
		(list prop)))
	  (properties-of-source source)))

(defun objc-properties-of-source (source)
  (mapcan #'(lambda (prop)
	      (when (member (car prop) *objc-properties*)
		(list prop)))
	  (properties-of-source source)))



(defun ostate-properties-of-objc (objc)
  (mapcan #'(lambda (prop)
	      (when (member (car prop) *ostate-properties*)
		(list prop)))
	  (with-source-of-objc (src objc)
	      (properties-of-source src))))
		  

;; no-op if props null and props of objc null.
;; todo : if no substantive props being removed or added do not need new-source and objc??
(defun objc-set-properties (o props)
  ;;(format t "~%objc-set-properties")
  (let* ((s (source-of-objc o))
	 (curprops (properties-of-source s)))
    (if (and (null props) (null curprops))
	o
	(let ((news (clone s)))
	  (set-source-properties props news)
	  (if (or (exists-p #'(lambda (p) (member (car p) *substantive-properties*))
			    props)
		  (exists-p #'(lambda (p) (member (car p) *substantive-properties*))
			    curprops))
	      (objc-modify-source o news)
	      (objc-modify-source o news t))))))

;;(progn (set-source-properties props s)
;;       (when (or (exists-p  #'(lambda (p) (member (car p) *ostate-properties*))
;;			    curprops)
;;		 (exists-p  #'(lambda (p) (member (car p) *ostate-properties*))
;;			    props))
;;	 (objc-flag-set-require-ostate o t))
;;       o)

(defun objc-add-property (o id term)
  (let ((s (source-of-objc o)))
    (let ((news (clone s)))
      (set-source-properties (acons id term (properties-of-source s)) news)
      (if (member id *substantive-properties*)
	  (objc-modify-source o news)
	  (objc-modify-source o news t)))))
      
;;(progn (set-source-properties (acons id term (properties-of-source s)) s)
;;       (when (member id *ostate-properties*) (objc-flag-set-require-ostate o t))
;;       o)

(defun objc-remove-property (o id)
  (let* ((s (source-of-objc o))
	 (props (properties-of-source s))
	 (p (assoc id props)))
    (if (null p)
	o
	(let ((news (clone s)))
	  (set-source-properties (remove id props :key #'car) news)
	  (if (and p (member id *substantive-properties*))
	      (objc-modify-source o news)
	      (objc-modify-source o news t))))))

;;(progn (when p (set-source-properties (remove id (properties-of-source s) :key #'car) s))
;;       (when (member id *ostate-properties*) (objc-flag-set-require-ostate o t))
;;       o)
	
	    
  

(defstruct (library-object (:include com-library-object))
  collectable-p
  objc)

(defun new-library-object (active-p collectable-p objc)
  ;;(break "nlo")
  (make-library-object :active-p active-p :collectable-p collectable-p :objc objc))


(defun activate-library-object (o)
  (if (library-object-active-p o)
      o
      (let ((newo (copy-library-object o)))
	(setf (library-object-active-p newo) t)
	newo)))


(defun deactivate-library-object (o)
  (if (library-object-active-p o)
      (let ((newo (copy-library-object o)))
	(setf (library-object-active-p newo) nil)
	newo)
      o))

(defun disallow-library-object-collection (o)
  (if (library-object-collectable-p o)
      (let ((newo (copy-library-object o)))
	;;(break "dloc")
	(setf (library-object-collectable-p newo) nil)
	newo)
      o))

(defun allow-library-object-collection (o)
  (if (library-object-collectable-p o)
      o
      (let ((newo (copy-library-object o)))
	(setf (library-object-collectable-p newo) t)
	newo)))


;;(defun library-object-active-p (o) (com-library-object-active-p o))

;; todo cache stamps as terms.
;;(define-primitive |!object| ((bool . active)) (objc))

;; active bool? collectable bool
;;PERF each bind does broadcast and import
;; resulting in duplicate data structures for shared data.
;; twould be nice if mod objc, unbind, bind, lookup had shared data with pre-mod objc.
;; getting lost in marshall/unmarshall for broadcasts to table.

(define-primitive !library_object ((bool . collectable) (bool . active)) (objc))

(defclass lobj (data)
  ((loterm :reader term-of-lobj
	  :writer set-lobj-term
	  :initform nil
	  :initarg loterm)
   ))

(defmethod data-import ((lobj lobj) super)
  (let ((term (call-next-method lobj super)))
    (set-lobj-term term lobj)))

(defmethod data-export ((lobj lobj) term)
  (declare (ignore term))
  ;;(break "de lobj")
  (call-next-method lobj (term-of-lobj lobj)))

(defun new-lobj (obj oc)
  (let ((d (make-instance 'lobj
			  'type 'lobj
			  'loterm
			  (ilibrary-object-term
			   (library-object-collectable-p obj)
			   (library-object-active-p obj)
			   (persist-data oc nil t)))))
    (data-flag-set-provided d t)
    d))
  

(defun library-import (term)
  (let ((data (term-to-data term)))
    ;; 'objc if bind, 'lobj if weak bind.
    (if (eql (type-of-data data) 'objc)
	(new-library-object nil t data)
	(let ((lobj (term-of-lobj (provide-data data 'lobj))))
	  (new-library-object (active-of-ilibrary-object-term lobj)
			      (collectable-of-ilibrary-object-term lobj)
			      (term-to-data (objc-of-ilibrary-object-term lobj)))))))
	


;;(defun library-import (term)
;;  (new-library-object nil t
;;		      (term-to-data term)))

;; is there any need for this?
;;(defun library-export (o)
;;  (iobject-term (library-object-active-p o)
;;		(persist-data (library-object-objc o))))



(defun objc-of-library-object (o)
  ;;(setf -o o) (break "oolo")
  (let ((objc (library-object-objc o)))
    (if (data-provided-p objc)
	objc
	(setf (library-object-objc o) (provide-data objc 'objc)))))

(defun ephemeral-objc-of-library-object (o)
  ;;(setf -o o) (break "oolo")
  (let ((objc (library-object-objc o)))
    (if (data-provided-p objc)
	objc
	(provide-data objc 'objc))))





(defun set-inf-objc-step (objc inf-step)
  (set-inf-source-step inf-step (source-of-objc objc)))

(defun step-of-inf-objc (objc)
  (step-of-inf-source (source-of-objc objc)))

(defun step-of-inf-objc-r (objc)
  (or (step-of-inf-objc objc)
      (raise-error (error-message '(inf step)))))


(defun annotations-of-inf-objc-src (objc)
  (annotations-of-inf-source (source-of-objc objc)))


;; inf-objc containing inf-step will have cumulative refs and extract.
;;


;;;;	Source:
;;;;	goal 		: modifiable
;;;;	tactic/source 	: modifiable
;;;;	annotations	: destructively? modifiable.
;;;;	  no point to destructiveness, translate will save substance.
;;;;	refinememnt	: modifiable
;;;;	  - goal(reduced)/tactic(reduced)/subgoals
;;;;	
;;;;	Substance :
;;;;	  
;;;;	tactic(reduced) : term-of-substance
;;;;	abbrev refinement :
;;;;	goal(reduced?)
;;;;	subgoals 
;;;;	extract
;;;;	dependencies
;;;;
;;;;	This appears to be overkill but we desire the substance to be as durable as
;;;;	possible to avoid re-stamping and requiring re-translation of all dependent
;;;;	objects. If we required the refinement only in the substance then the
;;;;	substance would contain the inf-tree of top refinements.  Re-refinenment
;;;;	would necessarily change the inf-tree and thus require modification of the
;;;;	substance. If not restamped at mod then equivalent to destructive mod and a
;;;;	priori that is a BAD thing.
;;;;
;;;;	all modifications loose translation
;;;;	translate may reuse substance if substances same.
;;;;
;;;;	translate :
;;;;	  - check if source refinement matches rest of source.
;;;;	      * source data may be nil in which
;;;;	  
;;;;	
;;;;	
;;;;	
;;;;	  - if not, fail (or implicitly re-refine)
;;;;	    failure so as to allow user to back out of change if failure not expected.
;;;;	    also define predicate to predict failure so user can re-refine prior to translate
;;;;	    if translate will fail otherwise.
;;;;	  - check if refinement matches substance : if not loose substance and
;;;;	    make new.
;;;;	
;;;;	Translation will move refinement to substance unless they are similar.
;;;;	
;;;;	if not direct then translation always fails if source refinement differs from other
;;;;	source data.
;;;;	
;;;;	allow for source goal/tactic/annotations to be null, ie implicit in refinement
;;;;	natural case for non-direct refinements.

;;;;	



(defstruct inf-tree
  oid
  children)

(defstruct (inf-objc-tree (:include inf-tree))
  objc
  )


(defun children-of-inf-tree (it) (inf-tree-children it))
(defun objc-of-inf-objc-tree (it) (inf-objc-tree-objc it))

(defun oid-of-inf-tree (it)
 (if (inf-objc-tree-p it)
     (raise-error (error-message '(oid-of-inf-tree ephemeral)))
     (inf-tree-oid it)))

(defun objc-of-inf-tree (it)
  (if (inf-objc-tree-p it)
      (objc-of-inf-objc-tree it)
      (let ((oid (oid-of-inf-tree it)))
	(oc oid))))

(defun goal-of-inf-tree (it)
  (goal-of-inf-step (step-of-inf-objc-r (objc-of-inf-tree it))))

(defun direct-inf-tree-p (it)
  (direct-inf-step-p (step-of-inf-objc-r (objc-of-inf-tree it))))

(defun refined-inf-tree-p (it)
  (refined-inf-step-p (step-of-inf-objc-r (objc-of-inf-tree it))))

(defun unrefined-inf-tree-p (it)
  (unrefined-inf-step-p (step-of-inf-objc-r (objc-of-inf-tree it))))
  

(defun inf-tree (oid children)
  (make-inf-tree :oid oid :children children))

(defun inf-objc-tree (objc children)
  (make-inf-objc-tree :objc objc :children children :oid nil))

(define-primitive |!inf_object_tree| ((oid . oid)) (children))

(defun inf-tree-to-term (it)
  (if (inf-objc-tree-p it)
       (raise-error (error-message '(inf-tree-to-term ephemeral)))
       (iinf-object-tree-term 
	(oid-of-inf-tree it)
	(map-list-to-ilist (children-of-inf-tree it)
			   (inil-term)
			   #'inf-tree-to-term))))


(defun term-to-inf-tree (term)
  (inf-tree (oid-of-iinf-object-tree-term term)
	    (map-isexpr-to-list (children-of-iinf-object-tree-term term)
				(icons-op)
				#'term-to-inf-tree)))


	

;;;;	modify-inf-objc-goal
;;;;	modify-inf-objc-annotations
;;;;	modify-source does tactic.
;;;;
;;;;	refinement should be part of source, translation
;;;;	will extract essential pieces of proof such as extract and dependencies.
;;;;	
;;;;	if we allow edit of goal and tactic then must detect substantive mod and
;;;;	trash refinement, which argues for refinement being part of substance.


(defun inf-objc-modify-step (objc step)
  (let ((news (clone (source-of-objc objc))))
    (set-inf-source-step step news)
    (objc-modify-source objc news)))

(defun inf-objc-modify-step-goal (objc step goal)
  (let ((news (clone (source-of-objc objc))))
    (setf (inf-step-goal step) goal)
    (set-inf-source-step step news)
    (objc-modify-source objc news)))

(defun inf-objc-modify-src-goal (objc goal)
  (let ((news (clone (source-of-objc objc))))
    (set-inf-source-goal goal news)
    (objc-modify-source objc news)))

(defun inf-objc-modify-annotations (objc annotations)
  (let ((news (clone (source-of-objc objc))))
    (set-inf-source-annotations annotations news)
    (objc-modify-source objc news)))


(defun similar-goals-p (a b)
    (apply-predicate-to-list-pair a b #'compare-terms-p))

(defmethod translation-required ((source inf-source) (substance inf-substance) term)
  
  (let ((goal (goal-of-inf-source source))
	(step (step-of-inf-source source)))

    (when (null step)
      (raise-error (error-message '(inf translate refinement not))))
	

    ;; Consider :  source term modified, but not inf-step.
    ;;  thus must check now
    ;;    - term matches reduced
    ;;    - reduced matches step
    ;;    - goal(reduced?) matches step
    
    ;;(setf -source source -substance substance -goal goal -step step -term term) (break "itr")

    (let ((rgoal (when goal (mapcar #'(lambda (g) (source-reduce g '(inf)))
				    goal))))

      (unless (and
	       (or (null term) (ivoid-term-p term)
		   (let ((reduced (reduced-of-source source)))
		     (and (compare-terms-p reduced (inf-preprocess-reduce term))
			  (compare-terms-p reduced (tactic-of-inf-step step)))))

	   
	       (or (null rgoal)
		   (similar-goals-p rgoal (goal-of-inf-step step))))
	
	(raise-error (error-message '(inf translate refinement match not))))

      ;; check for similar goals in inf steps.
      (or (not (equal-properties-p (substantive-properties-of-source source)
				   (properties-of-substance substance)))
	  (and (not (equal-stamps-p (stamp-of-refinement (refinement-of-inf-step step))
				    (stamp-of-refinement (refinement-of-inf-step
							  (step-of-inf-substance substance)))))
	       (let ((astep (inf-step-abbreviate step)))
		 (unless (similar-refinements-p (refinement-of-inf-step astep)
						(refinement-of-inf-step
						 (step-of-inf-substance substance)))
	  
		   astep)))))))


;;; abbreviate source refinement and compare to substance.
;;;  - extracts must match;
;;;  - goals and subgoals must match
;;;  - tactics do not need to match as long as result is the same.
;;;    however since tactic occures in substance should check or
;;;    destructive update tactic in substance
;;;  dependencies should be checked since if dependencies differ
;;;  want substance to have updated depenedencies. This might
;;;  be handled by destructive update of substance depenedencies.
;;;  this is more general problem to be dealt with later;
;;  TODO 
;;; -destructive update of substance means inherit old substance stamp in new substance.
(defun similar-refinements-p (ref-a ref-b)
  (with-ignore
      (or (equal-stamps-p (stamp-of-refinement ref-a) (stamp-of-refinement ref-b))

	  (and  
	   ;; compare tactics ?
	   (compare-terms-p (tactic-of-refinement ref-a) (tactic-of-refinement ref-b)) 

	   ;; compare subgoals
	   (forall-p #'similar-goals-p (subgoals-of-refinement ref-a) (subgoals-of-refinement ref-b))

	   ;; compare extracts.
	   ;; PERF TODO causes extract of top-refinement,
	   ;;           if transalation required then extract done again to produce substance refinement.
	   (equal-terms-p (extract-of-refinement ref-a) (extract-of-refinement ref-b))))))
      

;; goal must match expanded source
(defun prf-objc-modify-inf-tree (objc inf-tree)
  (let ((news (clone (source-of-objc objc))))
   
    (set-proof-source-inf-tree inf-tree news)
    (objc-modify-source objc news)))


(defun prf-objc-delete-inf-tree (objc)
  (prf-objc-modify-inf-tree objc nil))


(defun goal-of-prf-objc-r (o)
  (if (objc-translated-p o)
      (goal-of-proof-substance (substance-of-objc o))
      (raise-error '(prf goal translation not))))

(defun extract-of-prf-objc-r (o)
  (if (objc-translated-p o)
      (extract-of-proof-substance (substance-of-objc o))
      (raise-error '(prf extract translation not))))

(defun maybe-extract-of-prf-objc (o)
  (when (objc-translated-p o)
    (extract-of-proof-substance (substance-of-objc o))))
    


;;;	
;;;	TODO what about substance prop changes - need to allow retranslation so
;;;	 prop changes get included in substance.
;;;


(defmethod translation-required ((source proof-source) (substance proof-substance) term)
  
  (or (call-next-method source substance term)
      (let* ((goal (car (goal-of-proof-substance substance)))
	     (inf-tree (inf-tree-or-proxy-of-proof-source source))
	     (source-goal (car (goal-of-inf-tree-or-proxy inf-tree))))

	(not (or (eq source-goal goal)
		 (compare-terms-p source-goal goal)))

	;; TODO TODO TODO prf-translate dependencies ???
	;; Certain dependencies need to be extracted from source
	;; and saved in substance, a difference in these semantic
	;; dependencies should result in retranslation.
	;; retranslation consist of extracting dependencies and
	;; extract and new stamp.

	nil
	)))

(defun new-library (stamp tag)
  (new-com-library stamp tag
		   #'library-import
		   :activate-f #'activate-library-object
		   :deactivate-f #'deactivate-library-object
		   :allow-f #'allow-library-object-collection
		   :disallow-f #'disallow-library-object-collection
		   )
    
  ;;(setf (library-dependency-table lib-table)  (make-hash-table :test #'equal))
  )
  
(defun allocate-library (stamp tag)
  (new-library stamp tag))


(defun library-list ()
  (let ((acc nil))
    (definition-table-map (resource 'library)
		   (current-transaction-stamp)
		   #'(lambda (oid obj)
		       (declare (ignore obj))
		       (push oid acc)))
    acc))





;;;	
;;;
;;;	

;;;;	breadth : map over table and collect pointers, iterate on collect pointers.
;;;;	  - know collected not visited. conses to collect.
;;;;	  - seen either visited or collected.
;;;;	  
;;;;	depth : map over table and visit pointers. 
;;;;	  - must maintain state (visited?) for oid.


;;;;	
;;;;	maps lib table and tags all oids which are root or referenced in closure of roots.
;;;;	maps lib table and applies mod to all objects satisfying predicate. The predicate
;;;;	  takes an arg which indicates if object was in closure.
;;;;	
;;;;	rootp (oid oc)		: bool
;;;;	modp (oid oc bool{member})	: bool
;;;;	  * member is true if member of closure.
;;;;	mod (oid oc)		: unit
;;;;	
;;;;	
;;;;	

(defun maplib-aux-2 (oid obj f1 f2 f3)
  (let ((val (funcall f3 oid)))
    (when (funcall f1 oid obj val)
		(funcall f2 oid obj))))


(defun maplib (lib-table rootp modp mod)
  (let ((ok nil))
    (let ((r (catch 'abort
	       (prog1
		   (let ((table (make-hash-table :test #'equal)))

		     (labels
		      ((visit-id (oid &optional obj)
				 ;;(when (and -fu (equal-oids-p oid -myoid))
				 ;;(break "maplib"))

				 ;; can be nil, 'seen
				 (unless (null-oid-p oid)
				   (let ((b (gethash (stamp-of-oid oid) table)))
				     (unless b
				       (setf (gethash (stamp-of-oid oid) table) 'seen)
				       (if obj
					   (visit-object obj)
					 (let ((obj (maybe-library-lookup oid t)))
					   (when obj (visit-object obj))))))))

		       (seen-p (oid)
			       (gethash (stamp-of-oid oid) table))

		       (visit-parameter (p)
					(when (oid-parameter-p p)
					  (let ((v (value-of-parameter p)))
					    (when (real-parameter-value-p v (type-of-parameter p))
					      (visit-id v)))))

		       (visit-term (term)
				   (if (idata-persist-term-p term)
				       (progn
					 #-cmu (with-ignore (visit-term (term-of-idata-persist-term term)));;LAL
					 #+cmu (with-ignore (visit-term (term-of-idata-persist-term term)))
					 )
	         
				     ;; kludge alert
				     (unless (and (idependencies-term-p term)
						  (eql `access-definition-object-id (tag-of-idependencies-term term))
						  t)
				       (mapc #'visit-parameter
					     (parameters-of-term term))
				       (mapc #'(lambda (bt)
						 (visit-term (term-of-bound-term bt)))
					     (bound-terms-of-term term)))))

		       ;; term-of-data should not cause writes, as any persistent data should already be written.
		       ;; it will however needlessly marshall data to terms.
		       ;; thus a visit-term method for data may be a win in order to avoid this marshalling
		       ;; ie method takes closure to apply to terms of data without mashalling glue ops.
		       ;; twould be analogous to export. maybe export could be implemented on top of visit??
		       (visit-object (obj)
				     (let ((term (with-ignore (term-of-data (library-object-objc obj)))))
				       (when term (visit-term term) ))))

		      ;;(with-transaction (nil))  ; assume fttb done by caller.
	  
		      (definition-table-map (resource 'library)
			(current-transaction-stamp)
			#'(lambda (oid obj) 
			    (let* ((test (funcall rootp oid obj))
				   (action (and test (visit-id oid obj))))
			      action)))

		      (format t "~%;; maplib pass 1 finished~%") ;;(break "maplib")
		      
		      (definition-table-map lib-table
			(current-transaction-stamp)
			#'(lambda (oid obj) 
			    (let* ((test (funcall modp oid obj (seen-p oid)))
				   (action (and test (funcall mod oid obj))))
			      action)))	      

		      (format t "~%;; maplib pass 2 finished~%")

		      ))
		 (setf ok t)))))

      (unless ok
	(raise-error (error-message '(maplib abort) r)))
		 
      r)))



(defun new-oid-graph (g)
  (format t "~%~%new-oid-graph~%")
  (make-oid-graph :g g))

(defun hash-oid-graph-rehash (inoids og)
  (let ((oids (remove-duplicates inoids :test #'equal-oids-p)))
    (let ((sg (split-graph #'(lambda (oid) (member oid oids :test #'equal-oids-p)) (oid-graph-g og))))

      (let ((nog (new-oid-graph
		  (append (mapcan #'(lambda (oid)
				      (when (library-oid-bound-p oid)
					(list (cons oid (oid-graph-visit-term
							 (library-lookup oid))))))
				  oids)
			  (cdr sg)))))

	(setf (oid-graph-breadthaddrs nog) (oid-graph-breadthaddrs og))
	nog))))

(defun graph-of-oid-graph (og)
    (oid-graph-g og))

(defun list-of-oid-graph (og)
  (or (oid-graph-list og)
      (setf (oid-graph-list og) (mapcar #'car (graph-of-oid-graph og)))))

(defun littlebigger (i)
  (round (* 1.2 i)))

(defun oid-graph-set-hash (og)
  (let ((g (oid-graph-g og)))
    (let ((ll (littlebigger (length g))))
      (let ((rhash (make-hash-table :test #'equal :size ll))
	    (fhash (make-hash-table :test #'equal :size ll)))
	(setf (oid-graph-list og)
	      (mapcar #'(lambda (e)
			  (let ((oid (car e))
				(oids (cdr e)))

			    (dolist (o oids)
				    (hashoid-set rhash o (cons oid (hashoid-get rhash o))))

			    (hashoid-set fhash oid oids)
			    oid))
		      g)
	      (oid-graph-rhash og) rhash
	      (oid-graph-fhash og) fhash
	      )))))

(defun rhash-of-oid-graph (og)
  (or (oid-graph-rhash og)
      (progn (oid-graph-set-hash og)
	     (oid-graph-rhash og))))

(defun fhash-of-oid-graph (og)
  (or (oid-graph-fhash og)
      (progn (oid-graph-set-hash og)
	     (oid-graph-fhash og))))

(defun reverse-of-oid-graph (og)
  (let ((rhash (rhash-of-oid-graph og)))
    (or (oid-graph-reverse og)
	(setf (oid-graph-reverse og)
	      (mapcar #'(lambda (o)
			  (cons o (hashoid-get rhash o)))
		      (list-of-oid-graph og))))))

(defun dirhash-of-oid-graph (og)
  (or (oid-graph-dirhash og)
      (setf (oid-graph-dirhash og)
	    (directory-reachable-oids))))

(defunml (|update_breadth_addresses| (l))
    (((object_id |#| (int list)) list) -> unit)
  (hash-oid-graph-aux)
  (let ((og (current-oid-graph)))
    (let ((h (make-hash-table :test #'equal :size (littlebigger (length l)))))
      (dolist (e l)
	(hashoid-set h (car e) e))
      (setf (oid-graph-breadthaddrs og) h) )))


(defun breadth-addresses-of-oid-graph (og)
  (or (oid-graph-breadthaddrs og)
      (raise-error (error-message '(breadth addresses oid graph not)))))

(defunml (|breadth_address| (oid))
    (object_id -> (int list))
  (let ((ba (breadth-addresses-of-oid-graph (current-oid-graph))))
    (cdr (hashoid-get ba oid))))


(defun breadth-addr-less (a b)
	 ;; longer address is less if matching prefix is equal.
	 ;; eg dir points to contents, thus contents precede dir.
	 ;; ie preeorder?
	 (cond
	   ((and (null a) (null b)) nil) ;; equal so not less
	   ((and (null a) b) nil)	;; a contains b
	   ((and a (null b)) t)		;; b contains a
	   ((< (car a) (car b)) t)
	   ((> (car a) (car b)) nil)
	   (t ; must be equal
	    (breadth-addr-less (cdr a) (cdr b)))))

(defunml (|find_breadth_inconsistencies| (unit) :declare ((declare (ignore unit))))
    (unit -> ((object_id |#| object_id) list))


  (labels
      ((breadth-addr-less (a b)
	 ;; longer address is less if matching prefix is equal.
	 ;; eg dir points to contents, thus contents precede dir.
	 ;; ie preeorder?
	 (cond
	   ((and (null a) (null b)) nil) ;; equal so not less
	   ((and (null a) b) nil)	;; a contains b
	   ((and a (null b)) t)		;; b contains a
	   ((< (car a) (car b)) t)
	   ((> (car a) (car b)) nil)
	   (t ; must be equal
	    (breadth-addr-less (cdr a) (cdr b))))))

  ;; get ba first so as to fail quickly if not available.
  (let ((ba (breadth-addresses-of-oid-graph (current-oid-graph))))

    (hash-oid-graph-aux)

    ;; hash may change graph so must call current-oid-graph a second time
    (let ((og (current-oid-graph))
	  (acc nil))
      (let ((fhash (fhash-of-oid-graph og)))

	(maphash #'(lambda (k oidaddr) (declare (ignore k))
		     (let ((oid (car oidaddr)))
		       (dolist (ooid (hashoid-get fhash oid))
			 (let ((oaddr (cdr (hashoid-get ba ooid))))
			   (when (and oaddr
				      (not (equal-oids-p oid ooid))
				      (not (breadth-addr-less oaddr (cdr oidaddr))))
			     (push (cons oid ooid) acc))))))
		 ba))
      acc))))



(defun oid-graph-visit-term-aux (term &optional avoidp)
  (labels
      ((visit-parameter (l p)
	 (or (when (oid-parameter-p p)
	       (let ((v (value-of-parameter p)))
		 (when (real-parameter-value-p v (type-of-parameter p))
		   (unless (member v l :test #'equal-oids-p)
		     (cons v l)))))
	     l))
       (aux (l term)
	 (if (and avoidp (funcall avoidp term))
	     l
	     (or (if (idata-persist-term-p term)
		     (with-ignore (aux l (term-of-idata-persist-term term)))
		     ;; kludge alert
		     (unless (and (idependencies-term-p term)
				  (eql `access-definition-object-id (tag-of-idependencies-term term))
				  t)

		       (reduce #'aux
			       (bound-terms-of-term term)
			       :key #'(lambda (bt) (term-of-bound-term bt))
			       :initial-value (reduce #'visit-parameter
						      (parameters-of-term term)
						      :initial-value l))))
		 l))))
       (aux nil term)))

(defun oid-graph-visit-term (obj)
  (let ((term (with-ignore (term-of-data (library-object-objc obj) t))))
    (when term (oid-graph-visit-term-aux term))))


#|(defun oid-graph-visit-term (obj)
  (labels
   ((visit-parameter (l p)
			 (or (when (oid-parameter-p p)
			       (let ((v (value-of-parameter p)))
				 (when (real-parameter-value-p v (type-of-parameter p))
				   (unless (member v l :test #'equal-oids-p)
				     (cons v l)))))
			     l))
    (visit-term (l term)
	(or (if (idata-persist-term-p term)
		(with-ignore (visit-term l (term-of-idata-persist-term term)))
	      ;; kludge alert
	      (unless (and (idependencies-term-p term)
			   (eql `access-definition-object-id (tag-of-idependencies-term term))
			   t)

		(reduce #'visit-term
			(bound-terms-of-term term)
			:key #'(lambda (bt) (term-of-bound-term bt))
			:initial-value (reduce #'visit-parameter
					       (parameters-of-term term)
					       :initial-value l))))
	    l)))

   (let ((term (with-ignore (term-of-data (library-object-objc obj)))))
     (when term (visit-term nil term)))))|#



(defun oid-graph ()
  (let ((ok nil))
    (let ((r (catch 'abort
	       (prog1
		   (let ((acc nil)
			 (i 0))
		       ;; term-of-data should not cause writes, as any persistent data should already be written.
		       ;; it will however needlessly marshall data to terms.
		       ;; thus a visit-term method for data may be a win in order to avoid this marshalling
		       ;; ie method takes closure to apply to terms of data without mashalling glue ops.
		       ;; twould be analogous to export. maybe export could be implemented on top of visit??

		      (definition-table-map (resource 'library)
			(current-transaction-stamp)
			#'(lambda  (oid obj)
			    (incf i)
			    (when (zerop (mod i 100))
			      (format t "~%~%OidGraph ~a~%" i))

			    (unless (null-oid-p oid)
			      (setf acc (cons (cons oid (oid-graph-visit-term obj))
					      acc)))))

		      (new-oid-graph acc))
		 (setf ok t)))))

      (unless ok
	(raise-error (error-message '(maplib abort) r)))
		 
      r)))

(defun hash-oid-graph-aux (&optional forcep)
  (let ((bufp  *io-db-buffer*))
    (stop-db-buffering)
    (let ((env (current-environment)))
      (let ((og (oid-graph-of-lib-environment env)))
	(if (or forcep (null og))
	    (lib-environment-set-oid-graph env (oid-graph))
	    (let ((touched (oid-graph-touched og)))
	      (if (null touched)
		  og
		  (prog1 (lib-environment-set-oid-graph env (hash-oid-graph-rehash touched og))
		    (setf (oid-graph-touched og) nil))))))
      (when bufp (start-db-buffering)))))


(defunml (|hash_oid_graph| (unit) :declare ((declare (ignore unit))))
  (unit -> unit)

  (hash-oid-graph-aux)
  nil)

(defunml (|hash_oid_graph_edge| (oid))
  (object_id -> (object_id list))

  (hash-oid-graph-aux)
  ;;(setf -oid oid -fhash (fhash-of-oid-graph (current-oid-graph)))
  (hashoid-get (fhash-of-oid-graph (current-oid-graph)) oid))

(defmacro current-oid-graph () `(oid-graph-of-lib-environment (current-environment)))

(defun unreachable-and (p)
  (hash-oid-graph-aux)
  (let ((og (current-oid-graph)))
    (let ((dhash (dirhash-of-oid-graph og))
	  (l (list-of-oid-graph og)))
      (mapcan #'(lambda (o)
		  (unless (hashoid-get dhash o)
		    (when (funcall p o)
		      (list o))))
	      l))))


;;;;	
;;;;	Thought is that objects not reachable from dirs
;;;;	are probably not wanted.
;;;;	
;;;;	

;; not in a dir, ie don't use on infs and prfs.
;; but lemmas, code, term, disp, abs and com which are not in a dir
;; are suspect.
(defunml (|unreachable_and| (p))
  ((object_id -> bool) -> (object_id list))

  (unreachable-and #'(lambda (oid) (funmlcall p oid)))) 

;; want to be able to find who refs an obid thus keeping it from being collected.
;; finding layered closure might be useful as that will find top.
;;  find closure
;;  reduce graph
;;  layer smaller graph.

;; (lib-find-oids-by-name '|markb|)


(defun deactivate-oid (oid)
  (ap (ml-text "\\oid. (deactivate oid ? ()); (allow_collection oid ? ())") oid))


(defun unbind-oid (oid)
 (ap (ml-text "\\oid. if lib_bound_p oid then (((lib_unbind oid)()); ())") oid))

(defun collectable-oid-p (oid)
  (library-object-collectable-p (library-lookup oid)))


;; if a given subgraph can be removed without leaving hanging refs then
;; they can be deactivated and unbound.

;; returns two subgraphs
;; first contains objects not in oids.
;; second contains objects in oids.
;; objects not in og are not returned.
;; verifies that no objects in first point to objects in second.
;;  allows objects in second to point to first.
(defun hashed-oid-divide-graph (oids og)

  (let ((l (length oids))
	(new nil)
	(del nil))
    (if (< l 100)
	(dolist (e (graph-of-oid-graph og))
	  (if (member (car e) oids :test #'equal-oids-p)
	      (push e del)
	      ;; check no refs.
	      (if (null (intersection oids (cdr e) :test #'equal-oids-p))
		  (push e new)
		  (return-from hashed-oid-divide-graph (car e)))))

	(let ((dhash (make-hash-table :test #'equal :size (* 2 l))) 
	      (g (graph-of-oid-graph og)))

	  (dolist (oid oids)
	    (hashoid-set dhash oid t))

	  (format t "~%Checking separability ~a ~a " l (length g))

	  (let ((i 0))
	    (dolist (e g)
	      (incf i)
	      (when (zerop (mod i 1000))
		(format t "~%Checking ... ~a " i))
	      
	      (let ((oid (car e)))
		(if (hashoid-get dhash oid)
		    (push e del)
		    ;; check no refs.
		    (progn
		      ;; 10/2002. there occurred a situation where apparently a prf
		      ;; object was deleted which was still accessible from the
		      ;; theories dir. Thus we make a special test
		      ;; to check that no accessible proofs are members of the delete list.
		      (with-ignore
			  (let* ((obj (library-lookup oid t)))
			    (with-objc-of-library-object (objc obj)
			      (when (eql (kind-of-objc objc) 'STM)
				(with-source-of-objc (src objc)
				  (when (exists-p #'(lambda (r) (hashoid-get dhash r))
						  (proofs-of-statement-source src))
				    (setf -e e -oid oid -objc objc -src -src) (break "hodg")
				    (return-from hashed-oid-divide-graph oid)))))))
		      (if (exists-p #'(lambda (r) (hashoid-get dhash r))
				    (cdr e))
			  (return-from hashed-oid-divide-graph oid)
			  (push e new)))))))))
	
    (cons new del)))

(defunml (|commit| (unit) :declare ((declare (ignore unit))))
    (unit -> unit)
  (commit-completions (completion-peek-first)))

(defun delete-hashed-oid-subgraph (oids og)

  (let ((d (hashed-oid-divide-graph oids og)))
    ;;(setf -d d -og og) (break "dhos1")
    (when (not (consp d))
      (raise-error (oid-error-message (list d) `(delete-hashed-oid-subgraph ref))))

    (let ((buffp *io-db-buffer*))
      (when buffp (stop-db-buffering))

      (let ((i 0)
	    (tot 0))

	(dolist (e (cdr d))
	  (let ((oid (car e)))
	    (deactivate-oid oid)
	    (unbind-oid oid)
	    (incf i)
	    (when (= i 512)
	      (incf tot 512)
	      (commit-completions (completion-peek-first))
	      (format t "~%deleted ~a " tot)
	      (setf i 0))
	    )))	

      (when buffp (start-db-buffering)))

    ;;(setf -d d -og og) (break "dhos2")
    (new-oid-graph (car d)))
  )


(defun hash-oid-graph-orphans (og)

   ;; find collectable.
   (let ((roots (filter #'dag-root-p (list-of-oid-graph og))))
     (let ((cl (graph-closure nil (fhash-of-oid-graph og) roots)))
      ;; (setf -roots roots -cl cl) (break "hogo")

       (let ((d (fast-diff-oids (list-of-oid-graph og) cl)))
	 ;;(setf -d d) (break "hogod")
	 d))))

(defun oids-of-inf-tree (it)
  (let ((acc nil))
    (labels ((aux (it)
	       (push (oid-of-inf-tree it) acc)
	       (dolist (it (children-of-inf-tree it))
		 (aux it))))
      (aux it)
      acc)))



(defun hash-oid-graph-prf-proxies ()

  (hash-oid-graph-aux)
  (let ((og (current-oid-graph)))
    (let ((acc nil)
	  (rhash (rhash-of-oid-graph og)))
      (dolist (oid (list-of-oid-graph og))
	(let ((obj (library-lookup oid t)))
	  (with-objc-of-library-object (objc obj)
	    (when (eql 'prf (kind-of-objc objc))
	      (let ((it (inf-tree-of-proof-source (source-of-objc objc))))
		(when (inf-tree-p it)
		  (let ((ioids (oids-of-inf-tree it))
			(ooids (oid-graph-visit-term-aux (term-of-data objc)
							 #'iinf-tree-term-p)))
		    ;;(setf -ioids ioids -ooids ooids -objc objc) (break "ooo")
		    (when (and (or t ;; difficult to prevent prf from depending on inf oids.
				   (null (intersection ioids ooids :test #'equal-oids-p)))
			       ;; inf oids of inf-tree (check if refs to each other than prf).
			       (forall-p-optimized (ioid ioids)
						   (let* ((r (hashoid-get rhash ioid))
							  (rr (remove-duplicates r :test #'equal-oids-p)))
						     (when (< (length rr) (length r)) (format t "L"))
						     (if (null r)
							 (progn
							   ;; no refs to an oid would mean prf if any containing oid does not
							   ;; reference oid ?? Happens as a result of inflating a proxy to a tree.
							   ;; the og looks at disk rep of object which is still a proxy since
							   ;; objc not written since inflated.
							   ;; In this case best not to compresss since disk version still compressed.
							   ;;(setf -oid oid -ioid ioid -it it -objc objc -og og -objc objc)
							   ;;(break "oog")
							   nil)
							 (and (null (cdr rr))
							      (equal-oids-p (car rr) oid))))))
		      (push oid acc)))))))))
      acc)))


(defunml (|lib_prf_proxies_whynot| (poid))
  (object_id -> (object_id list))


  (hash-oid-graph-aux)
  (let ((og (current-oid-graph)))
    (let ((rhash (rhash-of-oid-graph og)))

      (let ((obj (library-lookup poid t)))
	(with-objc-of-library-object (objc obj)
	  (when (eql 'prf (kind-of-objc objc))
	      (let ((it (inf-tree-of-proof-source (source-of-objc objc))))
		(when (inf-tree-p it)
		  (let ((ioids (oids-of-inf-tree it)))
		    ;;(setf -rhash rhash -oids ioids) (break "whynot")
 		    (mapcan #'(lambda (ioid)
				(copy-list (hashoid-get rhash ioid)))
			    ioids))))))))))

;; (c-z) results in deps on infs. fixed.
;; rhash may have multiple refs of a prf to an inf???
(defunml (|lib_prf_proxies| (unit) :declare ((declare (ignore unit))))
  (unit -> (object_id list))

  (hash-oid-graph-prf-proxies))

;; one would think lib_delete_list (lib_orphans ())
;; is the thing to do.
;; letref orphans = nil : object_id list;;
;; (orphans := lib_orphans(); length orphans);;
;; lib_delete_list orphans;;
(defunml (|lib_orphans| (unit) :declare ((declare (ignore unit))))
  (unit -> (object_id list))

  (hash-oid-graph-aux)
  (hash-oid-graph-orphans (current-oid-graph)))

(defunml (|lib_delete_list| (oids))
  ((object_id list) -> unit)

  (hash-oid-graph-aux)
  (let ((env (current-environment)))
    (lib-environment-set-oid-graph
     env 
     (delete-hashed-oid-subgraph oids (oid-graph-of-lib-environment env))))
  nil)


(defun hash-oid-graph-root-path (oid &optional stopoids)
  (let ((og (current-oid-graph)))
    (when (null og)
      (raise-error (error-message '(oid root path))))
    (oid-graph-path nil (rhash-of-oid-graph og) oid #'dag-root-p stopoids)))

;; ignores paths containing stopoids.
(defunml (|oid_root_path| (stopoids oid))
  ((object_id list) -> (object_id -> (object_id list)))
  
  (hash-oid-graph-aux)
  (hash-oid-graph-root-path oid stopoids))

(defun unbind-collect-aux (lib-table)
  (let ((count 0)
	(unbind-count 0))

    (maplib lib-table
	    #'(lambda (oid obj)
		(or (library-object-active-p obj)
		    (not (library-object-collectable-p obj)) ))

	    #'(lambda (oid obj memp)
		(incf count)
		(and (not (or (library-object-active-p obj)
			      (not (library-object-collectable-p obj))))
		     (not memp)))

	    #'(lambda (oid obj)
		(declare (ignore obj))

		(incf unbind-count)
		(unbind-oid oid)

		(when (zerop (mod unbind-count 512))
		  (when (completions-p)
		    (commit-completions (completion-peek-first))) )))

    (values unbind-count count)))


(defun unbind-collect ()

  (mlet* (((unbind-count count)
	   (unbind-collect-aux (resource 'library))))

    (terpri)
    (format t "*** ~%")
    (format t "***    Unbind collect : ~%")
    (format t "*** ~%")
    (format t "***    Unbound ~8:D object ids.~%" unbind-count)
    (format t "***    Visited ~8:D object ids.~%" count)
    (format t "*** ~%")
    (terpri)))

(defun count-closure (lib-table coid)

  (let ((count 0)
	(closure-count 0))

    (maplib lib-table
	    #'(lambda (oid obj)
		(declare (ignore obj))
		(equal-oids-p coid oid))

	    #'(lambda (oid obj memp)
		(declare (ignore oid obj))
		(incf count)
		memp)

	    #'(lambda (oid obj)
		(declare (ignore oid obj))
		(incf closure-count)
		))

    (cons count closure-count)))




(defunml (|count_closure| (coid))
  (object_id -> (int |#| int))
  (count-closure (resource 'library) coid))

;; returns nil without calling body if no objc available.
(defmacro with-objc-of-oid ((objc oid) &body body)
  (let ((obj (gensym)))
    `(let* ((,obj (maybe-library-lookup ,oid t)))
      (when ,obj
	(with-objc-of-library-object (,objc ,obj)
	  ,@body)))))
      

(defun new-termsig-table ()
  (make-hash-table :test #'equal))

(defun hash-termsig-set (thash sig x)
  (setf (gethash sig thash) x))


;;(cons (cons term x)
;;(delete-if #'(lambda (a)
;;(compare-terms-p (car a) term))
;;bucket))

(defun hash-termsig-get (thash sig)
  (gethash sig thash))

(defunml (|abs_disp_graph| (abss disps))
    ((object_id list) -> ((object_id list) -> ((object_id |#| (object_id list)) list)))

  (format t ";;; abs_disp_graph ~a ~a ~%" (length abss) (length disps))

  (without-dependencies

   (let ((ohash (new-oid-table))
	 (thash (new-termsig-table)))

     ;; populate thash with oids of objects for model term-sigs.
     (dolist (doid disps)
       (with-objc-of-oid (objc doid)
	 (with-substance-of-objc (sub objc)
	   (when sub
	     (let ((model-sig (term-sig-of-term (model-of-display-substance sub))))
	       (format t ".")
	       (hash-termsig-set thash model-sig (cons doid (hash-termsig-get thash model-sig))))))))

     (format t "disp hash table size ~a~%" (hash-table-count thash))
     
     (dolist (aoid abss)
       (with-objc-of-oid (objc aoid)
	 (with-substance-of-objc (sub objc)
	   (when sub
	     (let ((iabs (term-of-substance sub)))
	       (when (iabstraction-term-p iabs)
		 (format t ",")
		 (hashoid-set ohash aoid
			      (cons aoid (hash-termsig-get thash (term-sig-of-term (lhs-of-iabstraction-term iabs)))))))))))

     (format t "abs hash table size ~a~%" (hash-table-count ohash))

     
     (let ((acc nil))
       (maphash #'(lambda (k v)
		    (declare (ignore k))
		    (when (cdr v)
		      (push v acc)))
		ohash)
       (when *process-break* (setf -acc acc) (break "x"))
       acc
       ))))


;; (count-orphans (resource 'library));;
;; (unbind-dummy-collect (resource 'library));;

(defun unbind-dummy-collect (lib-table)

  (let ((count 0)
	(unbind-count 0))

    (maplib lib-table
	    #'(lambda (oid obj)
		(declare (ignore oid))

		(or (library-object-active-p obj)
		    (not (library-object-collectable-p obj))))

	    #'(lambda (oid obj memp)
		(declare (ignore oid))
		
		(incf count)
		(and (not (or (library-object-active-p obj)
			      (not (library-object-collectable-p obj))))
		     (not memp)))

	    #'(lambda (oid obj)
		(declare (ignore oid obj))

		(incf unbind-count)
		))))




(defun count-orphans (lib-table)
  (let ((count 0)
	(orphan-count 0))

    (maplib lib-table
	    #'(lambda (oid obj)
		(declare (ignore obj))
		
		(dag-root-p oid))

	    #'(lambda (oid obj memp)
		(declare (ignore oid obj))
		
		(incf count)
		(not memp))

	    #'(lambda (oid obj)
		(declare (ignore oid obj))

		(incf orphan-count)
		))

    (terpri)
    (format t "*** ~%")
    (format t "***    Orphan Count : ~%")
    (format t "*** ~%")
    (format t "***    Orphans ~8:D object ids.~%" orphan-count)
    (format t "***    Total ~8:D object ids.~%" count)
    (format t "*** ~%")
    (terpri))  
  )


(defun deactivate-orphans-aux (lib-table)
  (let ((count 0)
	(orphan-count 0))

    (maplib lib-table
	    #'(lambda (oid obj)
		(declare (ignore obj))
		
		(dag-root-p oid))

	    #'(lambda (oid obj memp)
		(declare (ignore oid obj))
		
		(incf count)
		(not memp))

	    #'(lambda (oid obj)
		(declare (ignore obj))

		(deactivate-oid oid)
		
		(when (zerop (mod orphan-count 512))
		  (when (completions-p)
		    (commit-completions (completion-peek-first))))

		(incf orphan-count)
		))

    (values orphan-count count)
    ))


(defun deactivate-orphans ()
  (mlet* (((orphan-count count) (deactivate-orphans-aux (resource 'library))))

    (terpri)
    (format t "*** ~%")
    (format t "***    Orphan Count : ~%")
    (format t "*** ~%")
    (format t "***    Orphans ~8:D object ids.~%" orphan-count)
    (format t "***    Total ~8:D object ids.~%" count)
    (format t "*** ~%")
    (terpri)
    )  
  )

(defunml (|collect_orphans| (flush-garbage-p))
    (bool -> unit)

  (when flush-garbage-p
    (ap (ml-text "\\u. (dag_remove_directory (descendent_s ``local garbage``) `queue` ? ())") nil))

  (deactivate-orphans))

(defunml (|unbind_collect| (unit) :declare ((declare (ignore unit))))
    (unit -> unit)

    (unbind-collect))


(defun get-term (oid) (term-of-source (source-of-objc (objc-of-library-object (library-lookup oid)))))


;;;;
;;;; following is attempt to recover lib after loss of log 
;;;; by reversing history pointers. More in io-db. 


;; inf-source 
;; statement-source code-source source objc
;; (recover-data-list "/local/eaton/..../5480d260_6433_c214b957/data/" "markb" 17)
(defun recover-data-list-aux (kinds path)

  (labels ((recover-inf-source (d)
	     (let* ((step (step-of-inf-source d))
		    (tac (term-of-source d))
		    (goal (goal-of-inf-step step))
		    (refinement (refinement-of-inf-step step))
		    (subgoals (when refinement (subgoals-of-refinement refinement))))

	       (when (and refinement (top-refinement-p refinement))
		 (instantiate-term
		  (instantiate-operator 'inf-data)
		  (list (instantiate-bound-term (ivoid-term)) ; no props.
			(instantiate-bound-term
			 (instantiate-term
			  (instantiate-operator 'inf-step)
			  (list
			   (instantiate-bound-term (car goal))
			   (instantiate-bound-term tac)
			   (instantiate-bound-term 
			    (map-list-to-ilist subgoals
					       (isubgoal-nil-term)
					       #'car))))))))))

	   (recover-source (d)
	     (let ((term (term-of-source d))
		   (props (properties-of-source d)))

	       (when *process-break*
		 (setf -d d -s term)
		 (break "rdl"))
	       (instantiate-term
		(instantiate-operator 'source)
		(list (instantiate-bound-term
		       (properties-to-term
			(mapcan #'(lambda (prop)
				    (let ((p (assoc prop props)))
				      (when p (list p))))
				'(name description
				  |reference_environment_minimal|
				  |reference_environment_theories_minimal|
				  |reference_environment_relative_minimal|
				  ))))
		      (instantiate-bound-term (or term (ivoid-term)))))))
	   
	   (recover-data (kind pathname)
	     (let ((dl (directory pathname)))
	       ;;(setf -dl dl) (break)
	       (let ((acc nil))
      
		 (dolist (fname dl)
		   (let ((k (pathname-type fname)))
		     (when (string= kind k)
		       (push fname acc))))
		 acc))))

    (let ((aacc nil))
      
      (dolist (kind kinds)
	(let ((data (recover-data (string kind) path))
	      (acc nil))

	  (when data (format t "+"))
	  ;;(format t "~%Found ~a ~a " (length data) kind)
      
	  (dolist (fname data)

	    (let* ((pid (intern-system
			 (car (last (pathname-directory fname) 2))))
		   (seq (read-from-string (pathname-name fname)))
		   (stamp (cons (cons 0 pid) (cons seq (get-universal-time)))))

	      (let ((d (make-instance kind
				      'stamp stamp
				      'type kind)))
		(data-import d (db-read stamp kind))
		(let ((sourcet (if (eql 'inf-source kind)
				   (recover-inf-source d)
				   (recover-source d))))
		  (when sourcet
		    (push (cons seq
				(instantiate-term
				 (instantiate-operator 'recovered_data)
				 (list (instantiate-bound-term (stamp-to-term stamp))
				       (instantiate-bound-term sourcet))))
			  acc))))))

	  ;;(format t "~%Found ~a non-null ~a " (length acc) kind)
	  (push (cons kind acc) aacc)))

      aacc)))

(defun recover-data-list (path n v)
  (dolist (kl (recover-data-list-aux '(source statement-source code-source inf-source)
				     path))
    (let ((kind (car kl))
	  (acc (cdr kl)))
	     
      (format t "~%Found ~a non-null ~a " (length acc) kind)
      (let ((fname (format-string "~~/fdlpatch/recovered-~a-data-~a-~a.trm" kind n v)))
	(format t "~%Will write to ~a " fname)
	(let ((l (sort acc #'> :key #'car)))
	  (setf -l l)
	  (when (eql kind `inf-source)
	    (break "oktowrite?"))
	  (write-terms-to-file fname (mapcar #'cdr l)))))))

(defun search-db-files (kind p &optional path)
  (let ((kl (car (recover-data-list-aux (list kind)
					(or path (pid-to-path-aux (process-id) (list "data")))))))
    (let ((kind (car kl))
	  (acc (cdr kl)))

      (setf -acc acc)
      ;;(format t "~%Found ~a non-null ~a " (length acc) kind)
      (let ((ll (mapcan #'(lambda (x)
			    (setf -x x)
			    ;;(break "sdf")
			    (when (funcall p (cdr x))
			      (list x))
			    )
			acc)))

	;;(format t "~%Found ~a satisfying predicate " (length ll))
      
	(let ((l (sort ll #'> :key #'car)))
	  l)))))

(defun term-search-string-f (s)
  (let ((m (string-pattern-search #'identity s t)))
    #'(lambda (term)
	(term-walk-p term
		     #'(lambda (term)
			 (exists-p #'(lambda (p)
				       (and (string-parameter-p p)
					    (real-parameter-p p)
					    (funcall m (value-of-parameter-r p))))
				   (parameters-of-term term)))))))

;; (db-extend-pathname (list "5480d260_fe8_c21f45da" "data")))
(defun find-old-code (s &optional path)
  (if (not (eql t path))
      (search-db-files 'code-source  (term-search-string-f s)  path)

      ;; search all db-files.
      (let ((f (term-search-string-f s))
	    (acc nil))
	(let ((l (reverse (directory-listing *master-pathname*))))
	  (format t "~%~%There are ~a elements in directory ~a~%" (length l) *master-pathname*)
	  (dotimeslist (i d l)
	   (if (zerop (mod i 40))
	       (format t ". ~a~%" i)
	       (format t "."))
	    (when (probe-file (format-string "~a/data/" (namestring d)))
	      (format t ".")
	      (let ((r (search-db-files 'code-source f (format-string "~a/data/" (namestring d)))))
		(when r
		  (setf acc (cons (cons d r) acc))
		  (format t "~% Found ~a at ~a " (length r) d))))))
	(setf -acc acc)
	(length acc))))

;; shows only latest from each dir.
(defun sort-old-code (l)
  (let ((v (ml-text "view_show"))
	(ll (mapcan #'(lambda (dl)
			(setf -dl dl)
			(let ((d (car dl)))
			  (mapcar #'(lambda (e)
				      (icons-term (itext-term (namestring d))
				      (icons-term (iint-term (car e))
						  (cdr e))))
				  (cdr dl) )))
		    l)))
    
    (if (< (length ll) 20)
	(dolist (tt ll)
	  (funmlcall v tt))
	(dolist (tt ll)
	  (funmlcall v tt)))))
    


  
  


;;;;	locks : need to lock oids to prevent simultaneous transactions from mapping, binding, unbinding,
;;;;	or activate/deactivating same oid.
;;;;	
;;;;	transaction must maintain list of oids locked per directive so as to unlock at completion
;;;;	
;;;;	mapping multiple oids to same oid ok, but mapping same oid to multiple not.	
;;;;
;;;;	transaction locks can be maintained in completions.

;; rle todo: need *locks* to be part of library table as oids can be shared by env within process.

(defvar *locks* nil)

(defun lock (oid)
  ;;(break "lock")
  (let ((l (assoc oid *locks* :test #'equal-oids-p)))
    (if l
	(unless (in-transaction-p (cdr l) (current-transaction-stamp))
	  (raise-error (oid-error-message (list oid) '(oid locked))))
	(setf *locks* (acons oid (current-transaction-stamp) *locks*)))))

(defun unlock (oid)
  (setf *locks* (remove oid *locks* :test #'equal-oids-p :key #'car)))


(defvar *lib-description* (description-to-term (new-description '(library))))

(defunml (|objectiddag_fixup_oids| (unit) :declare ((declare (ignore unit))))
    (unit -> (object_id list))

  (let ((table (resource 'library))
	(stamp (current-transaction-stamp)))
    (let ((oiddags nil))
      (oid-table-map (oid-table-of-definition-table table)
		     stamp
		     #'(lambda (oid data)
			 (let ((desc  (description-property-of-objc (objc-of-library-object data))))
			   (when (and desc (member '|ObjectIdDAG| (purposes-of-description desc))
				      (eql '|!dyneval| (id-of-term (term-of-source (source-of-objc (objc-of-library-object data))))))
			     (push oid oiddags)))
			 nil))
      oiddags )))

(defun translated-code-oids ()
  (let ((acc nil))
    (oid-table-map (oid-table-of-definition-table (resource 'library))
		   (current-transaction-stamp)
		   #'(lambda (oid data)
		       (let ((objc (objc-of-library-object data)))
			 (when (and (eql 'code (kind-of-objc objc))
				    (not (null (translation-of-objc objc))))
			   (push (cons oid objc) acc)))
		       nil))
    acc))

(defunml (|import_proof| (oid itree))
    (object_contents -> (term -> object_contents))

  (new-source (ivoid-term) 'prf
	      (new-inf-tree-proxy itree))
  )


;; inf_tree_of_prf_objc needs to recognize itp and unroll?
;;  some callers could ask for inf-objc-tree?
;; see comments at ;;;; to-proxy
;; how to be sure itp persistent?? presumbably check when object written.
;; objc -> objc
(defun inf-tree-to-proxy (pobjc)
  
  (require-objc-kind pobjc 'prf)
    
  ;; convert inf-tree to proxy term
  (let ((itp (new-complete-inf-tree-proxy
	      (inf-tree-of-proof-source (source-of-objc pobjc)))))

    (prf-objc-modify-inf-tree pobjc itp)) )

(defunml (|prf_objc_src_proxy_inf_tree| (objc))
    (object_contents -> object_contents)

  (inf-tree-to-proxy objc)
  )

(defun provide-inf-tree-proxy (itree)
  (if (eql 'complete-inf-tree-proxy (type-of-data itree))
      (provide-data itree 'complete-inf-tree-proxy)
      (provide-data itree 'inf-tree-proxy)
      ))

(defun inf-tree-of-proof-source-r (psrc &optional ephp)
  (let ((itree (inf-tree-of-proof-source psrc)))
    (if (inf-tree-p itree) itree
	(let ((nit (iinf-tree-term-to-inf-tree
		    (tree-of-inf-tree-proxy (provide-inf-tree-proxy itree))
		    nil
		    nil
		    ephp)))
	  (when (not ephp)
	    (set-proof-source-inf-tree nit psrc))
	  nit))))

(defun restore-proof-source-from-db (pobjc)
  (require-objc-kind pobjc 'prf)
  (let ((data (objc-source pobjc)))
    (let ((d (make-instance (type-of-data data)
			    'stamp (stamp-of-data data)
			    'type (type-of-data data))))
      (data-import d (db-read  (stamp-of-data d) (type-of-data d)))
      (set-objc-source d pobjc))))

(defunml (|restore_prf_src_db| (pobjc))
    (object_contents -> unit)

  (restore-proof-source-from-db pobjc)
  nil)


(defun inf-tree-or-proxy-of-proof-source (psrc)
  (let ((itree (inf-tree-of-proof-source psrc)))
    (if (inf-tree-p itree)
	itree
	(provide-inf-tree-proxy itree))))


(defun inf-tree-term-of-proof-source (psrc)
  (let ((itree (inf-tree-of-proof-source psrc)))
    (if (inf-tree-p itree)
	(inf-tree-to-iinf-tree-term itree nil t)
	(tree-of-inf-tree-proxy (provide-inf-tree-proxy  itree)))))

;; for fixing-up migrated objects.
(defun lib-find-oid-by-name (name)
  (definition-table-map (resource 'library)
      (current-transaction-stamp)
    #'(lambda (oid obj)
	;;(setf -oid oid -obj obj) (break "lfobn")
	(and (library-object-active-p obj)
	     (let ((objc (objc-of-library-object obj)))
	       (when (eql name (name-of-objc objc))
		 (return-from lib-find-oid-by-name oid)))))))


;; string-pattern-search
(defun lib-find-oids-by-match (pattern &optional case-p)
  (let ((patf (string-pattern-search #'(lambda (x) x)
				     pattern
				     case-p)))
    (let ((acc nil))
      (definition-table-map (resource 'library)
	  (current-transaction-stamp)
	#'(lambda (oid obj)
	    ;;(setf -oid oid -obj obj) (break "lfobn")
	    (let ((objc (objc-of-library-object obj)))
	      (let ((n (name-of-objc objc)))
		(when (and n (funcall patf n))
		  (push oid acc))))))
      acc)))

(defun lib-find-oids-by-kind (k)
  (let ((acc nil))
    (definition-table-map (resource 'library)
	(current-transaction-stamp)
      #'(lambda (oid obj)
	  (with-objc-of-library-object (objc obj)
	    (when (eql k (kind-of-objc objc))
	      (push oid acc)))))
    acc))

(defunml (|lib_find_by_kind| (k))
    (token -> (object_id list))
  (lib-find-oids-by-kind k))

(defunml (|lib_find_by_match| (pattern))
    (string -> (object_id list))
  (lib-find-oids-by-match pattern))

(defun lib-find-oids-by-name (name)
  (let ((acc nil))
    (definition-table-map (resource 'library)
	(current-transaction-stamp)
      #'(lambda (oid obj)
	  ;;(setf -oid oid -obj obj) (break "lfobn")
	  (let ((objc (objc-of-library-object obj)))
	    (when (eql name (name-of-objc objc))
	      (push oid acc)))))
    acc))

(defun lib-find-oids-by-names (names)
  (let ((acc nil))
    (definition-table-map (resource 'library)
	(current-transaction-stamp)
      #'(lambda (oid obj)
	  ;;(setf -oid oid -obj obj) (break "lfobn")
	  (let ((objc (objc-of-library-object obj)))
	    (let ((oname (name-of-objc objc)))
	      (when (member oname names)
		(push (cons oname oid) acc))))))
    (mapcar #'(lambda (name)
		(cdr (assoc name acc)))
	    names)))
		  

(defun name-of-oid (oid) (name-of-objc (oc oid)))
(defun kind-of-oid (oid) (kind-of-objc (oc oid)))

(defunml (|lib_find_oid_by_name| (name))
    (tok -> object_id)

  (or (lib-find-oid-by-name name)
      (raise-error (error-message '(find oid name) name))))

(defunml (|lib_find_oids_by_name| (name))
    (tok -> (object_id list))

  (lib-find-oids-by-name name)
  )

(defunml (|lib_find_oids_by_names| (names))
    ((tok list) -> (object_id list))

  (let ((oids (lib-find-oids-by-names names)))
    (when (member nil oids)
      (raise-error (error-message '(find oids names not)
				  (mapcan #'(lambda (n oid)
					      (when (null oid) (list n)))
					  names
					  oids))))))


(defun inline-persists-dump (term)
  (term-walk-d term
	       #'(lambda (x) (and (idata-persist-term-p x)
				  (not (itemplate-term-p
					(term-of-bound-term (car (bound-terms-of-term x)))))))
	       #'(lambda (term contf)
		   (let ((tstamp (stamp-of-idata-persist-term term))
			 (type (type-of-idata-persist-term term)))
		     ;;(setf -tstamp tstamp -type type -term term) (break "ipd")
		     (idata-persist-inline-term type
						tstamp
						(funcall contf (db-read (term-to-stamp tstamp) type))
						)))))



;; closurep if true then dumps closure of static refs.
;; otherwise dumps only list.

;; depstorep includes dynamic deps encoded in dependency-stores.
;; should guarauntee activation after import.

;; ghost dump builds terms and clousure list but does not write file.

(define-primitive |!dump_object| ((oid . oid)) (obj))
(define-primitive |!dump| () ())

(defun idump-term-aux-p (term)
  (equal-operators-p (operator-of-term term) *idump-operator*))

(defun collect-term-oid-list (term avoid-depstorep)
  (let ((acc nil))
    (collect-term-oids term
		       (if avoid-depstorep
			   #'idependency-store-term-p
			   #'(lambda (term) (declare (ignore term)) nil))

		       #'(lambda (oid)
			   (unless (dummy-object-id-p oid)
			     (pushnew oid acc :test #'equal-oids-p) )))
    acc))

(defun dump-objects (fname oids compressp closurep avoid-depstorep mobilep ghostp &optional kind)

  (let ((dhash (make-hash-table :test #'equal))
	(todo (remove-duplicates oids :test #'equal-oids-p))
	(done nil)
	)

    (dolist (oid oids) (setf (gethash (stamp-of-oid oid) dhash) 'todo))
    
    (do ()
	((null todo))
      
      (let ((oid (car todo)))

	;;(push oid done)
	(setf todo (cdr todo))
	;;(setf (gethash (stamp-of-oid oid) dhash) 'done)
	
	(let ((lobj (maybe-library-lookup oid t)))
	  (when lobj
	    (let ((obj-export (with-proxize-inf-tree
				  (with-objc-of-library-object (objc lobj)
				    ;;(setf -objc objc) (break "fu")
				    (push (cons oid objc) done)
				    (data-export (new-lobj lobj objc) (ivoid-term))))))
	      ;;(format t "obj-export ~a~%" (term-op-count obj-export))

	      (when closurep
		
		;;(format t "obj-dump ~a~%" (term-op-count obj-dump))

		  (collect-term-oids (inline-persists-dump obj-export) ;; need inline to force all obids into term.
				     (if avoid-depstorep
					 #'(lambda (term)
					     (or (idependency-store-term-p term)
						 (ievent-dependencies-term-p term)
						 (ienvironment-dependencies-term-p term)
						 ))
					 #'(lambda (term) (declare (ignore term)) nil))

				     #'(lambda (oid)
					 (unless (dummy-object-id-p oid)
					   (let ((s (stamp-of-oid oid)))
					     (let ((status (gethash s dhash)))
					       (when (null status)
						 (setf (gethash s dhash) 'todo)
						 (push oid todo) ))))))

		(format t "~%seen ~a, todo ~a " (hash-table-count dhash) (length todo))
                ))))))

    (format t "loop done ~a~%" (length done))

    ;;  comments, terms, abstractions, proofs (inf ???), statements, sorted code.
    ;; after load need do recompile all dependent code???
    (let ((kinds (list
		  (list 'inactive)
		  (list 'com)
		  (list 'term)
		  (list 'abs)
		  (list 'disp)
		  (list 'prf)
		  (list 'stm)
		  (list 'code))))

      (dolist (oidobjc done)
	(let* ((objc (cdr oidobjc))
               (oid (car oidobjc))
               (kind (if (lib-active-p oid)
			 (kind-of-objc objc)
			 'inactive))
	       (akind (or (assoc kind kinds)
			  (let ((nkind (list kind)))
			    (setf kinds (cons nkind kinds))
			    nkind))) )
	    
	  (setf (cdr akind) (cons oidobjc (cdr akind)))))


      (let ((code (cdr (assoc 'code kinds))))

	;; TODO
	;; a valiant effort, but if not closed then likely will still have compile errors at
	;; load due to intermediate still calling old earlier def.
	(let ((ocode (when code (n-objc-sort-by-dependencies *code-order-sort-dependency-kinds*
						             code))))

	  ;;(setf -ocode ocode -code code) (break "do")

       (labels ((dump-it (oidobjc)
                  (let ((oid (car oidobjc))
		        (objc (cdr oidobjc)))
		     (let ((lobj (maybe-library-lookup oid t)))

           	      (let ((obj-export (data-export (new-lobj lobj objc) (ivoid-term))))
	               (let ((obj-dump (if mobilep
		  	   	          (inline-persists-dump obj-export)
			 	          obj-export)))
			(idump-object-term oid obj-dump)))))))

	  (unless ghostp
	    (with-cprl-open-out-file (stream fname (when compressp *db-compression-levels*) compressp)
	      (when kind (cprl-stream-write stream (itoken-term kind)))

	      (do ((kr kinds (cdr kr)))
                  ((null kr))
               (let ((kind (car kr))
		     (l (mapcar #'length kinds)))
		(unless (eql (car kind) 'code)
                  (do ((r (cdr kind) (cdr r)))
		      ((null r))
                    (format t "WriteRemaining ~a ~a~%" (length r) l)
		    (cprl-stream-write stream (dump-it (car r)))))))

	      (do ((r ocode (cdr r)))
		  ((null r))
                (format t "CodeWriteRemaining ~a ~%" (length r))
		(let ((oidobjc (car r)))
		  (cprl-stream-write stream (dump-it oidobjc))))) ))))

	  nil
	  )))


(defunml (|load_object_list| (fname hook))
    (string -> ((bool -> (bool -> (object_contents -> (object_id -> unit)))) -> unit))

  ;;(setf -hook hook) (break "lol")
  (labels ((load-obj (term)
	     (let ((lterm (term-of-idata-term (obj-of-idump-object-term term))))
	       ;;(setf -bt bt -lterm lterm -term term) (break "lol")
	       (funmlcall hook
			  (collectable-of-ilibrary-object-term lterm)
			  (active-of-ilibrary-object-term lterm)
			  (term-to-objc (objc-of-ilibrary-object-term lterm))
			  (oid-of-idump-object-term term)) )))

    (with-cprl-open-in-file (stream fname)
      (do ((term (cprl-stream-read stream) (cprl-stream-read stream)))
	  ((null term))

	(when (itoken-term-p term)
	  (raise-error (error-message '(load object list) term)))

	(if (idump-term-aux-p term)
	    (mapc #'(lambda (bt)
		      (load-obj (term-of-bound-term bt)))
		  (bound-terms-of-term term))
	    (load-obj term))))))


(defunml (|load_object_term_list| (kinds fname hook))
    ((tok list) -> (string -> ((bool -> (bool -> (term -> (object_id -> unit)))) -> unit)))

  ;;(setf -hook hook) (break "lol")
  (labels
      ((load-obj (term)
	 (let ((lterm (term-of-idata-term (obj-of-idump-object-term term))))
	   (funmlcall hook
		      (collectable-of-ilibrary-object-term lterm)
		      (active-of-ilibrary-object-term lterm)
		      (objc-of-ilibrary-object-term lterm)
		      (oid-of-idump-object-term term)) ))   
       (visit (term)
	 (if (idump-term-aux-p term)
	     (mapcar #'(lambda (bt) (term-of-bound-term bt))
		     (bound-terms-of-term term))
	     (load-obj term))))

    (with-cprl-open-in-file (stream fname)
      (let ((term (cprl-stream-read stream)))

	(if (itoken-term-p term)
	    (unless (member (token-of-itoken-term term) kinds)
	      (raise-error (error-message '(load object term list) term)))
	    (visit term)))

      (do ((term (cprl-stream-read stream) (cprl-stream-read stream)))
	  ((null term))

	(visit term)))))

(defunml (|unpack_term_to_objc| (term))
    (term -> object_contents)
  (term-to-objc term))

(defunml (|dump_object_list| (closurep mobilep fname oids))
    (bool -> (bool -> (string -> ((object_id list) -> unit))))

  (dump-objects fname oids t closurep t ;;nil ;; was t but when exporting caused trouble.
		mobilep nil))

(defunml (|dump_object_list_wkind| (kind closurep mobilep fname oids))
    (tok -> (bool -> (bool -> (string -> ((object_id list) -> unit)))))

  (dump-objects fname oids t closurep t ;;nil ;; was t but when exporting caused trouble.
		mobilep nil
		kind))



;;% not necessarily always precise not robust comparable.
;;% 
(defunml (|modification_time| (objc))
    (object_contents -> (int |#| int))
  (let ((s (stamp-of-data objc)))
    (cons (time-of-stamp s) (sequence-of-stamp s))))


;; what's transaction situation?
(defun lib-checkpoint (garbagep orphansp unbindp logsp)

  (let ((lib (resource 'library)))
    
    (without-dependencies

     (when garbagep
       (ap (ml-text "\\u. (dag_remove_directory (descendent_s ``local garbage``) `queue` ? ())")
	   nil))

     (when orphansp
       (deactivate-orphans-aux lib))
  
     (when unbindp
       (unbind-collect-aux lib)))

    (when logsp
      (close-table-logs lib t))

    (journal-checkpoint (current-environment) t)))

;; inf_tree_to_iproof_node_term_g
(defunml (|pvs_term_to_inf_tree| (prf))
    (term -> inf_tree)

  ;;(setf -prf prf) (break "pttit")
  (let ((pvs-cons-op (instantiate-operator '|!cons| (list (token-parameter '|pvs|)
							  (token-parameter '!))))
	(pvs-nil-op  (instantiate-operator '|!nil| (list (token-parameter '|pvs|)
							 ))))
    (labels ((rule-of-pvs-proof-term (term)
	       (subterm-of-term term '(1)))
	     (goal-of-pvs-proof-term (term)
	       (subterm-of-term term '(0)))
	     (subgoals-of-pvs-proof-term (term)
	       (subterm-of-term term '(2)))

	     (pvs-ilist-to-list (i)
	       (if (equal-operators-p (operator-of-term i) pvs-cons-op)
		   (cons (subterm-of-term i '(0)) (pvs-ilist-to-list (subterm-of-term i '(1))))
		   (if (equal-operators-p pvs-nil-op (operator-of-term i))
		       nil
		       (raise-error (error-message '(bad pvs list) i)))))
	   
	     (visit (pterm)
	       (let ((goal (cons (goal-of-pvs-proof-term pterm) nil))
		     (tac (rule-of-pvs-proof-term pterm))
		     (subgoals (mapcar #'visit (pvs-ilist-to-list (subgoals-of-pvs-proof-term pterm)))))

		 (let ((r (new-certified-refinement 'not tac subgoals))
		       (objc (object-contents 'INF tac)))

		   (let ((o (inf-objc-modify-step (inf-objc-modify-src-goal objc goal)
						  (make-inf-step :goal goal
								 :refinement r))))
		     (inf-objc-tree o subgoals))))))

      (let ((objc-tree (visit prf)))
	;;(setf -prf prf -objc-tree objc-tree) (break "pvsterm_to_prf")
	objc-tree))))



;;;;	
;;;;	following was cooked up to recover old versions of objects when the later
;;;;	versions had files removed. Hopefully not a common occurence but might form
;;;;	the basis for recovery in other bad situations.
;;;;	

(defun bind-bcast-p (term)
  (and (ipassport-term-p term)
       (eql 'library (table-type-of-ipassport-term term))
       (let ((bcast (broadcast-of-ipassport-term term)))
	 (and (idefinition-insert-term-p bcast)))))

(defun log-to-binds-array (fname)

  (let ((a (make-array 10000 :adjustable t :fill-pointer 0)))

    (labels ((visit (term)
	       (if (bind-bcast-p term)
		   (vector-push-extend term a 5000)
		   (mapc #'(lambda (bt) (visit (term-of-bound-term bt))) (bound-terms-of-term term)))))

      (db-read-map #'(lambda (term)
		       (visit term)
		       nil)
		   fname))

    a))


;; kinds are opids
;; !definition_activate !definition_deactivate !definition_insert !definition_delete
;; disallow?
(defun log-entry-flatten (e &optional kinds-arg)
  (let ((kinds (or kinds-arg
		   '(|!definition_activate| |!definition_deactivate|
		     |!definition_insert| |!definition_delete|))))
    (cond
      ((icollection-term-weak-p e)
       (mapcan #'(lambda (bt)
		   (let ((b (broadcast-of-ipassport-term
			     (term-of-bound-term bt))))
		     (when (member (id-of-term b) kinds)
		       (list b))))
	       (bound-terms-of-term e)))
      ((ipassport-term-p e)
       (let ((b (broadcast-of-ipassport-term e)))
	 (when (member (id-of-term b) kinds)
	   (list b))
	 ))
      (t (setf -e e)
	 (break "log-entry-flatten")))))

(defun log-entry-search (a start stop &optional kinds)
  (labels ((first-nat (term)
	     (value-of-parameter-r
	      (find-if #'natural-parameter-p (parameters-of-term term)))))

    (let ((acc nil))
      
      (dotimes (i (length a))
	(let ((e (aref a i)))
	  (let ((l (log-entry-flatten e kinds)))
	    ;;(format t ".")
	    (when (some #'(lambda (d)
			    (let ((seq (first-nat d)))
			      (and (>= seq start)
				   (or (zerop stop)
				       (<= seq stop)))))
			l)
	      ;;(format t ",")
	      (setf acc (nconc (reverse l) acc))))))

      (nreverse acc))))
  

(defun log-length (fname)

  (let ((i 0))
    (labels ((visit (term)
	       (incf i)))

      (db-read-map #'(lambda (term)
		       (visit term)
		       nil)
		   fname))
    i))

(defvar *log-segment-buffer* nil)

(defun log-segment (fname start stop)

  (let ((i 0)
	(a (make-array (if (zerop stop) 5000 (+ (- stop start) 2))
		       :adjustable t :fill-pointer 0)))

    (labels ((visit (term)
	       (when (and (>= i start) (or (zerop stop) (<= i stop)))
		 (vector-push-extend term a 2000))
	       (incf i)))

      (db-read-map #'(lambda (term)
		       (visit term)
		       (and (not (zerop stop)) (> i stop)))
		   fname))
    (setf *log-segment-buffer* a))
  nil)

;; starts at zero.
(defun log-pick (fname index)

  (let ((i 0)
	(e nil))

    (labels ((visit (term)
	       (format t ".")
	       (if (= i index)
		   (progn (setf e term)
			  t)
		   (progn (incf i)
			  nil))))

      (db-read-map #'(lambda (term)
		       (visit term)
		       )
		   fname))
    e))


;; picks an entry from the log.
(defunml (|log_pick| (fname index))
    (string -> (int -> term))
  (log-pick fname index))

;; pulls a segment from the log using indices.
(defunml (|log_segment| (fname start stop))
    (string -> (int -> (int -> unit)))
  (log-segment fname start stop)
  nil))

;; finds records in the most recent segment using seq numbers.
(defunml (|log_search| (start stop))
    (int -> (int -> (term list)))
  (log-entry-search *log-segment-buffer* start stop))
  


(defun fix-missing-objcs (logname)
  (let ((bad (make-hash-table :test #'equal)))

    (definition-table-map (resource 'library)
	(current-transaction-stamp)
      #'(lambda (oid obj)
	  (let ((objc (with-ignore (objc-of-library-object obj))))
	    (when (null objc)
	      (setf (gethash (stamp-of-oid oid) bad) oid)))))

    (let ((binda (log-to-binds-array logname)))
      (setf -bad bad -binda binda) (break "fmo 1")

      (let ((good (make-hash-table :test #'equal)))
	(maphash #'(lambda (k v)
		     (let ((bind (find-if #'(lambda (bcast)
					      (let ((d (definition-of-idefinition-insert-term
							   (broadcast-of-ipassport-term bcast))))
						(and (equal-oids-p (oid-of-idefinition-term d) v)
						     (and (with-ignore
							      (term-of-idata-persist-term (data-of-idefinition-term d)))
							  t))))
					  binda
					  :from-end t)))
		       (setf (gethash k good) bind)))

		 bad)

	(setf -good good) (break "fmo 2")

	(maphash #'(lambda (k bcast)
		     (declare (ignore k))
		     (let ((d (definition-of-idefinition-insert-term
				  (broadcast-of-ipassport-term bcast))))
		       (funmlcall (ml-text "\\oid oc. save oid oc")
				  (oid-of-idefinition-term d)
				  (term-to-objc (data-of-idefinition-term d)))))
		 good)
	(break "fmo 3")))))



#|(defun obj-kind-count (lib-table activep)
  (let ((count nil))

  (let ((acc nil))
    (without-dependencies
     (definition-table-map (resource 'library)
	 (current-transaction-stamp)
       #'(lambda (oid obj)
	   (when (or (null activep)
		     (library-object-active-p obj))
	     (with-objc-of-library-object (objc obj)
	       (when (member (kind-of-objc objc) kinds)
		 (when (ap f oid objc)
		   (push oid acc))))))))
      acc)
    ))
|#

(defvar *lib-size-initial* nil)
(defvar *lib-size-last* nil)

(defun lib-size (env &optional reset-last)
  (let ((s (hash-table-count
	    (oid-table-of-definition-table
	     (cdr (assoc 'library (resources-of-environment env)))))))
    (unless *lib-size-initial*
      (setf *lib-size-last* s
	    *lib-size-initial* s))

    (when reset-last
      (setf *lib-size-last* s))

    (let ((growth (- s *lib-size-last*))
	  (allgrowth (- s *lib-size-initial*)))

      (format t "~%;;;~%;;;   LibGrowth :")
      (format t "~%;;;     CurrentSize : ~a" s)
      (format t "~%;;;     DailyGrowth : ~a" (num-to-string growth))
      (format t "~%;;;     TotalGrowth : ~a~%;;;" (num-to-string allgrowth))

      (list s growth allgrowth))))

(defun lib-log-date (env)
  (let ((js (journals-of-environment env)))
    (if (onep (length js))
	(let ((j (car js)))
	  (let* ((blink (blink-of-journal j))
		 (l (link-of-bus-link blink)))
	    (let ((stream (prl-stream-stream
			   (prl-stream-of-cprl-stream
			    (log-of-journal-channel
			     (channel-of-soft-link l))))))
	      ;;(setf -s stream) (break "lld")
	      (let ((wd (file-write-date stream)))
		(let ((elapsed (- (get-universal-time) wd)))
		  (format t "~%;;;   LastLibLogWrite was ~a ago~%;;;~%"
			  (num-secs-to-string elapsed)))
		  ))))
	
	(format t "LastLogWrite not a single journal open"))))

(defun lib-stats (&optional (update t) note ctime)
  (mapcar #'(lambda (env)
	      (when (member '|lib| (address-of-environment env))
		(lib-size env update)
		(lib-log-date env)))
	  *component*))



;; this may work?

#+cmu
(defun run-shell-command (string)
  (cl-user::run-program  "/bin/sh" (list "-c" string)
                :wait t :input nil :output t :error :output))
#+allegro
(defun run-shell-command (string)
  (excl:run-shell-command string :wait t))

;;
;; blob = stamp # <src-fileinfo>{last import}
;; <fdl>/sys/blobs/<process-id>/<seq>-<fname>.<ftype>
;;   * process-id and seq at time of export.
;; 
;; more info?
;;  import/export history.
;; 
;;  awkward name but ensures unique.
;;  can't write to users directory unless other write permission
(defunml (|modify_blob_objc| (objc path fname ftype nmname))
    (object_contents -> (string -> (string -> (string -> (string -> object_contents)))))
  (let ((filename (prl-make-filename path nil fname (unless (string= ftype "") ftype)))
	(stamp (new-transaction-stamp)))
    (let ((dest (stamp-to-pathname stamp "BLOB" t)))

      ;;(setf -filename filename -stamp stamp)  (break "blob1")
      ;;  check if file exists and is not a dir
      ;;  do cp
      (let ((x (concatenate 'string (complete-system-path (list "bin") "blob-import" "pl")
			    " "
			    filename
			    " "
			    (namestring dest))))

	;; cp file
	;;(setf -x x -filename filename -stamp stamp)  (break "blob")
	(unless (and (run-shell-command x)
		     (probe-file dest))
	  (raise-error (error-message '(cp create blob file) x)))
    
	;; modify objc
	(objc-modify-source-term objc
				 (iblob-proxy-term (stamp-to-term stamp)
						   (iblob-nameinfo-term nmname ftype)))))))

(defunml (|init_blob_objc| (objc fname ftype))
    (object_contents -> (string -> (string -> object_contents)))
  (let ((stamp (new-transaction-stamp)))
    (let ((dest (stamp-to-pathname stamp "BLOB" t)))

      ;;(setf -filename filename -stamp stamp)  (break "blob1")
      ;;  check if file exists and is not a dir
      ;;  do cp
      (let ((x (concatenate 'string (complete-system-path (list "bin") "blob-import" "pl")
			    " "
			    "0"
			    " "
			    (namestring dest))))

	;; cp file
	;;(setf -x x -filename filename -stamp stamp)  (break "blob")
	(unless (and (run-shell-command x)
		     (probe-file dest))
	  (raise-error (error-message '(cp create blob file) x)))
    
	;; modify objc
	(objc-modify-source-term objc
				 (iblob-proxy-term (stamp-to-term stamp)
						   (iblob-nameinfo-term fname ftype)))))))

;; export blob : cp to /home/fdl/blobs/<process_id>/<curstatmp>-<fname>.<ftype>
;; should be failure to modify blob-objc other than import/export
(defunml (|is_blob_objc| (objc))
    (object_contents -> bool)
  (iblob-proxy-term-p (term-of-source (source-of-objc objc))))

(defunml (|export_blob_objc| (objc))
    (object_contents -> (string |#| (string |#| string)))
  (let ((term  (term-of-source (source-of-objc objc))))
    (let ((blobt (when term (term-find #'iblob-proxy-term-p term))))
      (when (null blobt)
	(raise-error (error-message '(blob export not) (list blobt))))

      (let ((blobstamp (term-to-stamp (term-of-wrapped-term (stamp-of-iblob-proxy-term blobt))))
	    (nameinfo (term-of-wrapped-term (nameinfo-of-iblob-proxy-term blobt)))
	    (stamp (new-transaction-stamp))
	    (path (extend-system-path '(|blobs|)))
	    )

	(let ((src (stamp-to-pathname blobstamp "BLOB" t))
	      (process (process-id-to-string (process-id-of-stamp stamp)))
	      (seq (princ-to-string (sequence-of-stamp stamp)))
	      (ftype (type-of-iblob-nameinfo-term nameinfo)))
	  (let ((filent (if (not (string= "" ftype))
			    (format-string "~a.~a"
					   (name-of-iblob-nameinfo-term nameinfo)
					   ftype)
			    (name-of-iblob-nameinfo-term nameinfo))))
      
	    (let ((x (concatenate 'string
				  (complete-system-path (list "bin") "blob-export" "pl")
				  " " (namestring src)
				  " " (prl-remove-trailing-separator path)
				  " " process
				  " " seq
				  " " filent
				  )))

	      (let ((fname (prl-make-filename path
					      (list process) 
					      (format-string "~a-~a" seq filent))))
		(unless (and (run-shell-command x)
			     (probe-file fname))
		  (raise-error (error-message '(blob export not probe) (list blobt fname))))

		(cons (extend-system-path (list '|blobs| process))
		      (cons (format-string "~a-~a" seq (name-of-iblob-nameinfo-term nameinfo))
			    ftype) )))))))))