
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

(defun directory-merge (a b)

  (let ((acc a)
	(prev-btok nil)
	)

    (labels ((insert (be)
	       ;;(setf -be be -acc acc) (break "dmi")
	       (if (null prev-btok)
		   (setf acc (append acc (list be)))
		   (setf acc (mapcan #'(lambda (e) (if (eql (car e) prev-btok)
						   (list e be)
						   (list e)))
				     acc)))
	       )
	     (rename (n i)
	       (if (member n acc :key #'car)
		   (rename (intern-system (concatenate 'string (string n) "_" (princ-to-string i)))
			   (1+ i))
		   n)))

      (dolist (be b)
	(let ((btok (car be))
	      (boid (cdr be)))

	  (let ((ae (assoc btok acc)))

	    (if (null ae)
		;; toks differ.
		(insert be)

		;; toks same
		(if (not (equal-oids-p (cdr ae) boid))
		    (let ((newbtok (intern-system (concatenate 'string
							      (string btok)
							      "_old_"
							      (sortable-datetime-string
							       (get-universal-time))))))
		      
		      (insert (cons (rename newbtok 0) boid))
		      (setf btok newbtok) ;so prev gets set so.
		      )
		    ;; object ids are equal. lose other.
		    nil
		    )))

	    (setf prev-btok btok)))

      acc)))

(defunml (|directory_merge| (a b))
    (((tok |#| object_id) list) -> (((tok |#| object_id) list) -> ((tok |#| object_id) list)))
			    
  (directory-merge a b))


