
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;; files should be alist of dir . files.
(defun omlcomp (&optional files (printp nil))
  (com-ml-comp)
  (inml (ml-text
	 (list
	  (format-string "load_system true false ~a [\"library\"]"
			 (if printp "true" "false"))

	  "[ ([\"orb\"], [\"orbm-bsc\"])"

	  "; ([\"top\"], [\"comm-nlb\"; \"comm-graph\" ])"
	  "]")))

  (when files
    (inml (ml-text
	    (flatten
	     (list
	      (format-string "load_system true false ~a [\"library\"]"
			     (if printp "true" "false"))

	      (list
	       "["
	       " ([\"top\"], [\"comm-nlb\"])"

	       ;; "; ([\"<dir>\"], [<files>])"
	       (mapcar #'(lambda (d-fnames)
			   (list
			    (format-string "; ([\"~a\"], [\"~a\"" (car d-fnames) (cadr d-fnames))
			    (mapcar #'(lambda (fname)
					(format-string "; \"~a\"" fname))
				    (cddr d-fnames)
				    )
			    "])"))
		       files)
	       "]")
	      ))))))


(defun do-init-orb (&optional (files nil))

  (init-com-restart nil)

  (db-init (db-root-path t (find-db-path)))

  (when files (omlcomp files)))


;;new_simple_environment `test` `algebra`
