%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

let edd_connection () =
  first_tok (get_transaction_property `edd_connection`)
;;

let edd_eval_aux props e =
 % props arg supplied to edd_connection to forestall compile-time eval %
 (( orb_eval_args_wprops (if null props then [edd_connection props] else props)
  ? orb_eval_args `ONE`)
  nuprl5_edit_description_term
  e)
;;

let edd_eval = edd_eval_aux nil;;

let edd_eval_any = orb_eval_args `ANY` nuprl5_edit_description_term;;


let edd_eval_asynch_aux props e =
  orb_queue_asynch_wo_completion `ANY` false nuprl5_edit_description_term 
    ((if null props then [edd_connection props] else props) ? [])
    e
;;
let edd_evald prop = edd_eval_asynch_aux [prop];;

let edd_eval_to_term_aux props e =
 (( orb_eval_args_to_term_wprops (if null props then [edd_connection props] else props)
  ? orb_eval_args_to_term `ANY`)
  nuprl5_edit_description_term
  e)
;;

let edd_eval_to_term = edd_eval_to_term_aux nil;;
let edd_eval_to_string_marshalled = make_string_return_marshalled edd_eval_to_term;;
let edd_eval_to_string = make_string_return edd_eval_to_term;;
let edd_eval_to_strings = make_strings_return edd_eval_to_term;;
let edd_eval_to_terms = make_terms_return edd_eval_to_term;;

%
	Compile/Refine Source updates.
%
let lib_abs_reference_static_ap = begin_ap "abs_reference_static";;
let lib_abs_reference_static desc reterm term =
  orb_eval_args_to_term `ANY` desc (term_ap (term_ap lib_abs_reference_static_ap reterm) term)
;;


let lib_ml_code_compile_ap = begin_ap "com_ml_compile";;
let lib_ml_code_compile desc reterm code =
  orb_eval_args_to_term `ANY` desc (term_ap (term_ap lib_ml_code_compile_ap reterm) code)
;;

let lib_lisp_code_compile_ap = begin_ap "com_lisp_compile";;
let lib_lisp_code_compile desc reterm code =
  orb_eval_args_to_term `ANY` desc (term_ap (term_ap lib_lisp_code_compile_ap reterm) code)
;;

