;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************


(in-package "CL-USER")

#+lucid
(unless (find-package *system-package-name*)
  ;;(make-package *system-package-name* :use '("LISP"))
  ;; be nice if LCL is not needed? but for now need it to get clos functions.
  (make-package *system-package-name* :use '("LISP" "LCL")) 
  )

#+lucid
(unless (find-package "CL-USER")
  ;;(make-package *system-package-name* :use '("LISP"))
  ;; be nice if LCL is not needed? but for now need it to get clos functions.
  (make-package "CL-USER" :use '("LISP" "LCL" "USER")) 
  )

#-lucid
(unless (find-package *system-package-name*)
  (make-package *system-package-name* :use '("LISP")))

(export '(*system-package-name* *system-package-name-root* in-system-package))

(export '(expand large-expand very-large-expand half-gig-expand huge-expand))

;; danger danger danger kludge alert.
#+ansi-cl(pushnew :cltl2 *features*)

#-cltl2(in-package cl-user::*system-package-name*)
#+cltl2(in-system-package)


(import '(cl-user:*system-package-name* cl-user:*system-package-name-root* cl-user:in-system-package
	  cl-user:config-data cl-user:read-config cl-user:load-user-config))

(import '(cl-user:expand cl-user:large-expand cl-user:very-large-expand cl-user:half-gig-expand cl-user:huge-expand cl-user:expand-space))

#-dlwin
(import '(cl-user:*system-kind* cl-user:*system-root* cl-user:*system-path-prefix* cl-user:*system-site-prefix*
	  cl-user:*system-major-version* cl-user:*system-minor-version*
	  cl-user:*path-separator-string*
	  cl-user:cd cl-user:gc cl-user:pwd cl-user:getenv cl-user:pfeatures
	  cl-user:extend-pathname cl-user:butlast-pathname
	  cl-user:standard-binary-directories
	  cl-user::quit
	  cl-user:ccs cl-user:compile-current-system
	  ))

#+(or allegro cmu)
(import '(cl-user:prompt-and-read))

(defvar *system-package*
  (find-package *system-package-name*))


;;;
;;;	Other packages.
;;;

(defparameter *ml-runtime-package-name* (concatenate 'string *system-package-name* "-ML-RUNTIME"))
    
(unless (find-package *ml-runtime-package-name*)
  (make-package *ml-runtime-package-name*))

(defparameter *system-variable-package-name*
  (concatenate 'string *system-package-name* "-VARIABLE"))

(defparameter *system-abstraction-meta-variable-package-name*
  (concatenate 'string *system-package-name* "-ABSTRACTION-META-VARIABLE"))

(defparameter *system-display-meta-variable-package-name*
  (concatenate 'string *system-package-name* "-DISPLAY-META-VARIABLE"))

(unless (find-package *system-variable-package-name*)
  (make-package *system-variable-package-name* :use nil))

(unless (find-package *system-abstraction-meta-variable-package-name*)
  (make-package *system-abstraction-meta-variable-package-name* :use nil))

(unless (find-package *system-display-meta-variable-package-name*)
  (make-package *system-display-meta-variable-package-name* :use nil))


;;; substitute is term substitution.
(shadow '(substitute))


#-dontinline
(proclaim '(inline intern-system symbol-upcase))

(defun intern-system (s)
  (intern s *system-package*))

(defun symbol-upcase (s)
  (intern (string-upcase (symbol-name s)) (symbol-package s)))


(defparameter *system-variable-package*
  (find-package *system-variable-package-name*))

(defparameter *system-abstraction-meta-variable-package*
  (find-package *system-abstraction-meta-variable-package-name*))

(defparameter *system-display-meta-variable-package*
  (find-package *system-display-meta-variable-package-name*))

(defparameter *ml-runtime-package*
  (find-package *ml-runtime-package-name*))


(defmacro loadff (pathname)
  #+(and cmu18e) 	`(sys::load-object-file ,pathname)
  #+(and cmu (not cmu18e))	`(alien:load-foreign ,pathname)
  #+lucid	`(load-foreign-files ,pathname)
  #+allegro	`(load ,pathname)
  )

(defmacro unloadff (pathname)
  ;;#+cmu		nil
  ;;#+lucid	`(load-foreign-files ,pathname)
  #+(and allegro (not allegro-v4.3))	`(ff:unload-foreign-library ,pathname)
  ;;#+allegro	`(ff:unload-foreign-library ,pathname)
  )

;; butlast is kludge
(defun loadnff (name)
  (loadff (extend-pathname cl-user:*system-path-prefix*
			    #-ALLEGRO-V4.3
			    (append '("binaries")
				    (butlast (cl-user:standard-binary-directories)))
			   #+ALLEGRO-V4.3 (list "sys" "bin" "linux86" "libc5")
			   name (cdr make::*foreign-filename-extensions*))))

(defun unloadnff (name)
  (unloadff (extend-pathname cl-user:*system-path-prefix*
			   (append '("binaries") (butlast (cl-user:standard-binary-directories)))
			   name (cdr make::*foreign-filename-extensions*))))

#+lucid (load-foreign-libraries nil)

#+allegro-v3.1 (require :foreign)

#+cmu
(progn
  (loadnff "ffi-bsc")
  (loadnff "ffi-io")
  (loadnff "ffi-unix")
  )

#+dlwin
(progn
  (load "c:/nuprl/nuprl5/bin/Debug/ffi-bsc.dll")
  (load "c:/nuprl/nuprl5/bin/Debug/ffi-io.dll")
  )

