%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%


let loadf_system = load_system true false false;;
let loadt_system = load_system true false true;;
let loadft_system = load_system true true false;;
let loadtt_system = load_system true true true;;

let unconditional_compile printp path files =
  load_system true true printp path [[], files];;

letref system_path = system_path_prefix();;
letref system_path_dirs = ["library"];;

let compile path fname  = loadt_system system_path_dirs [path, [fname]];;
let mlpatch fname  = loadt_system ["bin"; "patches"] [nil, [fname]];;

let make_system_filename dirs name type = make_filename system_path dirs name type;;
let make_system_ml_filename dirs name = make_filename system_path dirs name "";;


let cmfx d n = loadt_system system_path_dirs [d, [n]];;
let cmf d n = loadt_system system_path_dirs [[d], [n]];;
let cml n = loadt_system system_path_dirs [[], [n]];;

let complete_system_path dirs fname = 
 string_to_tok
  (make_system_filename (map tok_to_string dirs)
			(tok_to_string fname)
			"")
;;

let compile_list dirs names =
  loadft_system system_path_dirs [(map tok_to_string dirs, map tok_to_string names)]; ();;

let identical_terms_p = lex_equal_terms;;


%
letrec find_first f l =
 if l = [] then false
 else (f (hd l)) or find_first f (tl l)
;;
%

letrec find_first f l =
 if l = [] then fail
 else
 let x = (hd l) in
 if (f x) then x else find_first f (tl l)
;;

let first_n n l =
  letrec aux nn li ll = if li = [] then ll else
  if nn = 0 then ll 
  else aux (nn-1) (tl li) ((hd li).ll) in
  aux n l []
;;


let cs = compile ["sys"; "src"];;

let replace_term i t s = 
  make_term (operator_of_term t)
   let pre, post = split (i - 1) (bound_terms_of_term t) in 
     append pre ((fst (hd post), s) . (tl post))
;;

% debug warn etc %
let allow_tty_print = ``error``;;     
let tty_print_all = false;;

let tty_debug kind msg =
 if tty_print_all or (member kind allow_tty_print)
    then tty_print (concatenate_strings ((tok_to_string kind) . msg))
;;


let lhs_rhs_of_abstraction_by_name name = 
 let attrs, lhs, rhs, expandable_p = abstraction_lookup (abstraction_lookup_by_name name) in
  lhs, rhs
;;    
