%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

let igoal_term goal = 
  make_term (`!goal`, [])
	     [[],(fst goal);
	      [],(map_to_ilist (\x.x) (`!annotation_cons`,[]) (snd goal))]
;;

% assumes graph is ordered such that no dependency precedes a dependent.
  isor : index_accessor, csor : closure accessor
%

abstype (*, **, ***) graph_element = (* # (** # * list) # (*** # * list)) 
 with mk_graph_element index cdata clos data edges = abs_graph_element (index, (cdata, clos), (data, edges))
 and ge_index e = fst (rep_graph_element e)
 and ge_cdata e = (fst o fst o snd) (rep_graph_element e)
 and ge_clos  e = (snd o fst o snd) (rep_graph_element e)
 and ge_data  e = (fst o snd o snd) (rep_graph_element e)
 and ge_edges e = (snd o snd o snd) (rep_graph_element e)
 and ge_show  e = rep_graph_element e
;;


abstype (*, **, ***) graph = (((*, **, ***) graph_element) list # ((* -> * -> bool) # ** %initial cdata value%))

 with new_graph eqp v = abs_graph (nil, (eqp, v))

 and destruct_graph g = rep_graph g

 and update_graph_list g gl = 
      let ogl, r = rep_graph g in
        abs_graph (gl, r)
 and graph_initial_value g = snd (snd (rep_graph g))

 and graph_member g index =
      let gl, eqp, v = rep_graph g in
       (can (find (\e. eqp (ge_index e) index)) gl)

 and graph_find g index =
      let gl, eqp, v = rep_graph g in
       ((find (\e. eqp (ge_index e) index) gl) ? (really_break `graph_find`; failwith `graph_find`))

 and graph_add g e = 
      let (gl, r) = rep_graph g in
       abs_graph ((e . gl), r)

 and graph_remove g index = 
      let gl, r = rep_graph g in 
      let eqp = fst r in 
        abs_graph ((remove_if (\e. eqp index (ge_index e)) gl), r)

 % returns list of elements matching indices and an list of remainder in stable order % 
 and graph_divide g indices = 
      let gl, eqp, v =  rep_graph g in 
        divide_list (\ee. can (find (\index. eqp index (ge_index ee))) indices) gl

 and % edges are indices, 
       assumes closures in g good, 
       returns index list
       order : indices from later edges occur later
	       edge indices themselves occur first.
        an order inconsistency in closures of edges will not be detected and one
        will be chosen arbitrarily,
        cycles cause failure
     %
     %graph_closure g index edges =
       let gl, eqp, v = rep_graph g in
       letrec aux rem acc = 
        if null rem then acc
           else let clos = ge_clos ((find (\e. eqp (ge_index e) (hd rem)) gl) ? failwith `find_closure__edge`) in
                let new = diff_p eqp clos acc in
                if (member_p index new eqp) then failwith `find_closure__cycle`
                   else aux (tl rem) (new @ acc)
     in aux edges edges%

     graph_closure g index edges =
       let gl, eqp, v = rep_graph g in
        reduce (\indices acc . let new = diff_p eqp indices acc in
                              if (member_p index new eqp)
			         then (raise_error nil %(index . edges)% % coerces graph type to oid%
						   ``find_closure__cycle`` []; fail)
 		                 else (new @ acc))
               nil 
	       ( edges
               . (map (\index. ge_clos ( (find (\e. eqp (ge_index e) index) gl) 
				       ? (raise_error nil %(index . edges)%
						      ``find_closure__edge`` []; fail)))
                      edges))

 and graph_show g =
      map ge_show (fst (rep_graph g))

;;

let graph_init g index cdata data = 
  if (graph_member g index) then failwith `graph_init__duplicate_index`;
     graph_add g (mk_graph_element index cdata nil data nil)
;;

let graph_insert g e =
 let gg = graph_remove g (ge_index e) in
 let suffix, prefix = graph_divide gg (ge_clos e) in
    update_graph_list gg (append prefix (e . suffix))
;;

%
let graph_update updatef g index data edges = 

  %% if index member of edges then get misleading error of inability to find edge to due first removal
    below. either test for membership and fail here or maybe compute closre of g instead of gg.
  %% 

  let gg = graph_remove g index in
  let clos = graph_closure g index edges in
  let initial_value = graph_initial_value gg in
 
  %% accumulate cdata		
   clos is newest to oldest, desire to accumulate such that oldest at tail	
   let rclos = rev clos in %%
   let cdata = reduce (\ind acc. updatef (ge_data (graph_find gg ind)) acc)
		 initial_value
                 clos in

  let ncdata = updatef data cdata in 
   
    (graph_insert gg (mk_graph_element index ncdata clos data edges))
;;
%
let graph_update_aux f g index data edges = 

  % if index member of edges then get misleading error of inability to find edge to due first removal
    below. either test for membership and fail here or maybe compute closre of g instead of gg.
  % 
  let gg = graph_remove g index in
  let clos = graph_closure g index edges in
    (f gg clos index data edges
      (\ndata cdata.
         (graph_insert gg 
           (mk_graph_element index cdata clos ndata edges)))) 
;;

%  want to modify closure data of some already present entry.
%
let graph_set g index cdata =
  (let ge = graph_find g index
   and gg = graph_remove g index in
    graph_insert gg
      (mk_graph_element index cdata (ge_clos ge) (ge_data ge) (ge_edges ge)))
  ? graph_insert g
      (mk_graph_element index cdata nil cdata nil)
;;

let graph_update updatef = 
 graph_update_aux 
   (\gg clos index data edges r.
      let initial_value = graph_initial_value gg in
      let cdata = reduce (\ind acc. updatef (ge_data (graph_find gg ind)) acc)
		 initial_value
                 clos in

	  (r data (updatef data cdata)))
;;

let graph_refresh updatef g index = 
  let e = graph_find g index in
    graph_update updatef g index (ge_data e) (ge_edges e) 
;;

  
lettype tok_graph = (tok, int, int list) graph;;

letref testgraph = (new_graph $= 0) : tok_graph;;

let itg () =
 let assignf = (\g. testgraph := g) in
 let updatef = (\nums sum . reduce (\a b. a + b) sum nums)  in 
   assignf (graph_update updatef testgraph `a` [0] nil)
 ; assignf (graph_update updatef testgraph `b` [1; 2] ``a``)
 ; assignf (graph_update updatef testgraph `c` [3] ``a b``)
 ; assignf (graph_update updatef testgraph `d` [4] ``b``)
 ; assignf (graph_update updatef testgraph `b` [1; 2; 3] ``a``)
 ; assignf (graph_refresh updatef testgraph `c`)
 ; assignf (graph_refresh updatef testgraph `d`)
 ; graph_show testgraph
;;

%
;;;;	
;;;;	Dependencies : 
;;;;	  - update/refresh	: dependencies of closure oids.
;;;;	  - lookup		: dependency on index oid
;;;;	
;;;;	

;;;;	
;;;;	Updates :
;;;;	  occurs in two distinct steps :
;;;;	    - add : at object eval - data is added to ref state
;;;;	    - update : at refenv definition - data is extracted and used to update refenv.
;;;;	 
;;;;	ref_state_do_updates : rs oid oids edges
;;;;	 
;;;;	ref_state_set_data : ref_state  -> (object_id # data) list ref_state
;;;;	  * puts data into ref_state 
;;;;	 
;;;;	 
;;;;	update_hook : (tok{update-kind} #
;;;;                   (object_id{re} -> object_id list{prevs} -> object_id{update} list -> unit)
;;;;		        
;;;;	
;;;;	add_ref_environment_data
;;;;	  : object_id{update} -> tok{update-kind}
;;;;         -> (object_id{update} -> *{data} -> **){add_hook} -> *{data} -> unit
;;;;	
;;;;	
%

%
letref ref_environment = nil : (tok # object_id) list;;
letref ref_reset_hooks = nil : (tok # (unit -> unit)) list;;

let put_ref_reset_hook name h = 
 ref_reset_hooks := (name,h) . (remove_if (\n,hh. n = name) ref_reset_hooks)
 ; ()
;;
let ref_environment_reset () = 
 map (\name, f. f ()) ref_reset_hooks
 ; ()
;;
%

letref ref_state_get_debug = (`init`, dummy_object_id(), `init`);;

%
add_fu object_id {update} -> *** list -> unit
object_id of graph is index.
graph is index, cdata, data
* is cdata (? inherited)  often cdata is data list
** is data (? new updates)
*** is update
updateg takes update list to data, ie merges?.
  an index may have multiple updates.
updatef takes data and cdata to cdata, ie accumlates.
  cdata 
how do we merge on multiple inheritance

apparently :
 find all data from closure of index in graph then
 start with initial cdata value and accumulate datas to cdata.
 ie never combine cdata's directly, always rebuild from datas.

update_hook index prevs updates
  - computes merge 
  - modifies ref state in callback
%

absrectype (*, **, ***) ref_state =		% (cdata, data) ref_state %
 ( (object_id, *, **) graph
 # (object_id # ***) list
 # tok			      		% nmemonic %
 %# (unit + *)			%	% cache		%
 # (*** list -> **)			% updateg %
 # (** -> * -> *)			% updatef : takes cdata and data to produce cdata 
						will be applied to list of data such that oldest data
						is accumulated prior to newer.
					%
 )
with new_ref_state name updateg updatef l v = 
        abs_ref_state ((new_graph equal_oids_p v), l, name, updateg, updatef)
 and ref_state_modify_aux f rs oid data edges =
      let (g, r) = rep_ref_state rs in
       let gg, rest =  (f g oid data edges ? failwith `ref_state_modify_aux f`) in
         (abs_ref_state (gg, r), rest)
         %if (not (null rest))
	    then failwith (string_to_tok
			    ("ref_state_modify_aux__" J 
			      (concatenate_strings 
			        ( (tok_to_string n) . "__"
			        . (flatten (map (\n,r. ["_"; tok_to_string n]) rest))))))
         else (abs_ref_state ((graph_update (snd (snd r)) gg oid data edges), r))%
 and ref_state_modify rs oid data edges =
      let (g, r) = rep_ref_state rs in
       abs_ref_state ((graph_update (snd (snd (snd r))) g oid data edges), r)
 and ref_state_add rs oid data edges =
      let (g, r) = rep_ref_state rs in
       abs_ref_state ((graph_update (snd (snd (snd r))) g oid data edges), r)
 and ref_state_set rs oid cdata =
      let (g, r) = rep_ref_state rs in
       abs_ref_state ((graph_set g oid cdata), r)
 and ref_state_set_data rs updates =
      let (g, l, r) = rep_ref_state rs in
       abs_ref_state (g, (fast_update_alist equal_oids_p updates l), r)
 % if losing data watch out for multiple reset_ref_environment_data per obid %
 and ref_state_do_updates rs oid oids edges = 
      let (g, r) = rep_ref_state rs in
      let (l, n, uf, ug) = r in
 % should use oids and map_omitting_failures/apply_alist to l to get data in update order. %
 let data = uf (map_omitting_failures (\oid. apply_alist_p l oid equal_oids_p) oids) in
     % let data2 = uf (map snd (filter (\oid,data. member_p oid oids equal_oids_p) l)) in
       if not ((length data) = (length data2)) then (tty_print "ref_state_do_updates"; failwith `ref_state_do_updates`) else
     %
       abs_ref_state ((graph_update ug g oid data edges), r)
 and ref_state_remove rs oid =
      let (g, r) = rep_ref_state rs in
       abs_ref_state ((graph_remove g oid), r)
 and ref_state_get g oid =
       ( (ge_cdata (graph_find (fst (rep_ref_state g)) oid))
       ? ( (ref_state_get_debug := `get`,oid,(fst (snd (snd (rep_ref_state g)))))
	 ; failwith `ref_state_get`))
 and ref_state_get_element rs oid =
       ( (graph_find (fst (rep_ref_state rs)) oid)
       ? ( (ref_state_get_debug := `get_e`,oid,(fst (snd (snd (rep_ref_state rs)))))
	 ; failwith `ref_state_get_element`))
 and ref_state_name rs = fst (snd (snd (rep_ref_state rs)))

 % debug utils: %
 and ref_state_show g =
      let (g, l, n, r) = rep_ref_state g in
        n, (graph_show g)
 and destruct_ref_state rs = rep_ref_state rs
;;

% list not used and * == **  ie cdata and data have same type 
%
let new_simple_ref_state name updateg v = 
 new_ref_state name (\a. v) updateg (nil: (object_id # unit) list) v
;;

%  another common scenario would be ** == *** list. %
let new_singleton_ref_state v name = 
 let doid = dummy_object_id() in
   new_ref_state name (\x. last x) (\data cdata . data)
    [(doid, v)] % really expect v to be value %
    v
;;

%  Or *** == ** %
let new_list_ref_state name v = 
 let doid = dummy_object_id() in
   new_ref_state name flatten append 
    (map (\x. doid, [x]) v) % really expect v to be [] %
    v
;;

let new_alist_ref_state name v =
 let doid = dummy_object_id() in
 new_ref_state name
    flatten
     % priority_merge_alists seems like a better choice but this preserves order of the original
       implementation.
     %
    (\data cdata . multi_update_alist cdata data)
    (map (\x. doid, [x]) v)
    v
;;

letrec merge_list_alist a d =
  if null d then a else
  let ((i,v).rest) = d in
  let c = (apply_alist a i ? nil) in
    merge_list_alist (update_alist a i (v @ c)) rest
;;	   
	   
let new_list_alist_ref_state name v =
 let doid = dummy_object_id() in
 new_ref_state name
    flatten
     % priority_merge_alists seems like a better choice but this preserves order of the original
       implementation.
     %
    (\data cdata . merge_list_alist cdata data)
    (map (\x. doid, [x]) v)
    v
;;
	   
letref ref_environment_update_hooks = 
  [] : (tok # (object_id -> (object_id list) -> (object_id list) -> unit)) list;;

% object_id{update} # (tok{ref_state name} list)
  ie, which updates modify which ref_states.
%
letref ref_environment_data_map = 
  [] : (object_id # tok list) list;;
	   
let update_object_id_p oid =
  can (find (\doid,r. equal_oids_p doid oid)) ref_environment_data_map
;;

					
let set_ref_environment_update_hook name hook =
  ref_environment_update_hooks := update_insert_alist ref_environment_update_hooks name hook
;;

let set_ref_environment_data_map oid refstates =
 ref_environment_data_map := update_insert_alist_p equal_oids_p ref_environment_data_map oid refstates
;;

let add_ref_environment_data_map oid refstates =
 let e = apply_alist_p ref_environment_data_map oid equal_oids_p ? nil in
   ref_environment_data_map
     := update_insert_alist_p equal_oids_p ref_environment_data_map oid (refstates @ e)
;;

letref ref_environment_undeclare_hooks = nil : (tok # (object_id -> unit)) list;;
let add_ref_environment_undeclare_hook tag hook =
  ref_environment_undeclare_hooks :=
    update_alist ref_environment_undeclare_hooks tag hook
;;

 % need to filter in case stale data present in ref state.
 - add data to ref state and add object to data map.
 - remove object from data map.
 - call hook with object some other object of update uses same ref state.
 filtering by data map helps only if object removed or updated in data map, 
 would be nice to have reliable method of dectecting object modification, 
 ie require data map updates to be done by code table update, and have code table hooks
 to modify table map upon code def delete. maybe require property on object.
 FTTB just filter as we do not expect much modification of this sort.
 %
 
 

% kludge to acces funcs defined in objects 
  refvar may be necessary anyways since function may need to access later refenv update funcs.

  used to delay update of refenv until reference. a little dangerous as only called
  by get_ref_environment, thus if some reference to an environment prior to a call to
  get_ref_environment then a difficult to debug problem arises.
%

letref check_refenv_f =  (\oid : object_id . ():unit);;

%;;;	
;;;;	use ref_state to manage ref but avoid using cacheing mechanism
;;;%	

letref ref_environment_ref_state = 
  new_simple_ref_state `ref_environment` 
   (union_p (\a b. (fst a) = (fst b)))
   (nil : (tok # object_id) list)
;;

let ref_env_remove index =
 ref_environment_ref_state := ref_state_remove ref_environment_ref_state index;
 map (\h. (snd h) index) ref_environment_undeclare_hooks;
()
;;
	   
letref ref_state_view = [] : (tok # (object_id -> term)) list;;
letref ref_state_merge = [] : (tok # (object_id -> ((object_id list) -> bool))) list ;;

let update_ref_state_merge name f =
  ref_state_merge := update_alist ref_state_merge name f
;;

% reference_state_merge `soft_abstractions` rf1i (uc . sq1c . f1c . nil);;
%
let reference_state_merge name index edges = 
  ((apply_alist ref_state_merge name) index edges)
  ? false
;;
 

let update_ref_state_view rsf hook = 
 ref_state_view := update_alist ref_state_view
			        (ref_state_name (rsf ()))
				(hook rsf)
;;

let view_of_ref_state name oid = 
 let vf = ( (apply_alist ref_state_view name) 
          ? (raise_error [][`view_of_ref_state`; name; `not`][]; fail))
  in vf oid
;;

let ref_state_view_entry f rsf = 
  (\oid. f (ref_state_get (rsf ()) oid))
;;

let ref_state_view_list_entry f =
 ref_state_view_entry 
  (\l. map_to_ilist f (`ref_state_cons`, []) l)
;;

let ref_state_view_bool_entry =
 ref_state_view_entry 
  (\b. ibool_term b)
;;

%;;;	
;;;;	but where to call.
;;;;	  - graph update is called 
;;;;	      * edges are used to compute closure for result.
;;;;	      * closure is reduced with unionp to produce ref environment.
;;;;		  - this is incorrect
;;;;	  - desire 
;;;;	      * compute closure
;;;;	      * make_ref_env called to produce ref environment.
;;;%
let get_ref_environment index = 
  check_refenv_f index;
  ref_state_get ref_environment_ref_state index
;;

let get_ref_environment_edges index = 
  ge_edges (ref_state_get_element ref_environment_ref_state index)
;;

let get_ref_environment_edges_closure index = 
  ge_clos (ref_state_get_element ref_environment_ref_state index)
;;


let map_divide_list f l = 

 letrec aux l =
   if null l then (nil,nil)
   else let r = (f (hd l)) in
        let (a,b) = aux (tl l) in
	  if (isl r) then ((outl r).a), b else a, ((outr r).b) 

 in aux l
;;
         
letref mre_debug = nil : (tok # object_id) list;;
let merge_reference_environment_aux index data edges = 

 if null edges then (data, data, nil)
 else if (null (tl edges)) & null data 
         then (nil, (fst (fst (snd (ge_show
		          (graph_find 
			       (fst (destruct_ref_state ref_environment_ref_state))
			       (hd edges))))), nil))
 else 

 let closures = 
   map (\e. (fst (snd (ge_show
                        (graph_find 
                          (fst (destruct_ref_state ref_environment_ref_state))
			  e)))))
       edges in

 letrec alistify_aux rcl cls kinds r = 
   if null rcl then kinds,r
   else let (kind, oid) = (hd rcl) in
           if (member kind kinds) then alistify_aux (tl rcl) cls kinds r
	      else alistify_aux (tl rcl) cls
				(kind . kinds)
				( (kind, (remove_prior_duplicates_p equal_oids_p
					   ( oid
	 			           . (map_omitting_failures
                                               (\cl. (apply_alist (fst cl) kind))
					       cls))))
 				 . r)
 in

 letrec alistify cls kinds r = 
  if null cls then r
  else let nkinds, nr = (alistify_aux (fst (hd cls)) (tl cls) kinds r) in
         alistify (tl cls) nkinds nr

  in 

  let multis, singles = divide_list (\e. (length (snd e)) > 1)
                          (alistify closures (map fst data) % avoid those explicily specified %
					      nil) in

  letrec straight young oids = 
    if null oids then true 
    else let n = hd oids in
          if member_p n (get_ref_environment_edges_closure young) equal_oids_p  then straight young (tl oids)
	  else if member_p young (get_ref_environment_edges_closure n) equal_oids_p then straight n (tl oids)
          else false in

  let multis2, singles2 = 
   divide_list (\name, oids. not (straight (hd oids) (tl oids))) multis in

  let multis3, singles3 = 
   map_divide_list (\name, oids. if (reference_state_merge name index oids)
				    then (inr (name, index))
				    else (inl (name, oids))
				    ? (inl (name, oids)))
     multis2 in

  mre_debug := singles3;

  let f = (\e. (fst e, hd (snd e))) in
    % need merged to be in data so that later incremental update does not lose. %
    let ndata = (data @ singles3) in
     (ndata, (ndata @ (map f singles2) @ (map f singles)), multis3)

 % expect order of oids in (snd closures) to be consistent  but there is no guarauntee %
;;

letref merge_reference_environment = merge_reference_environment_aux;;

% returns graph and unresolved states.
 overrides normal (** -> * -> *) graph update?
%
let reference_environment_graph_update = 
  graph_update_aux
    (\gg clos index data edges r.
       let ndata, ok, rest = merge_reference_environment index data edges  in
        ((r ndata ok), rest))
;;

let update_ref_environment_ref_state index data edges = 
  ref_environment_ref_state := 
    ref_state_modify ref_environment_ref_state index data edges
;;

let update_ref_environment_ref_state_aux index edges = 
  let nrs, rest = ref_state_modify_aux reference_environment_graph_update
	            ref_environment_ref_state index nil edges in
  ref_environment_ref_state := nrs;
  rest
;;


% allow incremental bindings to a ref_environment. %
let union_ref_environment_ref_state index data =
  let ge = ref_state_get_element ref_environment_ref_state index in
    update_ref_environment_ref_state index
      (union_p (\a b. (fst a) = (fst b)) data (ge_data ge))
      (ge_edges ge)
;;


% view %
let ref_environment_oids () = 
  (map ge_index (fst (destruct_graph (fst (destruct_ref_state ref_environment_ref_state)))))
;; 

update_ref_state_view
 (\(). ref_environment_ref_state)
 (ref_state_view_list_entry 
     (\p. make_term (`ref_state_binding`, [ make_token_parameter (fst p)
					  ; make_object_id_parameter (snd p)])
		       []))
;;     
       
% a little kludge to let lisp funcs know that get_ref_environment has
  been recompiled.
%
reset_get_ref_environment_f ();; 

%  
;;;;	
;;;;	union_ref using edges for rs is could wrong.
;;;;	
;;;;	the re_index is used to find index, 
;;;;	often, if not always, if the rs is referencing other objects
;;;;	then the ref_environment is too.
;;;;	
;;;;	
;;;;	ref_environment is assoc to find indices for other ref states.
;;;;	 - inherits from earlier environment.
;;;;	   ie if env a has binding for ref_state r then
;;;;	   if env b wants same wants to use same binding for a then 
;;;;	   this can be done by inheriting. Ie a is an edge of b.
;;;;	     * One presumes that when updating
;;;;	     * assume env a and you want env b which just extends ref_state r but othewise is same as a.
;;;;	       then b has edge of a, and then b has r` with edge r
;;;;	
;;;;	
;;;;	
;;;;	r is a ref_state : assoc of indices to data
;;;;	a' is ref_environment 
;;;;	a'oid indexes `a`, aoid in ref_environment_ref_state 
;;;;	aoid indexes adata in r
;;;;	 a'e is a'oid edges in re ref_state
;;;;	 ae is aoid edges in r
;;;;	
;;;;	when we add an assoc element to r with a as edge
;;;;	
;;;;	
;;;;	What we would like is for ref_environment to return us the ref state given an index.
;;;;	Or maybe for ref_env to return us the data given the index.
;;;;	Then it would make sense to require the re-index and index to be the same.
;;;;	
;;;;	but is an edge of an element ref_state and edge of the ref_environment
;;;;	
;;;;	re_lookup_data	: name -> index -> data
;;;;	re_assoc	: name -> index -> edges -> data -> ()
;;;;	re_inherit	: index -> edges -> ()
;;;;	
;;;;	re_sig		: name -> updatef -> ()
;;;;	
;;;;	with index a'oid  has `a`,aoid binding 
;;;;	then aoid is index into cdata in a.
;;;;	
;;;;	can we assume a and a' are the same and they a has the same edges in ref_env and a
;;;;	
%

%
;;;;	
;;;;	if length edges > 1 
;;;;	if exists more than one edge binding a kind of data where ther 
;;;;	
;;;;	foreach name in refenv 
;;;;	  if there is more than one resolved edge
;;;;	     then we need to bind union of edges to index in refenv.
;;;;	otherwise we incorrectly inherit the first binding.
;;;;	
;;;;	
;;;;	One method would be for each ref_state to include a union hook.
;;;;	Another is to simply not update those for which it is ambiguous
;;;;	expecting an explicit later binding to resolve the ambiguity.
;;;;	
;;;;	Detecting ambiguity : 
;;;;	  - if single edge then not ambiguous
;;;;	  - foreach refstate :
;;;;	      - if some resolved edge is in closure of any other then remove from list
;;;;	      - if (length (union (resolve name edges)) == 1 then not ambiguous.
;;;;	
;;;;	multiple prevs, (resolve name prev) will return nearest ancestor that bind name.
;;;;	it may be that all prevs resolve to same ancestor, otherwise we have
;;;;	multiple bindings to be merged (but doesn't graph do this implicitly?).
;;;;
;;;;	(*{cdata},**{data},***{update})
;;;;	  u : (*** -> **)    : used to reduce updates to update-data
;;;;	  f : (** -> * -> *) : used to reduce data list to cdata. data is init value or update value.
;;;;	     f update-data (reduce f init cdata)
;;;;	  ??? m : (* list -> **) : merges cdata to data ???? usually merge causes f to be applied to prevs.
;;;;	  
;;;;	  
;;;;	  
;;;;	  It would seem (*{cdata},**{data},***{update}) ref_states would want following hooks :
;;;;	    - merge : * list -> *
;;;;	       -- * list is cdata of deref'd prevs.
;;;;	    - update: *** list -> **
;;;;	    - increment  : ** -> * -> *
;;;;	       -- add incremental data to cdata.
;;;;	    - init  : ** -> * -> *   ??or ** -> *??
;;;;	       -- increment initial cdata.
;;;;	    - sort : * -> * 
;;;;	
;;;;	   Then define prevs update == cdata <- (increment update (merge (map cdata-of-rs prevs))
;;;;	        define prevs        == cdata <- (merge (map cdata-of-rs prevs))
;;;;	        define update	    == cdata <- (init update initial-cdata)
;;;;	
;;;;	    init & increment similar and in most cases would be the same.
;;;;	    however, it is possible that one would like to treat incrementing 
;;;;	    the initial value differently from incrementing the merged cdata.
;;;;	  
;;;;	  
;;;;	  
;;;;	  
%


let declare_ref_environment index edges =
  update_ref_environment_ref_state_aux index edges
;;

let declare_ref_state_index re_index name index =
  union_ref_environment_ref_state re_index [(name, index)]
;;

let declare_ref_state_data rs index data edges =
  %tty_debug `ref_state` ("declare_ref_state_data" J (tok_to_string (ref_state_name rs)));%
  ref_state_add rs index data edges
;;

let resolve_edges name edges =
  remove_prior_duplicates_p equal_oids_p
    (map_omitting_failures (\oid. snd (assoc name (get_ref_environment oid))) edges)
;;
    
let ref_state_index_deref kind oid = snd (assoc kind (get_ref_environment oid));;

let declare_ref_state_data_indirect name rs index data edges =
   ref_state_add rs index data (resolve_edges name edges)
;;


let ref_environment_do_updates re edges updates =
 let small_dm = filter (\oid, names. member_p oid updates equal_oids_p)
                       ref_environment_data_map in
 let refstates = 
   remove_prior_duplicates
    (flatten
      (map snd small_dm)) in

  (map (\name,hook.
	   if (member name refstates)
              then ( %tty_print ("ref_environment_do_updates edges " J (tok_to_string name)
				 J " " J (int_to_string (length edges)))
		   ;% declare_ref_state_index re name re
                   ; hook re (resolve_edges name edges)
 		      (let upds = filter (\oid. member name
					  ( apply_alist_p small_dm oid equal_oids_p
					  % generally this means that the update object
					    does not point to itself %
					  % compile order problems at connect also cause these errors.
					    eph re updates get referenced at run time. Add an update
					    prior without re-running later and that dependency is not
					    made and that update is not visible to code-order. then
					    when trying to do_updates here, ref_environment_data_map
					    does not contain new update since not loaded yet.
					    THUS ANY TIME AN UPDATE IS ADDED ALL LATER UPDATES SHOULD BE
					    RECOMPILED (or at least the one immediately following). 
					  %
					  ? ( raise_error [oid] ``ref_environment_do_updates`` []
					    ; fail)) )
                                       updates in
                        %tty_print ("ref_environment_do_updates " J (tok_to_string name)
				  J " " J (int_to_string (length upds))); %
			upds))
	       else ())
      ref_environment_update_hooks)
%; tty_print ("ref_environment_do_updates done" J " " J (int_to_string (length small_dm)))%
; ()
;;

let reset_ref_environment_data oid =
  %map (\f. f oid) ref_environment_reset_hooks; %
  ref_environment_data_map :=  
    remove_alist_entry_p equal_oids_p ref_environment_data_map oid;
 ()
;;

let set_ref_environment_multi_data oid info =
 set_ref_environment_data_map oid (map fst info);
 map (\name, addf, data. addf oid data) info;
()
;;
 
let set_ref_environment_data oid name addf data =
 set_ref_environment_data_map oid [name];
 addf oid data;
()
;;

% if losing data watch out for multiple reset_ref_environment_data per obid %
let add_ref_environment_data oid name addf data =
 add_ref_environment_data_map oid [name];
 addf oid data;
()
;;

% if exists
  expect edges to be same. 
  if no index graph element then need to init.
;;;;	
;;;;	init	: no edges.
;;;;	add	: first for index.
;;;;	mod	: merge for index.
;;;;	
;;;;	multiple modifies in same refenv object should work??
;;;;	
%
let ref_state_modify_state_aux updatef rs data index edges =
 let name = ref_state_name rs in 

  if ( ((equal_oids_p (snd (assoc name (get_ref_environment index))) index) ? false)
     & (can (ref_state_get_element rs) index))
   then
    (let (gee, ged) = let ge = ref_state_get_element rs index in
                        ((ge_edges ge), (ge_data ge)) in 
     
      ref_state_modify rs index 
        (updatef data ged) 
        (union_p equal_oids_p gee (resolve_edges name edges)))

  else ( declare_ref_state_index index name index
       ; declare_ref_state_data_indirect name rs index data edges)
;;
  
let ref_state_modify_state = ref_state_modify_state_aux append;;


% incremental updates of data of entry of ref_state %

%;;; test %

letref test_ref_state =
  new_simple_ref_state `test` append  (nil : tok list)
;;

letref roid = dummy_object_id();;

let update_test index toks edges = 
 test_ref_state :=
   ref_state_modify test_ref_state index toks edges
;;

let get_test oid = ref_state_get test_ref_state oid;;

let lookup_test () =
  get_test (current_ref_environment_index `test`);;

let lookup_testn n =
  get_test (current_ref_environment_index n);;

letref aoid = dummy_object_id();;
letref boid = dummy_object_id();;
letref coid = dummy_object_id();;
letref doid = dummy_object_id();;

let ref_state_test () =
  roid := create_object_id();
  aoid := create_object_id();
  boid := create_object_id();
  coid := create_object_id();
  doid := create_object_id();

  declare_ref_environment roid nil;
  declare_ref_state_index roid `test` roid;

  update_test aoid ``a1 a2`` nil;
  update_test boid ``b1 b2`` nil;
  update_test coid ``c1 c2`` [aoid];
  update_test doid ``d1 d2`` (coid . boid . nil)
;;

%;;;	
;;;;	visible : use ref_state to control which definitions are visible
;;;;	          in a definition table.
;;;;	  - object_id list : when table index requested cache index in 
;;;;		all visible definitions. This allow for quick test.
;;;;	      * stale ? if an object is removed from list how can we be sure  
;;;;			its definition does not still indicate membership if no
;;;;			intervening cache.
;;;;	      * transaction ? ref visibility is moot if def not accessible in transaction.
;;;;		but consider activation after setting visibility cache, then 
;;;;		becomes visible in transaction but not ref visible when maybe should be.
;;;;		  - maybe have table check visibility when inserting in table.
;;;;	  - multiple ref_states active simultaneously ?   
;;;;	    no. always we are acting on behave of a single object.
;;;;		top level will be some all-encompassing distinquised top object. 
;;;;		recoginizable as univerally visible indes without need to cache.
;;;;	  - recursive ref_state bindings?  
;;;;	    yes. Should be similar to dependency collecting.
;;;%	


%;;;
;;;;	Abstractions.
;;;%

letref visible_abstractions_ref_state = 
  new_simple_ref_state `visible_abstractions`
    append
    (nil : object_id list)
;;

let ref_add_visible_abstractions index edges aboids = 
  declare_ref_state_index index `visible_abstractions` index;
  visible_abstractions_ref_state
     := declare_ref_state_data_indirect `visible_abstractions`
					 visible_abstractions_ref_state index aboids edges
 ; ()
;;
 
let get_visible_abstractions index = ref_state_get visible_abstractions_ref_state index;;

update_ref_state_view
 (\(). visible_abstractions_ref_state)
 (ref_state_view_list_entry ioid_term)
;;     

%
;;;;	
;;;;	ref_environment is tok # oid  assoc
;;;;	
;;;;	each ref_state should have tok # oid pair
;;;;	
;;;;	when a ref_state value is needed the ref_environment is used to find the
;;;;	index oid for the value.
;;;;	
;;;;	the ref_environment itself has a ref_state from which the ref_environment can be projected.
;;;;	it is required that each refinement supply a ref_environment index oid, and the environment
;;;;	is projected at refine time.
;;;;	


;;;;	
;;;;	ReflEqCD_cache : assoc list of ids to tactics.
;;;;	  - when lemma modified need to update list by removing modified entry
;;;;	     * thus need method of update all lists containg modified lemma.
;;;;	
;;;;	(<name>, <data>) list
;;;;	  * extension to visible_statements ??
;;;;	    ie could visible statements include an array of lemma caches?
;;;;	
;;;;	      - if some mod made to a visible statement then requires a refresh
;;;;		to the environments containing the visible statement, thus
;;;;		obviating the need for eager updates.
;;;;	      - seeing as the list of statements if fixed, it might make sense
;;;;		to build cache eagerly, but many caches in ref state will be untouched
;;;;		should at wait for a use. 
;;;;	      - previously had order problem, which required we call lib to get order.
;;;;		now just use order from visible_statements.
;;;;
;;;;	 Thus add transaction end hook which refreshes all stale environments.
;;;;	
;;;;	 if wf thm added during refinement of some proof then will that proof see it?
;;;;	 no since end hook will occur later, thus may need so sort of eager update if
;;;;	 lemma table mod in scope of ref-env.
;;;;
;;;;	  - indexed assoc list by environment.
;;;;	  - only visible lemmas should be available.
;;;; new_ref_state `<assoc>_cache` append (nil : object_id list);;
;;;;	
;;;;	
;;;;	
;;;;	YUnrollC :  some reference variable are simply forward references
;;;;	 to functions which can not be defined until some lemma is loaded.
;;;;	 they never are modified after they are set. It is tempting to leave
;;;;	 them be. However, this allows for transparent dependencies on the lemma
;;;;	 by users of the variable. Thus to be robust even these variables should
;;;;	 be accessed through the reference_environment.
;;;;	
;;;;	
;;;;	Lazy : to avoid building intermediate environments never referenced,
;;;;	  ref objects should not update ref states until used.
;;;;	
;;;;	  - maintain table of hooks to evaluate to effect state and flag to indicate
;;;;	    if evaluated.
;;;;	  - when needed check if evaled. if not check prereqs then eval.
;;;;	
;;;;	
;;;;	  eg, refenv index passed to refiner. refiner
;;;;	
;;;;	
;;;;	
;;;;	create_rec_module : add_AbReduce_conv which updates ref_add_ForceReduce_alist  
;;;;	  - have create_rec_module add an ML object which does the update.
;;;;	  - have create_rec_module and a reference_environment object which does updates refenv
;;;;	    wrt all module objects.
;;;;	
;;;;	  - evaluation of object calling create_rec_module should return a refenv addition
;;;;	     : object_id -> object_id list -> unit
;;;;	  - look at objects created and add to visible statement/abstractions/additions
;;;;	     eval on inl() finds obs and creates closure containing them.
;;;;	       on inr .. creates and finds obs and creates closure containing them.
;;;;	
%

%;;;	
;;;;	taxonomy : by type of indexed value.
;;;;	
;;;;	  - object_id list : controls access to objects.
;;;;	      * visible_abstractions
;;;;	      * visible-statements
;;;;	  - tok list 
;;;;	      * soft_abstractions
;;;;	  - tok list (visible_statements subset)
;;;;	      * Decidable__lemmas
;;;;	      * sq_stable__lemmas
;;;;	  - (tok # (tok list)) list
;;;;	      * inc/qinc (visible_statements cache)
;;;;	  - (tok # ((bool -> tactic) list)) list
;;;;	      * ReflEqCD/NonReflEqCD  (visible_statements cache)
;;;;	  - (tok # tok) list (declared)
;;;;	      * root_rel_relative_strengths  
;;;;	  - (tok # (tok # (term list->term->term)) list) list
;;;;	      * arith_property_inf_alist
;;;;	  - (tok # (int -> tactic)) list)
;;;;	      * D_additions
;;;;	      * Trivial_additions
;;;;	  - (tok # (tok -> convn)) list
;;;;	      * ForceReduce (AbReduce) (declared)
;;;;	  - (tok # tok # (int->tactic) # tactic) list 
;;;;	      * set_inc (declared)
;;;;	  - (tok # reln list) (declared - declare_rel_family)
;;;;	      * order_rel_families
;;;;	  - (tok # (proof -> reln -> bool)) list
;;;;	      * lin_order_check_funs
;;;;	  - (reln # reln) list
;;;;	      * order_rel_relative_strengths
;;;;	  - convn (tactic forward reference, wrt compiler->lib)
;;;;	      * YUnrollC
;;;;	      * pi1_evalC/pi2_evalC
;;;;	  - (tok # convn # convn) list
;;;;	      * RecUnfoldFold
;;;;	      * RecEta
;;;;	
;;;;	
%
% template for the assoc class of ref_states: %
% 
letref <name>_assoc = new_ref_state `<name>` <append> (nil : <type> list);;

let ref_add_<name> index edges items =
 declare_ref_state_index index `<name>` index;
 <name>_assoc 
   := declare_ref_state_data_indirect `<name>` <name>_assoc index items edges
;;

let ref_add_<name>_additions items index edges =
 <name>_assoc
   := ref_state_modify_state_aux (\data gedata. append gedata data)
         <name>_assoc items index edges
 ; ()
;;

let lookup_<name>_alist () = 
  ref_state_get <name>_assoc (current_ref_environment_index `<name>`)
;;

%% need id arg to forestall eval of lookup_<name>_alist () %%
let lookup_<name> id = apply_alist (lookup_<name>_alist ()) id;;

%% optionally : for code objects generated by create funcs.
let <name>_build <data> = 
 [ (<fu>,<bar>]
 ]
;;

let <name>_additions_term ... = 
  build_and_apply_additions_term "ref_add_<name>_additions" "<name>_build"
   ( <data> )
;;


%% add to NullEnvironment

ref_add_<name> null_refenv nil nil;;

%% convert updates to additions (build_and_apply_additions ref_add_<name>_additions build_<name> <data>)
%

% template for the lib-dep class of ref_states: %
% 

letref <name>_ref_state = new_ref_state `<name>` (\data cdata . data) <fail>;;

let set_<name> index edges f =
 declare_ref_state_index index `<name>` index;
 <name>_ref_state
   := declare_ref_state_data_indirect `<name>` <name>_ref_state index f edges
;;

%% apply to an arg to forstall evaluation of ref_state_get 
let <name> a =
  ((ref_state_get <name>_ref_state (current_ref_environment_index `<name>`)) a)
  ;;
    
;;
%
% template for the lib-dep class of conv built from lemma names. %
% 

letref <name>_ref_state =
   new_ref_state `<name>` 
                 (\data cdata . let l = union data (snd cdata) in (<build> l, l))
		 (FailC, ([] : tok list))
;;

let ref_add_<name>_additions names index edges =
 <name>_ref_state
   := declare_ref_state_data_indirect `<name>` <name>_ref_state index names edges
;;

%% apply to an arg to forstall evaluation of ref_state_get 
let <name> a =
  ((ref_state_get <name>_ref_state (current_ref_environment_index `<name>`)) a)
  ;;
    
;;
%

%;;;	
;;;;	ref_add_xxx_additions	items -> index -> edges -> unit
;;;;	xxx_additions_term	* -> term
;;;;	xxx_build		term -> items
;;;;	
;;;;	
;;;;	xxx_additions_term creates term to be enclosed as arg to build_xxx.
;;;;	ap of build_xxx to arg is then passed to ref_add_.. as arg.
;;;;	
;;;;	fu{"ref_add_xxx_additions", "build_xxx"} (args)
;;;;	
;;;;	
;;;;	
;;;%

let build_and_apply_additions_term_aux opid addfunc buildfunc args =
  make_term (opid, [ make_string_parameter addfunc
		   ; make_string_parameter buildfunc])
	    [[], args]
;;

let build_and_apply_additions_term = 
  build_and_apply_additions_term_aux `build_and_apply_additions`;;

let build_wre_and_apply_additions_term = 
  build_and_apply_additions_term_aux `build_wre_and_apply_additions`;;

let build_gwre_and_apply_additions_term = 
  build_and_apply_additions_term_aux `build_gwre_and_apply_additions`;;

let build_sequence_additions_term = make_icons_term (`sequence_additions`, nil);;
 

%;;;	ref_state cache : in order to provide reasonable performance it is 
;;;;	  necessary to cache the values for the heavily used ref states
;;;;	  at with_ref_environment time.
;;;;	
;;;;	  - provide hook to produce func to be bound to some letref which is called 
;;;;	    by dependent code, default func simply does lookup as now.
;;;;	ref_state_register_cache_hook :
;;;;	    tok 					{nmemonic}
;;;;	    -> (unit + object_id) -> unit
;;;;
;;;;	    -> (unit -> ref_state)
;;;;	    -> ((unit -> **) -> unit)			{set_accessor}
;;;;	    -> ( * {ref_state value} -> (unit -> **)	{build_accessor}
;;;;	    -> unit -> **				{default/fail}
;;;;        -> unit
;;;;	 need separate build/set so that default can be set when env unwound.
;;;;	 could do inl() build to have it return default? 
;;;;
;;;;	  - allow for multiple hooks in case more than one function could be optimized.
;;;;	  - recursion : rather than remembering state, simpily re-init after a recursive call ends. 
;;;;	
;;;;	  ? dynamic updates : hopefully already not allowed.
;;;;	  ? recursive calls and failures 
;;;;	
;;;;	  - test : 
;;;;	      * choose some theory and rerun with current environments
;;;;	      * consider wf caching skewing results.
;;;;	      * report on elasped time spent in refiner
;;;;	      * monitor some representative(expensive) refinements.
;;;;	
;;;%

letref ref_environment_cache_hooks = [] : (tok # ((unit + object_id) -> unit)) list;;

let ref_environment_init_caches env = 
  map (\n,f. f ( (inr (apply_alist env n))
	       ? ( tty_print ( "Reference Environment cache "
			     J (tok_to_string n) J " init failed")
		 ; inl ())))
      ref_environment_cache_hooks
;;

let ref_environment_reset_caches () = 
  map (\n,f. f (inl ())) ref_environment_cache_hooks
;;

let update_ref_environment_cache_hook name hook = 
 ref_environment_cache_hooks := update_alist ref_environment_cache_hooks name hook
;;

 
%let ref_environment_enter oid =
 let env = get_ref_environment oid in
    ref_environment_init_caches env
 ; env
;;
%
%LAL get_Ref_env won't work, term isn't as expected%
let ref_environment_enter term =
 let env =
     ( (ref_state_get ref_environment_ref_state (lookup_re_index_kludge term))
     ? (get_ref_environment (destruct_object_id_parameter (hd (parameters_of_term term))))
     ? (ref_state_get ref_environment_ref_state (lookup_re_index_kludge (subterm_of_term (subterm_of_term term 1) 1)))
     ? (get_ref_environment (destruct_object_id_parameter (hd (parameters_of_term (subterm_of_term (subterm_of_term term 1) 1))))))
 
  in
    ref_environment_init_caches env
    ; env
;;

let ref_environment_exit () =
  ref_environment_reset_caches ()
 ; ()
;;
 

let ref_state_size rs =
 let (g, l, r) = destruct_ref_state rs in
 let gl,r = destruct_graph g in
  (length gl, length l)
;;


%
;;;;	
;;;;	Code ref state : ref_state to parameterize lookup of ml function from name
;;;;	
;;;;	compile : oid{code} # ((ml-name # lisp-name) list)
;;;;	 * maybe under transaction control to allow removing code def.
;;;;	 * NB. calls to defs defined within same object a little tricky especially
;;;;	    if object where to call name defined previously then redefine name.
;;;;	    eg, func a defined in object o then object p has let a i = a i + 3;;
;;;;	      the call to a in p should call a defined in o but that may not be detectable from compile data.
;;;;	      maybe don't allow same object to call a func then redefine it.
;;;;	     OR change xref collection to know which object defined func when ml-lookup called !!!
;;;;	
;;;;	
;;;;	ml-name-cache : ml-name -> oid{code} list
;;;;	  * indicates that at one time a function with that name was compiled from that object.
;;;;	    must be validated by code-table lookup.
;;;;	
;;;;	ref_state : oid -> oid list
;;;;	  ie index to list of usable code objects.
;;;;	
;;;;	ml-name-lookup :
;;;;	  - ml_name_cache name -> oid{cache_candidate} list 
;;;;	  - intersect (oid{cache_candidate} list) (ref_state_lookup re) -> oid{re_canditate} list
;;;;	  - intersect (oid{re_candidate} list) (code_table_lookup ml_name) -> oid{candidate} list
;;;;	      * maybe code_table_lookup can implicitly do re check?
;;;;	  - if multiple candidates fail
;;;;	    if no candidates use file/builtin defs.
;;;;	    if one candidate use candidate def.
;;;;	

;;;;	
;;;;	Trick now is to make it conditionally applicable.
;;;;	 ie by default want code object to be visible but in
;;;;	 some circumstances want to check if reachable in ref_state.
;;;;	
%  
     
letref nml_code_ref_state =
 new_list_ref_state `nml_code`
   (nil : object_id list)
;; 

let nml_code_add_data oid data =
 nml_code_ref_state := ref_state_set_data nml_code_ref_state [oid, data]
;;

let nml_code_add oid data = 
 add_ref_environment_data oid `nml_code` nml_code_add_data data
;;

let nml_code_do_updates oid edges oids =
 nml_code_ref_state := ref_state_do_updates nml_code_ref_state oid oids edges
 ; ()
;;

let undeclare_nml_code oid = 
 (nml_code_ref_state := ref_state_remove nml_code_ref_state oid; ())
 ? ()
;;

update_ref_state_view
 (\(). nml_code_ref_state)
 (ref_state_view_list_entry ioid_term)
;;

let nml_code_ref_state_lookup () =
( ref_state_get nml_code_ref_state
   (current_ref_environment_index `nml_code`)
? nil)
;;

set_lisp_ml_forward_hook `NML_CODE`;;
