%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

%	nlb == not library. 
	
	this file defines functions for clients to call lib.
%

 

let lib_eval_aux e = orb_eval_args `ONE` nuprl5_library_description_term e;;

let lib_eval_to_term_aux e = orb_eval_args_to_term `ONE` nuprl5_library_description_term e;;

let lib_eval_to_term_readonly e = orb_eval_args_to_term `READONLY` nuprl5_library_description_term e;;

let lib_modify_environment_property name t =
  let addr = ienvironment_address_term (current_environment_address ()) in
    lib_eval_aux (term_ap (token_ap (term_ap (begin_ap "modify_environment_property_aux ") addr) name) t)
;;   

let lib_remove_environment_property name =
  let addr = ienvironment_address_term (current_environment_address ()) in
    lib_eval_aux (token_ap (term_ap (begin_ap "remove_environment_property_aux ") addr) name)
;;   
  
let lib_set_environment_bool_property_aux name b addr =
  lib_eval_aux (tokens_ap (bool_ap (token_ap (begin_ap "set_environment_bool_property ")
					     name)
				   b) addr)
;;


let lib_set_environment_priority_property i =
  let addr = ienvironment_address_term (current_environment_address ()) in
    lib_eval_aux (nat_ap (term_ap (begin_ap "set_environment_priority_property_aux ") addr) i)
;;   

let lib_show_environment_properties () =
  let addr = ienvironment_address_term (current_environment_address ()) in
    term_to_property_list
      (lib_eval_to_term_aux (term_ap (begin_ap "show_environment_properties_aux ") addr))
;;   

% could be more primitive than lib_eval, ie defined before lib eval is some comm file ?? %
letref remote_auto_include_properties = ``edd_connection``;;
letref remote_auto_include_properties_cache = ivoid_term, nil: (tok # term) list;;

let remote_eval_auto_properties_p () =
 (let stampt = get_environment_property `STAMP` in
  if (not (lex_equal_terms stampt
 		           (fst remote_auto_include_properties_cache)))

     then (let props = map_omitting_failures
                          (\n. n, get_environment_property n)
                          remote_auto_include_properties in
            remote_auto_include_properties_cache := stampt, props;
	    ());

   not (null (snd remote_auto_include_properties_cache)))
   ? false
 ;;

%%% notify utils orb_eval_and_notify needs to be fixed. %
let with_remote_properties posure = posure
%  (posure_ap
    (term_ap (begin_ap "eval_with_props")
	     (snd remote_auto_include_properties_cache))
    posure)
%
;;

let lib_eval posure = 
 if not (remote_eval_auto_properties_p ()) then lib_eval_aux posure
 else outl (mother_of_all_eval_args `ONE` false nil nuprl5_library_description_term
            (snd remote_auto_include_properties_cache) posure)
;;

let lib_eval_to_term posure = 
 if not (remote_eval_auto_properties_p ()) then lib_eval_to_term_aux posure
 else outr (mother_of_all_eval_args `ONE` true nil nuprl5_library_description_term
            (snd remote_auto_include_properties_cache) posure)
;;

let lib_eval_queue_asynch posure comp = 
  orb_queue_asynch false nuprl5_library_description_term nil posure false comp;;


%
	Functions for calling library.


	requires :

	lib_eval		: term # term_list -> unit
	lib_eval_to_term	: term # term_list -> term

%

let lib_eval_string = lib_eval o begin_ap;;

let lib_eval_to_string = make_string_return lib_eval_to_term;;
let lib_eval_to_token = make_token_return lib_eval_to_term;;
let lib_eval_to_object_id = make_oid_return lib_eval_to_term;;
let lib_eval_to_object_ids = make_oids_return lib_eval_to_term;;
let lib_eval_to_bool = make_bool_return lib_eval_to_term;;
let lib_eval_to_terms = make_terms_return lib_eval_to_term;;

let lib_apply_string_to_term s t = lib_eval_to_term (term_ap (begin_ap s) t);;

% unmarshall means remote eval does not marshall result
  but local process does unmarshall to desired type %
let lib_eval_to_string_unmarshall = make_string_return_unmarshall lib_eval_to_term;;
let lib_eval_to_oids_unmarshall = make_oids_return_unmarshall lib_eval_to_term;;


% relies of only one orb connected %
let library_open id =
  cmd_eval_string
    (orb_match_bus_environment [`ORB`])
    (concatenate_strings ["library_open ``"; (tok_to_string id); "``"])
;;

let library_open_as oldid newid=
  cmd_eval_string (orb_match_bus_environment [`ORB`])
    (concatenate_strings
       [ "library_open_as ``"
       ; (tok_to_string oldid)
       ; "`` `"
       ; (tok_to_string newid)
       ; "`"
	       ; ])
;;


  
let lib_set_environment_bool_property name b =
  lib_set_environment_bool_property_aux name b (current_environment_address ());;

     
% 9/2002 defined earlier but not sure if we should keep these or those???
let lib_remove_environment_property name =
  let addr = ienvironment_address_term (current_environment_address ()) in
    lib_eval (token_ap (term_ap (begin_ap "remove_environment_property_aux ") addr) name)
;;   

let lib_set_environment_priority_property i =
  let addr = ienvironment_address_term (current_environment_address ()) in
    lib_eval (nat_ap (term_ap (begin_ap "set_environment_priority_property_aux ") addr) i)
;;   

let lib_show_environment_properties () =
  let addr = ienvironment_address_term (current_environment_address ()) in
    term_to_property_list
      (lib_eval_to_term (term_ap (begin_ap "show_environment_properties_aux ") addr))
;;   
%


let put_term_ap = null_ap (itext_term "put_term ");;
let put_term oid t = lib_eval (term_ap (oid_ap put_term_ap oid) t);;

let get_term_ap = null_ap (itext_term "get_term ");;
let get_term oid = lib_eval_to_term (oid_ap get_term_ap oid);;

let get_substance_term_ap = null_ap (itext_term "get_substance_term ");;
let get_substance_term oid = lib_eval_to_term (oid_ap get_substance_term_ap oid);;



let create_object_id () = lib_eval_to_object_id (begin_ap "create_object_id ()");;

let create_object_ap = null_ap (itext_term "create_object_aux");;
let create_object type props term =
  lib_eval_to_object_id 
    (term_ap (term_ap (token_ap create_object_ap type)
		      (property_list_to_term props))
	     term)
;;

let create_named_object type props name term =
  create_object type ((`NAME`, (itoken_term name)) . props) term
;;

let create_term_object = create_object `TERM` nil;;

let concrete_lookup toks =
  lib_eval_to_object_id (tokens_ap (begin_ap "descendent_s") toks)
;;
