%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

%
;;;;	
;;;;	tactic term tree term
;;;;	
;;;;	
;;;;	<tttt>	: !cons(<term{tactic}>; <tttt> ilist)
;;;;		| <term{tactic}>
;;;;	
%

let children_of_tttt tttt = map_ilist_to_list tactic_tree_cons_op id (itail tttt);;
let tactic_of_tttt tttt = ihead tttt;;
			  
let iinf_tree_cons_op = `!inf_tree_cons`,[];;

let destruct_iinf_tree_term term =
     let ((id, parms),
	  [([],goal);
	    ([],node); 
	    ([],children);
	    ([],annotations)]) = destruct_term term in

      (goal, (node, (annotations,  map_isexpr_to_term_list iinf_tree_cons_op children)))
;;

let subgoals_of_iinf_tree itree =
  let g, n, a, subgoals = destruct_iinf_tree_term itree in
   map (fst o destruct_iinf_tree_term) subgoals
;;

let tttt_map f tttt =
 letrec aux t =
   make_icons_term tactic_tree_cons_op
                  (f (ihead t))
                  (map_to_ilist aux tactic_tree_cons_op (map_ilist_to_list tactic_tree_cons_op id (itail t)))
  in aux tttt
;;

let  simple_tactic_tree_term tac =
 make_icons_term tactic_tree_cons_op
     tac (make_term tactic_tree_cons_op nil)
;;

let destruct_igoal t =
  let (op, [([],gg); ([],ga)]) = destruct_term t in 
    (gg, map_isexpr_to_list iannotation_cons_op (\p.p) ga)
;;

let children_of_iinf_tree t =
  map_isexpr_to_term_list iinf_tree_cons_op (subtermn 3 t)
;;			  
			  
let iinf_tree_term goal tactic a subgoals =
  make_term (`!inf_tree_term`, [])
    [[], goal;
      [], tactic;
      [], subgoals;
      [], a]
;; 

let iinf_goal_term goal annos =
  make_term (`!inf_goal_term`, []) [[], goal; [], annos]
;; 



%  abstract Tactic Term Tree :
   f : unit -> ttt{children} # (term{tactic} # (term{ttt} # tok{mnemonic}))
%			   
absrectype ttt = (unit -> ttt list) # (term # (term # tok))
 with make_ttt stuff = abs_ttt stuff
  and ttt_children  ttt = (fst (rep_ttt ttt)) ()
  and ttt_tactic    ttt = fst (snd (rep_ttt ttt))
  and ttt_remainder ttt = fst (snd (snd (rep_ttt ttt)))
  and ttt_tag	    ttt = snd (snd (snd (rep_ttt ttt)))
;;

% destruct : term -> term # term list %
let build_ttt destruct tag t =
 letrec aux term =
   let tactic, children = destruct term in
    make_ttt ((\(). map aux children), (tactic, (term, tag))) 
 in aux t
;;

let ttt_unrefined_p ttt =
  alpha_equal_terms (ttt_tactic ttt) ivoid_term
;;

let apply_ttt_aux_cont reff ttt node =
  letrec aux ttt node = 
     if ttt_unrefined_p ttt then reff node ivoid_term (\l. tty_print "`apply_ttt_aux_cont`"; failwith `apply_ttt_aux_cont`)
     else (reff node (ttt_tactic ttt)
                (\rchildren.
		   let tchildren = ttt_children ttt in
		   tty_print ( "atac " J (int_to_string (length rchildren))
				       J " " J (int_to_string (length tchildren)));

                    if (length tchildren = length rchildren)
		       then inr (map2 (\rchild tchild. aux tchild rchild)
		                       rchildren tchildren)
  		       else (tty_print "atac l"; inl (ttt_tag ttt, ttt_remainder ttt))))
 in aux ttt node
;;

let ttt_children_pick ttts tsubgoals subgoals =
 letrec f sg tsubgoals ttts =
   if null tsubgoals then fail;
   if alpha_equal_terms sg (hd tsubgoals)
      then hd ttts
      else f sg (tl tsubgoals) (tl ttts) in
 
 % subgoal is !inf_goal(sequent annotations) %
 letrec aux i subgoals =
   if null subgoals then nil else
   ( f (subtermn 1 (hd subgoals)) tsubgoals ttts
   ? (nth i ttts ? (tty_print "subgoals/children count mismatch"; 
                    fail)))
   . aux (1 + i) (tl subgoals) in

   if not ((length ttts) = (length tsubgoals))
     then (tty_print "apply_ttt_pick subgoals/tac count mismatch"; ttts)
     else (aux 1 subgoals ? ttts)
;;

let ttt_node = ttt_tactic;; 
let apply_ttt_aux_cont_wg reff ttt node =
  letrec aux ttt node = 
     if ttt_unrefined_p ttt
        then reff node ivoid_term (\l. tty_print "`apply_ttt_aux_cont`"
				       ; failwith `apply_ttt_aux_cont`)
     else
      let tnode = ttt_node ttt in
      let x,[[],ttac; [],ttsubgoals] = destruct_term tnode in
      let tsubgoals = map_ilist_to_list icons_op id ttsubgoals in
       reff node ttac
                 (\rchildren.
		   let tchildren = ttt_children ttt in
		   let pchildren = ttt_children_pick tchildren tsubgoals rchildren in 
		   tty_print ( "atac " J (int_to_string (length pchildren))
				       J " " J (int_to_string (length tchildren))
				       J " " J (int_to_string (length rchildren)));

                    if (length pchildren = length rchildren)
		       then inr (map2 (\rchild tchild. aux tchild rchild)
		                       rchildren pchildren)
  		       else (tty_print "atac l"; inl (ttt_tag ttt, ttt_remainder ttt)))
 in aux ttt node
;;

let tttt_to_ttt tttt =
  (build_ttt 
     (\t. if (icons_term_p tactic_tree_cons_op t) 
	  then (ihead t, map_ilist_to_list tactic_tree_cons_op (\x.x) (itail t))
	  else (t, nil))
     `TTTT`
     tttt)
;;


